/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.report.mb.board.dept.loan;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.reportmb.context.AbstractReportContext;
import kd.fi.er.business.reportmb.context.DeptLoanAnalysisContext;
import kd.fi.er.business.reportmb.core.FieldDO;
import kd.fi.er.business.reportmb.core.TableDO;
import kd.fi.er.business.reportmb.datahandler.analysis.loan.Group2ListHandler;
import kd.fi.er.business.reportmb.datahandler.analysis.loan.SumAmountByDeadDateHandler;
import kd.fi.er.business.reportmb.query.CommonQueryExecuteProxy;
import kd.fi.er.business.reportmb.query.IRptQueryExecute;
import kd.fi.er.business.reportmb.query.MultiThreadQueryExecute;
import kd.fi.er.formplugin.report.mb.meta.DeptLoanAnalysisTableMeta;
import kd.fi.er.formplugin.report.mb.util.MBReportUtil;
import kd.fi.er.formplugin.report.mb.util.ReportDataProcessCenter;
import org.apache.commons.lang3.StringUtils;

public class DeptLoanAnalysisIndexPlugin
extends AbstractMobFormPlugin
implements TabSelectListener {
    private static final String ER_M_DAYSSETTING = "er_m_dayssetting";
    private static final String PIECHARTAP = "piechartap";
    private static final String LOANFILTERPAGE = "loanfilterpage";
    private static final String JOINSTR = ",";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{LOANFILTERPAGE});
    }

    public void tabSelected(TabSelectEvent p0) {
        if ("loan".equals(p0.getTabKey())) {
            this.refreshPage();
        } else if ("triptabpage".equals(p0.getTabKey())) {
            String formid = "er_trip_report";
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId(formid);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("tripreport");
            showParameter.setSendToClient(true);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("deptamt".equals(p0.getTabKey())) {
            String formid = "er_m_deptamtquerytpl";
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId(formid);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("deptamt");
            showParameter.setSendToClient(true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void refreshPage() {
        DeptLoanAnalysisContext context = new DeptLoanAnalysisContext();
        context.setView(this.getView());
        context.setTables(this.loadTable());
        Integer comingdaycount = (Integer)this.getModel().getValue("comingdays");
        context.setComingDays(comingdaycount);
        MultiThreadQueryExecute queryExecute = new MultiThreadQueryExecute((AbstractReportContext)context);
        CommonQueryExecuteProxy proxy = new CommonQueryExecuteProxy((IRptQueryExecute)queryExecute);
        Map data = proxy.doExecute();
        if (!data.values().stream().anyMatch(list -> !list.isEmpty())) {
            this.getModel().setValue("loandatatag", (Object)0);
            return;
        }
        this.getModel().setValue("loandatatag", (Object)1);
        SumAmountByDeadDateHandler dataHandler = new SumAmountByDeadDateHandler(data);
        Map result = (Map)dataHandler.doHandler((AbstractReportContext)context);
        Group2ListHandler group2ListHandler = new Group2ListHandler(data);
        ReportDataProcessCenter.doHandleProcess(this.getView(), (AbstractReportContext)context, "loan.loanmap", group2ListHandler);
        this.paintChart(result);
        this.paintList();
    }

    private List<TableDO> loadTable() {
        ArrayList tables = Lists.newArrayListWithCapacity((int)4);
        Map<DeptLoanAnalysisTableMeta.BILLTYPE, String[]> meta = this.getMeta();
        QFilter orgFilter = null;
        QFilter billStatusFilter = new QFilter("billstatus", "in", (Object)new String[]{"G"});
        QFilter nonFilter = new QFilter("1", "!=", (Object)1);
        QFilter currencyFilter = new QFilter("currency", "=", ((DynamicObject)this.getModel().getValue("currency")).getPkValue());
        for (Map.Entry<DeptLoanAnalysisTableMeta.BILLTYPE, String[]> entry : meta.entrySet()) {
            String[] entityIds;
            DeptLoanAnalysisTableMeta.BILLTYPE billtype = entry.getKey();
            for (String entityId : entityIds = entry.getValue()) {
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                TableDO tableDO = DeptLoanAnalysisTableMeta.createTableDO(billtype, entityId);
                tables.add(tableDO);
                List qFilters = tableDO.getQFilters();
                if (billtype == DeptLoanAnalysisTableMeta.BILLTYPE.TRIPLOAN) {
                    qFilters.add(new QFilter(FieldDO.trip_entry_balanceAmtField.getFilterKey(), ">", (Object)BigDecimal.ZERO));
                    orgFilter = this.getFilter("org", FieldDO.trip_orgField.getFilterKey());
                    if (orgFilter == null) {
                        orgFilter = nonFilter;
                    }
                    qFilters.add(new QFilter("isloan", "=", (Object)Boolean.TRUE));
                } else {
                    qFilters.add(new QFilter(FieldDO.entry_balanceAmtField.getFilterKey(), ">", (Object)BigDecimal.ZERO));
                    orgFilter = this.getFilter("org", FieldDO.orgField.getFilterKey());
                    if (orgFilter == null) {
                        orgFilter = nonFilter;
                    }
                }
                qFilters.add(orgFilter);
                qFilters.add(currencyFilter);
                qFilters.add(billStatusFilter);
            }
        }
        return tables;
    }

    private QFilter getFilter(String valField, String filterField) {
        DynamicObjectCollection coll;
        QFilter filter = null;
        Object val = this.getModel().getValue(valField);
        if (val instanceof DynamicObjectCollection && !(coll = (DynamicObjectCollection)val).isEmpty()) {
            filter = new QFilter(filterField, "in", coll.stream().map(v -> v.get("fbasedataid_id")).collect(Collectors.toList()));
        }
        return filter;
    }

    private Map<DeptLoanAnalysisTableMeta.BILLTYPE, String[]> getMeta() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        Object loanbilltype = this.getModel().getValue("loanbilltype");
        if (loanbilltype != null) {
            String[] billtypes;
            for (String billtype : billtypes = loanbilltype.toString().split(JOINSTR)) {
                if ("dailyloan".equals(billtype)) {
                    String dailyloanval = (String)this.getModel().getValue("dailyloanval");
                    map.put(DeptLoanAnalysisTableMeta.BILLTYPE.DAILYLOAN, dailyloanval.split(JOINSTR));
                }
                if ("triploan".equals(billtype)) {
                    String triploanval = (String)this.getModel().getValue("triploanval");
                    map.put(DeptLoanAnalysisTableMeta.BILLTYPE.TRIPLOAN, triploanval.split(JOINSTR));
                }
                if (!"prepay".equals(billtype)) continue;
                String prepayval = (String)this.getModel().getValue("prepayval");
                map.put(DeptLoanAnalysisTableMeta.BILLTYPE.PREPAYBILL, prepayval.split(JOINSTR));
            }
        }
        return map;
    }

    private void paintList() {
        Container contrainer = (Container)this.getControl("loanlistfp");
        String formid = "er_m_loangrouplist";
        contrainer.deleteControls(new String[]{formid});
        FlexPanelAp flex = new FlexPanelAp();
        flex.setGrow(0);
        flex.setShrink(0);
        flex.setRadius("8px");
        flex.setKey(formid);
        ArrayList items = Lists.newArrayListWithExpectedSize((int)1);
        items.add(flex.createControl());
        contrainer.addControls((List)items);
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formid);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(formid);
        showParameter.setSendToClient(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void paintChart(Map<String, Object> result) {
        Chart chart = (Chart)this.getControl(PIECHARTAP);
        chart.setShowTitle(true);
        BigDecimal notdayamt = (BigDecimal)result.get("notdayAmt");
        BigDecimal comingAmt = (BigDecimal)result.get("comingAmt");
        BigDecimal deadAmt = (BigDecimal)result.get("deadAmt");
        String sign = this.getModel().getDataEntity().getDynamicObject("currency").getString("sign");
        Tuple<BigDecimal, String> unit = MBReportUtil.getUnit(new BigDecimal[]{notdayamt, comingAmt, deadAmt});
        String titleTemplate = "%1s%2s%3s";
        chart.setTitlePropValue("text", (Object)String.format(titleTemplate, MBReportUtil.formatValue((BigDecimal)result.get("totalAmt"), unit, sign), System.lineSeparator(), ResManager.loadKDString((String)"\u501f\u51fa\u603b\u989d", (String)"DeptLoanAnalysis_0", (String)"fi-er-formplugin", (Object[])new Object[0])));
        chart.setTitlePropValue("left", (Object)"center");
        chart.setTitlePropValue("top", (Object)"center");
        chart.setShowTooltip(true);
        chart.addTooltip("formatter", (Object)"{b}({d}%)");
        PieSeries pieSeries = chart.createPieSeries("");
        pieSeries.setRadius("50%", "70%");
        pieSeries.addData(String.format(titleTemplate, ResManager.loadKDString((String)"\u672a\u5230\u671f", (String)"DeptLoanAnalysis_1", (String)"fi-er-formplugin", (Object[])new Object[0]), System.lineSeparator(), MBReportUtil.formatValue(notdayamt, unit, sign)), (Number)notdayamt);
        pieSeries.addData(String.format(titleTemplate, ResManager.loadKDString((String)"\u5373\u5c06\u5230\u671f", (String)"DeptLoanAnalysis_2", (String)"fi-er-formplugin", (Object[])new Object[0]), System.lineSeparator(), MBReportUtil.formatValue(comingAmt, unit, sign)), (Number)comingAmt);
        pieSeries.addData(String.format(titleTemplate, ResManager.loadKDString((String)"\u5df2\u5230\u671f", (String)"DeptLoanAnalysis_3", (String)"fi-er-formplugin", (Object[])new Object[0]), System.lineSeparator(), MBReportUtil.formatValue(deadAmt, unit, sign)), (Number)deadAmt);
        chart.refresh();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        if (LOANFILTERPAGE.equals(btn.getKey())) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId(ER_M_DAYSSETTING);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ER_M_DAYSSETTING));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("comingdays".equals(name) || "org".equals(name) || "currency".equals(name)) {
            this.refreshPage();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (ER_M_DAYSSETTING.equals(closedCallBackEvent.getActionId())) {
            this.refreshPage();
        }
    }
}

