/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.report.mb.board.dept.reim;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.reportmb.core.FieldDO;
import kd.fi.er.formplugin.report.mb.util.ReportDataProcessCenter;
import org.apache.commons.lang3.StringUtils;

public class DeptAnalysisShowDetailGroupPlugin
extends AbstractMobFormPlugin
implements TabSelectListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(DeptAnalysisShowDetailGroupPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        this.addClickListeners(new String[]{"expandall", "returnmainpage"});
        this.addRowClickListeners("expensegroup", "usergroup", "deptgroup", "travelexpensegroup");
    }

    private void addRowClickListeners(String ... entries) {
        for (String entryName : entries) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(entryName);
            if (entryGrid == null) continue;
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button item = (Button)evt.getSource();
        if ("expandall".equals(item.getKey())) {
            this.expandAll();
        } else if ("returnmainpage".equals(item.getKey())) {
            this.releasePage();
        }
    }

    private void expandAll() {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("er_m_grouplist");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("pageId", (Object)this.getView().getPageId());
        showParameter.setCustomParam("showall", (Object)true);
        Tab tab = (Tab)this.getControl("tabap");
        showParameter.setCustomParam("activeTab", (Object)tab.getCurrentTab());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void entryRowClick(RowClickEvent evt) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (!this.detailPage(formShowParameter)) {
            this.expandAll();
        } else {
            int n = evt.getRow();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (this.detailPage(formShowParameter)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"expandall"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mtoolbarap"});
        }
        String activeTab = (String)formShowParameter.getCustomParam("activeTab");
        if (StringUtils.isNotBlank((CharSequence)activeTab)) {
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab(activeTab);
        }
        this.getView().addClientCallBack("paintList", Integer.valueOf(10));
    }

    private boolean detailPage(FormShowParameter formShowParameter) {
        return Boolean.TRUE.equals(formShowParameter.getCustomParam("showall"));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        IFormView pview = null;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (this.detailPage(formShowParameter)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"expandall"});
            Object pageId = formShowParameter.getCustomParam("pageId");
            pview = this.getView().getView(pageId.toString()).getParentView();
        } else {
            pview = this.getView().getParentView();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"returnmainpage"});
        }
        if ("paintList".equals(e.getName())) {
            this.settingCurrency(pview);
            this.paintList(pview);
        }
    }

    private void settingCurrency(IFormView pview) {
        if (pview != null) {
            this.getModel().setValue("currency", pview.getModel().getValue("currency"));
        }
    }

    private void paintList(IFormView mainPageView) {
        Map groupMap = null;
        if (mainPageView != null) {
            String data = this.getData(mainPageView);
            if (data == null) {
                this.getView().showErrorNotification("no data");
                return;
            }
            groupMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        }
        if (groupMap != null && !groupMap.isEmpty()) {
            this.getModel().beginInit();
            this.initEntryEntity(groupMap, "expenseitem", "expensegroup", "expenseitem", "expenseitemamt", "seq1");
            this.initEntryEntity(groupMap, "applier", "usergroup", "userfield", "useramt", "seq2");
            this.initEntryEntity(groupMap, "costdept", "deptgroup", "orgfield", "orgamt", "seq3");
            this.initEntryEntity(groupMap, "tripexpenseitem", "travelexpensegroup", "tripexpenseitem", "tripexpenseamt", "seq4");
            this.getModel().endInit();
        }
    }

    private String getData(IFormView mainPageView) {
        return ReportDataProcessCenter.getData("reim.list", mainPageView);
    }

    private void initEntryEntity(Map<String, Map<String, Map<String, Number>>> groupMap, String tabName, String entryName, String keyField, String amtField, String seqField) {
        Map<String, Map<String, Number>> groupList = groupMap.get(tabName);
        if (groupList == null) {
            return;
        }
        LinkedList<Map.Entry<String, Map<String, Number>>> soryByAmount = this.soryByAmount(groupList);
        int[] batchCreateNewEntryRow = this.getModel().batchCreateNewEntryRow(entryName, groupList.size());
        int i = 0;
        for (Map.Entry entry : soryByAmount) {
            this.getModel().setValue(seqField, (Object)(batchCreateNewEntryRow[i] + 1), batchCreateNewEntryRow[i]);
            this.getModel().setValue(keyField, entry.getKey(), batchCreateNewEntryRow[i]);
            this.getModel().setValue(amtField, ((Map)entry.getValue()).get(FieldDO.amountField.getAlias()), batchCreateNewEntryRow[i]);
            ++i;
        }
        this.getView().updateView(entryName);
    }

    private LinkedList<Map.Entry<String, Map<String, Number>>> soryByAmount(Map<String, Map<String, Number>> groupList) {
        LinkedList list = Lists.newLinkedList(groupList.entrySet());
        String name = FieldDO.amountField.getAlias();
        Collections.sort(list, (o1, o2) -> {
            Map o1value = (Map)o1.getValue();
            Map o2value = (Map)o2.getValue();
            if (o1value == null) {
                return -1;
            }
            if (o2value == null) {
                return 1;
            }
            return ((Number)o2value.getOrDefault(name, 0)).intValue() - ((Number)o1value.getOrDefault(name, BigDecimal.ZERO)).intValue();
        });
        return list;
    }

    public void tabSelected(TabSelectEvent event) {
    }

    private void releasePage() {
        this.getView().close();
    }
}

