/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.share;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.fi.er.formplugin.share.CommonShareRulePlugin;
import org.apache.commons.lang3.StringUtils;

public class EntryShareRulePlugin
extends CommonShareRulePlugin
implements RowClickEventListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Control expenEntry = this.getControl("expenseentryentity");
        if (expenEntry instanceof EntryGrid) {
            ((EntryGrid)expenEntry).addRowClickListener((RowClickEventListener)this);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propNewValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        int parentRowIndex = valueSet[0].getParentRowIndex();
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection expenEntrys = null;
        int expenEntryIndex = dataModel.getEntryCurrentRowIndex("expenseentryentity");
        switch (propName) {
            case "sharemethod": {
                this.setRelateAmountToZero(expenEntryIndex, "shareamount_comrule", "shareappamount_comrule", "sharerate_comrule");
                break;
            }
            case "sharerule": {
                if (StringUtils.equals((CharSequence)"orgrule", (CharSequence)String.valueOf(propNewValue))) {
                    dataModel.setValue("sharerule_startdate", null);
                    dataModel.setValue("sharerule_enddate", null);
                }
                if ((expenEntrys = dataModel.getDataEntity(true).getDynamicObjectCollection("expenseentryentity")) == null || expenEntrys.size() <= 0) break;
                for (int index = 0; index < expenEntrys.size(); ++index) {
                    DynamicObjectCollection ruleEntrys = ((DynamicObject)expenEntrys.get(index)).getDynamicObjectCollection("expenseentryentity_rule");
                    if (ruleEntrys != null && ruleEntrys.size() > 0) {
                        if (expenEntryIndex == index) {
                            dataModel.deleteEntryData("expenseentryentity_rule");
                        } else {
                            ruleEntrys.clear();
                        }
                    }
                    if (ruleEntrys == null || ruleEntrys.size() >= 1) continue;
                    if (expenEntryIndex == index) {
                        dataModel.createNewEntryRow("expenseentryentity_rule");
                        continue;
                    }
                    DynamicObject ruleEntry = ruleEntrys.addNew();
                    ruleEntry.set("entrymonth_monthrule", dataModel.getValue("bizdate"));
                }
                break;
            }
            case "shareamount_comrule": {
                dataModel.setValue("shareappamount_comrule", propNewValue, rowIndex, parentRowIndex);
            }
            case "shareappamount_comrule": {
                DynamicObject entrycurrency = (DynamicObject)dataModel.getValue("entrycurrency", parentRowIndex);
                dataModel.beginInit();
                dataModel.setValue("entrycurrency", null, parentRowIndex);
                dataModel.endInit();
                dataModel.setValue("entrycurrency", (Object)entrycurrency, parentRowIndex);
            }
        }
    }

    private void setRelateAmountToZero(int expenCurEntryIndex, String ... amountFields) {
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection expenEntrys = dataModel.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        if (expenEntrys != null && expenEntrys.size() > 0) {
            for (int index = 0; index < expenEntrys.size(); ++index) {
                DynamicObjectCollection ruleEntrys = ((DynamicObject)expenEntrys.get(index)).getDynamicObjectCollection("expenseentryentity_rule");
                if (ruleEntrys == null || ruleEntrys.size() <= 0) continue;
                for (int i = 0; i < ruleEntrys.size(); ++i) {
                    if (expenCurEntryIndex == index) {
                        int finalI = i;
                        int finalIndex = index;
                        Arrays.stream(amountFields).forEach(e -> dataModel.setValue(e, (Object)BigDecimal.ZERO, finalI, finalIndex));
                        continue;
                    }
                    DynamicObject ruleEntry = (DynamicObject)ruleEntrys.get(i);
                    Arrays.stream(amountFields).forEach(e -> ruleEntry.set(e, (Object)BigDecimal.ZERO));
                }
            }
        }
    }

    public void entryRowClick(RowClickEvent arg0) {
        String key;
        EntryGrid source = (EntryGrid)arg0.getSource();
        switch (key = source.getKey()) {
            case "expenseentryentity": {
                IDataModel model = this.getModel();
                model.setValue("sharerule_startdate", null);
                model.setValue("sharerule_enddate", null);
                break;
            }
        }
    }
}

