/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.share;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ExpenseShareInvoiceUtil;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import org.apache.commons.lang3.StringUtils;

public class ExpenseShareViewInvoicePlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(ExpenseShareViewInvoicePlugin.class);
    private static final String BAR_VIEW_INVOICE = "viewinvoice";

    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObject costCompanyDO = (DynamicObject)model.getValue("costcompany");
        if (costCompanyDO == null) {
            logger.info("\u5f53\u524d\u5355\u636e\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a");
            return;
        }
        String billStatus = (String)model.getValue("billstatus");
        billStatus = (String)StringUtils.defaultIfBlank((CharSequence)billStatus, (CharSequence)"A");
        List<String> allowEditStatusList = Arrays.asList("A", "D");
        if (allowEditStatusList.contains(billStatus)) {
            IFormView view = this.getView();
            boolean invoiceIsEnabled = KingdeeInvoiceCloudConfig.isEnabled((long)((Long)costCompanyDO.getPkValue()));
            if (invoiceIsEnabled) {
                view.setVisible(Boolean.valueOf(true), new String[]{BAR_VIEW_INVOICE});
            } else {
                view.setVisible(Boolean.valueOf(false), new String[]{BAR_VIEW_INVOICE});
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BAR_VIEW_INVOICE)) {
            this.showInvoiceList();
        }
    }

    private void showInvoiceList() {
        Set<String> serialNos = this.getAllSerialNos();
        if (serialNos == null || serialNos.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u672a\u5173\u8054\u53d1\u7968\u3002", (String)"ExpenseShareViewInvoicePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            logger.info("\u9700\u8981\u5c55\u793a\u7684\u53d1\u7968\u5e8f\u5217\u53f7\u4e3a\u7a7a.");
            return;
        }
        serialNos.removeIf(serialNo -> StringUtils.isBlank((CharSequence)serialNo));
        if (serialNos.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u672a\u5173\u8054\u53d1\u7968\u3002", (String)"ExpenseShareViewInvoicePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            logger.info("\u9700\u8981\u5c55\u793a\u7684\u53d1\u7968\u5e8f\u5217\u53f7\u4e3a\u7a7a.");
            return;
        }
        String taxRegNum = this.getTaxRegNum();
        if (StringUtils.isBlank((CharSequence)taxRegNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ec4\u7ec7\u7684\u53d1\u7968\u4e91\u914d\u7f6e\u3002", (String)"ExpenseShareViewInvoicePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ShowInvoiceCloudPageUtil.viewInvoiceLst_pc((AbstractFormPlugin)this, this.getModel(), serialNos, this.getCostCompanyId());
    }

    protected Set<String> getAllSerialNos() {
        return ExpenseShareInvoiceUtil.getAllSerialNos((DynamicObject)this.getModel().getDataEntity(true));
    }

    private String getTaxRegNum() {
        DynamicObject costCompanyDO = (DynamicObject)this.getModel().getValue("costcompany");
        if (costCompanyDO == null) {
            logger.info("\u5f53\u524d\u5355\u636e\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a");
            return "";
        }
        String taxRegNum = KingdeeInvoiceCloudConfig.getTaxRegNum((long)((Long)costCompanyDO.getPkValue()));
        return taxRegNum;
    }

    private Long getCostCompanyId() {
        return ErCommonUtils.getPk((Object)this.getModel().getValue("costcompany"));
    }
}

