/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.stakeholderchange.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.utils.ErCommonUtils;

public class ErStakeHolderChangeBillUtil {
    public static void dealProjectOwner(DynamicObjectCollection billData, String entityId) {
        if (CollectionUtils.isEmpty((Collection)billData)) {
            return;
        }
        HashMap<Long, String> billRelatedOwner = new HashMap<Long, String>(16);
        Set billIds = billData.stream().filter(Objects::nonNull).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] dbBillDatas = BusinessDataServiceHelper.load((String)entityId, (String)"projectower", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        ErStakeHolderChangeBillUtil.dealData(billRelatedOwner, dbBillDatas);
        if (billRelatedOwner.size() == 0) {
            for (DynamicObject billDatum : billData) {
                billDatum.set("projectname", (Object)"");
            }
        } else {
            for (DynamicObject billDatum : billData) {
                Object id = billDatum.get("id");
                if (!billRelatedOwner.containsKey(Long.parseLong(id.toString()))) continue;
                billDatum.set("projectname", (Object)billRelatedOwner.getOrDefault(Long.parseLong(id.toString()), ""));
            }
        }
    }

    public static void refreshBaseInfoLabel(Object propValue, Label propControl) {
        String propStr = null;
        if (propValue instanceof DynamicObject) {
            ILocaleString name = ((DynamicObject)propValue).getLocaleString("name");
            propStr = name.getLocaleValue();
        } else if (propValue instanceof String) {
            propStr = (String)propValue;
        }
        if (propControl != null) {
            propControl.setText(propStr);
        }
    }

    private static void dealData(Map<Long, String> billRelatedOwner, DynamicObject[] load) {
        HashMap billIdAndUserIdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject row : load) {
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)row.get("projectower");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) continue;
            Set userIds = dynamicObjectCollection.stream().filter(dynamicObject -> dynamicObject.get("fbasedataid") != null).map(obj -> ErCommonUtils.getPk((Object)obj.get("fbasedataid"))).collect(Collectors.toSet());
            billIdAndUserIdMap.put(row.getLong("id"), userIds);
        }
        if (billIdAndUserIdMap.isEmpty()) {
            return;
        }
        Set entries = billIdAndUserIdMap.entrySet();
        HashSet userIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry entry : entries) {
            Set value = (Set)entry.getValue();
            userIds.addAll(value);
        }
        Map userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"name,id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)userIds)});
        Set users = userMap.keySet().stream().filter(Objects::nonNull).map(id -> Long.parseLong(id.toString())).collect(Collectors.toSet());
        for (Map.Entry entry : entries) {
            Long key = (Long)entry.getKey();
            Set tmpUserIds = (Set)entry.getValue();
            if (!users.containsAll(tmpUserIds)) continue;
            for (Long tmpUserId : tmpUserIds) {
                DynamicObject user = (DynamicObject)userMap.get(tmpUserId);
                if (billRelatedOwner.containsKey(key)) {
                    String ownerName = billRelatedOwner.get(key);
                    ownerName = ownerName + ";" + user.get("name");
                    billRelatedOwner.put(key, ownerName);
                    continue;
                }
                Object name = user.get("name");
                if (Objects.isNull(name)) {
                    billRelatedOwner.put(key, "");
                    continue;
                }
                billRelatedOwner.put(key, user.get("name").toString());
            }
        }
    }

    public static Map<Long, DynamicObjectCollection> dealProjectOwner(Map<String, List<Long>> billEntryIdAndBillIdMap) {
        HashMap resultSet = Maps.newHashMapWithExpectedSize((int)16);
        Set<Map.Entry<String, List<Long>>> entries = billEntryIdAndBillIdMap.entrySet();
        HashMap projectMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, List<Long>> entry : entries) {
            List<Long> billIds = entry.getValue();
            String string = entry.getKey();
            DynamicObject[] load = BusinessDataServiceHelper.load((String)string, (String)"projectower,projectower.detailid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIds)});
            if (load == null || load.length == 0) continue;
            for (DynamicObject dynamicObject2 : load) {
                ArrayList dbBillDatas = Lists.newArrayListWithCapacity((int)16);
                DynamicObjectCollection projectower = dynamicObject2.getDynamicObjectCollection("projectower");
                dbBillDatas.addAll(projectower);
                projectMap.put(ErCommonUtils.getPk((Object)dynamicObject2), dbBillDatas);
            }
        }
        if (projectMap.isEmpty()) {
            return resultSet;
        }
        Set entrySet = projectMap.entrySet();
        HashSet allUserIds = null;
        for (Map.Entry entry : entrySet) {
            List users = (List)entry.getValue();
            Set userIds = users.stream().filter(dynamicObject -> dynamicObject.get("fbasedataid") != null).map(dynamicObject -> ErCommonUtils.getPk((Object)dynamicObject.get("fbasedataid"))).collect(Collectors.toSet());
            if (allUserIds == null) {
                allUserIds = Sets.newHashSetWithExpectedSize((int)16);
            }
            allUserIds.addAll(userIds);
        }
        if (CollectionUtils.isNotEmpty(allUserIds)) {
            Map userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"name,id", (QFilter[])new QFilter[]{new QFilter("id", "in", allUserIds)});
            for (Map.Entry tmp : entrySet) {
                Long billId = (Long)tmp.getKey();
                List projectUsers = (List)tmp.getValue();
                DynamicObjectCollection users = new DynamicObjectCollection();
                Set<Long> userIds = projectUsers.stream().map(dynamicObject -> ErCommonUtils.getPk((Object)dynamicObject.get("fbasedataid"))).collect(Collectors.toSet());
                userIds.forEach(id -> {
                    if (userMap.containsKey(id)) {
                        users.add(userMap.get(id));
                    }
                });
                if (CollectionUtils.isEmpty((Collection)users)) continue;
                resultSet.put(billId, users);
            }
        }
        return resultSet;
    }

    public static Map<String, Object> dealApplierMsg(Long applierId) {
        HashMap<String, Object> resMap = new HashMap<String, Object>(2);
        QFilter qFilter = new QFilter("id", "=", (Object)applierId);
        DynamicObject[] applierUser = BusinessDataServiceHelper.load((String)"bos_user", (String)"name,id", (QFilter[])new QFilter[]{qFilter});
        if (applierUser == null || applierUser.length == 0) {
            return new HashMap<String, Object>();
        }
        resMap.put("applierafter", applierUser[0].get("id"));
        resMap.put("applierbefore", applierUser[0].get("name"));
        return resMap;
    }

    public static void setDataByIndex(IDataModel model, int rowIndex, DynamicObject dynamicObject, String entryId) {
        model.setValue("oribillno", (Object)dynamicObject.getString("billno"), rowIndex);
        model.setValue("bizdate", dynamicObject.get("bizdate"), rowIndex);
        model.getValue("oribillno", rowIndex);
        model.setValue("oridescription", dynamicObject.get("description"), rowIndex);
        model.setValue("stakeholderbefore", dynamicObject.get("projectname"), rowIndex);
        model.setValue("oribilltype", (Object)entryId, rowIndex);
        Map<String, Object> applier = ErStakeHolderChangeBillUtil.dealApplierMsg(Objects.requireNonNull(ErCommonUtils.getPk((Object)dynamicObject.get("applier"))));
        model.setValue("applierbefore", applier.getOrDefault("applierbefore", ""), rowIndex);
        model.setValue("applierafter", applier.getOrDefault("applierafter", ""), rowIndex);
        model.setValue("oribillid", (Object)dynamicObject.getLong("id"), rowIndex);
    }

    public static String dealUserName(DynamicObjectCollection dynamicObjects) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return "";
        }
        Set userNameSet = dynamicObjects.stream().map(user -> user.getString("name")).collect(Collectors.toSet());
        return String.join((CharSequence)",", userNameSet);
    }
}

