/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.base;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripClassUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import org.apache.commons.lang3.StringUtils;

public class ErBizInfoPluginSetEdit
extends AbstractBasePlugIn {
    private static Log logger = LogFactory.getLog(ErBizInfoPluginSetEdit.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        String number = (String)billShowParameter.getCustomParam("number");
        if (model.getValue("number") == null && StringUtils.isNotBlank((CharSequence)number)) {
            Boolean changeFlag = model.getDataChanged();
            model.setValue("number", (Object)number);
            model.setDataChanged(changeFlag.booleanValue());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            this.savePlugin();
        }
    }

    public void savePlugin() {
        Map<String, String> pluginMap = this.getPluginMap();
        String serverNumber = (String)this.getModel().getValue("number");
        String tripServiceClazz = "";
        if (Supplier.XIECHENG.name().equalsIgnoreCase(serverNumber)) {
            tripServiceClazz = "CTripService";
        } else if (Supplier.ZHONGXING.name().equalsIgnoreCase(serverNumber)) {
            tripServiceClazz = "ETripService";
        } else if (Supplier.CHAILVYIHAO.name().equalsIgnoreCase(serverNumber)) {
            tripServiceClazz = "TTripService";
        } else if (Supplier.DIDI.name().equalsIgnoreCase(serverNumber)) {
            tripServiceClazz = "DiDiTripService";
        } else if (Supplier.MEITUAN.name().equalsIgnoreCase(serverNumber)) {
            tripServiceClazz = "MeiTuanTripService";
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u670d\u52a1\u5546\u6682\u4e0d\u652f\u6301\u8bbe\u7f6e\u6269\u5c55\u63d2\u4ef6\u3002", (String)"ErBizInfoPluginSetEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        DynamicObject bizInfo_dataEntity = this.getModel().getDataEntity(true);
        ActionLocalCache.get().put("bizInfo_dataEntity", (Object)bizInfo_dataEntity);
        ITripService tripService = TripServiceFactory.getTripService((String)tripServiceClazz);
        Class<?> clazz = tripService.getClass();
        try {
            tripService = (ITripService)TripClassUtil.getNewInstance((String)clazz.getName(), pluginMap);
            Method updateService = clazz.getDeclaredMethod("updateService", ITripService.class);
            updateService.setAccessible(true);
            updateService.invoke((Object)tripService, tripService);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("\u670d\u52a1\u5546\u6269\u5c55\u63d2\u4ef6\u8bbe\u7f6e\u5931\u8d25:" + e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u5546\u6269\u5c55\u63d2\u4ef6\u8bbe\u7f6e\u5931\u8d25:%s", (String)"ErBizInfoPluginSetEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]), e));
        }
    }

    private Map<String, String> getPluginMap() {
        HashMap<String, String> pluginMap = new HashMap<String, String>();
        DynamicObjectCollection pluginDetails = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (pluginDetails == null || pluginDetails.size() < 1) {
            return pluginMap;
        }
        for (DynamicObject pluginDetail : pluginDetails) {
            String function = pluginDetail.getString("function");
            String classpath = pluginDetail.getString("classpath");
            boolean enable = pluginDetail.getBoolean("enable");
            if (!StringUtils.isNotBlank((CharSequence)function) || !StringUtils.isNotBlank((CharSequence)classpath) || !enable) continue;
            pluginMap.put(function, classpath.trim());
        }
        return pluginMap;
    }
}

