/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.checking;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.ErPermissionServiceHelper;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCheckingInvoiceImageInfoUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.common.ExternalConstants;
import kd.fi.er.common.ShowPageUtils;
import org.apache.commons.lang3.StringUtils;

public class CheckingBillList
extends AbstractListPlugin {
    private static final String BILLLISTAP = "billlistap";
    private static final String TOOLBARAP = "toolbarap";
    private static final String VIEWDETAIL_BTN = "viewdetailbtn";
    private static final String GETCHECKINGBILL_BTN = "getcheckingbillbtn";
    private static final String CONFIRM_BTN = "bar_confirm";
    private static final String DEL_BTN = "bar_del";
    private static final String VIEW_INVOICE_DETAILS_BTN = "viewinvoicedetails";
    private static final String GET_BILL_INVOICE = "getbillinvoice";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        IFormView view = this.getView();
        FormShowParameter showParameter = view.getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        ArrayList<QFilter> customQFilters = new ArrayList<QFilter>();
        if (null != customParams.get("server")) {
            customQFilters.add(new QFilter("server", "=", customParams.get("server")));
        }
        if (null != customParams.get("periodstartdate")) {
            Date periodstartdate = TripCommonUtil.convertToDate((String)customParams.get("periodstartdate").toString());
            customQFilters.add(new QFilter("periodstartdate", ">=", (Object)periodstartdate));
        }
        if (null != customParams.get("periodenddate")) {
            Date periodenddate = TripCommonUtil.convertToDate((String)customParams.get("periodenddate").toString());
            customQFilters.add(new QFilter("periodenddate", "<=", (Object)periodenddate));
        }
        if (null != customParams.get("settlemain")) {
            customQFilters.add(new QFilter("settlemain", "=", customParams.get("settlemain")));
        }
        if (!customQFilters.isEmpty()) {
            e.setCustomQFilters(customQFilters);
        }
        e.setOrderBy("periodstartdate desc, server asc");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP, VIEWDETAIL_BTN, GETCHECKINGBILL_BTN, CONFIRM_BTN, DEL_BTN});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        super.billListHyperLinkClick(e);
        String fieldName = e.getFieldName();
        if ("billnum".equals(fieldName)) {
            e.setCancel(Boolean.TRUE.booleanValue());
            this.showDetailCheckingList(true);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        IFormView view = this.getView();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)CONFIRM_BTN)) {
            int paramValue;
            long didiNotVehicleCount;
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CheckingBillList_22", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
            DynamicObjectCollection idSelectedListDate = QueryServiceHelper.query((String)"er_checkingbill", (String)"billnum,server,operationtype,id,settlementamount,billstatusname", (QFilter[])new QFilter[]{qFilter});
            if (null == idSelectedListDate || idSelectedListDate.size() == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8d26\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"CheckingBillList_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long count = idSelectedListDate.stream().filter(dynamicObject -> dynamicObject != null && StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("server"))).map(dynamicObject -> dynamicObject.getString("server")).distinct().count();
            if (count >= 2L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u540c\u65f6\u9009\u62e9\u76f8\u540c\u670d\u52a1\u5546\u7684\u6570\u636e\u3002", (String)"CheckingBillList_24", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long nullBillNumCount = idSelectedListDate.stream().filter(dynamicObject -> dynamicObject != null && StringUtils.isBlank((CharSequence)dynamicObject.getString("billnum"))).count();
            if (nullBillNumCount >= 1L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u8d26\u5355\u7f16\u53f7\u4e3a\u7a7a\u7684\u6570\u636e,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CheckingBillList_27", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Set serverSet = idSelectedListDate.stream().filter(dynamicObject -> dynamicObject != null && StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("server"))).map(dynamicObject -> dynamicObject.getString("server")).collect(Collectors.toSet());
            ArrayList serverList = new ArrayList(serverSet);
            serverSet.removeAll(Arrays.asList(Supplier.CHAILVYIHAO.name(), Supplier.DIDI.name(), Supplier.XIECHENG.name()));
            if (!serverSet.isEmpty()) {
                DynamicObjectCollection servers = QueryServiceHelper.query((String)"er_biz_info", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "in", serverSet)});
                List serverNameList = servers.stream().filter(dynamicObject -> dynamicObject != null && StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("name"))).map(dynamicObject -> dynamicObject.getString("name")).collect(Collectors.toList());
                String serverName = String.join((CharSequence)",", serverNameList);
                view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u670d\u52a1\u5546\u7684\u6708\u7ed3\u8d26\u5355\u6682\u4e0d\u652f\u6301\u8d26\u5355\u786e\u8ba4\u3002", (String)"CheckingBillList_25", (String)"fi-er-formplugin", (Object[])new Object[0]), serverName));
                evt.setCancel(true);
                return;
            }
            HashSet validateBillNums = Sets.newHashSetWithExpectedSize((int)idSelectedListDate.size());
            List waitConfirmBillNums = idSelectedListDate.stream().filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("billnum"))).map(dynamicObject -> dynamicObject.getString("billnum")).collect(Collectors.toList());
            for (String waitConfirmBillNum : waitConfirmBillNums) {
                if (waitConfirmBillNum.contains("-")) {
                    waitConfirmBillNum = waitConfirmBillNum.substring(0, waitConfirmBillNum.indexOf("-"));
                }
                validateBillNums.add(waitConfirmBillNum);
            }
            if (((String)serverList.get(0)).equals(Supplier.DIDI.name()) && validateBillNums.size() >= 2) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6ef4\u6ef4\u670d\u52a1\u5546\u7684\u6708\u7ed3\u8d26\u5355\u4e0d\u652f\u6301\u6279\u91cf\u8d26\u5355\u786e\u8ba4\u3002", (String)"CheckingBillList_26", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (((String)serverList.get(0)).equals(Supplier.DIDI.name()) && (didiNotVehicleCount = idSelectedListDate.stream().filter(dynamicObject -> dynamicObject != null && "8".equalsIgnoreCase(dynamicObject.getString("operationtype"))).count()) >= 1L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u76ee\u524d\u6682\u4e0d\u652f\u6301\u6ef4\u6ef4\u670d\u52a1\u7c7b\u578b\u4e3a\u201c\u7528\u9910\u9884\u8ba2\u201d\u7684\u6708\u7ed3\u8d26\u5355\u8fdb\u884c\u8d26\u5355\u786e\u8ba4\u3002", (String)"CheckingBillList_28", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (((String)serverList.get(0)).equals(Supplier.XIECHENG.name()) && (paramValue = TripSyncConfigUtil.getIntValue((String)"Ctrip_Billing_method", (int)1)) != 2 && paramValue != 3) {
                view.showTipNotification(ResManager.loadKDString((String)"\u643a\u7a0b\u670d\u52a1\u5546\u7684\u6708\u7ed3\u8d26\u5355\u6682\u4e0d\u652f\u6301\u8d26\u5355\u786e\u8ba4\u3002", (String)"CheckingBillList_29", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            for (DynamicObject dynamicObject2 : idSelectedListDate) {
                String billNum = dynamicObject2.getString("billnum");
                if (billNum.contains("-")) {
                    billNum = billNum.substring(0, billNum.indexOf("-")) + "%";
                } else if (((String)serverList.get(0)).equals(Supplier.XIECHENG.name())) {
                    for (String businessType : ExternalConstants.CTRIP_BUSINESSTYPE) {
                        billNum = billNum.replace(businessType, "%");
                    }
                } else {
                    billNum = billNum + "%";
                }
                qFilter.or(QFilter.like((String)"billnum", (String)billNum));
            }
            DynamicObjectCollection allSelectedListData = QueryServiceHelper.query((String)"er_checkingbill", (String)"billnum,server,billstatusname", (QFilter[])new QFilter[]{qFilter});
            if (null == allSelectedListData || allSelectedListData.size() == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8d26\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"CheckingBillList_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long notAuditCount = allSelectedListData.stream().filter(dynamicObject -> dynamicObject != null && !"2".equals(dynamicObject.getString("billstatusname"))).count();
            if (notAuditCount >= 1L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u6708\u7ed3\u8d26\u5355\u624d\u5141\u8bb8\u786e\u8ba4\uff0c\u6216\u8005\u8d26\u5355\u7f16\u53f7\u524d\u7f00\u76f8\u540c\u7684\u6708\u7ed3\u8d26\u5355\u5fc5\u987b\u90fd\u4e3a\u5df2\u5ba1\u6838\u624d\u5141\u8bb8\u540c\u65f6\u88ab\u786e\u8ba4\u3002", (String)"CheckingBillConfirmOp_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            for (Object validateBillNum : validateBillNums) {
                List samePreBillNums = allSelectedListData.stream().filter(arg_0 -> CheckingBillList.lambda$beforeItemClick$11((String)validateBillNum, arg_0)).collect(Collectors.toList());
                int size = samePreBillNums.size();
                for (int i = 0; i < size; ++i) {
                    DynamicObject dynamicObject3 = (DynamicObject)samePreBillNums.get(i);
                    String billnum = dynamicObject3.getString("billnum");
                    String newBillNum = "";
                    newBillNum = billnum.contains("-") ? billnum.substring(0, billnum.indexOf("-")) : billnum;
                    if (newBillNum.equals(validateBillNum)) continue;
                    allSelectedListData.remove((Object)dynamicObject3);
                }
            }
            StringBuilder billNums = new StringBuilder();
            for (DynamicObject dynamicObject4 : allSelectedListData) {
                billNums.append(dynamicObject4.get("billnum"));
                billNums.append(" \n");
            }
            String title2 = ResManager.loadKDString((String)"\u5373\u5c06\u786e\u8ba4\u4ee5\u4e0b\u8d26\u5355\uff1a  \n", (String)"CheckingBillList_11", (String)"fi-er-formplugin", (Object[])new Object[0]);
            view.showConfirm(title2, billNums.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("ok"));
            evt.setCancel(true);
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)VIEW_INVOICE_DETAILS_BTN)) {
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u5f20\u8d26\u5355\u8fdb\u884c\u67e5\u770b\u3002", (String)"CheckingBillList_19", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (CollectionUtils.isNotEmpty((Collection)selectedRows) && selectedRows.size() > 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u67e5\u770b\u5355\u5f20\u8d26\u5355\u7684\u5f00\u7968\u8be6\u60c5\u3002", (String)"CheckingBillList_12", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
            DynamicObject dynamicObject5 = QueryServiceHelper.queryOne((String)"er_checkingbill", (String)"billnum,server", (QFilter[])new QFilter[]{qFilter});
            String server = dynamicObject5.getString("server");
            if (!Supplier.CHAILVYIHAO.name().equals(server)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u76ee\u524d\u4ec5\u652f\u6301\u67e5\u770b\u5dee\u65c5\u58f9\u53f7\u670d\u52a1\u5546\u7684\u5f00\u7968\u8be6\u60c5\u3002", (String)"CheckingBillList_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)GET_BILL_INVOICE)) {
            if (selectedRows.size() > 10) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u540c\u65f6\u83b7\u53d610\u6761\u4ee5\u4e0a\u6708\u7ed3\u8d26\u5355\u7684\u53d1\u7968\u4fe1\u606f\u3002", (String)"CheckingBillList_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u6708\u7ed3\u8d26\u5355\u540e\uff0c\u624b\u52a8\u83b7\u53d6\u8d26\u5355\u53d1\u7968\u3002", (String)"CheckingBillList_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"er_checkingbill", (String)"billnum,server", (QFilter[])new QFilter[]{qFilter});
            List collect = dynamicObjects.stream().filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("server")) && !Supplier.CHAILVYIHAO.name().equals(dynamicObject.getString("server"))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u76ee\u524d\u4ec5\u652f\u6301\u624b\u5de5\u83b7\u53d6\u5dee\u65c5\u58f9\u53f7\u670d\u52a1\u5546\u7684\u6708\u7ed3\u8d26\u5355\u53d1\u7968\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CheckingBillList_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (VIEWDETAIL_BTN.equalsIgnoreCase(key)) {
            this.showDetailCheckingList(false);
        } else if (VIEW_INVOICE_DETAILS_BTN.equals(key)) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setFormId("er_checkingbill");
            billShowParameter.setPkId(selectedRows.get(0).getPrimaryKeyValue());
            this.getView().showForm((FormShowParameter)billShowParameter);
        } else if (GET_BILL_INVOICE.equals(key)) {
            IFormView view = this.getView();
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            QFilter qFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
            DynamicObjectCollection checkingBills = QueryServiceHelper.query((String)"er_checkingbill", (String)"billnum,server,formid", (QFilter[])new QFilter[]{qFilter});
            Map<String, List<DynamicObject>> datas = checkingBills.stream().filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("billnum"))).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("formid")));
            Set<Map.Entry<String, List<DynamicObject>>> entries = datas.entrySet();
            HashMap formAndBillNumMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Map.Entry<String, List<DynamicObject>> entry : entries) {
                String formid = entry.getKey();
                List<DynamicObject> value = entry.getValue();
                Set billNums = value.stream().map(dynamicObject -> TripCheckingInvoiceImageInfoUtil.dealBillNum((String)dynamicObject.getString("billnum"))).collect(Collectors.toSet());
                formAndBillNumMap.put(formid, billNums);
            }
            HashMap params = Maps.newHashMapWithExpectedSize((int)16);
            HashSet allNums = Sets.newHashSetWithExpectedSize((int)16);
            formAndBillNumMap.forEach((k, v) -> {
                if ("er_planecheckingbill".equalsIgnoreCase((String)k)) {
                    params.put("plane", new ArrayList(v));
                }
                if ("er_traincheckingbill".equalsIgnoreCase((String)k)) {
                    params.put("train", new ArrayList(v));
                }
                allNums.addAll(v);
            });
            params.put("all", new ArrayList(allNums));
            try {
                ITripService ttripService = TripServiceFactory.getTripService((String)"TTripService");
                ttripService.syncCheckingImageInfoFromTrip((Map)params);
                view.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u83b7\u53d6\u6240\u9009\u8d26\u5355\u7684\u53d1\u7968\u4fe1\u606f\u3002", (String)"CheckingBillList_20", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5546\u65c5\u96c6\u6210\u65e5\u5fd7\u3002", (String)"CheckingBillList_21", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (StringUtils.equals((CharSequence)"ok", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            this.getView().invokeOperation("confirmchecking", operateOption);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("er_getcheckingbill".equals(actionId)) {
            Map returnData = (Map)event.getReturnData();
            if (returnData == null || returnData.size() == 0) {
                return;
            }
            Boolean isSuccess = (Boolean)returnData.get("isSuccess");
            if (isSuccess.booleanValue()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8d26\u5355\u83b7\u53d6\u6210\u529f\u3002", (String)"CheckingBillList_16", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else {
                String detail = (String)returnData.get("detail");
                this.getView().showErrorNotification(detail);
            }
        }
    }

    private void showDetailCheckingList(Boolean isRowClick) {
        IFormView view = this.getView();
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        Long checkingBillId = null;
        if (!isRowClick.booleanValue()) {
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CheckingBillList_17", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectedRows.size() > 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u770b\u3002", (String)"CheckingBillList_18", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            checkingBillId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        } else {
            checkingBillId = (Long)billList.getFocusRowPkId();
        }
        DynamicObject checkingBill = QueryServiceHelper.queryOne((String)"er_checkingbill", (String)"formid,server,periodstartdate,periodenddate,billnum", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)checkingBillId)});
        String formId = checkingBill.getString("formid");
        if (formId == null || formId.trim().isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u672a\u786e\u8ba4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"CheckingBillList_23", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId(formId);
        listShowParameter.setCustomParam("server", (Object)checkingBill.getString("server"));
        listShowParameter.setCustomParam("startdate", (Object)checkingBill.getDate("periodstartdate"));
        listShowParameter.setCustomParam("enddate", (Object)checkingBill.getDate("periodenddate"));
        listShowParameter.setCustomParam("checkingbillnum", (Object)checkingBill.getString("billnum"));
        listShowParameter.setCustomParam("isViewCheckingbill", (Object)true);
        view.showForm((FormShowParameter)listShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String itemKey = args.getSource() instanceof FormOperate ? ((FormOperate)args.getSource()).getOperateKey() : "";
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"delete")) {
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\u3002", (String)"CheckingBillList_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
            DynamicObject idSelectedDate = QueryServiceHelper.queryOne((String)"er_checkingbill", (String)"billnum,formid", (QFilter[])new QFilter[]{qFilter});
            if (null == idSelectedDate) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8d26\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"CheckingBillList_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String billnum = idSelectedDate.getString("billnum");
            String formid = idSelectedDate.getString("formid");
            DynamicObjectCollection listDate = QueryServiceHelper.query((String)formid, (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("checkingbillnum", "=", (Object)billnum)});
            if (null != listDate && !listDate.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6708\u7ed3\u8d26\u5355\u5b58\u5728\u7ed3\u7b97\u660e\u7ec6\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"CheckingBillList_13", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        OperationResult result = eventArgs.getOperationResult();
        if (result == null || !result.isSuccess()) {
            return;
        }
        if (GETCHECKINGBILL_BTN.equals(eventArgs.getOperateKey())) {
            String appNum;
            List orgs;
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("formId", "er_getcheckingbill");
            paramMap.put("formType", "14");
            paramMap.put("needCallBack", Boolean.TRUE);
            HashMap<String, Long> customParam = new HashMap<String, Long>();
            ListView list = (ListView)this.getView();
            ControlFilters filters = list.getControlFilters();
            List settlemains = filters.getFilter("settlemain.id");
            Long settlemainId = null;
            if (settlemains != null && settlemains.size() > 0 && StringUtils.isNotBlank((CharSequence)settlemains.get(0).toString())) {
                settlemainId = Long.valueOf(settlemains.get(0).toString());
            }
            if (settlemainId == null && (orgs = ErPermissionServiceHelper.getOrgListWithQueryPerm((String)(appNum = StringUtils.isBlank((CharSequence)this.getView().getFormShowParameter().getAppId()) ? "em" : this.getView().getFormShowParameter().getAppId()), (String)"er_checkingbill")) != null && orgs.size() > 0) {
                settlemainId = (Long)orgs.get(0);
            }
            if (settlemainId == null) {
                settlemainId = RequestContext.get().getOrgId();
            }
            customParam.put("settlemain", settlemainId);
            paramMap.put("customParam", customParam);
            ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
        }
    }

    private static /* synthetic */ boolean lambda$beforeItemClick$11(String validateBillNum, DynamicObject dynamicObject) {
        return dynamicObject.getString("billnum").startsWith(validateBillNum);
    }
}

