/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.dailybiz;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.CarTypeEnum;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeProjectF7SelectListener;
import kd.fi.er.formplugin.daily.web.AbstractExpenseBaseBillPlugin;

public class DailyVehicleBillEdit
extends AbstractExpenseBaseBillPlugin
implements ClickListener,
UploadListener {
    protected IPageCache pageCache;
    private static int VEHICLE_COUNT = 2;

    public void initialize() {
        super.initialize();
        this.pageCache = this.getPageCache();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setProjectF7Filter();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        switch (propName) {
            case "costdept": {
                if (propValue == null) {
                    this.getModel().beginInit();
                    propValue = valueSet[0].getOldValue();
                    this.getModel().setValue("costdept", (Object)ErCommonUtils.getPk((Object)valueSet[0].getOldValue()));
                    this.getModel().endInit();
                }
                this.costDeptChange(propName, (DynamicObject)propValue);
                break;
            }
            case "costcompany": {
                if (propValue != null) break;
                this.getModel().beginInit();
                this.getModel().setValue(propName, valueSet[0].getOldValue());
                this.getModel().endInit();
                break;
            }
            case "vehicletype": 
            case "startdate": 
            case "vehicledate": 
            case "enddate": {
                if (null == propValue) break;
                Date startdate = this.getModel().getDataEntity(true).getDate("startdate");
                Date enddate = this.getModel().getDataEntity(true).getDate("enddate");
                String vehicletype = this.getModel().getDataEntity(true).getString("vehicletype");
                if (null != vehicletype && CarTypeEnum.HOVERTIME.getCode().equals(vehicletype) && null != startdate && null != enddate) {
                    Long dates = CommonServiceHelper.calcVehicleDays((Date)startdate, (Date)enddate);
                    this.getModel().setValue("vehiclenumber", (Object)(dates * (long)VEHICLE_COUNT));
                }
                if (startdate != null || enddate != null || !CarTypeEnum.HOVERTIME.getCode().equals(vehicletype)) break;
                this.getModel().setValue("vehiclenumber", (Object)VEHICLE_COUNT);
            }
        }
    }

    protected void costDeptChange(String propName, DynamicObject costDept) {
        if (costDept == null) {
            return;
        }
        IDataModel model = this.getModel();
        Long costCompany = CoreBaseBillServiceHelper.getAccountOrgId((boolean)true, (Long)((Long)costDept.getPkValue()));
        model.setValue("costcompany", (Object)costCompany);
        model.setValue("expensesassumeshowtypes", (Object)"1");
    }

    protected void refreshBaseInfoLabel(String propName, Object propValue) {
        String propStr = null;
        if (propValue instanceof DynamicObject) {
            ILocaleString name = ((DynamicObject)propValue).getLocaleString("name");
            propStr = name.getLocaleValue();
        } else if (propValue instanceof String) {
            propStr = (String)propValue;
        }
        Label propControl = (Label)this.getControl(propName + "V");
        if (propControl != null) {
            propControl.setText(propStr);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    private void setProjectF7Filter() {
        Object applier;
        BasedataEdit projectF7 = (BasedataEdit)this.getControl("headproject");
        if (projectF7 != null && (applier = this.getModel().getValue("applier")) != null) {
            projectF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeProjectF7SelectListener(ErCommonUtils.getPk((Object)applier), ErCommonUtils.getPk((Object)this.getModel().getValue("company"))));
        }
    }
}

