/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.dailybiz;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.trip.dailybiz.DailyReimCreateOrderEntrysUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ShowPageUtils;

public class PublicReimBillOrderEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final String DELETE_EXPENSE_ENTRY_IDS = "DELETE_EXPENSE_ENTRY_IDS";
    private static final Log logger = LogFactory.getLog(PublicReimBillOrderEdit.class);

    public void registerListener(EventObject e) {
        EntryGrid orderEntryControl;
        this.addItemClickListeners(new String[]{"advcontoolbarap3"});
        EntryGrid entryEntityControl = (EntryGrid)this.getControl("expenseentryentity");
        if (entryEntityControl != null) {
            entryEntityControl.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((orderEntryControl = (EntryGrid)this.getControl("orderentry")) != null) {
            orderEntryControl.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_copyentry": {
                IDataModel model = this.getModel();
                EntryGrid expenseEntryGrid = (EntryGrid)this.getView().getControl("expenseentryentity");
                if (expenseEntryGrid == null) {
                    return;
                }
                int[] selectRowIndexArr = expenseEntryGrid.getSelectRows();
                if (selectRowIndexArr == null) {
                    return;
                }
                for (int index : selectRowIndexArr) {
                    Boolean isexistmonthly = (Boolean)model.getValue("isexistmonthly", index);
                    if (!isexistmonthly.booleanValue()) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8d39\u7528\u5206\u5f55\u884c\u5df2\u5173\u8054\u5546\u65c5\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u590d\u5236\u3002", (String)"PublicReimBillOrderEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("orderentry");
        AdvContainer invoiceAdvContainer = (AdvContainer)this.getView().getControl("order_advconap");
        if (entryRowCount > 0) {
            invoiceAdvContainer.setCollapse(false);
        } else {
            invoiceAdvContainer.setCollapse(true);
        }
        DynamicObjectCollection orderentrys = model.getEntryEntity("orderentry");
        if (orderentrys.size() == 0) {
            return;
        }
        DynamicObjectCollection entryEntity = model.getEntryEntity("expenseentryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            if (!entry.getBoolean("isexistmonthly")) continue;
            String odernumStr = DailyReimCreateOrderEntrysUtil.getAllOrderNumStr((DynamicObjectCollection)orderentrys, (Long)ErCommonUtils.getPk((Object)entry.getPkValue()));
            model.setValue("ordernum", (Object)odernumStr, i);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = valueSet[0].getRowIndex();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        switch (propName) {
            case "exchangerate": {
                break;
            }
            case "expenseamount": {
                logger.info("PublicReimBillOrderEdit propertyChanged expenseamount");
                Boolean isexistmonthly = (Boolean)model.getValue("isexistmonthly", rowIndex);
                BigDecimal tripbookamount = (BigDecimal)this.getModel().getValue("tripbookamount", rowIndex);
                BigDecimal expenseamount = (BigDecimal)newValue;
                if (!isexistmonthly.booleanValue() || expenseamount.compareTo(tripbookamount) >= 0) break;
                logger.info("PublicReimBillOrderEdit propertyChanged expenseamount \uff1a" + expenseamount + ",tripbookamount:" + tripbookamount);
                model.setValue(propName, oldValue, rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5173\u8054\u5546\u65c5\u8ba2\u5355\u7684\u8d39\u7528\u660e\u7ec6\u884c\u62a5\u9500\u91d1\u989d\u4e0d\u5f97\u5c0f\u4e8e\u5546\u65c5\u9884\u8ba2\u91d1\u989d\u3002", (String)"PublicReimBillOrderEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if ("expenseentryentity".equals(entryName)) {
            IDataModel model = this.getModel();
            int[] rowIndexs = e.getRowIndexs();
            ArrayList<Long> deleteIDS = new ArrayList<Long>(rowIndexs.length);
            for (int rowIndex : rowIndexs) {
                Long id = ErCommonUtils.getPk((Object)model.getEntryRowEntity(entryName, rowIndex));
                deleteIDS.add(id);
            }
            ActionLocalCache.get().put(DELETE_EXPENSE_ENTRY_IDS, deleteIDS);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if ("expenseentryentity".equals(entryName)) {
            IDataModel model = this.getModel();
            List deleteIds = (List)ActionLocalCache.get().getDefaultIfNull(DELETE_EXPENSE_ENTRY_IDS, new ArrayList());
            if (deleteIds.size() > 0) {
                ArrayList<Integer> needDeleteRows = new ArrayList<Integer>();
                DynamicObjectCollection orderEntries = model.getEntryEntity("orderentry");
                for (int i = 0; i < orderEntries.size(); ++i) {
                    DynamicObject orderEntry = (DynamicObject)orderEntries.get(i);
                    Long ordexpenseentryid = orderEntry.getLong("ordexpenseentryid");
                    if (!deleteIds.contains(ordexpenseentryid)) continue;
                    needDeleteRows.add(i);
                }
                model.deleteEntryRows("orderentry", needDeleteRows.stream().mapToInt(Integer::intValue).toArray());
            }
            BigDecimal monthSettleAmount = AmountUtils.getEntryAmount((IDataModel)model, (String)"expenseentryentity", (String)"tripbookcuramount");
            model.setValue("monthsettleamount", (Object)monthSettleAmount);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldName = e.getFieldName();
        int rowIndex = e.getRowIndex();
        IDataModel model = this.getModel();
        switch (fieldName) {
            case "ordernum": {
                DynamicObject entry = (DynamicObject)model.getEntryEntity("expenseentryentity").get(rowIndex);
                Long detailid = ErCommonUtils.getPk((Object)entry);
                DynamicObjectCollection orderEntrys = model.getEntryEntity("orderentry");
                for (DynamicObject orderEntry : orderEntrys) {
                    if (detailid.longValue() != orderEntry.getLong("ordexpenseentryid")) continue;
                    String ordernum = orderEntry.getString("ordernumber");
                    String orderformid = orderEntry.getString("orderformid");
                    TripCommonUtil.openOrderBill((String)ordernum, (String)orderformid, (IFormView)this.getView());
                }
                break;
            }
            case "oabillnum": {
                String oabillnum = (String)model.getValue("oabillnum", rowIndex);
                String formNumber = "er_dailyapplybill";
                DynamicObject applyBill = QueryServiceHelper.queryOne((String)"er_dailyapplybill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)oabillnum)});
                if (applyBill == null) {
                    applyBill = QueryServiceHelper.queryOne((String)"er_tripreqbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)oabillnum)});
                    formNumber = "er_tripreqbill";
                }
                if (applyBill == null) break;
                ShowPageUtils.openLinkedForm((Object)applyBill.getLong("id"), (String)formNumber, (IFormView)this.getView());
                break;
            }
            case "ordernumber": {
                DynamicObject orderEntry = model.getEntryRowEntity("orderentry", rowIndex);
                String ordernum = orderEntry.getString("ordernumber");
                String orderformid = orderEntry.getString("orderformid");
                TripCommonUtil.openOrderBill((String)ordernum, (String)orderformid, (IFormView)this.getView());
            }
        }
    }
}

