/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.dailybiz;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.formplugin.trip.dailybiz.AbsDeleteServiceFeeFormPlugin;
import org.apache.commons.lang.StringUtils;

public class TripBusinessTravelInvoicePlugin
extends AbsDeleteServiceFeeFormPlugin {
    private static ThreadLocal<Set> invoiceNums = new ThreadLocal();

    @Override
    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        String kind = (String)this.getModel().getValue("billkind");
        boolean isMob = this.getView() instanceof IMobileView;
        Set<String> orderNumAndType = null;
        DynamicObjectCollection tripCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripEntry");
        if ("0".equalsIgnoreCase(kind) && "tripentry".equalsIgnoreCase(entryName)) {
            orderNumAndType = this.getInvoicePlaneOrders(tripCollection, e.getRowIndexs());
        } else if ("0".equalsIgnoreCase(kind) && "entryentity".equalsIgnoreCase(entryName)) {
            DynamicObjectCollection entryEntitys = ((DynamicObject)tripCollection.get(this.getModel().getEntryCurrentRowIndex("tripentry"))).getDynamicObjectCollection("entryentity");
            ArrayList<String> orders = new ArrayList<String>(1);
            for (int i : e.getRowIndexs()) {
                orders.add(((DynamicObject)entryEntitys.get(i)).getString("orderNum"));
            }
            orderNumAndType = this.getBusinessTravelInvoiceNums(orders);
        } else if ("1".equalsIgnoreCase(kind) && "entryentity".equalsIgnoreCase(entryName)) {
            DynamicObjectCollection entryEntitys = ((DynamicObject)tripCollection.get(0)).getDynamicObjectCollection("entryentity");
            int[] rows = e.getRowIndexs();
            ArrayList<String> orders = new ArrayList<String>(rows.length);
            for (int row : rows) {
                DynamicObject m = (DynamicObject)entryEntitys.get(row);
                if (!StringUtils.isNotBlank((String)m.getString("ordernum"))) continue;
                orders.add(m.getString("orderNum"));
            }
            orderNumAndType = this.getBusinessTravelInvoiceNums(orders);
        }
        if (orderNumAndType != null) {
            invoiceNums.set(orderNumAndType);
        }
    }

    @Override
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        String kind = (String)this.getModel().getValue("billkind");
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)entryName, (CharSequence)"invoiceentry")) {
            InvoiceUtils.updateInvoiceLabel((IFormView)this.getView());
        }
        if ("0".equalsIgnoreCase(kind) && ("tripentry".equalsIgnoreCase(entryName) || "entryentity".equalsIgnoreCase(entryName)) || "1".equalsIgnoreCase(kind) && "entryentity".equalsIgnoreCase(entryName)) {
            if (invoiceNums.get() == null || invoiceNums.get().size() == 0) {
                invoiceNums.remove();
                return;
            }
            DynamicObjectCollection invoiceEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("invoiceentry");
            HashSet<Integer> deleteInvoice = new HashSet<Integer>(4);
            for (int i = 0; i < invoiceEntry.size(); ++i) {
                DynamicObject invoice = (DynamicObject)invoiceEntry.get(i);
                if (!invoiceNums.get().contains(invoice.getString("invoiceno") + invoice.getString("ordertype"))) continue;
                deleteInvoice.add(i);
            }
            invoiceNums.remove();
            if (deleteInvoice.size() > 0) {
                this.getView().getPageCache().put("allowdeleteinvoice", "true");
                this.getModel().deleteEntryRows("invoiceentry", deleteInvoice.stream().mapToInt(m -> m).toArray());
                this.getView().getPageCache().remove("allowdeleteinvoice");
            }
        }
    }

    private Set<String> getInvoicePlaneOrders(DynamicObjectCollection tripCollection, int[] tripEntryIndexs) {
        ArrayList<String> list = new ArrayList<String>(4);
        for (int index : tripEntryIndexs) {
            DynamicObjectCollection entryCollection = ((DynamicObject)tripCollection.get(index)).getDynamicObjectCollection("entryentity");
            List orders = entryCollection.stream().filter(m -> StringUtils.isNotBlank((String)m.getString("ordernum"))).map(n -> n.getString("orderNum")).collect(Collectors.toList());
            list.addAll(orders);
        }
        return this.getBusinessTravelInvoiceNums(list);
    }

    private Set<String> getBusinessTravelInvoiceNums(List<String> list) {
        HashSet<String> orderNumAndTypes = new HashSet<String>(2);
        DynamicObjectCollection delOrders = QueryServiceHelper.query((String)"er_planebill", (String)"ticketnum, ordertype", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", list)});
        for (DynamicObject d : delOrders) {
            orderNumAndTypes.add(d.getString("ticketnum") + d.getString("ordertype"));
        }
        return orderNumAndTypes;
    }
}

