/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.home;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.MobileFormPosition;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.trip.overtime.TripOrderBillOvertimeHelper;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripUserGrantUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.trip.sso.util.TripSSOUtils;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang3.ObjectUtils;

public class TripAuthMobPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(TripAuthMobPlugin.class);

    public void registerListener(EventObject e) {
        IFormView view = this.getView();
        this.addClickListeners(new String[]{"confirm", "wait"});
        Container flex = (Container)view.getControl("flexpanelap");
        List items = flex.getItems();
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity" + i);
            if (ObjectUtils.isEmpty((Object)entryGrid)) continue;
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void click(EventObject evt) {
        HashMap returnMap;
        boolean ifLogin;
        FormShowParameter formShowParameter;
        IFormView view;
        block23: {
            Button btn = (Button)evt.getSource();
            IDataModel model = this.getModel();
            view = this.getView();
            formShowParameter = view.getFormShowParameter();
            ifLogin = false;
            returnMap = Maps.newHashMapWithExpectedSize((int)8);
            try {
                if (btn.getKey().equals("confirm")) {
                    Container flex = (Container)view.getControl("flexpanelap");
                    List items = flex.getItems();
                    if (CollectionUtils.isEmpty((Collection)items)) {
                        return;
                    }
                    int tmpTotal = items.size();
                    MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"er_trip_usergrant");
                    final ArrayList needDatas = Lists.newArrayListWithCapacity((int)16);
                    String currentUserNo = TripUserGrantUtils.getCurrentUserNo();
                    for (int i = 0; i < tmpTotal; ++i) {
                        DynamicObject dynamicObject2;
                        boolean aBoolean;
                        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity" + i);
                        if (CollectionUtils.isEmpty((Collection)entryentity) || !(aBoolean = (dynamicObject2 = (DynamicObject)entryentity.get(0)).getBoolean("check" + i)) || StringUtils.isEmpty((String)dynamicObject2.getString("servername" + i))) continue;
                        RequestContext context = RequestContext.get();
                        DynamicObject waitAddDynamicObject = new DynamicObject((DynamicObjectType)entityType);
                        String serverName = dynamicObject2.getString("servername" + i);
                        DynamicObjectCollection servers = TripUserGrantUtils.getServers((String)serverName);
                        waitAddDynamicObject.set("grantusername", (Object)context.getUserName());
                        waitAddDynamicObject.set("grantservers", (Object)serverName);
                        waitAddDynamicObject.set("grant", (Object)"1");
                        waitAddDynamicObject.set("grantuserno", (Object)currentUserNo);
                        waitAddDynamicObject.set("grantcontent_tag", (Object)((DynamicObject)servers.get(0)).getString("authroziedcontent_tag"));
                        waitAddDynamicObject.set("grantip", (Object)context.getLoginIP());
                        waitAddDynamicObject.set("granttime", (Object)new Date());
                        waitAddDynamicObject.set("grantmodel", (Object)context.getClient());
                        waitAddDynamicObject.set("grantuser", (Object)context.getCurrUserId());
                        needDatas.add(waitAddDynamicObject);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)needDatas)) {
                        final Object loginExternalPlatforms = formShowParameter.getCustomParam("loginExternalPlatforms");
                        SaveServiceHelper.save((DynamicObject[])needDatas.toArray(new DynamicObject[0]));
                        ThreadService.execute((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TripUserGrantUtils.syncData((List)needDatas, (Object)loginExternalPlatforms, (Object)formShowParameter.getCustomParam("applyBillId"));
                            }
                        }, (TaskType)TaskType.ER_TRIP_TASK, (RequestContext)RequestContext.get());
                        List didiServers = needDatas.stream().filter(dynamicObject -> Supplier.DIDI.name().equals(dynamicObject.getString("grantservers"))).collect(Collectors.toList());
                        List gaoDeServers = needDatas.stream().filter(dynamicObject -> Supplier.GAODE.name().equals(dynamicObject.getString("grantservers"))).collect(Collectors.toList());
                        if (loginExternalPlatforms != null && "true".equals(loginExternalPlatforms.toString())) {
                            if (CollectionUtils.isNotEmpty(didiServers)) {
                                ifLogin = true;
                                Map paramMap = CommonServiceHelper.getUserMap((Long)CommonServiceHelper.getCurrentUserID());
                                TripCommonUtil.openURL((String)Supplier.DIDI.name(), (String)"car", (Map)paramMap, (IFormView)this.getView());
                            }
                            if (CollectionUtils.isNotEmpty(gaoDeServers)) {
                                ifLogin = true;
                                TripCommonUtil.openFieldMappingLogin((IFormView)this.getView(), (String)"gaode_car", (String)Supplier.GAODE.name());
                            }
                            if (needDatas.size() == 1) {
                                try {
                                    Object key = formShowParameter.getCustomParam("controlKey");
                                    Long userId = RequestContext.get().getCurrUserId();
                                    DynamicObject userInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
                                    Optional<DynamicObject> mainJobOp = userInfo.getDynamicObjectCollection("entryentity").stream().filter(row -> !row.getBoolean("ispartjob")).findFirst();
                                    String tripReverseControlType = "0";
                                    if (mainJobOp.isPresent()) {
                                        Long companyId = CoreBaseBillServiceHelper.initCompanyByDept((Long)ErCommonUtils.getPk((Object)mainJobOp.get().getDynamicObject("dpt")));
                                        tripReverseControlType = SystemParamterUtil.getTripReserveControlType((Long)companyId);
                                    }
                                    boolean continueJump = Boolean.FALSE;
                                    if ("1".equals(tripReverseControlType)) {
                                        continueJump = QueryServiceHelper.exists((String)"er_businesswhitelist", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("enble", "=", (Object)Boolean.TRUE)});
                                    } else if ("0".equals(tripReverseControlType)) {
                                        continueJump = Boolean.TRUE;
                                    }
                                    if (key != null && continueJump) {
                                        ifLogin = true;
                                        TripSSOUtils.commonLogin(key.toString(), this.getView());
                                    }
                                }
                                catch (Exception e) {
                                    logger.error("\u6388\u6743\u540e\u7ee7\u7eed\u8df3\u8f6c\u670d\u52a1\u5546\u9519\u8bef", (Throwable)e);
                                    ifLogin = false;
                                }
                            }
                        }
                        if (needDatas.size() == 1 && CollectionUtils.isNotEmpty(didiServers)) {
                            returnMap.put("server", "DIDI");
                        }
                        if (needDatas.size() == 1 && CollectionUtils.isNotEmpty(gaoDeServers)) {
                            returnMap.put("server", "GAODE");
                        }
                        break block23;
                    }
                    returnMap.put("result", "notGrant");
                    break block23;
                }
                returnMap.put("result", "notGrant");
            }
            catch (Exception e) {
                logger.error("\u6570\u636e\u6388\u6743\u5931\u8d25:", (Throwable)e);
            }
        }
        Object aContinue = formShowParameter.getCustomParam("continue");
        view.setReturnData((Object)returnMap);
        view.returnDataToParent((Object)returnMap);
        if (!ifLogin) {
            if (aContinue == null || "true".equals(aContinue.toString())) {
                this.checkOvertimeOrderBill();
            }
            view.close();
        } else if (formShowParameter.getCustomParam("error") != null && "true".equals(formShowParameter.getCustomParam("error").toString())) {
            view.close();
        }
    }

    public void beforeBindData(EventObject e) {
        this.showData();
    }

    private void showData() {
        try {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            FormShowParameter formShowParameter = view.getFormShowParameter();
            String serverStr = TripUserGrantUtils.getViewParamServer((FormShowParameter)formShowParameter);
            DynamicObjectCollection enables = TripUserGrantUtils.getNotGrantServers((String)serverStr);
            List newEnables = TripUserGrantUtils.judgeTrial((DynamicObjectCollection)enables);
            int size = newEnables.size();
            int index = 0;
            for (int i = 0; i < size; ++i) {
                DynamicObject dynamicObject = (DynamicObject)newEnables.get(i);
                model.setValue("content" + index, (Object)ResManager.loadKDString((String)"\u67e5\u770b\u6388\u6743\u8bf4\u660e", (String)"TripAuthMobPlugin_01", (String)"fi-er-formplugin", (Object[])new Object[0]));
                model.setValue("servername" + index, (Object)dynamicObject.getString("number"));
                ++index;
            }
        }
        catch (Exception e) {
            logger.error("Mobile\u6570\u636e\u5c55\u793a\u9519\u8bef:", (Throwable)e);
        }
    }

    private void checkOvertimeOrderBill() {
        TripOrderBillOvertimeHelper helper = new TripOrderBillOvertimeHelper();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List overtimeOrderBill = helper.getOrderToRemind(userId);
        if (!overtimeOrderBill.isEmpty()) {
            HashMap<String, Integer> customParam = new HashMap<String, Integer>();
            customParam.put("count", overtimeOrderBill.size());
            HashMap<String, String> para = new HashMap<String, String>();
            para.put("formId", "er_overtime_remind");
            MobileFormShowParameter showParameter = (MobileFormShowParameter)FormShowParameter.createFormShowParameter(para);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setPosition(MobileFormPosition.Bottom);
            showParameter.setCustomParams(customParam);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "er_overtime_remind");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if ("er_overtime_remind".equalsIgnoreCase(actionId)) {
            this.overtimeRemindClosedCallBack(e);
            this.getView().close();
        }
    }

    private void overtimeRemindClosedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData != null && "go".equals(returnData.toString())) {
            this.initNotReimburse();
            HashMap<String, Boolean> customParam = new HashMap<String, Boolean>();
            customParam.put("isRealTime", true);
            customParam.put("isOverdue", true);
            ShowPageUtils.showPage((FormModel)new FormModel("er_vieworder", ResManager.loadKDString((String)"\u67e5\u770b\u8ba2\u5355", (String)"TripMainPagePlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", false, customParam), (AbstractFormPlugin)this);
        }
    }

    protected void initNotReimburse() {
        DynamicObject dept;
        Map countMap = CommonServiceHelper.getNotReimburseCountUsedByEmPage((Long)CommonServiceHelper.getCurrentUserID());
        int tripNotReimburseCount = (Integer)countMap.get("tripNotReimburseCount");
        Long currentUserID = CommonServiceHelper.getCurrentUserID();
        BigDecimal amount = CommonServiceHelper.getTripReimburseOutStandingAmount((Long)currentUserID);
        Map userMap = CommonServiceHelper.getUserMap((Long)currentUserID);
        Label labelap_watingv = (Label)this.getView().getParentView().getControl("labelap_watingv");
        Label labelap_outstandingv = (Label)this.getView().getParentView().getControl("labelap_outstandingv");
        DynamicObject currency = null;
        labelap_watingv.setText(tripNotReimburseCount + "");
        if (userMap != null && (dept = (DynamicObject)userMap.get("org")) != null && (currency = BaseCurrencyServiceHelper.getBaseCurrencyObject((Long)((Long)dept.getPkValue()))) != null) {
            AmountFormatsUtil.setAmountLabel((Label)labelap_outstandingv, (DynamicObject)currency, (BigDecimal)amount);
        }
    }

    public void afterBindData(EventObject e) {
        try {
            DynamicObjectCollection notGrantServers = TripUserGrantUtils.getNotGrantServers((String)TripUserGrantUtils.getViewParamServer((FormShowParameter)this.getView().getFormShowParameter()));
            List newEnables = TripUserGrantUtils.judgeTrial((DynamicObjectCollection)notGrantServers);
            int size = newEnables.size();
            IFormView view = this.getView();
            Container flex = (Container)view.getControl("flexpanelap");
            List items = flex.getItems();
            if (CollectionUtils.isEmpty((Collection)items)) {
                return;
            }
            int tmpTotal = items.size();
            if (size > tmpTotal) {
                return;
            }
            for (int i = size; i < tmpTotal; ++i) {
                view.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap" + i});
            }
            view.setEnable(Boolean.FALSE, new String[]{"confirm"});
        }
        catch (Exception ex) {
            logger.error("\u521d\u59cb\u5316\u6570\u636e\u9519\u8bef:", (Throwable)ex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            String name = e.getProperty().getName();
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            ChangeData[] changeSet = e.getChangeSet();
            if (name.startsWith("check")) {
                if (changeSet == null || changeSet.length == 0) {
                    return;
                }
                Object newValue = changeSet[0].getNewValue();
                if (newValue != null) {
                    String s = newValue.toString();
                    if ("true".equals(s)) {
                        view.setEnable(Boolean.TRUE, new String[]{"confirm"});
                    } else {
                        boolean okVisible = Boolean.FALSE;
                        Container flex = (Container)view.getControl("flexpanelap");
                        List items = flex.getItems();
                        if (CollectionUtils.isEmpty((Collection)items)) {
                            return;
                        }
                        int size = items.size();
                        for (int i = 0; i < size; ++i) {
                            DynamicObject dynamicObject;
                            boolean grant;
                            DynamicObjectCollection entryentity = model.getEntryEntity("entryentity" + i);
                            if (CollectionUtils.isEmpty((Collection)entryentity) || !(grant = (dynamicObject = (DynamicObject)entryentity.get(0)).getBoolean("check" + i))) continue;
                            okVisible = Boolean.TRUE;
                            break;
                        }
                        view.setEnable(Boolean.valueOf(okVisible), new String[]{"confirm"});
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("\u5c5e\u6027\u6539\u53d8\u9519\u8bef:", (Throwable)ex);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof CardEntry) {
            CardEntry cardEntry = (CardEntry)source;
            String entryKey = cardEntry.getEntryKey();
            String index = entryKey.substring(entryKey.length() - 1);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryKey);
            if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(0);
                String server = dynamicObject.getString("servername" + index);
                if (server == null) {
                    return;
                }
                HashMap paramMap = Maps.newHashMapWithExpectedSize((int)8);
                paramMap.put("formId", "er_trip_grantcontent_mb");
                MobileFormShowParameter showParameter = (MobileFormShowParameter)MobileFormShowParameter.createFormShowParameter((Map)paramMap);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("server", (Object)server);
                HashMap<String, String> m = new HashMap<String, String>(1);
                m.put("position", "center");
                showParameter.getOpenStyle().setCustParam(m);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }
}

