/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.home;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.er.business.utils.TripUserGrantUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang3.ObjectUtils;

public class TripAuthPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(TripAuthPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (!ObjectUtils.isEmpty((Object)entryGrid)) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        this.showData();
    }

    private void showData() {
        try {
            IDataModel model = this.getModel();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String serverStr = TripUserGrantUtils.getViewParamServer((FormShowParameter)formShowParameter);
            boolean index = false;
            DynamicObjectCollection enables = TripUserGrantUtils.getNotGrantServers((String)serverStr);
            List newEnables = TripUserGrantUtils.judgeTrial((DynamicObjectCollection)enables);
            model.batchCreateNewEntryRow("entryentity", newEnables.size());
            for (int i = 0; i < newEnables.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)newEnables.get(i);
                model.setValue("servername", (Object)dynamicObject.getString("number"), i);
            }
            this.getView().updateView("entryentity");
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u5c55\u793a\u9519\u8bef:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void click(EventObject evt) {
        try (IFormView view = this.getView();){
            Control control = (Control)evt.getSource();
            String key = control.getKey();
            IDataModel model = this.getModel();
            final FormShowParameter formShowParameter = view.getFormShowParameter();
            switch (key) {
                case "btnok": {
                    RequestContext context = RequestContext.get();
                    String currentUserNo = TripUserGrantUtils.getCurrentUserNo();
                    MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"er_trip_usergrant");
                    final ArrayList needDatas = Lists.newArrayListWithCapacity((int)16);
                    DynamicObjectCollection modelEntryEntity = model.getEntryEntity("entryentity");
                    int i = 0;
                    while (true) {
                        if (i >= modelEntryEntity.size()) {
                            if (!CollectionUtils.isNotEmpty((Collection)needDatas)) return;
                            final Object loginExternalPlatforms = formShowParameter.getCustomParam("loginExternalPlatforms");
                            SaveServiceHelper.save((DynamicObject[])needDatas.toArray(new DynamicObject[0]));
                            ThreadService.execute((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    TripUserGrantUtils.syncData((List)needDatas, (Object)loginExternalPlatforms, (Object)formShowParameter.getCustomParam("applyBillId"));
                                }
                            }, (TaskType)TaskType.ER_TRIP_TASK, (RequestContext)RequestContext.get());
                            return;
                        }
                        DynamicObject dynamicObject = (DynamicObject)modelEntryEntity.get(i);
                        boolean grant = dynamicObject.getBoolean("check");
                        if (grant && !StringUtils.isEmpty((String)dynamicObject.getString("servername"))) {
                            DynamicObject waitAddDynamicObject = new DynamicObject((DynamicObjectType)entityType);
                            String serverName = dynamicObject.getString("servername");
                            DynamicObjectCollection servers = TripUserGrantUtils.getServers((String)serverName);
                            waitAddDynamicObject.set("grantusername", (Object)context.getUserName());
                            waitAddDynamicObject.set("grantservers", (Object)serverName);
                            waitAddDynamicObject.set("grant", (Object)"1");
                            waitAddDynamicObject.set("grantuserno", (Object)currentUserNo);
                            waitAddDynamicObject.set("grantcontent_tag", (Object)((DynamicObject)servers.get(0)).getString("authroziedcontent_tag"));
                            waitAddDynamicObject.set("grantip", (Object)context.getLoginIP());
                            waitAddDynamicObject.set("granttime", (Object)new Date());
                            waitAddDynamicObject.set("grantmodel", (Object)context.getClient());
                            waitAddDynamicObject.set("grantuser", (Object)context.getCurrUserId());
                            needDatas.add(waitAddDynamicObject);
                        }
                        ++i;
                    }
                }
            }
            return;
        }
    }

    public void afterBindData(EventObject e) {
        try {
            DynamicObjectCollection notGrantServers = TripUserGrantUtils.getNotGrantServers((String)TripUserGrantUtils.getViewParamServer((FormShowParameter)this.getView().getFormShowParameter()));
            List newEnables = TripUserGrantUtils.judgeTrial((DynamicObjectCollection)notGrantServers);
            int size = newEnables.size();
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                return;
            }
            int tmpTotal = entryEntity.size();
            if (size > tmpTotal) {
                return;
            }
            view.setEnable(Boolean.FALSE, new String[]{"btnok"});
        }
        catch (Exception ex) {
            logger.error("\u521d\u59cb\u5316\u6570\u636e\u9519\u8bef:", (Throwable)ex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            String name = e.getProperty().getName();
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            ChangeData[] changeSet = e.getChangeSet();
            if (name.startsWith("check")) {
                if (changeSet == null || changeSet.length == 0) {
                    return;
                }
                Object newValue = changeSet[0].getNewValue();
                if (newValue != null) {
                    String s = newValue.toString();
                    if ("true".equals(s)) {
                        view.setEnable(Boolean.TRUE, new String[]{"btnok"});
                    } else {
                        boolean okVisible = Boolean.FALSE;
                        DynamicObjectCollection modelEntryEntity = model.getEntryEntity("entryentity");
                        if (CollectionUtils.isEmpty((Collection)modelEntryEntity)) {
                            return;
                        }
                        int size = modelEntryEntity.size();
                        for (int i = 0; i < size; ++i) {
                            DynamicObject dynamicObject = (DynamicObject)modelEntryEntity.get(i);
                            boolean grant = dynamicObject.getBoolean("check");
                            if (!grant) continue;
                            okVisible = Boolean.TRUE;
                            break;
                        }
                        view.setEnable(Boolean.valueOf(okVisible), new String[]{"btnok"});
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("\u5c5e\u6027\u4fee\u6539\u9519\u8bef:", (Throwable)ex);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        Object server = this.getModel().getValue("servername", rowIndex);
        if (server == null) {
            return;
        }
        HashMap<String, Object> customParamMap = new HashMap<String, Object>(16);
        customParamMap.put("server", server);
        FormModel formModel = new FormModel("er_trip_grantcontent", ResManager.loadKDString((String)"\u6388\u6743\u8bf4\u660e", (String)"TravelExpenseBillPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "1", true, customParamMap);
        formModel.setShowType(ShowType.Modal);
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
    }
}

