/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.order;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.TripOrderUtil;
import kd.fi.er.formplugin.trip.order.AbstractOrderNoticePlugin;

public class OrderNoticePlugin
extends AbstractOrderNoticePlugin
implements ItemClickListener {
    private static Log logger = LogFactory.getLog(OrderNoticePlugin.class);

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("confrimbutton".equals(key)) {
            String str = ResManager.loadKDString((String)"\u8ba2\u5355\u4fe1\u606f\u662f\u5426\u6b63\u786e\uff1f", (String)"OrderNoticePlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(str, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ok", (IFormPlugin)this));
        } else if ("feedbackbutton".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(this.getFeedbackFormId());
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.getCustomParams().put("feedback", this.getModel().getValue("feedback"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, showParameter.getFormId()));
            this.getView().showForm(showParameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getModel().setValue("isconfirm", (Object)"1");
            DynamicObject object = this.getModel().getDataEntity();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            TripOrderUtil.confrimAllOrder((Long)ErCommonUtils.getPk((Object)this.getModel().getDataEntity().getPkValue()));
            String str = ResManager.loadKDString((String)"\u786e\u8ba4\u6210\u529f\u3002", (String)"OrderNoticePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(str);
        }
    }

    @Override
    String getFeedbackFormId() {
        return "er_trip_order_feedback";
    }

    public void beforeBindData(EventObject e) {
        try {
            BigDecimal bigDecimal;
            super.beforeBindData(e);
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            Object totalamount = model.getValue("totalamount");
            if (totalamount != null && (bigDecimal = new BigDecimal(totalamount.toString())).compareTo(ConvertUtil.getOrderAmountInit()) == 0) {
                HashMap map = Maps.newHashMapWithExpectedSize((int)2);
                map.put("zs", false);
                HashMap items = Maps.newHashMapWithExpectedSize((int)2);
                items.put("item", map);
                view.updateControlMetadata("totalamount", (Map)items);
                model.setValue("totalamount", null);
                model.setDataChanged(false);
            }
        }
        catch (Exception ex) {
            logger.error("beforeBindData error", (Throwable)ex);
        }
    }
}

