/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.payinvoice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.QueryInvoiceDetailBO;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.TripInvoiceUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.common.model.attachment.AttachmentData;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.formplugin.invoicecloud.v2.tripbusi.ImportInvoiceForCheckingPayBillPlugin;
import org.apache.commons.lang3.StringUtils;

public class CheckingPayBillInvoiceEntryEditPlugin
extends ImportInvoiceForCheckingPayBillPlugin
implements IBillPlugin,
RowClickEventListener,
UploadListener {
    private static final Log logger = LogFactory.getLog(CheckingPayBillInvoiceEntryEditPlugin.class);
    private static final String UPLOAD_INVOICE_ATTACHMENT = "uploadinvoiceattachment";
    private static final String ONC_CLICK_UPLOAD_INVOICE = "oneclickuploadinvoice";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        int[] rowIndexs = entryGrid.getSelectRows();
        if (StringUtils.equals((CharSequence)UPLOAD_INVOICE_ATTACHMENT, (CharSequence)itemKey)) {
            if (rowIndexs == null || rowIndexs.length == 0) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ed3\u7b97\u5355\u660e\u7ec6\uff0c\u518d\u70b9\u51fb\u201c\u4e00\u952e\u4e0a\u4f20\u53d1\u7968\u5f71\u50cf\u9644\u4ef6\u201d\u64cd\u4f5c\u9879\u3002", (String)"CheckingPayBillEditPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
            }
        } else if (StringUtils.equals((CharSequence)ONC_CLICK_UPLOAD_INVOICE, (CharSequence)itemKey)) {
            DynamicObject costCompanyDO = this.getCostCompanyDO();
            InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)costCompanyDO));
            if (config == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u542f\u7528\u53d1\u7968\u4e91\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"CheckingPayBillEditPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            if (rowIndexs == null || rowIndexs.length == 0) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ed3\u7b97\u5355\u660e\u7ec6\uff0c\u518d\u70b9\u51fb\u201c\u4e00\u952e\u4e0a\u4f20\u53d1\u7968\u201d\u64cd\u4f5c\u9879\u3002", (String)"CheckingPayBillEditPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            ArrayList validateList = Lists.newArrayListWithExpectedSize((int)16);
            for (int rowIndex : rowIndexs) {
                DynamicObject dynamicObject2 = (DynamicObject)entryEntity.get(rowIndex);
                validateList.add(dynamicObject2);
            }
            List resultList = validateList.stream().filter(dynamicObject -> !dynamicObject.getBoolean("isuploadinvoicecloud")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(resultList)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5747\u5df2\u4e0a\u4f20\u53d1\u7968\u4e91\uff0c\u8bf7\u9009\u62e9\u672a\u4e0a\u4f20\u53d1\u7968\u7684\u7ed3\u7b97\u5355\u660e\u7ec6\uff08\u201c\u4e0a\u4f20\u53d1\u7968\u4e91\u201d\u4e3a\u201c\u5426\u201d\uff09\u3002", (String)"CheckingPayBillEditPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
            }
        }
        if (!evt.isCancel() && StringUtils.equalsAny((CharSequence)itemKey, (CharSequence[])new CharSequence[]{ONC_CLICK_UPLOAD_INVOICE, UPLOAD_INVOICE_ATTACHMENT})) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("formId", "er_progressbar");
            paramMap.put("showType", ShowType.Modal);
            paramMap.put("needCallBack", Boolean.TRUE);
            ShowPageUtils.showWebForm(paramMap, (AbstractFormPlugin)this);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        final String itemKey = evt.getItemKey();
        final IFormView view = this.getView();
        final IPageCache pageCache = this.getPageCache();
        RequestContext rc = RequestContext.get();
        final String clientFullContextPath = rc.getClientFullContextPath();
        if (StringUtils.equals((CharSequence)UPLOAD_INVOICE_ATTACHMENT, (CharSequence)itemKey)) {
            ThreadService.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        RequestContext context = RequestContext.get();
                        context.setClientFullContextPath(clientFullContextPath);
                        pageCache.put("type", "attach");
                        int count = CheckingPayBillInvoiceEntryEditPlugin.this.uploadImageInfoToAttr();
                        if (count == 0) {
                            pageCache.put("remind", ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5e94\u53d1\u7968\u5f71\u50cf\u6587\u4ef6\uff0c\u8bf7\u91cd\u8bd5\u6216\u624b\u52a8\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"CheckingPayBillEditPlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        } else if (count > 0) {
                            pageCache.put("success", ResManager.loadKDString((String)"\u4e00\u952e\u4e0a\u4f20\u53d1\u7968\u5f71\u50cf\u9644\u4ef6\u6210\u529f\u3002", (String)"CheckingPayBillEditPlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u4e00\u952e\u4e0a\u4f20\u53d1\u7968\u9644\u4ef6\u5931\u8d25:", (Throwable)e);
                        String msg = String.format(ResManager.loadKDString((String)"\u4e00\u952e\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u67e5\u8be2\u65e5\u5fd7\u3002TraceId\uff1a%1$s\u3002", (String)"CheckingBillEdit_7", (String)"fi-er-formplugin", (Object[])new Object[0]), RequestContext.get().getTraceId());
                        pageCache.put("error", msg);
                    }
                    finally {
                        pageCache.put("task_percent", "100");
                    }
                }
            }, (TaskType)TaskType.ER_LOWFREQUENCYTASK_TASK, (RequestContext)RequestContext.get());
        } else {
            ThreadService.execute((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (StringUtils.equals((CharSequence)CheckingPayBillInvoiceEntryEditPlugin.ONC_CLICK_UPLOAD_INVOICE, (CharSequence)itemKey)) {
                        try {
                            logger.info("\u5f53\u524d\u7ebf\u7a0b\u7684traceId  {}", (Object)RequestContext.get().getTraceId());
                            pageCache.put("type", "invoice");
                            boolean enableXhInvoiceCloud = KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud();
                            HashMap indexAndData = Maps.newHashMapWithExpectedSize((int)16);
                            List waitSiftData = CheckingPayBillInvoiceEntryEditPlugin.this.getSelectedDatas(indexAndData);
                            Map resultMap = CheckingPayBillInvoiceEntryEditPlugin.this.siftData(waitSiftData);
                            HashMap waitUpdateEntryMap = Maps.newHashMapWithExpectedSize((int)16);
                            Map resultCountMap = enableXhInvoiceCloud ? CheckingPayBillInvoiceEntryEditPlugin.this.XhInvoiceFunction(resultMap, waitUpdateEntryMap) : CheckingPayBillInvoiceEntryEditPlugin.this.AwsInvoiceFunction(resultMap, waitUpdateEntryMap);
                            CheckingPayBillInvoiceEntryEditPlugin.this.updateEntryDatas(waitUpdateEntryMap, indexAndData);
                            CheckingPayBillInvoiceEntryEditPlugin.this.updateEntryInvoiceNos(indexAndData);
                            int size = CheckingPayBillInvoiceEntryEditPlugin.this.getTotal(resultMap);
                            String errorMsg = String.format(ResManager.loadKDString((String)"\u4e00\u952e\u4e0a\u4f20\u53d1\u7968\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\uff1b\u8bf7\u5230\u3010\u673a\u7968/\u706b\u8f66\u7ed3\u7b97\u5355\u3011\u5217\u8868\u9875\u7b5b\u9009\u51fa\u672a\u8bc6\u522b\u6210\u529f\u7684\u53d1\u7968\u8fdb\u884c\u624b\u52a8\u8bc6\u522b\uff08\u901a\u8fc7\u201c\u53d1\u7968\u8bc6\u522b\u6210\u529f\u201d\u5b57\u6bb5\u8fdb\u884c\u7b5b\u9009\uff09\u540e\u518d\u6b21\u4e00\u952e\u4e0a\u4f20\u53d1\u7968\uff0c\u6216\u624b\u52a8\u5bfc\u5165\u53d1\u7968\u3002", (String)"CheckingPayBillEditPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]), resultCountMap.get("success"), size - (Integer)resultCountMap.get("success"));
                            if (size == (Integer)resultCountMap.get("success")) {
                                errorMsg = ResManager.loadKDString((String)"\u4e00\u952e\u4e0a\u4f20\u53d1\u7968\u6210\u529f\u3002", (String)"CheckingPayBillEditPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]);
                                pageCache.put("success", errorMsg);
                            } else {
                                pageCache.put("remind", errorMsg);
                            }
                        }
                        catch (Exception e) {
                            logger.error("\u4e00\u952e\u4e0a\u4f20\u53d1\u7968\u5931\u8d25:", (Throwable)e);
                            String msg = String.format(ResManager.loadKDString((String)"\u4e00\u952e\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u67e5\u8be2\u65e5\u5fd7\u3002TraceId\uff1a%1$s\u3002", (String)"CheckingBillEdit_7", (String)"fi-er-formplugin", (Object[])new Object[0]), RequestContext.get().getTraceId());
                            pageCache.put("error", msg);
                        }
                        finally {
                            pageCache.put("task_percent", "100");
                            view.getActionResult();
                        }
                    }
                }
            }, (TaskType)TaskType.ER_LOWFREQUENCYTASK_TASK, (RequestContext)RequestContext.get());
        }
    }

    private int getTotal(Map<String, Set<DynamicObject>> resultMap) {
        int count = 0;
        for (Set<DynamicObject> value : resultMap.values()) {
            count = Integer.sum(count, value.size());
        }
        logger.info("\u5f53\u524d\u8bc6\u522b\u603b\u6570:{}", (Object)count);
        return count;
    }

    private Map<String, Integer> AwsInvoiceFunction(Map<String, Set<DynamicObject>> resultMap, Map<String, Set<DynamicObject>> waitUpdateEntryMap) throws Exception {
        Set<DynamicObject> monthbill;
        int totalSuccessCount = 0;
        int totalFailCount = 0;
        int totalCount = 0;
        HashSet totalIdentifySuccess = Sets.newHashSetWithExpectedSize((int)16);
        HashSet waitCallInvoiceCloudApiData = Sets.newHashSetWithExpectedSize((int)16);
        HashSet waitCallInvoiceCloudApiByCheckingData = Sets.newHashSetWithExpectedSize((int)16);
        Set<Map.Entry<String, Set<DynamicObject>>> entries = resultMap.entrySet();
        HashSet serialNos = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<String, Set<DynamicObject>> entry : entries) {
            String key = entry.getKey();
            if ("identifyFail_checking".equalsIgnoreCase(key)) {
                waitCallInvoiceCloudApiByCheckingData.addAll((Collection)entry.getValue());
                continue;
            }
            waitCallInvoiceCloudApiData.addAll((Collection)entry.getValue());
        }
        serialNos.addAll(this.dealAwsInvoiceCloud(waitUpdateEntryMap, (Set<DynamicObject>)totalIdentifySuccess, waitCallInvoiceCloudApiData));
        serialNos.addAll(this.dealAwsInvoiceCloud(waitUpdateEntryMap, (Set<DynamicObject>)waitCallInvoiceCloudApiByCheckingData, Boolean.FALSE));
        if (waitUpdateEntryMap.containsKey("monthbill") && CollectionUtils.isNotEmpty(monthbill = waitUpdateEntryMap.get("monthbill"))) {
            totalSuccessCount = Integer.sum(monthbill.size(), totalSuccessCount);
        }
        totalCount = entries.size();
        int successSize = totalIdentifySuccess.size();
        totalSuccessCount = Integer.sum(totalSuccessCount, successSize);
        totalFailCount = Integer.sum(totalFailCount, Math.abs(totalCount - totalSuccessCount));
        logger.info("AWS\u603b\u6570\u91cf:{}", (Object)totalCount);
        logger.info("AWS\u6210\u529f\u6570\u91cf:{}", (Object)totalSuccessCount);
        logger.info("AWS\u5931\u8d25\u6570\u91cf:{}", (Object)totalFailCount);
        this.callInvoiceCloudQueryApi(serialNos, Boolean.FALSE);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)2);
        countMap.put("success", totalSuccessCount);
        countMap.put("fail", totalFailCount);
        return countMap;
    }

    private Set<String> dealAwsInvoiceCloud(Map<String, Set<DynamicObject>> waitUpdateEntryMap, Set<DynamicObject> waitCallInvoiceCloudApiByCheckingData, Boolean flag) {
        if (!flag.booleanValue()) {
            ThreeTuple<Set<String>, Set<DynamicObject>, Set<DynamicObject>> resultTuple = this.callInvoiceCloudApi(waitCallInvoiceCloudApiByCheckingData, Boolean.TRUE, Boolean.FALSE);
            Set successDatas = (Set)resultTuple.item2;
            waitUpdateEntryMap.put("monthbill", Sets.newHashSet((Iterable)successDatas));
            return (Set)resultTuple.item1;
        }
        return new HashSet<String>();
    }

    private Set<String> dealAwsInvoiceCloud(Map<String, Set<DynamicObject>> waitUpdateEntryMap, Set<DynamicObject> totalIdentifySuccess, Set<DynamicObject> identifyData) {
        ThreeTuple<Set<String>, Set<DynamicObject>, Set<DynamicObject>> resultTuple = this.callInvoiceCloudApi(identifyData, Boolean.TRUE, Boolean.FALSE);
        this.dealResult(waitUpdateEntryMap, totalIdentifySuccess, resultTuple);
        return (Set)resultTuple.item1;
    }

    private Map<String, Integer> XhInvoiceFunction(Map<String, Set<DynamicObject>> resultMap, Map<String, Set<DynamicObject>> waitUpdateEntryMap) throws Exception {
        ThreeTuple<Set<String>, Set<DynamicObject>, Set<DynamicObject>> resultTuple;
        Set<DynamicObject> identifyFail;
        int totalSuccessCount = 0;
        int totalFailCount = 0;
        HashSet totalIdentifySuccess = Sets.newHashSetWithExpectedSize((int)16);
        HashSet serialNos = Sets.newHashSetWithExpectedSize((int)16);
        if (resultMap.containsKey("identifySuccess")) {
            Set<DynamicObject> identifySuccess = resultMap.get("identifySuccess");
            logger.info("identifySuccess size{}", (Object)identifySuccess.size());
            totalSuccessCount = Integer.sum(totalSuccessCount, identifySuccess.size());
            waitUpdateEntryMap.put("checkingbill", identifySuccess);
            serialNos.addAll(identifySuccess.stream().filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("serialno"))).map(dynamicObject -> dynamicObject.getString("serialno")).collect(Collectors.toSet()));
            totalIdentifySuccess.addAll(identifySuccess);
        }
        if (resultMap.containsKey("identifyFail")) {
            identifyFail = resultMap.get("identifyFail");
            logger.info("identifyFail size{}", (Object)identifyFail.size());
            resultTuple = this.callInvoiceCloudApi(identifyFail, Boolean.TRUE, Boolean.TRUE);
            int successCount = ((Set)resultTuple.item2).size();
            totalSuccessCount = Integer.sum(totalSuccessCount, successCount);
            totalFailCount = Integer.sum(totalFailCount, ((Set)resultTuple.item3).size());
            this.dealResult(waitUpdateEntryMap, totalIdentifySuccess, resultTuple);
            serialNos.addAll((Collection)resultTuple.item1);
        }
        if (resultMap.containsKey("identifyFail_checking")) {
            identifyFail = resultMap.get("identifyFail_checking");
            logger.info("identifyFail_checking size{}", (Object)identifyFail.size());
            resultTuple = this.callInvoiceCloudApi(identifyFail, Boolean.FALSE, Boolean.TRUE);
            Set successDatas = (Set)resultTuple.item2;
            waitUpdateEntryMap.put("monthbill", successDatas);
            totalSuccessCount = Integer.sum(totalSuccessCount, successDatas.size());
            totalFailCount = Integer.sum(totalFailCount, ((Set)resultTuple.item3).size());
            serialNos.addAll((Collection)resultTuple.item1);
        }
        this.callInvoiceCloudQueryApi(serialNos, Boolean.TRUE);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)2);
        countMap.put("success", totalSuccessCount);
        countMap.put("fail", totalFailCount);
        return countMap;
    }

    private void dealResult(Map<String, Set<DynamicObject>> waitUpdateEntryMap, Set<DynamicObject> totalIdentifySuccess, ThreeTuple<Set<String>, Set<DynamicObject>, Set<DynamicObject>> resultTuple) {
        Set failDatas = (Set)resultTuple.item3;
        Set successDatas = (Set)resultTuple.item2;
        if (waitUpdateEntryMap.containsKey("checkingbill")) {
            Set<DynamicObject> checkingbill = waitUpdateEntryMap.get("checkingbill");
            if (CollectionUtils.isNotEmpty(checkingbill)) {
                checkingbill.addAll(successDatas);
                waitUpdateEntryMap.put("checkingbill", checkingbill);
            } else {
                waitUpdateEntryMap.put("checkingbill", successDatas);
            }
        } else {
            waitUpdateEntryMap.put("checkingbill", successDatas);
        }
        totalIdentifySuccess.addAll(successDatas);
        HashSet updateDatas = Sets.newHashSetWithExpectedSize((int)16);
        updateDatas.addAll(successDatas);
        updateDatas.addAll(failDatas);
        DynamicObject[] orderBills = TripInvoiceUtils.setOrderBill((Set)updateDatas);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])updateDatas.toArray(new DynamicObject[updateDatas.size()]));
                if (orderBills != null) {
                    SaveServiceHelper.save((DynamicObject[])orderBills);
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new KDException((Throwable)e, new ErrorCode("-1", e.getMessage()), new Object[0]);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("-1", e.getMessage()), new Object[0]);
        }
    }

    private void updateEntryInvoiceNos(Map<Integer, DynamicObject> indexAndData) {
        IDataModel model = this.getModel();
        DynamicObjectCollection invoiceentry = model.getEntryEntity("invoiceentry");
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)invoiceentry) || CollectionUtils.isEmpty((Collection)entryentity)) {
            return;
        }
        Set travelbill = entryentity.stream().filter(dynamicObject -> dynamicObject.getBoolean("travelbill")).collect(Collectors.toSet());
        Set invoiceNos = invoiceentry.stream().filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("invoiceno"))).map(dynamicObject -> dynamicObject.getString("invoiceno")).collect(Collectors.toSet());
        for (DynamicObject dynamicObject2 : travelbill) {
            String ticketnum = dynamicObject2.getString("ticketnum");
            if (!invoiceNos.contains(ticketnum)) continue;
            dynamicObject2.set("invoicenum", (Object)ticketnum);
            dynamicObject2.set("invoicenum_tag", (Object)ticketnum);
            invoiceNos.remove(ticketnum);
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"er_checkingbill", (String)"id,billno,invoiceentry.invoiceno", (QFilter[])new QFilter[]{new QFilter("invoiceentry.invoiceno", "in", invoiceNos)});
        if (load == null || load.length == 0) {
            return;
        }
        HashMap invoiceNoMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject3 : load) {
            Set invoiceNoSet;
            String billno = dynamicObject3.getString("billno");
            DynamicObjectCollection dynamicObjectCollection = dynamicObject3.getDynamicObjectCollection("invoiceentry");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection) || CollectionUtils.isEmpty(invoiceNoSet = dynamicObjectCollection.stream().filter(object -> StringUtils.isNotEmpty((CharSequence)object.getString("invoiceno"))).map(object -> object.getString("invoiceno")).collect(Collectors.toSet()))) continue;
            invoiceNoMap.put(billno, invoiceNoSet);
        }
        Set<Map.Entry<Integer, DynamicObject>> entries = indexAndData.entrySet();
        for (Map.Entry<Integer, DynamicObject> entry : entries) {
            Set entryInvoiceNos;
            String checkingBillno;
            DynamicObject dynamicObject3;
            dynamicObject3 = entry.getValue();
            if (dynamicObject3.getBoolean("travelbill") || !invoiceNoMap.containsKey(checkingBillno = dynamicObject3.getString("checkingbillno")) || CollectionUtils.isEmpty((Collection)(entryInvoiceNos = (Set)invoiceNoMap.get(checkingBillno)))) continue;
            entryInvoiceNos.retainAll(invoiceNos);
            dynamicObject3.set("invoicenum", entryInvoiceNos.stream().findFirst().get());
            dynamicObject3.set("invoicenum_tag", (Object)String.join((CharSequence)",", entryInvoiceNos));
            model.setValue("invoicenum", entryInvoiceNos.stream().findFirst().get(), entry.getKey().intValue());
            model.setValue("invoicenum_tag", (Object)String.join((CharSequence)",", entryInvoiceNos), entry.getKey().intValue());
        }
    }

    private void updateEntryDatas(Map<String, Set<DynamicObject>> waitUpdateEntryMap, Map<Integer, DynamicObject> waitSiftData) {
        String checkingBillNo;
        DynamicObject waitSiftDatum;
        Integer rowIndex;
        Set<Map.Entry<Integer, DynamicObject>> entries;
        IDataModel model = this.getModel();
        Set<DynamicObject> monthbill = waitUpdateEntryMap.get("monthbill");
        Set<DynamicObject> checkingbill = waitUpdateEntryMap.get("checkingbill");
        if (CollectionUtils.isNotEmpty(monthbill)) {
            Set monthBillNums = monthbill.stream().filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("billnum"))).map(dynamicObject -> dynamicObject.getString("billnum")).collect(Collectors.toSet());
            entries = waitSiftData.entrySet();
            for (Map.Entry<Integer, DynamicObject> entry : entries) {
                rowIndex = entry.getKey();
                waitSiftDatum = entry.getValue();
                checkingBillNo = waitSiftDatum.getString("checkingbillno");
                if (!monthBillNums.contains(checkingBillNo) || waitSiftDatum.getBoolean("travelbill")) continue;
                waitSiftDatum.set("isuploadinvoicecloud", (Object)1);
                model.setValue("isuploadinvoicecloud", (Object)1, rowIndex.intValue());
            }
        }
        if (CollectionUtils.isNotEmpty(checkingbill)) {
            Set checkingBillNums = checkingbill.stream().filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("ordernum"))).map(dynamicObject -> dynamicObject.getString("ordernum")).collect(Collectors.toSet());
            entries = waitSiftData.entrySet();
            for (Map.Entry<Integer, DynamicObject> entry : entries) {
                rowIndex = entry.getKey();
                waitSiftDatum = entry.getValue();
                checkingBillNo = waitSiftDatum.getString("checkingbillnum");
                if (!checkingBillNums.contains(checkingBillNo) || !waitSiftDatum.getBoolean("travelbill")) continue;
                waitSiftDatum.set("isuploadinvoicecloud", (Object)1);
                model.setValue("isuploadinvoicecloud", (Object)1, rowIndex.intValue());
            }
        }
    }

    private ThreeTuple<Set<String>, Set<DynamicObject>, Set<DynamicObject>> callInvoiceCloudApi(Set<DynamicObject> identifyData, boolean setProp, boolean xhEnable) {
        HashSet successDatas = Sets.newHashSetWithExpectedSize((int)16);
        HashSet failDatas = Sets.newHashSetWithExpectedSize((int)16);
        HashSet serialNos = Sets.newHashSetWithExpectedSize((int)16);
        Iterator<DynamicObject> iterator = identifyData.iterator();
        IPageCache pageCache = this.getPageCache();
        int size = identifyData.size();
        if (xhEnable) {
            InvoiceService instanceService = InvoiceService.getInstanceService();
            int index = 0;
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = iterator.next();
                if (TripInvoiceUtils.checkingInvoiceIdentify((DynamicObject)dynamicObject, (InvoiceService)instanceService, (boolean)setProp, (Set)serialNos).booleanValue()) {
                    successDatas.add(dynamicObject);
                } else {
                    failDatas.add(dynamicObject);
                }
                if (++index % 3 != 1) continue;
                pageCache.put("task_percent", String.valueOf(((float)index - 1.0f) / (float)size * 100.0f).replaceAll("\\.[0-9]*", ""));
            }
        } else {
            int index = 0;
            IDataModel model = this.getModel();
            DynamicObject dataEntity = model.getDataEntity();
            Object pkValue = dataEntity.getPkValue();
            String billNo = dataEntity.getString("billno");
            Long costCompany = ErCommonUtils.getPk((Object)dataEntity.getDynamicObject("company"));
            String bxdKey = "er_checkingpaybill" + pkValue;
            String userKey = "";
            try {
                userKey = APIHelper.getCommonUserKey((Long)costCompany, (String)bxdKey, (String)billNo);
            }
            catch (InvoiceCloudException e) {
                logger.error("aws invoicecloud \u83b7\u53d6userkey error", (Throwable)e);
            }
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = iterator.next();
                if (TripInvoiceUtils.checkInvoiceIdentifyByAws((DynamicObject)dynamicObject, (String)userKey, (Set)serialNos)) {
                    successDatas.add(dynamicObject);
                } else {
                    failDatas.add(dynamicObject);
                }
                if (++index % 3 != 1) continue;
                pageCache.put("task_percent", String.valueOf(((float)index - 1.0f) / (float)size * 100.0f).replaceAll("\\.[0-9]*", ""));
            }
        }
        return new ThreeTuple((Object)serialNos, (Object)successDatas, (Object)failDatas);
    }

    private void callInvoiceCloudQueryApi(Set<String> serialNos, boolean xhEnable) throws Exception {
        if (CollectionUtils.isEmpty(serialNos)) {
            return;
        }
        List<InvoiceVO> invoiceVOs = this.getInvoiceVOS(xhEnable, new ArrayList<String>(serialNos));
        if (CollectionUtils.isEmpty(invoiceVOs)) {
            return;
        }
        this.executeProcess(invoiceVOs);
    }

    private List<InvoiceVO> getInvoiceVOS(boolean xhEnable, List<String> serialNosStr) throws Exception {
        List invoiceVOs;
        DynamicObject costCompanyDO = this.getCostCompanyDO();
        if (xhEnable) {
            invoiceVOs = InvoiceService.getInstanceService().queryInvoicesBySerialNos((AbstractFormPlugin)this, serialNosStr, costCompanyDO);
        } else {
            QueryInvoiceDetailBO queryInvoiceDetailBO = QueryInvoiceDetailBO.buildQueryInvoiceDetailBO((DynamicObject)costCompanyDO, (String)String.join((CharSequence)",", serialNosStr));
            queryInvoiceDetailBO.setBxdKey(APIHelper.getBillNoCachedInCloud((DynamicObject)this.getExtView().getModel().getDataEntity()));
            queryInvoiceDetailBO.setView(this.getView());
            invoiceVOs = APIHelper.queryInvoiceDetailBySerialNo((QueryInvoiceDetailBO)queryInvoiceDetailBO);
        }
        return invoiceVOs;
    }

    private int uploadImageInfoToAttr() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        int[] rowIndexs = entryGrid.getSelectRows();
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        ArrayList travelBillList = Lists.newArrayListWithCapacity((int)16);
        ArrayList notTravelBillList = Lists.newArrayListWithExpectedSize((int)16);
        for (int rowIndex : rowIndexs) {
            DynamicObject dynamicObject2 = (DynamicObject)entryentity.get(rowIndex);
            boolean travelbill = dynamicObject2.getBoolean("travelbill");
            if (travelbill) {
                travelBillList.add(dynamicObject2);
                continue;
            }
            notTravelBillList.add(dynamicObject2);
        }
        Set<String> planeBillNos = travelBillList.stream().filter(dynamicObject -> StringUtils.equals((CharSequence)dynamicObject.getString("entry_operationtype"), (CharSequence)"2")).map(dynamicObject -> dynamicObject.getString("checkingbillnum")).collect(Collectors.toSet());
        Set<String> trainBillNos = travelBillList.stream().filter(dynamicObject -> StringUtils.equals((CharSequence)dynamicObject.getString("entry_operationtype"), (CharSequence)"4")).map(dynamicObject -> dynamicObject.getString("checkingbillnum")).collect(Collectors.toSet());
        Set checkingBillNos = notTravelBillList.stream().map(dynamicObject -> dynamicObject.getString("checkingbillno")).collect(Collectors.toSet());
        DynamicObjectCollection planeDynamicObjectCollection = this.getBillDatas("er_planecheckingbill", planeBillNos);
        DynamicObjectCollection trainDynamicObjectCollection = this.getBillDatas("er_traincheckingbill", trainBillNos);
        DynamicObjectCollection checkingBillDynamicObjectCollection = QueryServiceHelper.query((String)"er_checkingbill", (String)"invoiceentry.id id,billnum ordernum,invoiceentry.downloadurl downloadlink,invoiceentry.innerdownloadurl kddownloadlink", (QFilter[])new QFilter[]{new QFilter("billnum", "in", checkingBillNos), new QFilter("invoiceentry.flightitineraryandtrain", "!=", (Object)Character.valueOf('1'))});
        DynamicObjectCollection allDatas = new DynamicObjectCollection();
        allDatas.addAll((Collection)planeDynamicObjectCollection);
        allDatas.addAll((Collection)trainDynamicObjectCollection);
        allDatas.addAll((Collection)checkingBillDynamicObjectCollection);
        if (CollectionUtils.isEmpty((Collection)allDatas)) {
            return 0;
        }
        return this.finalUploadImage(allDatas, view, model);
    }

    private int finalUploadImage(DynamicObjectCollection allDatas, IFormView view, IDataModel model) {
        if (CollectionUtils.isEmpty((Collection)allDatas)) {
            return 0;
        }
        AttachmentPanel filePanel = (AttachmentPanel)view.getControl("attachmentpanel");
        if (filePanel == null) {
            return 0;
        }
        Object pkValue = model.getDataEntity().getPkValue();
        List attachmentData = filePanel.getAttachmentData();
        List attachmentDataList = JSON.parseArray((String)JSONArray.toJSONString((Object)attachmentData), AttachmentData.class);
        Set existsNames = attachmentDataList.stream().map(AttachmentData::getUid).collect(Collectors.toSet());
        ArrayList newAttachmentDatas = Lists.newArrayListWithExpectedSize((int)16);
        IPageCache pageCache = this.getPageCache();
        try {
            TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int i = 0;
            int size = allDatas.size();
            for (DynamicObject dynamicObject : allDatas) {
                if (i % 3 == 1) {
                    pageCache.put("task_percent", String.valueOf(((float)i - 1.0f) / (float)size * 100.0f).replaceAll("\\.[0-9]*", ""));
                }
                String downLoadLink = dynamicObject.getString("downloadlink");
                AttachmentData attachmentDataForUpload = new AttachmentData();
                attachmentDataForUpload.setBillPkId(String.valueOf(pkValue));
                String attachmentName = dynamicObject.get("id").toString();
                if (existsNames.contains(attachmentName)) continue;
                Map data = HttpServiceHelper.doGetInputStream((String)downLoadLink);
                if (data == null) {
                    ++i;
                    continue;
                }
                InputStream inputStream = (InputStream)data.get("in");
                if (inputStream == null) {
                    ++i;
                    continue;
                }
                String suffix = TripInvoiceUtils.getSuffix((String)downLoadLink);
                logger.info("\u5f71\u50cf\u540e\u7f00{}", (Object)suffix);
                if (!attachmentName.endsWith("." + suffix)) {
                    attachmentName = attachmentName + "." + suffix;
                }
                attachmentDataForUpload.setType(suffix);
                attachmentDataForUpload.setName(attachmentName);
                byte[] bytes = ByteStreams.toByteArray((InputStream)inputStream);
                String filePath = tempFile.saveAsFullUrl(attachmentName, (InputStream)new ByteArrayInputStream(bytes), 30000);
                logger.info("\u5f71\u50cf\u5730\u5740{}", (Object)filePath);
                filePath = AttachmentServiceHelper.saveTempToFileService((String)filePath, (String)"em", (String)view.getEntityId(), (Object)model.getDataEntity(true).getLong("id"), (String)attachmentName);
                attachmentDataForUpload.setUrl(filePath);
                attachmentDataForUpload.setSize((long)bytes.length);
                attachmentDataForUpload.setClient("web");
                attachmentDataForUpload.setUid(attachmentName);
                attachmentDataForUpload.setEntityNum(model.getDataEntityType().getName());
                attachmentDataForUpload.setStatus("success");
                attachmentDataForUpload.setLastModified(System.currentTimeMillis());
                attachmentDataForUpload.setCreatedate(System.currentTimeMillis());
                newAttachmentDatas.add((Map)JSON.toJSON((Object)attachmentDataForUpload));
                ++i;
            }
            AttachmentServiceHelper.upload((String)view.getEntityId(), (Object)pkValue.toString(), (String)"attachmentpanel", (List)newAttachmentDatas);
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u4ed8\u6b3e\u7533\u8bf7\u5355 \u4e0a\u4f20\u9644\u4ef6 error", (Throwable)e);
        }
        return newAttachmentDatas.size();
    }

    private DynamicObjectCollection getBillDatas(String entityId, Set<String> billNos) {
        return QueryServiceHelper.query((String)entityId, (String)"id,ordernum,kddownloadlink,downloadlink", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", billNos)});
    }

    private Map<String, Set<DynamicObject>> siftData(List<DynamicObject> waitSiftData) {
        Map<String, Set<DynamicObject>> resultMap = this.travelBillSift(waitSiftData);
        Set<DynamicObject> dynamicObjects = this.notTravelBillSift(waitSiftData);
        if (CollectionUtils.isNotEmpty(dynamicObjects)) {
            resultMap.put("identifyFail_checking", dynamicObjects);
        }
        return resultMap;
    }

    private List<DynamicObject> getSelectedDatas(Map<Integer, DynamicObject> indexAndDataMap) {
        IDataModel model = this.getModel();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        ArrayList waitSiftData = Lists.newArrayListWithExpectedSize((int)16);
        int[] rowIndexs = entryGrid.getSelectRows();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        for (int rowIndex : rowIndexs) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rowIndex);
            if (dynamicObject.getBoolean("isuploadinvoicecloud")) continue;
            waitSiftData.add(dynamicObject);
            indexAndDataMap.put(rowIndex, dynamicObject);
        }
        return waitSiftData;
    }

    private Map<String, Set<DynamicObject>> travelBillSift(List<DynamicObject> waitSiftData) {
        Set checkingBillId = waitSiftData.stream().filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("checkingbillid")) && dynamicObject.getBoolean("travelbill")).map(dynamicObject -> dynamicObject.getString("checkingbillid")).collect(Collectors.toSet());
        DynamicObject[] checkingBills = BusinessDataServiceHelper.load((String)"er_allcheckingbill", (String)"id,checkingid,checkingformid", (QFilter[])new QFilter[]{new QFilter("checkingid", "in", checkingBillId)});
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)2);
        if (checkingBills != null && checkingBills.length > 0) {
            DynamicObject checkingBill = checkingBills[0];
            String formId = checkingBill.getString("checkingformid");
            Set ids = checkingBillId.stream().map(str -> Long.parseLong(str.trim())).collect(Collectors.toSet());
            DynamicObject[] checkings = BusinessDataServiceHelper.load((String)formId, (String)"id,ordernum,settlemain,kddownloadlink,downloadlink,serialno,invoiceidentityflag,identityerrormsg,allorderbase.ordernum,allorderbase.orderformid", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            Set identifySuccessData = Arrays.stream(checkings).filter(dynamicObject -> dynamicObject.getBoolean("invoiceidentityflag")).collect(Collectors.toSet());
            Set identifyFailData = Arrays.stream(checkings).filter(dynamicObject -> !dynamicObject.getBoolean("invoiceidentityflag")).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(identifySuccessData)) {
                resultMap.put("identifySuccess", identifySuccessData);
            }
            if (CollectionUtils.isNotEmpty(identifyFailData)) {
                resultMap.put("identifyFail", identifyFailData);
            }
        }
        return resultMap;
    }

    private Set<DynamicObject> notTravelBillSift(List<DynamicObject> waitSiftData) {
        Set checkingbillnos = waitSiftData.stream().filter(dynamicObject -> !dynamicObject.getBoolean("travelbill") && StringUtils.isNotEmpty((CharSequence)"checkingbillno")).map(dynamicObject -> dynamicObject.getString("checkingbillno")).collect(Collectors.toSet());
        DynamicObjectCollection checkingBills = QueryServiceHelper.query((String)"er_checkingbill", (String)"settlemain,invoiceentry.downloadurl downloadlink,invoiceentry.flightitineraryandtrain,billnum", (QFilter[])new QFilter[]{new QFilter("billnum", "in", checkingbillnos)});
        return checkingBills.stream().filter(dynamicObject -> !dynamicObject.getBoolean("invoiceentry.flightitineraryandtrain")).collect(Collectors.toSet());
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return null;
    }

    @Override
    protected String getCostCompanyKey() {
        return "company";
    }

    public void afterRemove(UploadEvent evt) {
        IFormView view = this.getView();
        AttachmentPanel filePanel = (AttachmentPanel)view.getControl("attachmentpanel");
        this.getModel().setValue("annexnum", (Object)filePanel.getAttachmentData().size());
        view.updateView("annexnum");
    }

    public void afterUpload(UploadEvent evt) {
        IFormView view = this.getView();
        AttachmentPanel filePanel = (AttachmentPanel)view.getControl("attachmentpanel");
        this.getModel().setValue("annexnum", (Object)filePanel.getAttachmentData().size());
        view.updateView("annexnum");
    }
}

