/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.payinvoice;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.fi.er.business.trip.util.CheckingPayBillWriteOffMoneyUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ShowPageUtils;

public class CheckingPayBillWriteOffMoneyPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        AbstractGrid writeoffapplyEntry = (AbstractGrid)this.getControl("writeoffmoney");
        if (writeoffapplyEntry != null) {
            writeoffapplyEntry.addHyperClickListener((HyperLinkClickListener)this);
        }
        if (this.getView().getControl("advcontoolbarap3") != null) {
            this.addItemClickListeners(new String[]{"advcontoolbarap3"});
        }
    }

    public void afterBindData(EventObject e) {
        Container advconap = (Container)this.getControl("advconap2");
        if (advconap != null) {
            int entryRowCount = this.getModel().getEntryRowCount("writeoffmoney");
            if (entryRowCount > 0) {
                advconap.setCollapse(false);
            } else {
                advconap.setCollapse(true);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        Object appliercompany = this.getModel().getValue("appliercompany");
        if (appliercompany == null) {
            return;
        }
        long companyId = ((DynamicObject)appliercompany).getLong("id");
        Boolean isTripUpFilterBySupplier = SystemParamterUtil.getIsTripUpFilterBySupplier((Long)companyId);
        if ("addprepay".equals(itemKey) && isTripUpFilterBySupplier.booleanValue() && this.getModel().getValue("payer") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"CheckingPayBillWriteOffMoneyPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("loanbillnov1".equals(fieldName)) {
            DynamicObject entry = this.getModel().getEntryRowEntity("writeoffmoney", rowIndex);
            String entityId = entry.getString("srcbilltype");
            long sourcebillid = entry.getLong("sourcebillid");
            ShowPageUtils.openLinkedForm((Object)sourcebillid, (String)entityId, (IFormView)this.getView());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean isTripUpFilterBySupplier;
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("accloanamount".equals(propName)) {
            BigDecimal newAccValue;
            DynamicObject entry = model.getEntryRowEntity("writeoffmoney", rowIndex);
            BigDecimal loanamount = entry.getBigDecimal("loanamount");
            if (loanamount.compareTo(newAccValue = (BigDecimal)newValue) < 0) {
                model.setValue("accloanamount", oldValue, rowIndex);
                return;
            }
            AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)((BigDecimal)newValue), (String)"curraccloanamount", (String)"loanexchangerate", (String)"loancurrency", (String)"writeoffquotetype", (int)rowIndex);
            CheckingPayBillWriteOffMoneyUtil.refreshCheckingPayHeadAmount((DynamicObject)model.getDataEntity(true));
            view.updateView("totalaccloanamount");
            view.updateView("settleamount");
            view.updateView("totalamount_head");
        } else if ("actentryamount".equals(propName)) {
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObjectCollection writeoffmoney = dataEntity.getDynamicObjectCollection("writeoffmoney");
            if (writeoffmoney != null && !writeoffmoney.isEmpty()) {
                int precision = AmountUtils.getAmountFieldPrecision((DynamicObject)dataEntity, (String)"currency");
                DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
                BigDecimal actentryamount = AmountUtils.getEntryAmount((DynamicObjectCollection)entryentity, (String)"actentryamount");
                for (int i = 0; i < writeoffmoney.size(); ++i) {
                    BigDecimal currLoanAmount;
                    DynamicObject entry = (DynamicObject)writeoffmoney.get(i);
                    BigDecimal loanamount = entry.getBigDecimal("loanamount");
                    if (actentryamount.compareTo(loanamount) > 0) {
                        entry.set("accloanamount", (Object)loanamount);
                        currLoanAmount = AmountUtils.getCurrencyAmount((BigDecimal)loanamount, (BigDecimal)entry.getBigDecimal("loanexchangerate"), (int)precision, (String)entry.getString("writeoffquotetype"));
                        entry.set("curraccloanamount", (Object)currLoanAmount);
                        actentryamount = actentryamount.subtract(loanamount);
                        continue;
                    }
                    entry.set("accloanamount", (Object)actentryamount);
                    currLoanAmount = AmountUtils.getCurrencyAmount((BigDecimal)actentryamount, (BigDecimal)entry.getBigDecimal("loanexchangerate"), (int)precision, (String)entry.getString("writeoffquotetype"));
                    entry.set("curraccloanamount", (Object)currLoanAmount);
                    actentryamount = BigDecimal.ZERO;
                }
                view.updateView("writeoffmoney");
            }
            CheckingPayBillWriteOffMoneyUtil.refreshCheckingPayHeadAmount((DynamicObject)model.getDataEntity(true));
            view.updateView("totalaccloanamount");
            view.updateView("settleamount");
            view.updateView("totalamount_head");
        } else if ("payer".equals(propName) && (isTripUpFilterBySupplier = SystemParamterUtil.getIsTripUpFilterBySupplier((Long)ErCommonUtils.getPk((Object)model.getValue("appliercompany")))).booleanValue()) {
            Long payerId = ErCommonUtils.getPk((Object)newValue);
            DynamicObjectCollection writeoffmoney = model.getDataEntity(true).getDynamicObjectCollection("writeoffmoney");
            if (writeoffmoney == null || writeoffmoney.isEmpty()) {
                return;
            }
            Iterator iterator = writeoffmoney.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                String srcbilltype = entry.getString("srcbilltype");
                DynamicObject srcentrywlunit = entry.getDynamicObject("srcentrywlunit");
                if (Objects.equals(payerId, ErCommonUtils.getPk((Object)srcentrywlunit)) || !ErEntityTypeUtils.isPrePayBill((String)srcbilltype)) continue;
                iterator.remove();
            }
            view.updateView("writeoffmoney");
            CheckingPayBillWriteOffMoneyUtil.refreshCheckingPayHeadAmount((DynamicObject)model.getDataEntity(true));
            view.updateView("totalaccloanamount");
            view.updateView("settleamount");
            view.updateView("totalamount_head");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey;
        super.afterDoOperation(e);
        IDataModel model = this.getModel();
        switch (opKey = e.getOperateKey()) {
            case "deleteaccentry": {
                CheckingPayBillWriteOffMoneyUtil.refreshCheckingPayHeadAmount((DynamicObject)model.getDataEntity(true));
                IFormView view = this.getView();
                view.updateView("totalaccloanamount");
                view.updateView("settleamount");
                view.updateView("totalamount_head");
            }
        }
    }
}

