/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.payinvoice;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.servicehelper.CheckingBillServiceHelper;
import kd.fi.er.business.servicehelper.ErPermissionServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class CheckingSetting
extends AbstractFormPlugin {
    private static final String billFlag = "entityNum";

    private boolean needCompany() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List hideControls = (List)customParams.get("hidecontrols");
        if (hideControls != null) {
            return !hideControls.contains("company");
        }
        return true;
    }

    public void beforeBindData(EventObject e) {
        String source;
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        Object sourceObject = customParams.get(billFlag);
        if (sourceObject != null && "er_invoiceorderbill".equals(source = (String)sourceObject)) {
            DateEdit checkdate = (DateEdit)this.getControl("checkdate");
            LocaleString name = new LocaleString(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u671f\u95f4", (String)"CheckingSetting_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            checkdate.setCaption(name);
        }
    }

    public void initialize() {
        super.initialize();
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        List hideControls = (List)customParams.get("hidecontrols");
        if (hideControls != null && !hideControls.isEmpty()) {
            for (String hideControl : hideControls) {
                view.setVisible(Boolean.FALSE, new String[]{hideControl});
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"okbtn"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.needCompany()) {
            List<Long> allPermissionOrgs = this.getAllPermissionOrg();
            MulBasedataEdit control = (MulBasedataEdit)this.getControl("company");
            QFilter orgFilter = new QFilter("id", "in", allPermissionOrgs);
            control.setQFilter(orgFilter);
            this.getModel().setValue("company", (Object)allPermissionOrgs.toArray());
            this.getView().updateView("company");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("okbtn".equalsIgnoreCase(key)) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            IDataModel model = this.getModel();
            DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                String propName = property.getName();
                result.put(propName, model.getValue(propName));
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            result.putAll(customParams);
            this.getView().returnDataToParent(result);
            this.getView().close();
        }
    }

    private List<Long> getAllPermissionOrg() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entityNum = (String)customParams.get(billFlag);
        String appNum = StringUtils.isBlank((CharSequence)this.getView().getFormShowParameter().getAppId()) ? "em" : this.getView().getFormShowParameter().getAppId();
        String permItemId = null;
        String entityId = null;
        if ("er_invoiceorderbill".equals(entityNum)) {
            permItemId = "/=HE4D3JP788";
            entityId = "er_invoiceorderbill";
        } else {
            permItemId = "47150e89000000ac";
            entityId = "er_checkingpaybill";
        }
        return ErPermissionServiceHelper.getOrgListWithPerm((String)appNum, (String)entityId, (String)permItemId);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Calendar calendar = Calendar.getInstance();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        calendar.setTime(new Date());
        Object sourceObject = customParams.get(billFlag);
        if (sourceObject != null) {
            String source = (String)sourceObject;
            if ("er_invoiceorderbill".equals(source)) {
                calendar.add(2, 0);
            }
        } else {
            calendar.add(2, -1);
        }
        Date lastMonth = calendar.getTime();
        CheckingBillServiceHelper.CheckDateRange dateRange = CheckingBillServiceHelper.getCheckDateRange((Date)lastMonth);
        Date startDate = dateRange.getStartDate();
        model.setValue("checkdate", (Object)startDate);
        model.setValue("enddate", (Object)startDate);
    }
}

