/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.payinvoice;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;

public class ErInvoiceOrderPlugin
extends AbstractBillPlugIn {
    public void afterLoadData(EventObject e) {
        super.afterBindData(e);
        this.calculateEverAmount();
        this.loadSettleInfo();
        this.getModel().setDataChanged(false);
    }

    private void loadSettleInfo() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("er_seinvoice_entryinfo");
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey("flexsettlecontainer");
        formShowParameter.setCustomParam("invoiceid", this.getModel().getDataEntity().getPkValue());
        formShowParameter.setCustomParam("operationtype", this.getModel().getValue("operationtype"));
        this.getView().showForm(formShowParameter);
    }

    private void calculateEverAmount() {
        IDataModel dataModel = this.getModel();
        DynamicObject bill = dataModel.getDataEntity();
        dataModel.setValue("amountnotax", (Object)this.ifnullBigDecimal(bill.getBigDecimal("invoiceamount")).subtract(this.ifnullBigDecimal(bill.getBigDecimal("invoicetax"))));
        dataModel.setValue("settleamountnotax", (Object)this.ifnullBigDecimal(bill.getBigDecimal("settleamountwithtax")).subtract(this.ifnullBigDecimal(bill.getBigDecimal("settleamounttax"))));
        dataModel.setValue("diffamountnotax", (Object)this.ifnullBigDecimal(bill.getBigDecimal("diffamountwithtax")).subtract(this.ifnullBigDecimal(bill.getBigDecimal("difftaxamount"))));
    }

    private BigDecimal ifnullBigDecimal(BigDecimal amount) {
        if (amount == null) {
            amount = BigDecimal.ZERO;
        }
        return amount;
    }
}

