/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.sso;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.formplugin.trip.sso.util.TripSSOUtils;

public class ErMainPageSSOPlugin
extends AbstractMobFormPlugin {
    public static final String TRIP_GROUP = "ESC_TRAIS";

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        Map<String, String> tmpMap = TripSSOUtils.SERVER_AND_CONTROLKEY_MAP;
        Set<String> tmpList = tmpMap.keySet();
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "in", tmpList), new QFilter("enable", "=", (Object)"1")};
        Boolean isVisible = TripCommonUtil.reqBtnIsVisible((QFilter[])qFilters);
        if (!isVisible.booleanValue()) {
            view.setVisible(Boolean.FALSE, new String[]{"er_trip"});
            return;
        }
        TripSSOUtils.judgeTrialOrg(view, tmpList);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        String[] keys = TripSSOUtils.SERVER_AND_CONTROLKEY_MAP.values().toArray(new String[0]);
        Set<String> keySet = Arrays.stream(keys).collect(Collectors.toSet());
        keySet.add("pushapplybill");
        keySet.add("refreshorderbill");
        this.addClickListeners(keySet.toArray(new String[0]));
    }

    public void click(EventObject evt) {
        LicenseCheckResult checkResult;
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IFormView view = this.getView();
        List collect = TripSSOUtils.SERVER_AND_CONTROLKEY_MAP.values().stream().collect(Collectors.toList());
        collect.add("pushapplybill");
        collect.add("refreshorderbill");
        if (collect.contains(key) && !(checkResult = LicenseServiceHelper.checkPerformGroup((String)TRIP_GROUP)).getHasLicense().booleanValue()) {
            view.showTipNotification(checkResult.getMsg());
            return;
        }
        if (Arrays.asList("pushapplybill", "refreshorderbill").contains(key)) {
            MobileFormShowParameter showParameter;
            if ("refreshorderbill".equals(key)) {
                showParameter = new MobileFormShowParameter();
                showParameter.setFormId("er_trip_pull_order");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                view.showForm((FormShowParameter)showParameter);
            } else if ("pushapplybill".equals(key)) {
                showParameter = new MobileFormShowParameter();
                showParameter.setFormId("er_trip_sync_applybill");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                view.showForm((FormShowParameter)showParameter);
            }
        } else {
            String server;
            Map<String, String> tmpMap = TripSSOUtils.SERVER_AND_CONTROLKEY_MAP;
            if (!tmpMap.containsValue(key)) {
                return;
            }
            switch (server = tmpMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)).getOrDefault(key, "")) {
                case "CHAILVYIHAO": 
                case "XIECHENG": 
                case "TONGCHENG": 
                case "ALI": 
                case "QICHENG": 
                case "MEIYA": {
                    TripSSOUtils.commonLogin(key, view);
                    break;
                }
                case "DIDI": {
                    TripSSOUtils.didiLogin(key, view);
                    break;
                }
                case "MEITUAN": {
                    TripCommonUtil.openURL((String)server, (String)"dinnner", new HashMap(), (IFormView)view);
                    break;
                }
                case "GAODE": {
                    TripCommonUtil.openFieldMappingLogin((IFormView)view, (String)key, (String)server);
                }
            }
        }
    }
}

