/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.syncapplybill;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.trip.sso.util.TripSSOUtils;

public class TripSyncApplyBillMobPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    private final Log logger = LogFactory.getLog(TripSyncApplyBillMobPlugin.class);
    private static final String REQ_PREFIX = "req";
    private static final String VEHICLE_PREFIX = "vehicle";

    public void registerListener(EventObject e) {
        Control entryentity = this.getControl("entryentity");
        if (entryentity instanceof CardEntry) {
            ((CardEntry)entryentity).addRowClickListener((RowClickEventListener)this);
        }
        this.addClickListeners(new String[]{"sync"});
    }

    public void afterCreateNewData(EventObject e) {
        Container vehicleFlex;
        Container reqFlex;
        long currUserId = RequestContext.get().getCurrUserId();
        IDataModel model = this.getModel();
        QFilter commonFilter = new QFilter("applier", "=", (Object)currUserId).or(new QFilter("creator", "=", (Object)currUserId));
        QFilter reqFilter = commonFilter.or(new QFilter("multitravelers.fbasedataid", "=", (Object)currUserId));
        DynamicObjectCollection reqBills = QueryServiceHelper.query((String)"er_tripreqbill", (String)"billno,bizdate,description,applier,billstatus", (QFilter[])new QFilter[]{new QFilter("billstatus", "in", Arrays.asList("B", "C", "E")).and(reqFilter), new QFilter("isloan", "=", (Object)"0")}, (String)"bizdate desc");
        Iterator iterator = reqBills.iterator();
        HashMap booleanMap = Maps.newHashMapWithExpectedSize((int)16);
        while (iterator.hasNext()) {
            DynamicObject reqBill = (DynamicObject)iterator.next();
            String billStatus = reqBill.getString("billstatus");
            if (!Arrays.asList("C", "B").contains(billStatus)) continue;
            long userId = reqBill.getLong("applier");
            if (booleanMap.containsKey(userId) && !((Boolean)booleanMap.get(userId)).booleanValue()) {
                iterator.remove();
                continue;
            }
            boolean whiteUser = CommonServiceHelper.noApprovaWhiteList((Long)userId, (String)"1");
            booleanMap.put(userId, whiteUser);
            if (whiteUser) continue;
            iterator.remove();
        }
        TripSSOUtils.setBillDatas(reqBills, model, REQ_PREFIX, "reqbillentryentity");
        if (CollectionUtils.isEmpty((Collection)reqBills) && (reqFlex = (Container)this.getControl("reqbillflex")) != null) {
            reqFlex.setCollapse(Boolean.TRUE.booleanValue());
        }
        commonFilter = new QFilter("billstatus", "in", Arrays.asList("B", "C", "E")).and(new QFilter("applier", "=", (Object)currUserId).or(new QFilter("creator", "=", (Object)currUserId)));
        DynamicObjectCollection vehicleBills = QueryServiceHelper.query((String)"er_dailyvehiclebill", (String)"billno,bizdate,description,billstatus,applier,company", (QFilter[])new QFilter[]{commonFilter}, (String)"bizdate desc");
        Iterator vehicleIterator = vehicleBills.iterator();
        booleanMap.clear();
        HashMap<Long, Boolean> whiteUserMap = new HashMap<Long, Boolean>(16);
        while (vehicleIterator.hasNext()) {
            DynamicObject vehicleBill = (DynamicObject)vehicleIterator.next();
            String billStatus = vehicleBill.getString("billstatus");
            if (!Arrays.asList("C", "B").contains(billStatus)) continue;
            long company = vehicleBill.getLong("company");
            long userId = vehicleBill.getLong("applier");
            if (booleanMap.containsKey(company) && !((Boolean)booleanMap.get(company)).booleanValue() || whiteUserMap.containsKey(userId) && !((Boolean)whiteUserMap.get(userId)).booleanValue()) {
                vehicleIterator.remove();
                continue;
            }
            Object paramValue = ErCommonUtils.getEMParameter((long)company, (String)"syncvehiclebilltotrip");
            boolean whiteUser = CommonServiceHelper.noApprovaWhiteList((Long)userId, (String)"1");
            whiteUserMap.put(userId, whiteUser);
            if (!"1".equals(paramValue) && !whiteUser) {
                booleanMap.put(company, Boolean.FALSE);
                vehicleIterator.remove();
                continue;
            }
            booleanMap.put(company, Boolean.TRUE);
        }
        TripSSOUtils.setBillDatas(vehicleBills, model, VEHICLE_PREFIX, "vehiclebillentryentity");
        if (CollectionUtils.isEmpty((Collection)vehicleBills) && (vehicleFlex = (Container)this.getControl("vehiclebillflex")) != null) {
            vehicleFlex.setCollapse(Boolean.TRUE.booleanValue());
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry entry;
        Object source = evt.getSource();
        if (source instanceof CardEntry && "entryentity".equals((entry = (CardEntry)source).getEntryKey())) {
            Map<String, String> tmpMap = TripSSOUtils.SERVER_AND_CONTROLKEY_MAP;
            DynamicObjectCollection enableServers = QueryServiceHelper.query((String)"er_biz_info", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "in", tmpMap.keySet()), new QFilter("enable", "=", (Object)"1")});
            if (CollectionUtils.isEmpty((Collection)enableServers)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u540c\u6b65\u7684\u670d\u52a1\u5546\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002", (String)"TripSyncApplyBillMobPlugin_01", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("er_need_sync_servers");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_need_sync_servers"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("er_need_sync_servers".equals(actionId)) {
            IPageCache pageCache = this.getPageCache();
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData instanceof Map) {
                Map returnMap = (Map)returnData;
                String name = returnMap.getOrDefault("name", "");
                IFormView view = this.getView();
                Label labelap = (Label)view.getControl("label_select");
                labelap.setText(name + "\t>");
                String number = returnMap.getOrDefault("number", "");
                pageCache.put("server", number);
                if (Supplier.ALI.getValue().equals(number)) {
                    view.setVisible(Boolean.FALSE, new String[]{"vehiclebillflex"});
                } else {
                    view.setVisible(Boolean.TRUE, new String[]{"vehiclebillflex"});
                }
                view.updateView("entryentity");
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        try {
            Button button;
            String key;
            Object source = evt.getSource();
            if (source instanceof Button && "sync".equals(key = (button = (Button)source).getKey())) {
                IPageCache pageCache = this.getPageCache();
                String server = pageCache.get("server");
                if (StringUtils.isEmpty((String)server)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u670d\u52a1\u5546\u3002", (String)"TripSyncApplyBillMobPlugin_02", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                IDataModel model = this.getModel();
                model.setValue("serverfield", (Object)server);
                DynamicObjectCollection reqEntry = model.getEntryEntity("reqbillentryentity");
                DynamicObjectCollection vehicleEntry = model.getEntryEntity("vehiclebillentryentity");
                List reqSelectDatas = reqEntry.stream().filter(obj -> obj.getBoolean("reqcheckbox")).collect(Collectors.toList());
                List vehicleSelectDatas = vehicleEntry.stream().filter(obj -> obj.getBoolean("vehiclecheckbox")).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(reqSelectDatas) && CollectionUtils.isEmpty(vehicleSelectDatas)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u7533\u8bf7\u5355\u8fdb\u884c\u540c\u6b65\u3002", (String)"TripSyncApplyBillMobPlugin_03", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    evt.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                if (Supplier.ALI.getValue().equals(server) && CollectionUtils.isEmpty(reqSelectDatas)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u7533\u8bf7\u5355\u8fdb\u884c\u540c\u6b65\u3002", (String)"TripSyncApplyBillMobPlugin_03", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    evt.setCancel(Boolean.TRUE.booleanValue());
                }
            }
        }
        catch (Exception ex) {
            String tips = String.format(ResManager.loadKDString((String)"\u70b9\u51fb\u4e8b\u4ef6\u51fa\u73b0\u4e86\u95ee\u9898\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff0c\u65e5\u5fd7ID:%s\u3002", (String)"TripSyncApplyBillMobPlugin_04", (String)"fi-er-formplugin", (Object[])new Object[0]), RequestContext.get().getTraceId());
            this.logger.error("kd.fi.er.formplugin.trip.syncapplybill.TripSyncApplyBillMobPlugin.click \u70b9\u51fb\u4e8b\u4ef6\u51fa\u73b0\u4e86\u95ee\u9898,\u8bf7\u67e5\u770b\u65e5\u5fd7", (Throwable)ex);
            this.getView().showErrorNotification(tips);
        }
    }

    public void click(EventObject evt) {
        Button button;
        String key;
        Object source = evt.getSource();
        if (source instanceof Button && "sync".equals(key = (button = (Button)source).getKey())) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException exception) {
                this.logger.error("\u4f11\u7720\u9519\u8bef", (Throwable)exception);
            }
            IDataModel model = this.getModel();
            DynamicObjectCollection reqEntry = model.getEntryEntity("reqbillentryentity");
            DynamicObjectCollection vehicleEntry = model.getEntryEntity("vehiclebillentryentity");
            Set billNos = reqEntry.stream().filter(obj -> obj.getBoolean("reqcheckbox")).map(obj -> obj.getString("reqbillno")).collect(Collectors.toSet());
            billNos.addAll(vehicleEntry.stream().filter(obj -> obj.getBoolean("vehiclecheckbox")).map(obj -> obj.getString("vehiclebillno")).collect(Collectors.toSet()));
            QFilter or = new QFilter("function", "=", (Object)ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355", (String)"ErAccountChangeBillPlugin_04", (String)"fi-er-formplugin", (Object[])new Object[0])).or("function", "=", (Object)ResManager.loadKDString((String)"\u7528\u8f66\u7533\u8bf7\u5355", (String)"ErHomeAddNewDialogPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
            DynamicObjectCollection logs = QueryServiceHelper.query((String)"er_trip_log", (String)"server,status,billno_tag", (QFilter[])new QFilter[]{new QFilter("traceid", "=", (Object)RequestContext.get().getTraceId()), new QFilter("billno_tag", "in", billNos), or});
            Set failBillNos = logs.stream().filter(obj -> obj.getString("status").equals("B")).map(obj -> obj.getString("billno_tag")).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty((Collection)logs) || CollectionUtils.isNotEmpty(failBillNos)) {
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u540c\u6b65\u6210\u529f\u3002", (String)"TripSyncApplyBillMobPlugin_07", (String)"fi-er-formplugin", (Object[])new Object[0]), Integer.valueOf(4000));
        }
    }
}

