/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BtnSettingPluginForBillList
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(BtnSettingPluginForBillList.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String appId = formShowParameter.getAppId();
        if ("kdem".equalsIgnoreCase(appId) || "/J5TH+OKHVUA".equalsIgnoreCase(appId)) {
            this.hideButton(view);
            String billFormId = ((IListView)this.getView()).getBillFormId();
            String billCollection = String.join((CharSequence)",", "er_layout_dailyreimburse", "er_layout_tripreimburse");
            if (billCollection.contains(billFormId)) {
                view.setVisible(Boolean.valueOf(true), new String[]{"baritemap1"});
            } else {
                view.setVisible(Boolean.valueOf(false), new String[]{"baritemap1"});
            }
            if (StringUtils.equals((CharSequence)"er_layout_dailyloanbill", (CharSequence)((IListView)this.getView()).getBillFormId())) {
                view.setVisible(Boolean.valueOf(true), new String[]{"bar_image"});
            }
        }
    }

    private void hideButton(IFormView view) {
        view.setVisible(Boolean.valueOf(false), new String[]{"bar_pushrec", "bar_push", "baritemap4", "bar_receive", "pushpay", "baritemap", "baritemap2", "baritemap3", "bar_selrec"});
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        DynamicObject reqbill;
        super.beforeShowBill(e);
        BillShowParameter billShowParameter = e.getParameter();
        Object billId = billShowParameter.getPkId();
        if (billId != null && (reqbill = QueryServiceHelper.queryOne((String)"er_tripreqbill", (String)"isloan", (QFilter[])new QFilter[]{new QFilter("id", "=", billId)})) != null && reqbill.getBoolean("isloan")) {
            billShowParameter.setCustomParam("isloan", (Object)true);
            billShowParameter.setCaption(ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355(\u501f)", (String)"TripReqBillList_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        IListView list = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        if (!"bar".equals(itemKey) && !"trackup".equals(itemKey) && !"bar_trackup".equals(itemKey) || primaryKeyValues.length > 1) {
            // empty if block
        }
        if (!"tracedown".equals(itemKey) && !"trackdown".equals(itemKey) && !"bar_trackdown".equals(itemKey) && !"bar_query".equals(itemKey) || primaryKeyValues.length > 1) {
            // empty if block
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("bar_viewloan".equals(key)) {
            String appid;
            switch (appid = this.getView().getFormShowParameter().getAppId()) {
                case "18X6P1ZSXS44": 
                case "exp": {
                    this.showLoanList("em");
                    break;
                }
                case "18XD+/5EDN8X": 
                case "tra": {
                    this.showLoanList("er");
                    break;
                }
                case "10MYBGBYHXDU": 
                case "em": 
                case "/J5TH+OKHVUA": 
                case "kdem": {
                    this.showLoanList("fi");
                    break;
                }
                default: {
                    this.showLoanList("er");
                    break;
                }
            }
        } else if ("addestimateasset".equals(key)) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("er_costestimateassetbill");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void showLoanList(String app) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Long userid = CommonServiceHelper.getCurrentUserID();
        if (userid == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"BtnSettingPluginForBillList_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        String formId = ((ListView)this.getView()).getEntityTypeId();
        if (formId == null || "".equals(formId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BtnSettingPluginForBillList_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        FilterInfo filterinfo = new FilterInfo();
        if (selectedRows.size() == 0) {
            switch (app) {
                case "em": 
                case "er": {
                    filterinfo.getFilterItems().clear();
                    filterinfo.addFilterItem("applier", (Object)userid);
                    this.showReportList("er_employee_loan_repay", filterinfo);
                    return;
                }
                case "fi": {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BtnSettingPluginForBillList_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u3002", (String)"BtnSettingPluginForBillList_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        Long orgid = 0L;
        Object primaryKey = selectedRows.get(0).getPrimaryKeyValue();
        try {
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", primaryKey)};
            DynamicObject row = QueryServiceHelper.queryOne((String)formId, (String)"id,applier.id,company.id", (QFilter[])qFilters);
            orgid = row.getLong("company.id");
            userid = row.getLong("applier.id");
        }
        catch (Exception e) {
            log.error(ResManager.loadKDString((String)"\u67e5\u770b\u501f\u8fd8\u6b3e\u5931\u8d25\u3002", (String)"BtnSettingPluginForBillList_7", (String)"fi-er-formplugin", (Object[])new Object[0]), (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u770b\u501f\u8fd8\u6b3e\u5931\u8d25\u3002", (String)"BtnSettingPluginForBillList_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (app) {
            case "em": 
            case "er": {
                filterinfo.getFilterItems().clear();
                filterinfo.addFilterItem("applier", (Object)userid);
                this.showReportList("er_employee_loan_repay", filterinfo);
                break;
            }
            case "fi": {
                filterinfo.getFilterItems().clear();
                filterinfo.addFilterItem("loanpayer", (Object)userid);
                filterinfo.addFilterItem("paramcompany", (Object)orgid);
                this.showReportList("er_employee_loan_repay_fi", filterinfo);
                break;
            }
        }
    }

    private void showReportList(String formid, FilterInfo filterinfo) {
        ReportShowParameter showForm = new ReportShowParameter();
        if (filterinfo != null) {
            filterinfo.addFilterItem("paramstatus", (Object)0, "=");
            ReportQueryParam queryParam = new ReportQueryParam();
            queryParam.setFilter(filterinfo);
            showForm.setQueryParam(queryParam);
        }
        showForm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showForm.setFormId(formid);
        this.getView().showForm((FormShowParameter)showForm);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)source.getOperateKey(), (CharSequence)"printpreview")) {
            OperateOption printOp = source.getOption();
            printOp.setVariableValue("BOS_AUDIT_CUSTOMAUDITVALUE", "E,F,G,H,I");
        }
    }
}

