/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.events.ChatEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;

public class EntrustReimburseList
extends AbstractListPlugin {
    public void chat(ChatEvent e) {
        e.setCancel(true);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (CommonServiceHelper.isFullApp((String)appId)) {
            this.addPersonalFilter(e);
        }
    }

    protected void addPersonalFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        Optional<QFilter> enableFilter = qFilters.stream().filter(v -> "enable".equals(v.getProperty())).findAny();
        Optional<QFilter> useOrgFilter = qFilters.stream().filter(v -> "id".equals(v.getProperty())).findAny();
        if (useOrgFilter.isPresent()) {
            qFilters.remove(useOrgFilter.get());
        }
        if (enableFilter.isPresent()) {
            qFilters.add(enableFilter.get());
        }
        qFilters.add(this.getPersonalFilter());
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap1", "bar_manage"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (CommonServiceHelper.isFullApp((String)appId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap1"});
        }
    }

    private QFilter getPersonalFilter() {
        QFilter listFilter = null;
        Long userId = CommonServiceHelper.getCurrentUserID();
        listFilter = new QFilter("consignor", "=", (Object)userId);
        listFilter = listFilter.or("trustee", "=", (Object)userId);
        return listFilter;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (CommonServiceHelper.isFullApp((String)appId)) {
            List commonFilterColumns = args.getCommonFilterColumns();
            Iterator iterator = commonFilterColumns.iterator();
            ArrayList personalNotVisible = Lists.newArrayList((Object[])new String[]{"useorg.id", "consignor.name", "trustee.name"});
            while (iterator.hasNext()) {
                FilterColumn filterColumn = (FilterColumn)iterator.next();
                if (!personalNotVisible.contains(filterColumn.getFieldName())) continue;
                iterator.remove();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (CommonServiceHelper.isFullApp((String)appId)) {
            FormOperate operate = (FormOperate)args.getSource();
            String operateKey = operate.getOperateKey();
            ArrayList forbiddenOperate = Lists.newArrayList((Object[])new String[]{"disable", "delete", "enable"});
            if (forbiddenOperate.contains(operateKey)) {
                ListSelectedRowCollection listSelectedData = args.getListSelectedData();
                List pks = listSelectedData.stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toList());
                Map map = BusinessDataServiceHelper.loadFromCache((String)"er_entrustreimburse", (String)"consignor", (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
                String userId = RequestContext.get().getUserId();
                Optional<Map.Entry> findAny = map.entrySet().stream().filter(v -> !userId.equals(((DynamicObject)v.getValue()).getString("consignor.id"))).findAny();
                if (findAny.isPresent()) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u59d4\u6258\u4eba\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"EntrustReimburseList_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

