/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.fi.er.business.common.AccountChangeUtil;
import kd.fi.er.business.daily.reimburse.topublic.AccountInfo;
import kd.fi.er.business.daily.reimburse.topublic.PublicReimbursePayerAcctUtils;
import kd.fi.er.business.expand.ErExpandServiceFacade;
import kd.fi.er.business.servicehelper.CreditLevelServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.PayerTypeEnum;
import kd.fi.er.formplugin.daily.web.util.ShowUserInfoUtils;
import org.apache.commons.lang.StringUtils;

public class ErAccountChangeBillPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
HyperLinkClickListener {
    public static final Map<String, String> RULEID_MAP;
    public static final Map<String, String> PAYERTYPE_MAP;
    public static final String[] CHANGE_PROP;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit payerName = (TextEdit)this.getControl("changepayername");
        payerName.addClickListener((ClickListener)this);
        TextEdit changepayeraccount = (TextEdit)this.getControl("changepayeraccount");
        changepayeraccount.addClickListener((ClickListener)this);
        EntryGrid changeEntry = (EntryGrid)this.getControl("changeentry");
        changeEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid originEntry = (EntryGrid)this.getControl("originalentry");
        originEntry.addHyperClickListener((HyperLinkClickListener)this);
        Arrays.stream(new String[]{"changesupplier", "changecustomer", "changecasorg", "changepayeer"}).forEach(fieldName -> {
            BasedataEdit control = (BasedataEdit)this.getControl((String)fieldName);
            control.setF7BatchFill(false);
        });
        EntryGrid entryGrid = (EntryGrid)this.getControl("changeentry");
        int focusRow = entryGrid.getEntryState().getFocusRow();
        if (this.getModel().getEntryRowCount("changeentry") == 0 || focusRow == -1) {
            return;
        }
        BasedataEdit changesupplierCardF7 = (BasedataEdit)this.getControl("changesupplier");
        BasedataEdit changecustomerCardF7 = (BasedataEdit)this.getControl("changecustomer");
        BasedataEdit changecasorgCardF7 = (BasedataEdit)this.getControl("changecasorg");
        BasedataEdit changepayeerCardF7 = (BasedataEdit)this.getControl("changepayeer");
        changesupplierCardF7.addBeforeF7SelectListener(event -> {
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier", focusRow);
            if (supplier != null && listShowParameter != null && listShowParameter.getListFilterParameter().getQFilters() != null) {
                listShowParameter.getListFilterParameter().getQFilters().clear();
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "=", supplier.getPkValue()));
                DynamicObject supplierObj = BusinessDataServiceHelper.loadSingle((String)PayerTypeEnum.SUPPLIER.getType(), (String)"createorg.id", (QFilter[])new QFilter[]{new QFilter("id", "=", supplier.getPkValue())});
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)PayerTypeEnum.SUPPLIER.getType(), (Long)supplierObj.getLong("createorg.id"));
                listShowParameter.getListFilterParameter().getQFilters().add(baseDataFilter);
            }
        });
        changecustomerCardF7.addBeforeF7SelectListener(event -> {
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            DynamicObject customer = (DynamicObject)this.getModel().getValue("customer", focusRow);
            if (customer != null && listShowParameter != null && listShowParameter.getListFilterParameter().getQFilters() != null) {
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "=", customer.getPkValue()));
            }
        });
        changecasorgCardF7.addBeforeF7SelectListener(event -> {
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            DynamicObject casorg = (DynamicObject)this.getModel().getValue("casorg", focusRow);
            if (casorg != null && listShowParameter != null && listShowParameter.getListFilterParameter().getQFilters() != null) {
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "=", casorg.getPkValue()));
            }
        });
        changepayeerCardF7.addBeforeF7SelectListener(event -> {
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            DynamicObject payeer = (DynamicObject)this.getModel().getValue("payeer", focusRow);
            if (payeer != null && listShowParameter != null && listShowParameter.getListFilterParameter().getQFilters() != null) {
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("payer.id", "=", ((DynamicObject)payeer.get("payer")).getPkValue()));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        ShowUserInfoUtils.initUserInfo((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        String applierStr = null;
        String deptStr = null;
        String applierPicUrl = null;
        String positionStr = null;
        DynamicObject applier = (DynamicObject)model.getValue("applier");
        DynamicObject dept = (DynamicObject)model.getValue("org");
        positionStr = model.getValue("applierpositionstr").toString();
        if (applier != null) {
            applierStr = applier.getLocaleString("name").getLocaleValue();
            applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applier.getPkValue()));
        }
        if (dept != null) {
            deptStr = dept.getLocaleString("name").getLocaleValue();
        }
        ((Label)this.getControl("applierv")).setText(applierStr);
        ((Label)this.getControl("orgv")).setText(deptStr);
        String telStr = (String)model.getValue("tel");
        model.setValue("tel", (Object)telStr);
        ((Label)this.getControl("telv")).setText(telStr);
        ((Label)this.getControl("applierpositionv")).setText(positionStr);
        Image applierPic = (Image)this.getControl("applierpic");
        applierPic.setUrl(applierPicUrl);
        if (applier != null) {
            String appilerIdStr = String.valueOf(applier.getPkValue());
            String creditlevelStr = CreditLevelServiceHelper.getCreditLevelByUserAndView((Object)appilerIdStr, (IFormView)this.getView());
            if (StringUtils.isEmpty((String)creditlevelStr)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"creditlevel"});
            } else {
                ((Label)this.getControl("creditlevel")).setText(creditlevelStr);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        IDataModel model = this.getModel();
        Object newValue = changeData.getNewValue();
        if (newValue == null) {
            return;
        }
        switch (fieldKey) {
            case "changepayername": {
                this.changePayerNameDataConsistent(newValue, rowIndex);
                break;
            }
            case "changesupplier": 
            case "changecustomer": 
            case "changecasorg": {
                String payerName = ((DynamicObject)newValue).getLocaleString("name").getLocaleValue();
                model.setValue("changepayername", (Object)payerName, rowIndex);
                Object payerType = model.getValue("changepayertype", rowIndex);
                AccountInfo accInfo = PublicReimbursePayerAcctUtils.getPayerDefaultInfo((String)((String)payerType), (Long)ErCommonUtils.getPk((Object)newValue));
                this.fillRowData(accInfo, rowIndex);
                break;
            }
            case "changepayeer": {
                DynamicObject payer = (DynamicObject)newValue;
                model.setValue("changepayername", payer.get("outpayer"), rowIndex);
                this.getModel().setValue("changepayeraccount", payer.get("payeraccount"), rowIndex);
                this.getModel().setValue("changepayeraccountname", payer.get("payeraccountname"), rowIndex);
                this.getModel().setValue("changepayerbank", (Object)payer.getLong("payerbank_Id"), rowIndex);
                break;
            }
            case "changepayertype": {
                String billType = (String)this.getModel().getValue("changebilltype", rowIndex);
                if (org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)billType, (CharSequence[])new CharSequence[]{"er_dailyloanbill", "er_publicreimbursebill", "er_prepaybill"})) {
                    this.clearRowData(rowIndex);
                    break;
                }
                if (this.getPageCache().get("isrevert") != null) {
                    this.getPageCache().remove("isrevert");
                    return;
                }
                String tips = String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u652f\u6301\u53d8\u66f4\u6536\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"ErAccountChangeBillPlugin_01", (String)"fi-er-formplugin", (Object[])new Object[0]), this.getBillTypeName(billType));
                this.getView().showTipNotification(tips);
                this.getPageCache().put("isrevert", "true");
                this.getModel().setValue(fieldKey, changeData.getOldValue(), rowIndex);
            }
        }
    }

    private void changePayerNameDataConsistent(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        String changepayertype = (String)model.getValue("changepayertype", rowIndex);
        PayerTypeEnum payerTypeEnum = PayerTypeEnum.getValue((String)changepayertype);
        if (payerTypeEnum == null || PayerTypeEnum.OTHER.compareTo((Enum)payerTypeEnum) == 0) {
            return;
        }
        DynamicObject payer = null;
        switch (payerTypeEnum) {
            case SUPPLIER: {
                payer = (DynamicObject)model.getValue("changesupplier", rowIndex);
                break;
            }
            case CUSTOMER: {
                payer = (DynamicObject)model.getValue("changecustomer", rowIndex);
                break;
            }
            case CASORG: {
                payer = (DynamicObject)model.getValue("changecasorg", rowIndex);
                break;
            }
            case PAYER: {
                payer = (DynamicObject)model.getValue("changepayeer", rowIndex);
            }
        }
        if (payer == null) {
            return;
        }
        String stdChangePayerName = payer.getLocaleString("name").getLocaleValue();
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)stdChangePayerName, (CharSequence)((String)newValue))) {
            model.beginInit();
            model.setValue("changepayername", (Object)stdChangePayerName, rowIndex);
            model.endInit();
            this.getView().updateView("changepayername", rowIndex);
        }
    }

    public void click(EventObject evt) {
        String keyName;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (keyName = control.getKey()) {
            case "changepayername": {
                this.selectPayer();
                break;
            }
            case "changepayeraccount": {
                ListShowParameter lsp = AccountChangeUtil.selectAccountByChangePayer((IFormView)this.getView(), (IDataModel)this.getModel());
                if (lsp == null) break;
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "changepayeraccountbank");
                lsp.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)lsp);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (operateKey.equals("draw")) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("er_accchange_drawview");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_accchange_drawview"));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            Map existRecordMap = this.getModel().getDataEntity(true).getDynamicObjectCollection("originalentry").stream().filter(m -> m.getLong("sourceentryid") > 0L).collect(Collectors.groupingBy(row -> row.getString("sourcebilltype"), Collectors.mapping(row -> Long.valueOf(row.getString("sourceentryid")), Collectors.toList())));
            for (Map.Entry entry : existRecordMap.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                formShowParameter.setCustomParam(entry.getKey(), entry.getValue());
            }
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)actionId, (CharSequence)"er_accchange_drawview")) {
            Map resultMap = (Map)event.getReturnData();
            if (resultMap == null || resultMap.size() == 0) {
                return;
            }
            Iterator iterator = resultMap.entrySet().iterator();
            ArrayList dataEntitysDyn = Lists.newArrayListWithExpectedSize((int)4);
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                String srcBillType = (String)next.getKey();
                ListSelectedRowCollection row = (ListSelectedRowCollection)next.getValue();
                DrawArgs drawArgs = this.buildDrawArgs(srcBillType, "er_accountchangebill", this.getView(), row, this.getRuleId(srcBillType));
                ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)drawArgs);
                if (!result.isSuccess()) continue;
                IRefrencedataProvider refProvider = new IRefrencedataProvider(){

                    public void fillReferenceData(Object[] dataEntitys, IDataEntityType type) {
                        BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
                    }
                };
                List dataEntitys = result.loadTargetDataObjects(refProvider, (MainEntityType)((BillEntityType)this.getModel().getDataEntityType()));
                dataEntitysDyn.addAll(dataEntitys);
                ((IBillModel)this.getModel()).push(dataEntitysDyn.get(0));
                result.release(refProvider, (MainEntityType)((BillEntityType)this.getModel().getDataEntityType()));
            }
            this.getView().updateView();
        } else if ("changepayeraccountbank".equals(actionId) && (returnData = event.getReturnData()) != null) {
            ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
            EntryGrid entry = (EntryGrid)this.getControl("changeentry");
            int rowIndex = entry != null ? entry.getEntryState().getFocusRow() : -1;
            String payerType = AccountChangeUtil.getPayerType((IFormView)this.getView(), (IDataModel)this.getModel());
            Object entryKey = PayerTypeEnum.CASORG.getType().equals(payerType) || PayerTypeEnum.PAYER.getType().equals(payerType) ? rowInfo.getPrimaryKeyValues()[0] : rowInfo.getEntryPrimaryKeyValues()[0];
            AccountInfo accountInfo = PublicReimbursePayerAcctUtils.getBankInfo((String)payerType, (long)((Long)entryKey));
            AccountChangeUtil.fillBankInfo((IDataModel)this.getModel(), (AccountInfo)accountInfo, (Integer)rowIndex);
            ErExpandServiceFacade.get().invokeExtService("ext.service.er.fillbankInfoPC", "fillbankInfoPC", new Object[]{payerType, (Long)entryKey, this.getModel(), rowIndex}, new Class[]{String.class, Long.class, IDataModel.class, Integer.class});
        }
    }

    protected String getRuleId(String billType) {
        return RULEID_MAP.get(billType);
    }

    private void selectPayer() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("changeentry");
        int focusRow = entryGrid.getEntryState().getFocusRow();
        String payerType = (String)this.getModel().getValue("changepayertype", focusRow);
        DynamicObject payeer = (DynamicObject)this.getModel().getValue("payeer", focusRow);
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)payerType, (CharSequence)"other") || payeer != null && payeer.get("payer") == null) {
            return;
        }
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(PAYERTYPE_MAP.get(payerType));
        basedataEdit.click();
    }

    private void fillRowData(AccountInfo accInfo, int rowIndex) {
        if (accInfo == null) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().setValue("changepayeraccount", (Object)accInfo.getAccount());
        this.getModel().setValue("changepayeraccountname", (Object)accInfo.getAccountName());
        this.getModel().setValue("changepayerbank", accInfo.getBeBank());
        this.getModel().endInit();
    }

    private void clearRowData(int rowIndex) {
        IDataModel model = this.getModel();
        model.beginInit();
        for (String propName : CHANGE_PROP) {
            model.setValue(propName, null, rowIndex);
        }
        model.endInit();
        this.getView().updateView("changeentry", rowIndex);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)entryName, (CharSequence)"originalentry")) {
            return;
        }
        HashMap delRowMap = new HashMap(e.getRowIndexs().length);
        DynamicObjectCollection delEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryName);
        for (int index : e.getRowIndexs()) {
            DynamicObject row = (DynamicObject)delEntry.get(index);
            String srcBillId = row.getString("sourcebillid");
            String srcEntryId = row.getString("sourceentryid");
            if (delRowMap.containsKey(srcBillId)) {
                ((Set)delRowMap.get(srcBillId)).add(srcEntryId);
                continue;
            }
            delRowMap.put(srcBillId, new HashSet(1));
            ((Set)delRowMap.get(srcBillId)).add(srcEntryId);
        }
        this.getView().getPageCache().put(entryName, JSON.toJSONString(delRowMap));
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)entryName, (CharSequence)"originalentry")) {
            return;
        }
        Map tamp = (Map)JSON.parse((String)this.getPageCache().get(entryName));
        Map<String, Set> delRow = tamp.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> new HashSet((List)entry.getValue())));
        DynamicObjectCollection changeEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("changeentry");
        int[] indexs = IntStream.range(0, changeEntry.size()).filter(idx -> {
            Set entrySet = (Set)delRow.get(((DynamicObject)changeEntry.get(idx)).getString("changebillid"));
            return entrySet != null && entrySet.contains(((DynamicObject)changeEntry.get(idx)).getString("changeentryid"));
        }).toArray();
        if (indexs.length != 0) {
            this.getModel().deleteEntryRows("changeentry", indexs);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String billID;
        String billType;
        String fieldName = event.getFieldName();
        int rowIndex = event.getRowIndex();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)fieldName, (CharSequence)"sourcebillno")) {
            billType = (String)this.getModel().getValue("sourcebilltype", rowIndex);
            billID = (String)this.getModel().getValue("sourcebillid", rowIndex);
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)fieldName, (CharSequence)"changebillno")) {
            billType = (String)this.getModel().getValue("changebilltype", rowIndex);
            billID = (String)this.getModel().getValue("changebillid", rowIndex);
        } else {
            return;
        }
        this.openLinkedForm(Long.valueOf(billID), billType);
    }

    private void openLinkedForm(Object pkValue, String FormId) {
        IFormView view = this.getView();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(pkValue);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId(FormId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private String getBillTypeName(String billType) {
        switch (billType) {
            case "er_tripreimbursebill": {
                return ResManager.loadKDString((String)"\u5dee\u65c5\u62a5\u9500\u5355", (String)"ErAccountChangeBillPlugin_02", (String)"fi-er-formplugin", (Object[])new Object[0]);
            }
            case "er_dailyreimbursebill": {
                return ResManager.loadKDString((String)"\u8d39\u7528\u62a5\u9500\u5355", (String)"ErAccountChangeBillPlugin_03", (String)"fi-er-formplugin", (Object[])new Object[0]);
            }
            case "er_tripreqbill": {
                return ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355", (String)"ErAccountChangeBillPlugin_04", (String)"fi-er-formplugin", (Object[])new Object[0]);
            }
        }
        return billType;
    }

    private DrawArgs buildDrawArgs(String srcEntity, String tarEntity, IFormView tarView, ListSelectedRowCollection rows, String ruleId) {
        DrawArgs args = new DrawArgs();
        args.setSourceEntityNumber(srcEntity);
        args.setTargetEntityNumber(tarEntity);
        args.getSelectedRows().addAll(rows);
        args.setTargetPageId(tarView.getPageId());
        args.setRuleId(ruleId);
        args.setBuildConvReport(true);
        return args;
    }

    static {
        Map<String, String> tamp = Arrays.stream(new String[][]{{"er_tripreimbursebill", "1579015114017753088"}, {"er_dailyreimbursebill", "1578985910614116352"}, {"er_publicreimbursebill", "1579005024963414016"}, {"er_dailyloanbill", "1574516860853275648"}, {"er_prepaybill", "1579046137849989120"}, {"er_tripreqbill", "1583935055494167552"}}).collect(Collectors.toMap(item -> item[0], item -> item[1], (v1, v2) -> v1));
        RULEID_MAP = Collections.unmodifiableMap(tamp);
        tamp = Arrays.stream(new String[][]{{"bd_supplier", "changesupplier"}, {"bd_customer", "changecustomer"}, {"bos_org", "changecasorg"}, {"er_payeer", "changepayeer"}}).collect(Collectors.toMap(item -> item[0], item -> item[1], (v1, v2) -> v1));
        PAYERTYPE_MAP = Collections.unmodifiableMap(tamp);
        CHANGE_PROP = new String[]{"changepayername", "changesupplier", "changecustomer", "changecasorg", "changepayeer", "changepayeraccount", "changepayeraccountname", "changepayerbank"};
    }
}

