/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ErTripReimAutoWriteDescription
extends AbstractFormPlugin {
    private static final String[] BILL_ENTRY = new String[]{"er_tripreimbursebill", "er_publicreimbursebill", "er_dailyreimbursebill", "er_dailyloanbill"};
    private static final Log logger = LogFactory.getLog(ErTripReimAutoWriteDescription.class);

    public static String getEXP_ITEM_NAME() {
        return ResManager.loadKDString((String)"@\u8d39\u7528\u9879\u76ee", (String)"ErTripReimAutoWriteDescription_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    public static String getDATE() {
        return ResManager.loadKDString((String)"#\u65e5\u671f", (String)"ErTripReimAutoWriteDescription_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    public static String getLOCAL() {
        return ResManager.loadKDString((String)"$\u76ee\u7684\u5730", (String)"ErTripReimAutoWriteDescription_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    public static String getPLACE() {
        return ResManager.loadKDString((String)"$\u5730\u70b9", (String)"ErTripReimAutoWriteDescription_5", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    public static void setDiscription(IFormView view) {
        String reimDisc;
        String description;
        SimpleDateFormat sdf;
        DynamicObject item;
        DynamicObjectCollection itemEntry;
        String entryId = view.getEntityId();
        if (!Arrays.asList(BILL_ENTRY).contains(entryId)) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObjectCollection expColl = null;
        DataEntityPropertyCollection dataEntityColl = model.getDataEntityType().getProperties();
        logger.info("expCollection : " + dataEntityColl);
        if (dataEntityColl.containsKey((Object)"tripentry")) {
            expColl = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
        } else if (dataEntityColl.containsKey((Object)"expenseentryentity")) {
            expColl = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        } else {
            logger.info("tripentry\u548cexpenseentryentity\u5c5e\u6027\u672a\u627e\u5230");
            return;
        }
        String billKind = "0";
        if (dataEntityColl.containsKey((Object)"billkind")) {
            billKind = model.getDataEntity(true).getString("billkind");
        }
        if (expColl.size() <= 0) {
            logger.info("\u8d39\u7528/\u5dee\u65c5\u660e\u7ec6\u5206\u5f55\u4e3a\u7a7a");
            return;
        }
        DynamicObject expInfo = (DynamicObject)expColl.get(0);
        DataEntityPropertyCollection expProperColl = expInfo.getDataEntityType().getProperties();
        DynamicObject expenseItemInfo = null;
        if (expProperColl.containsKey((Object)"tripexpenseitem")) {
            if (dataEntityColl.containsKey((Object)"billkind")) {
                expenseItemInfo = StringUtils.equals((CharSequence)"1", (CharSequence)billKind) ? model.getDataEntity(true).getDynamicObject("headexpenseitem") : expInfo.getDynamicObject("tripexpenseitem");
            }
        } else if (expProperColl.containsKey((Object)"expenseitem")) {
            expenseItemInfo = expInfo.getDynamicObject("expenseitem");
        } else {
            logger.info("tripexpenseitem\u548cexpenseitem\u5c5e\u6027\u672a\u627e\u5230");
            return;
        }
        if (expenseItemInfo == null) {
            logger.info("\u8d39\u7528/\u5dee\u65c5\u9879\u76ee\u4e3a\u7a7a");
            return;
        }
        HashMap billInfo = Maps.newHashMap();
        billInfo.put(ErTripReimAutoWriteDescription.getEXP_ITEM_NAME(), expenseItemInfo.getString("name"));
        if (StringUtils.equals((CharSequence)"1", (CharSequence)billKind)) {
            if (expProperColl.containsKey((Object)"entryentity") && !(itemEntry = expInfo.getDynamicObjectCollection("entryentity")).isEmpty()) {
                item = (DynamicObject)itemEntry.get(0);
                SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
                Date st = item.getDate("trip2startdate");
                Date et = item.getDate("trip2enddate");
                if (st == null || et == null) {
                    logger.info("\u65e5\u671f\u4e3a\u7a7a");
                    billInfo.put(ErTripReimAutoWriteDescription.getDATE(), " ");
                } else {
                    String start = sdf2.format(st);
                    String end = sdf2.format(et);
                    billInfo.put(ErTripReimAutoWriteDescription.getDATE(), String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s", (String)"ErTripReimAutoWriteDescription_6", (String)"fi-er-formplugin", (Object[])new Object[0]), start, end));
                }
            }
        } else if (expProperColl.containsKey((Object)"startdate")) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date st = expInfo.getDate("startdate");
            Date et = expInfo.getDate("enddate");
            if (st == null || et == null) {
                logger.info("\u65e5\u671f\u4e3a\u7a7a");
                billInfo.put(ErTripReimAutoWriteDescription.getDATE(), " ");
            } else {
                String start = sdf.format(st);
                String end = sdf.format(et);
                billInfo.put(ErTripReimAutoWriteDescription.getDATE(), String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s", (String)"ErTripReimAutoWriteDescription_6", (String)"fi-er-formplugin", (Object[])new Object[0]), start, end));
            }
        } else if (expProperColl.containsKey((Object)"happendate")) {
            sdf = new SimpleDateFormat("yyyy-MM");
            Date hd = expInfo.getDate("happendate");
            if (hd == null) {
                logger.info("\u65e5\u671f\u4e3a\u7a7a");
                billInfo.put(ErTripReimAutoWriteDescription.getDATE(), " ");
            } else {
                String happen = sdf.format(hd);
                billInfo.put(ErTripReimAutoWriteDescription.getDATE(), happen);
            }
        } else {
            logger.info("\u65e5\u671f\u4e3a\u7a7a");
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)billKind)) {
            if (expProperColl.containsKey((Object)"entryentity") && !(itemEntry = expInfo.getDynamicObjectCollection("entryentity")).isEmpty()) {
                item = (DynamicObject)itemEntry.get(0);
                DynamicObject to = item.getDynamicObject("trip2to");
                if (to == null) {
                    logger.info("\u65e5\u671f\u4e3a\u7a7a");
                    billInfo.put(ErTripReimAutoWriteDescription.getLOCAL(), " ");
                } else {
                    String local = to.getLocaleString("name").toString();
                    billInfo.put(ErTripReimAutoWriteDescription.getLOCAL(), local);
                }
            }
        } else if (expProperColl.containsKey((Object)"to")) {
            DynamicObject to = expInfo.getDynamicObject("to");
            if (to == null) {
                logger.info("\u65e5\u671f\u4e3a\u7a7a");
                billInfo.put(ErTripReimAutoWriteDescription.getLOCAL(), " ");
            } else {
                String local = to.getLocaleString("name").toString();
                billInfo.put(ErTripReimAutoWriteDescription.getLOCAL(), local);
            }
        }
        if ((description = ErTripReimAutoWriteDescription.putTripInfoTogether(billInfo, reimDisc = expenseItemInfo.getString("reimbursediscription"))) != null && !description.isEmpty()) {
            view.getModel().setValue("description", (Object)description);
        }
    }

    private static String putTripInfoTogether(Map<String, String> billInfo, String reimDisc) {
        String local;
        String expItemName;
        if (reimDisc == null || reimDisc.isEmpty()) {
            logger.info("come in there one , description is nothing , there 4");
            return null;
        }
        String date = billInfo.get(ErTripReimAutoWriteDescription.getDATE());
        if (date != null && reimDisc.contains(ErTripReimAutoWriteDescription.getDATE())) {
            reimDisc = reimDisc.replace(ErTripReimAutoWriteDescription.getDATE(), date);
        }
        if ((expItemName = billInfo.get(ErTripReimAutoWriteDescription.getEXP_ITEM_NAME())) != null && reimDisc.contains(ErTripReimAutoWriteDescription.getEXP_ITEM_NAME())) {
            reimDisc = reimDisc.replace(ErTripReimAutoWriteDescription.getEXP_ITEM_NAME(), expItemName);
        }
        if ((local = billInfo.get(ErTripReimAutoWriteDescription.getLOCAL())) != null && reimDisc.contains(ErTripReimAutoWriteDescription.getLOCAL())) {
            reimDisc = reimDisc.replace(ErTripReimAutoWriteDescription.getLOCAL(), local);
        } else if (local != null && reimDisc.contains(ErTripReimAutoWriteDescription.getPLACE())) {
            reimDisc = reimDisc.replace(ErTripReimAutoWriteDescription.getPLACE(), local);
        } else {
            reimDisc = reimDisc.replace(ErTripReimAutoWriteDescription.getPLACE(), "");
            reimDisc = reimDisc.replace(ErTripReimAutoWriteDescription.getLOCAL(), "");
            logger.info("local is nothing");
        }
        return reimDisc;
    }
}

