/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.business.servicehelper.invoice.GenerateInvoicerAssistant;
import kd.fi.er.business.servicehelper.invoice.Serviceitem;
import kd.fi.er.business.trip.dailybiz.TripReimCreateOrderEntrysUtil;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.CalculateTripSumUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.ReimburseUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.model.ChangeField;
import kd.fi.er.formplugin.util.OffsetUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ErTripReimburseBillTripEntryFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(ErTripReimburseBillTripEntryFormPlugin.class);
    public static final String MONTHLY_TYPE = "2";

    public void propertyChanged(PropertyChangedArgs e) {
        BigDecimal taxRate;
        BigDecimal exchangeRate;
        this.propertyChangedCountIncrease();
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeValue = changeSet[0];
        Object propValue = changeValue.getNewValue();
        int rowIndex = changeValue.getRowIndex();
        int parentIndex = changeValue.getParentRowIndex();
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"entrycurrency") || StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"exchangerate")) {
            if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"entrycurrency")) {
                if (propValue == null) {
                    propValue = propValue == null ? changeValue.getOldValue() : propValue;
                    model.setValue("entrycurrency", propValue, changeValue.getRowIndex(), changeValue.getParentRowIndex());
                }
                Map exchangeMap = AmountChangeUtil.getCurrentEntryExchangeRate((long)ErCommonUtils.getPk((Object)propValue), (IDataModel)model);
                String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
                exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
                if (model.getProperty("detailquotetype") != null) {
                    model.setValue("detailquotetype", (Object)quoteType, changeValue.getRowIndex(), changeValue.getParentRowIndex());
                }
                model.setValue("exchangerate", (Object)exchangeRate, changeValue.getRowIndex(), changeValue.getParentRowIndex());
            }
            this.getPropEntryCurrencyExchangeRate(this.getView(), model, changeValue);
            Integer entryRowIndex = changeSet[0].getRowIndex();
            AmountChangeUtil.recalcReimburseAmountField((IFormView)this.getView(), (IDataModel)model, (int)changeSet[0].getParentRowIndex(), (List)Lists.newArrayList((Object[])new Integer[]{entryRowIndex}), (boolean)false);
            AmountChangeUtil.updateTripApproveInfo((IDataModel)this.getModel(), (IFormView)this.getView(), (int)changeSet[0].getParentRowIndex(), (int)entryRowIndex, (boolean)false);
            if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"exchangerate") && propValue != null) {
                BigDecimal price = (BigDecimal)model.getValue("price", changeValue.getRowIndex(), changeValue.getParentRowIndex());
                DynamicObject currency = (DynamicObject)model.getValue("currency");
                String detailquotetype = (String)model.getValue("detailquotetype", changeValue.getRowIndex(), changeValue.getParentRowIndex());
                model.setValue("curprice", (Object)AmountUtils.getCurrencyAmount((BigDecimal)price, (BigDecimal)((BigDecimal)propValue), (int)AmountUtils.getCurrencyPrecision((Object)currency.getPkValue()), (String)detailquotetype), changeValue.getRowIndex(), changeValue.getParentRowIndex());
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"tripcurrency") || StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"tripexchangerate")) {
            if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"tripcurrency")) {
                if (propValue == null) {
                    propValue = propValue == null ? changeValue.getOldValue() : propValue;
                    model.setValue("tripcurrency", propValue, changeValue.getRowIndex());
                }
                Map currentEntryExchangeRate = AmountChangeUtil.getCurrentEntryExchangeRate((long)ErCommonUtils.getPk((Object)propValue), (IDataModel)model);
                String tripQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)currentEntryExchangeRate.get("quoteType")), (Object)"0");
                exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)currentEntryExchangeRate.get("exchangeRate")), (Object)BigDecimal.ONE);
                if (model.getProperty("tripquotetype") != null) {
                    model.setValue("tripquotetype", (Object)tripQuoteType, changeValue.getRowIndex());
                }
                model.setValue("tripexchangerate", (Object)exchangeRate, changeValue.getRowIndex());
            }
            this.getPropEntryCurrencyExchangeRate(this.getView(), model, changeValue);
            DynamicObjectCollection entryItemEntrys = ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("tripentry").get(changeSet[0].getRowIndex())).getDynamicObjectCollection("entryentity");
            if (entryItemEntrys != null && !entryItemEntrys.isEmpty()) {
                List entryItemRows = Stream.iterate(0, i -> i + 1).limit(entryItemEntrys.size()).collect(Collectors.toList());
                AmountChangeUtil.recalcReimburseAmountField((IFormView)this.getView(), (IDataModel)this.getModel(), (int)changeSet[0].getRowIndex(), entryItemRows, (boolean)true);
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"orientryamount")) {
            AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)((BigDecimal)changeValue.getNewValue()), (String)"entryamount", (String)"exchangerate", (String)"detailquotetype", (int)rowIndex, (int)parentIndex);
            taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex, parentIndex);
            AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentIndex, (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
            model.setValue("orientryappamount", changeValue.getNewValue(), rowIndex, parentIndex);
            AmountChangeUtil.updateTripEntryAndHeadAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (int)parentIndex);
        }
        if (Arrays.asList("entryamount", "entryappamount").contains(propertyName)) {
            AmountChangeUtil.updateTripEntryTitleAmountLabel((IFormView)this.getView(), (IDataModel)this.getModel());
        }
        if ("curprice".equals(propertyName)) {
            CalculateTripSumUtil.calculateAppnotaxamount((IFormView)this.getView(), (int)changeSet[0].getParentRowIndex());
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"taxrate") || StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"airportconstructionfee")) {
            AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentIndex, (boolean)true);
            AmountChangeUtil.updateTripEntryAndHeadAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (int)parentIndex);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"orientryappamount")) {
            BigDecimal oriEntryAmount;
            BigDecimal reimburseAppAmountOri = (BigDecimal)changeValue.getNewValue();
            if (reimburseAppAmountOri.compareTo(oriEntryAmount = (BigDecimal)this.getModel().getValue("orientryamount", rowIndex, parentIndex)) > 0) {
                return;
            }
            BigDecimal taxRate2 = (BigDecimal)this.getModel().getValue("taxrate", rowIndex, parentIndex);
            AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)((BigDecimal)changeValue.getNewValue()), (String)"entryappamount", (String)"exchangerate", (String)"detailquotetype", (int)rowIndex, (int)parentIndex);
            AmountChangeUtil.updateTripApproveInfo((IDataModel)this.getModel(), (IFormView)this.getView(), (int)parentIndex, (int)rowIndex, (BigDecimal.ZERO.compareTo(taxRate2) != 0 ? 1 : 0) != 0);
            OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentIndex, (BigDecimal.ZERO.compareTo(taxRate2) != 0 ? 1 : 0) != 0, (String)propertyName);
            AmountChangeUtil.updatePrice((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"entryentity", (String)"orientryappamount", (int)changeSet[0].getRowIndex(), (int)changeSet[0].getParentRowIndex(), (String)"entrycurrency", (ChangeField)ChangeField.ORIENTRYAPP_AMOUNT);
            AmountChangeUtil.updateTripEntryAndHeadAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (int)parentIndex);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"taxamount")) {
            AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentIndex, (boolean)false);
            this.setDefaultApproveTax(rowIndex, parentIndex);
            OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentIndex, (boolean)false, (String)propertyName);
            AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentIndex, (ChangeField)ChangeField.TAX_AMOUNT);
            AmountChangeUtil.updateTripEntryAndHeadAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (int)parentIndex);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"expenseitem")) {
            Object settlementType = this.getModel().getValue("settlementtype", rowIndex, parentIndex);
            if (MONTHLY_TYPE.equals(settlementType)) {
                return;
            }
            DynamicObject tripItemDO = (DynamicObject)propValue;
            if (tripItemDO == null && changeSet[0].getOldValue() != null) {
                model.setValue("expenseitem", changeValue.getOldValue(), rowIndex, parentIndex);
            }
            if (tripItemDO != null) {
                InvoiceUtils.updateTaxWhenItemChange((IFormView)this.getView(), (IDataModel)this.getModel(), (BigDecimal)tripItemDO.getBigDecimal("taxrate"), (int)rowIndex, (int)parentIndex);
                InvoiceUtils.updateOffsetWhenItemChange((IFormView)this.getView(), (IDataModel)this.getModel(), (Boolean)tripItemDO.getBoolean("isoffset"), (int)rowIndex, (int)parentIndex);
                String attribute = tripItemDO.getString("attribute");
                if (!StringUtils.equals((CharSequence)attribute, (CharSequence)MONTHLY_TYPE)) {
                    model.setValue("airportconstructionfee", (Object)BigDecimal.ZERO, rowIndex, parentIndex);
                }
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"deductibletax")) {
            ReimburseUtils.sumTripDeduxibleAmount((IDataModel)this.getModel(), (int)parentIndex);
            AmountChangeUtil.updatePrice((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"entryentity", (String)"orientryappamount", (int)rowIndex, (int)parentIndex, (String)"entrycurrency", (ChangeField)ChangeField.DEDUCTIBLE_TAX);
            AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentIndex, (ChangeField)ChangeField.DEDUCTIBLE_TAX);
            InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)this.getView(), (int)rowIndex, (int)parentIndex);
        }
        if (StringUtils.equals((CharSequence)"price", (CharSequence)propertyName)) {
            AmountChangeUtil.setCurPrice((IDataModel)model, (IFormView)this.getView(), (BigDecimal)((BigDecimal)propValue), (int)rowIndex, (int)parentIndex, (String)"entrycurrency");
        }
        if (StringUtils.equals((CharSequence)"approvetax", (CharSequence)propertyName)) {
            AmountChangeUtil.updatePrice((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"entryentity", (String)"orientryappamount", (int)rowIndex, (int)parentIndex, (String)"entrycurrency", (ChangeField)ChangeField.APPROVE_TAX);
            AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentIndex, (ChangeField)ChangeField.APPROVE_TAX);
        }
        if (StringUtils.equals((CharSequence)"offset", (CharSequence)propertyName)) {
            taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex, parentIndex);
            OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentIndex, (BigDecimal.ZERO.compareTo(taxRate) != 0 ? 1 : 0) != 0, (String)propertyName);
            InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)this.getView(), (int)rowIndex, (int)parentIndex);
        }
        if (StringUtils.equals((CharSequence)"iteminoutamount", (CharSequence)propertyName)) {
            InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)this.getView(), (int)rowIndex, (int)parentIndex);
        }
        if (StringUtils.equals((CharSequence)"invoicecurrency", (CharSequence)propertyName) && propValue != null) {
            long pkValue = (Long)((DynamicObject)propValue).getPkValue();
            InvoiceUtils.lockCurrency((IFormView)this.getView(), Collections.singleton(pkValue));
            InvoiceUtils.changeInvoiceCurrency((IFormView)this.getView(), (ChangeData)changeValue);
        }
        this.propertyChangedCountPrint();
    }

    private void propertyChangedCountIncrease() {
        if (ThreadCache.exists((Object)"reimIsPushVar")) {
            Map controlMap = (Map)ThreadCache.get((Object)"reimIsPushVar");
            AtomicInteger propertyChangedCountAtomic = (AtomicInteger)controlMap.get("reimPropertyChangedInvokeCount");
            propertyChangedCountAtomic.incrementAndGet();
        }
    }

    private void propertyChangedCountPrint() {
        if (ThreadCache.exists((Object)"reimIsPushVar")) {
            Map controlMap = (Map)ThreadCache.get((Object)"reimIsPushVar");
            AtomicInteger propertyChangedCountAtomic = (AtomicInteger)controlMap.get("reimPropertyChangedInvokeCount");
            log.info(" propertyTimes " + propertyChangedCountAtomic);
        }
    }

    private void getPropEntryCurrencyExchangeRate(IFormView view, IDataModel model, ChangeData changeValue) {
        DynamicObjectCollection tripEntrys = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
        if (changeValue == null || tripEntrys == null) {
            return;
        }
        Map<String, Object> changeValueEntryIndexMap = this.getChangeValueEntryIndex(changeValue);
        if (changeValueEntryIndexMap.get("tripcurrentRowIndex") != null) {
            int tripcurrentRowIndex = (Integer)changeValueEntryIndexMap.get("tripcurrentRowIndex");
            boolean isCurrencyShowinTripentry = SystemParamterUtil.getIsCurrencyShowinTripentry((long)ErCommonUtils.getPk((Object)this.getModel().getValue("company")));
            if (isCurrencyShowinTripentry && !DailyBillServiceHelper.isNewTripReim((IDataModel)model)) {
                DynamicObject curTripentry = (DynamicObject)tripEntrys.get(tripcurrentRowIndex);
                AmountChangeUtil.refreshCurrencyShowInTripEntryAmount((IFormView)view, (IDataModel)model, (DynamicObject)curTripentry);
            } else {
                DynamicObject curTripEntry = (DynamicObject)tripEntrys.get(tripcurrentRowIndex);
                DynamicObjectCollection curEntrys = curTripEntry.getDynamicObjectCollection("entryentity");
                if (curEntrys != null && !curEntrys.isEmpty()) {
                    if (changeValueEntryIndexMap.get("curEntryIndex") != null) {
                        int curEntryIndex = (Integer)changeValueEntryIndexMap.get("curEntryIndex");
                        DynamicObject curEntry = (DynamicObject)curEntrys.get(curEntryIndex);
                        AmountChangeUtil.refreshCurrencyShowInExpenseEntryAmount((IFormView)view, (IDataModel)model, (DynamicObject)curTripEntry, (DynamicObject)curEntry);
                    } else {
                        AmountChangeUtil.refreshCurrencyShowInExpenseEntryAmount((IFormView)view, (IDataModel)model, (DynamicObject)curTripEntry, null);
                    }
                }
            }
        }
    }

    private Map<String, Object> getChangeValueEntryIndex(ChangeData changeValue) {
        HashMap<String, Object> changeValueEntryIndexMap = new HashMap<String, Object>();
        int tripcurrentRowIndex = 0;
        String entryName = changeValue.getDataEntity().getDataEntityType().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)entryName, (CharSequence)"tripentry")) {
            tripcurrentRowIndex = changeValue.getRowIndex();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)entryName, (CharSequence)"entryentity")) {
            int curEntryIndex = changeValue.getRowIndex();
            tripcurrentRowIndex = changeValue.getParentRowIndex() == -1 ? 0 : changeValue.getParentRowIndex();
            changeValueEntryIndexMap.put("curEntryIndex", curEntryIndex);
        }
        changeValueEntryIndexMap.put("tripcurrentRowIndex", tripcurrentRowIndex);
        return changeValueEntryIndexMap;
    }

    private void setDefaultApproveTax(int rowIndex, int parentIndex) {
        if (this.getModel().getProperty("approvetax") != null) {
            BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("taxamount", rowIndex, parentIndex);
            this.getModel().setValue("approvetax", (Object)taxAmount, rowIndex, parentIndex);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entityName = e.getEntryProp().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)entityName, (CharSequence)"entryentity")) {
            AmountChangeUtil.updateTripEntryAndHeadAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (int)this.getModel().getEntryCurrentRowIndex("tripentry"));
            String loanType = (String)this.getModel().getValue("loanchecktype");
            AmountChangeUtil.loanClearEntryChange((IFormView)this.getView(), (IDataModel)this.getModel(), (String)loanType);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)entityName, (CharSequence)"tripentry")) {
            AmountChangeUtil.updateTitleAmountTotal((IDataModel)this.getModel());
            String loanType = (String)this.getModel().getValue("loanchecktype");
            AmountChangeUtil.loanClearEntryChange((IFormView)this.getView(), (IDataModel)this.getModel(), (String)loanType);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)entityName, (CharSequence)"invoiceentry")) {
            int rowCount = this.getModel().getEntryRowCount("invoiceentry");
            if (rowCount == 0) {
                InvoiceUtils.lockCurrency((IFormView)this.getView(), (Set)Collections.EMPTY_SET);
            } else {
                Set invoiceCurrencySet = this.getModel().getEntryEntity("invoiceentry").stream().map(invoiceEntry -> {
                    DynamicObject invoiceCurrency = invoiceEntry.getDynamicObject("invoicecurrency");
                    if (invoiceCurrency == null) {
                        return 0L;
                    }
                    return (Long)invoiceCurrency.getPkValue();
                }).collect(Collectors.toSet());
                InvoiceUtils.lockCurrency((IFormView)this.getView(), invoiceCurrencySet);
            }
        }
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        String name;
        switch (name = e.getEntryProp().getName()) {
            case "invoiceentry": {
                InvoiceUtils.lockCurrency((IFormView)this.getView(), (Set)Collections.EMPTY_SET);
            }
        }
    }

    public void afterBindData(EventObject e) {
        BigDecimal encashAmount;
        IDataModel model = this.getModel();
        boolean ischanged = model.getDataChanged();
        Long companyId = ErCommonUtils.getPk((Object)model.getValue("company"));
        boolean iscurrencyshowintripentry = !DailyBillServiceHelper.isNewTripReim((IDataModel)this.getModel()) && companyId != null && SystemParamterUtil.getIsCurrencyShowinTripentry((long)companyId);
        model.setValue("iscurrencyshowintripentry", (Object)iscurrencyshowintripentry);
        model.setDataChanged(ischanged);
        AmountChangeUtil.updateTripEntryTitleAmountLabel((IFormView)this.getView(), (IDataModel)this.getModel());
        if (this.getModel().getDataEntity().getDataEntityState().isPushChanged()) {
            DynamicObjectCollection tripEntries = model.getEntryEntity("tripentry");
            for (int i = 0; i < tripEntries.size(); ++i) {
                DynamicObject tripEntry = (DynamicObject)tripEntries.get(i);
                Optional<DynamicObject> findFirst = tripEntry.getDynamicObjectCollection("entryentity").stream().filter(v -> MONTHLY_TYPE.equals(v.getString("settlementtype"))).findFirst();
                if (!findFirst.isPresent()) continue;
                model.beginInit();
                model.setValue("tripcurrency", null, i);
                model.endInit();
                model.setValue("tripcurrency", (Object)ErCommonUtils.getPk((Object)findFirst.get().get("entrycurrency")), i);
            }
        }
        if ((encashAmount = (BigDecimal)model.getValue("encashamount")).compareTo(BigDecimal.ZERO) > 0) {
            AmountChangeUtil.showPayAmountLable((IDataModel)model, (Label)((Label)this.getControl("totalencashamountlabel")), (String)"encashamount");
            model.setDataChanged(false);
        }
    }

    private String getOrderNumFromReimburseDetail(DynamicObject reimburseDetail, Long feeId) {
        String orderFormId = reimburseDetail.getString("orderformid");
        if (!StringUtils.equals((CharSequence)"er_vehiclebill", (CharSequence)orderFormId)) {
            return null;
        }
        Long pk = ErCommonUtils.getPk((Object)reimburseDetail.get("expenseitem"));
        if (pk != null && pk.equals(feeId)) {
            return null;
        }
        return reimburseDetail.getString("ordernum");
    }

    private static void calcServiceFee(List<DynamicObject> vehicleBills, String entryOrderNum, DynamicObject entry, Map<String, List<DynamicObject>> invoiceSettingObjectMap) {
        List vehicleBill = vehicleBills.stream().filter(dynamicObject -> dynamicObject != null && dynamicObject.getString("ordernum").equals(entryOrderNum)).collect(Collectors.toList());
        for (DynamicObject orderBill : vehicleBill) {
            BigDecimal serviceamounttax;
            List invoiceSetting = new ArrayList();
            String server = orderBill.getString("server");
            List<DynamicObject> invoiceSettingLst = invoiceSettingObjectMap.get(server);
            if (invoiceSettingLst != null && !invoiceSettingLst.isEmpty()) {
                invoiceSetting = GenerateInvoicerAssistant.getInvoiceSetting((DynamicObject)invoiceSettingLst.get(0), (String)server);
            }
            Map<Object, List<Map>> invoiceSetGroup = invoiceSetting.stream().collect(Collectors.groupingBy(v -> (String)v.get("operationtype")));
            List<Map> invoiceSetByOperation = invoiceSetGroup.get(orderBill.getString("operationtype"));
            BigDecimal totalTax = BigDecimal.ZERO;
            BigDecimal ticketAmount = BigDecimal.ZERO;
            String producttype = orderBill.getString("producttype");
            if (producttype.equals("1")) {
                ticketAmount = orderBill.getBigDecimal("totalamount").subtract(orderBill.getBigDecimal("servicefee"));
            }
            Map invoiceSetMap = TripReimCreateOrderEntrysUtil.calculateInvoiceSet((DynamicObject)orderBill, invoiceSetByOperation, (BigDecimal)ticketAmount, (BigDecimal)totalTax, (Serviceitem)Serviceitem.SERVICE);
            BigDecimal taxamount = BigDecimal.ZERO;
            BigDecimal totalamount = entry.getBigDecimal("orientryamount");
            taxamount = serviceamounttax = (BigDecimal)((Object)invoiceSetMap.getOrDefault("serviceamounttax", "0"));
            entry.set("taxamount", (Object)taxamount);
            entry.set("approvetax", (Object)taxamount);
            entry.set("deductibletax", (Object)taxamount);
            entry.set("notaxamount", (Object)totalamount.subtract(taxamount));
            entry.set("price", (Object)totalamount.subtract(taxamount));
        }
    }
}

