/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.common.SettlementTypeEnum;

public class MultiTripReimburserPlugin
extends AbstractBillPlugIn {
    private static final String T_MAIN = "advcontoolbarap2";
    private static final String MULTRAVELERSRECIPT = "multravelersrecipt";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{T_MAIN});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        CommonServiceHelper.setIsMulTravelers((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)MULTRAVELERSRECIPT, (CharSequence)evt.getItemKey())) {
            this.deleteOldReciptInformation();
            this.queryAlltripInformationAndAddReciptInformation();
        }
    }

    private void queryAlltripInformationAndAddReciptInformation() {
        DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
        HashMap<Long, BigDecimal> reimburserAmountMaps = new HashMap<Long, BigDecimal>(2);
        HashMap<Long, BigDecimal> noAmountMaps = new HashMap<Long, BigDecimal>(2);
        this.groupAmountByTravels(applier, reimburserAmountMaps, noAmountMaps);
        reimburserAmountMaps.putAll(noAmountMaps);
        ArrayList<Long> reimburseIds = new ArrayList<Long>(2);
        reimburserAmountMaps.forEach((reimburserId, approveCurrAmount) -> {
            if (!this.buildMultiAccountEntry((Long)reimburserId, (BigDecimal)approveCurrAmount)) {
                reimburseIds.add((Long)reimburserId);
            }
        });
        DynamicObjectCollection tripEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        HashMap payerIdMapAccCostCompany = new HashMap(reimburserAmountMaps.size());
        tripEntry.stream().forEach(card -> {
            DynamicObjectCollection detailEntry = card.getDynamicObjectCollection("entryentity");
            detailEntry.stream().forEach(row -> {
                DynamicObject accCostCompany = row.getDynamicObject("travelcostcompany");
                Map<Long, DynamicObject> map = row.getDynamicObjectCollection("trip2travelers").stream().filter(Objects::nonNull).collect(Collectors.toMap(traver -> traver.getLong("fbasedataid_id"), traver -> accCostCompany, (v1, v2) -> accCostCompany));
                map.entrySet().stream().filter(entry -> payerIdMapAccCostCompany.get(entry.getKey()) == null).forEach(entry -> {
                    DynamicObject cfr_ignored_0 = (DynamicObject)payerIdMapAccCostCompany.put(entry.getKey(), entry.getValue());
                });
            });
        });
        DynamicObjectCollection accEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("accountentry");
        IntStream.range(0, accEntry.size()).forEach(idx -> {
            Long payerId = ((DynamicObject)accEntry.get(idx)).getDynamicObject("payer").getDynamicObject("payer").getLong("id");
            if (payerIdMapAccCostCompany.get(payerId) != null) {
                ((DynamicObject)accEntry.get(idx)).set("acccostcompany", payerIdMapAccCostCompany.get(payerId));
                this.getView().updateView("acccostcompany", idx);
            }
        });
        this.showConfirm(reimburseIds);
    }

    protected void groupAmountByTravels(DynamicObject applier, Map<Long, BigDecimal> reimburserAmountMaps, Map<Long, BigDecimal> noAmountMaps) {
        if (DailyBillServiceHelper.isNewTripReim((IDataModel)this.getModel())) {
            DynamicObjectCollection tripEntryDOs = this.getModel().getEntryEntity("tripentry");
            for (DynamicObject tripEntry : tripEntryDOs) {
                DynamicObjectCollection entries = tripEntry.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entries) {
                    if (SettlementTypeEnum.MONTH_SETTLEMENT.getCode().equals(entry.getString("settlementtype"))) continue;
                    DynamicObjectCollection travelers = entry.getDynamicObjectCollection("trip2travelers");
                    BigDecimal tripApproveAmount = entry.getBigDecimal("entryappamount");
                    this.addValueToMap(applier, reimburserAmountMaps, noAmountMaps, travelers, tripApproveAmount);
                }
            }
        } else {
            DynamicObjectCollection tripEntryDOs = this.getModel().getEntryEntity("tripentry");
            for (DynamicObject tripEntry : tripEntryDOs) {
                DynamicObjectCollection travelers = tripEntry.getDynamicObjectCollection("travelers");
                DynamicObjectCollection entries = tripEntry.getDynamicObjectCollection("entryentity");
                BigDecimal[] tripApproveAmount = new BigDecimal[]{BigDecimal.ZERO};
                entries.stream().filter(e -> !SettlementTypeEnum.MONTH_SETTLEMENT.getCode().equals(e.getString("settlementtype"))).forEach(e -> {
                    tripApproveAmount[0] = tripApproveAmount[0].add(e.getBigDecimal("entryappamount"));
                });
                this.addValueToMap(applier, reimburserAmountMaps, noAmountMaps, travelers, tripApproveAmount[0]);
            }
        }
    }

    protected void addValueToMap(DynamicObject applier, Map<Long, BigDecimal> reimburserAmountMaps, Map<Long, BigDecimal> noAmountMaps, DynamicObjectCollection travelers, BigDecimal tripApproveAmount) {
        if (travelers.size() > 1) {
            Map<Long, BigDecimal> tripNoAmountMap = travelers.stream().filter(Objects::nonNull).map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toMap(e -> e, e -> BigDecimal.ZERO, (e1, e2) -> e1));
            noAmountMaps.putAll(tripNoAmountMap);
        } else {
            Long reveiverId = travelers.isEmpty() ? (Long)applier.getPkValue() : Long.valueOf(((DynamicObject)travelers.get(0)).getLong("fbasedataid_id"));
            if (reimburserAmountMaps.get(reveiverId) != null) {
                reimburserAmountMaps.put(reveiverId, reimburserAmountMaps.get(reveiverId).add(tripApproveAmount));
            } else {
                reimburserAmountMaps.put(reveiverId, tripApproveAmount);
            }
        }
    }

    protected void showConfirm(List<Long> reimburseIds) {
        Map userArray;
        if (!reimburseIds.isEmpty() && (userArray = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", reimburseIds)})) != null && userArray.size() > 0) {
            ArrayList<String> userNameList = new ArrayList<String>(userArray.size());
            for (Map.Entry entry : userArray.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                userNameList.add(dynamicObject.getLocaleString("name").getLocaleValue());
            }
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u672a\u81ea\u52a8\u4ea7\u751f\u6536\u6b3e\u4fe1\u606f\uff0c\u8bf7\u624b\u5de5\u6dfb\u52a0\u3002", (String)"MultiTripReimburserPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), userNameList), MessageBoxOptions.OK);
        }
    }

    protected DynamicObjectCollection getTravels(DynamicObject tripEntry) {
        DynamicObjectCollection travels = null;
        if (DailyBillServiceHelper.isNewTripReim((IDataModel)this.getModel())) {
            DynamicObjectCollection entries = tripEntry.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                DynamicObjectCollection trip2travelers = entry.getDynamicObjectCollection("trip2travelers");
                if (travels == null) {
                    travels = trip2travelers;
                    continue;
                }
                travels.addAll((Collection)trip2travelers);
            }
        } else {
            travels = tripEntry.getDynamicObjectCollection("travelers");
        }
        return travels;
    }

    private boolean buildMultiAccountEntry(Long reimburserId, BigDecimal approveCurrAmount) {
        IDataModel model = this.getModel();
        List defaultAccounts = PayeeServiceHelper.getOtherDefaultAccountByPayerID((Long)reimburserId, null, (boolean)false);
        if (defaultAccounts == null || defaultAccounts.isEmpty()) {
            return false;
        }
        DynamicObject defaultAccount = (DynamicObject)defaultAccounts.get(0);
        if (null == defaultAccount) {
            return false;
        }
        int rowIndex = model.createNewEntryRow("accountentry");
        CoreBaseBillServiceHelper.fillAccountEntry((IDataModel)model, (int)rowIndex, (DynamicObject)defaultAccount);
        Map currencyMap = AmountChangeUtil.getCurrencyPayerAndParam((IDataModel)model, (int)rowIndex, (Long)reimburserId);
        BigDecimal approveOriAmount = AmountChangeUtil.getOriAmount((BigDecimal)approveCurrAmount, (Map)currencyMap, (String)((String)model.getValue("accquotetype", rowIndex)));
        model.setValue("accountcurrency", currencyMap.get("currencyId"), rowIndex);
        model.setValue("accexchangerate", currencyMap.get("exchangeRate"), rowIndex);
        model.setValue("receiveamount", (Object)approveCurrAmount, rowIndex);
        model.setValue("orireceiveamount", (Object)approveOriAmount, rowIndex);
        model.setValue("accnotpayamount", (Object)approveCurrAmount, rowIndex);
        model.setValue("oriaccnotpayamount", (Object)approveOriAmount, rowIndex);
        return true;
    }

    private void deleteOldReciptInformation() {
        this.getModel().deleteEntryData("accountentry");
    }
}

