/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class PayeeEdit
extends AbstractBasePlugIn {
    private static final Log logger = LogFactory.getLog((String)"PayeeEdit");

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String appid = this.getView().getFormShowParameter().getAppId();
        if (CommonServiceHelper.isFullApp((String)appid)) {
            this.getModel().setValue("fullapp", (Object)Boolean.TRUE);
            this.getModel().setDataChanged(false);
        } else if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnsave"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel dataModel = this.getModel();
        Long currentUserID = CommonServiceHelper.getCurrentUserID();
        dataModel.setValue("creator_id", (Object)currentUserID);
        RequestContext requestContext = RequestContext.get();
        Long createOrgId = CommonServiceHelper.getCompanyIdByUserId((Long)currentUserID);
        if (createOrgId == null && (createOrgId = Long.valueOf(UserServiceHelper.getUserMainOrgId((long)currentUserID))).floatValue() == 0.0f) {
            createOrgId = RequestContext.get().getOrgId();
        }
        DynamicObject payer = (DynamicObject)dataModel.getValue("payer");
        boolean isemployee = (Boolean)dataModel.getValue("isemployee");
        if (payer == null && isemployee) {
            dataModel.setValue("payer", (Object)requestContext.getUserId());
            dataModel.setValue("outpayer", ((DynamicObject)dataModel.getValue("payer")).get("name"));
            dataModel.setValue("payeraccountname", ((DynamicObject)dataModel.getValue("payer")).get("name"));
        } else if (payer != null && isemployee) {
            dataModel.setValue("outpayer", ((DynamicObject)dataModel.getValue("payer")).get("name"));
        }
        String appNum = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appNum)) {
            appNum = "em";
        }
        String createOrg = null;
        if (StringUtils.containsAny((CharSequence)appNum, (CharSequence[])new CharSequence[]{"em", "kdem"})) {
            IFormView payeerListView = this.getView().getParentView();
            if (payeerListView != null) {
                createOrg = payeerListView.getPageCache().get("payeecreateorg");
            }
            if (!StringUtils.isEmpty(createOrg)) {
                createOrgId = Long.valueOf(createOrg);
            }
        }
        this.getModel().setValue("createorg", (Object)createOrgId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        IDataModel dataModel = this.getModel();
        switch (propName) {
            case "payer": {
                DynamicObject payer = (DynamicObject)propValue;
                boolean isemployee = (Boolean)this.getModel().getValue("isemployee");
                if (payer == null || !isemployee) break;
                dataModel.setValue("outpayer", payer.get("name"));
                dataModel.setValue("payeraccountname", payer.get("name"));
                break;
            }
            case "isemployee": {
                boolean isEmpoloyee = false;
                if (propValue != null) {
                    isEmpoloyee = (Boolean)propValue;
                }
                if (isEmpoloyee) {
                    this.getModel().setValue("payer", null);
                } else {
                    this.getModel().setValue("outpayer", (Object)"");
                    this.getModel().setValue("payer", null);
                }
                this.getModel().setValue("payeraccountname", (Object)"");
                break;
            }
            case "payeraccount": {
                if (propValue == null) break;
                this.getModel().setValue("payeraccount", (Object)propValue.toString().replaceAll("\\s", ""));
                break;
            }
            case "outpayer": {
                if (((Boolean)this.getModel().getValue("isemployee")).booleanValue()) break;
                this.getModel().setValue("payeraccountname", propValue);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        boolean cancel = false;
        switch (operateKey) {
            case "save": {
                String appId;
                IDataModel model = this.getModel();
                DynamicObject createorg = (DynamicObject)model.getValue("createorg");
                String isgetaccountcurrency = "0";
                if (createorg != null) {
                    isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)createorg.getPkValue()));
                }
                if ("1".equals(isgetaccountcurrency) && model.getValue("currency") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u5206\u5f55\u662f\u5426\u53d6\u8d26\u6237\u5e01\u79cd\u503c\u4e3a\u662f\uff0c\u8bf7\u8f93\u5165\u201c\u5e01\u79cd\u201d\u3002", (String)"PayeeEdit_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    cancel = true;
                }
                DynamicObject payer = (DynamicObject)model.getValue("payer");
                String outpayer = (String)model.getValue("outpayer");
                boolean isemployee = (Boolean)model.getValue("isemployee");
                if (isemployee && payer == null) {
                    model.setValue("payer", (Object)CommonServiceHelper.getCurrentUserID());
                }
                boolean isshare = (Boolean)model.getValue("isshare");
                DynamicObjectCollection userid = (DynamicObjectCollection)model.getValue("userid");
                if (isshare && userid != null && userid.isEmpty()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u82e5\u6253\u5f00\u201c\u6388\u6743\u4f7f\u7528\u201d\u5f00\u5173\uff0c\u5219\u9700\u6307\u5b9a\u4f7f\u7528\u4eba\u3002", (String)"PayeeEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    cancel = true;
                }
                if (!isemployee && StringUtils.isEmpty((CharSequence)outpayer)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4eba\u3002", (String)"PayeeEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    cancel = true;
                }
                if (!CommonServiceHelper.isFullApp((String)(appId = this.getView().getFormShowParameter().getAppId())) || payer == null) break;
                Long payerId = (Long)payer.getPkValue();
                Long creatorId = (Long)model.getValue("creator_id");
                Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
                boolean isdefault = (Boolean)model.getValue("isdefault");
                if (creatorId.equals(currentUserId) || payerId.equals(currentUserId)) {
                    List defaultAccts;
                    if (!isdefault || payerId.equals(currentUserId) || (defaultAccts = PayeeServiceHelper.getOtherDefaultAccountByPayerID((Long)payerId, (Object)model.getDataEntity().getPkValue(), (boolean)false)).isEmpty()) break;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5df2\u5b58\u5728\u9ed8\u8ba4\u6536\u6b3e\u4fe1\u606f\uff0c\u65e0\u6cd5\u518d\u8bbe\u7f6e\u3002", (String)"PayeeEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    cancel = true;
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u672c\u4eba\u6216\u672c\u4eba\u7ef4\u62a4\u7684\u8d26\u53f7\u624d\u80fd\u8fdb\u884c\u4fee\u6539\u3002", (String)"PayeeEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                cancel = true;
            }
        }
        args.setCancel(cancel);
    }
}

