/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.ErPermissionServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class PayeeListOrgFilterPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog((String)"PayeeListOrgFilterPlugin");

    public void filterContainerInit(FilterContainerInitArgs args) {
        boolean isLookUp;
        super.filterContainerInit(args);
        FilterContainerInitEvent filterContainerInitEvent = args.getFilterContainerInitEvent();
        List filterList = filterContainerInitEvent.getCommonFilterColumns().stream().filter(ComboItem2 -> !ComboItem2.getFieldName().equals("useorg.id")).collect(Collectors.toList());
        filterContainerInitEvent.getCommonFilterColumns().clear();
        filterContainerInitEvent.getCommonFilterColumns().addAll(filterList);
        String appNum = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appNum)) {
            appNum = "em";
        }
        if (!(isLookUp = ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp()) && (StringUtils.equals((CharSequence)"em", (CharSequence)appNum) || StringUtils.equals((CharSequence)"kdem", (CharSequence)appNum))) {
            this.initComboFilter(filterContainerInitEvent);
        }
    }

    private void initComboFilter(FilterContainerInitEvent filterContainerInitEvent) {
        Long defaultCompanyId;
        List commonFilterColumns = filterContainerInitEvent.getCommonFilterColumns();
        CommonFilterColumn orgFilterColumn = new CommonFilterColumn("createorg");
        orgFilterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"PayeeListOrgFilterPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0])));
        orgFilterColumn.setMulti(false);
        orgFilterColumn.setMustInput(false);
        commonFilterColumns.add(0, orgFilterColumn);
        String adminOrgsCache = this.getPageCache().get("adminOrgs");
        List adminOrgs = null;
        if (!StringUtils.isEmpty((CharSequence)adminOrgsCache)) {
            adminOrgs = (List)SerializationUtils.deSerializeFromBase64((String)adminOrgsCache);
        }
        if (adminOrgs == null || adminOrgs.isEmpty()) {
            adminOrgs = OrgUnitServiceHelper.getAllOrgByViewId((long)1L, (boolean)false);
            this.getPageCache().put("adminOrgs", SerializationUtils.serializeToBase64((Object)adminOrgs));
        }
        QFilter orgIdFilter = new QFilter("id", "in", (Object)adminOrgs);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = this.getView().getFormShowParameter().getServiceAppId();
        }
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "em";
        }
        List allPermCompanyIds = ErPermissionServiceHelper.getOrgListWithQueryPerm((String)appId, (String)"er_payeer");
        QFilter allPermcCmpanyFilter = new QFilter("id", "in", (Object)allPermCompanyIds);
        QFilter orgPatternFilter = new QFilter("orgpattern.patterntype", "in", (Object)new String[]{"1", "2"});
        String adminOrgDymCache = this.getPageCache().get("adminOrgDym");
        DynamicObjectCollection adminOrgDym = null;
        if (!StringUtils.isEmpty((CharSequence)adminOrgDymCache)) {
            adminOrgDym = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)adminOrgDymCache);
        }
        if (adminOrgDym == null || adminOrgDym.isEmpty()) {
            adminOrgDym = QueryServiceHelper.query((String)"bos_org", (String)"id, name", (QFilter[])new QFilter[]{orgIdFilter, orgPatternFilter, allPermcCmpanyFilter}, null);
            this.getPageCache().put("adminOrgDym", SerializationUtils.serializeToBase64((Object)adminOrgDym));
        }
        Map<Object, String> orgIdNameMap = adminOrgDym.stream().filter(e -> e != null && Long.valueOf(e.getLong("id")) != null).collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("name"), (e1, e2) -> e1));
        logger.info("PayeeListOrgFilterPlugin_initComboFilter>>>payeeDyms.length" + orgIdNameMap.size());
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(orgIdNameMap.size());
        for (Map.Entry<Object, String> orgIdName : orgIdNameMap.entrySet()) {
            Long orgId = (Long)orgIdName.getKey();
            String localName = orgIdName.getValue();
            if (orgId == null) continue;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(localName));
            item.setValue(orgId.toString());
            comboItems.add(item);
        }
        logger.info("PayeeListOrgFilterPlugin_initComboFilter>>>comboItemSet.size" + comboItems.size());
        String defaultValue = "";
        Long currentUserID = CommonServiceHelper.getCurrentUserID();
        if (currentUserID != null && (defaultCompanyId = CommonServiceHelper.getCompanyIdByUserId((Long)currentUserID)) != null) {
            defaultValue = defaultCompanyId.toString();
            this.getPageCache().put("payeecreateorg", defaultValue);
        }
        if (StringUtils.isEmpty((CharSequence)defaultValue)) {
            for (ComboItem item : comboItems) {
                if (StringUtils.isEmpty((CharSequence)item.getValue())) continue;
                defaultValue = item.getValue();
                this.getPageCache().put("payeecreateorg", defaultValue);
                break;
            }
        }
        orgFilterColumn.setComboItems(comboItems);
        orgFilterColumn.setDefaultValue(defaultValue);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        FilterParameter filterParameter = args.getFilterParameter();
        if (filterParameter != null) {
            List qFilters = filterParameter.getQFilters();
            for (QFilter filter : qFilters) {
                Object value;
                if (!StringUtils.equals((CharSequence)"createorg.id", (CharSequence)filter.getProperty()) || !((value = filter.getValue()) instanceof Long)) continue;
                String appNum = this.getView().getFormShowParameter().getAppId();
                if (StringUtils.isBlank((CharSequence)appNum)) {
                    appNum = "em";
                }
                this.getPageCache().put("payeecreateorg", value.toString());
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (StringUtils.equals((CharSequence)"createorg.id", (CharSequence)fieldName)) {
            List qfilters = args.getQfilters();
            QFilter orgPatternFilter = new QFilter("orgpattern.patterntype", "in", (Object)new String[]{"1", "2"});
            qfilters.add(orgPatternFilter);
        }
    }
}

