/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.util.OpenPageUtils;
import kd.fi.er.business.trip.overtime.TripOrderBillOvertimeHelper;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.TripReimOpenTypeUtils;
import kd.fi.er.business.utils.TripUserGrantUtils;
import kd.fi.er.common.model.UserCurrentDeptInfo;
import kd.fi.er.common.model.trip.TripReimburseOpenType;

public class TripAppHomeMainPagePlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(TripAppHomeMainPagePlugin.class);

    public void afterBindData(EventObject e) {
        TripUserGrantUtils.checkServerAuth((IFormView)this.getView(), (String)"", (boolean)true);
        this.checkOvertimeOrderBill();
    }

    private void checkOvertimeOrderBill() {
        TripOrderBillOvertimeHelper helper = new TripOrderBillOvertimeHelper();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List overtimeOrderBill = helper.getOrderToRemind(userId);
        if (!overtimeOrderBill.isEmpty()) {
            HashMap<String, Integer> customParam = new HashMap<String, Integer>();
            customParam.put("count", overtimeOrderBill.size());
            HashMap<String, String> para = new HashMap<String, String>();
            para.put("formId", "er_overtime_remind_pc");
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParams(customParam);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        logger.info("\u5173\u95ed\u5dee\u65c5\u62a5\u9500\u5355\u540e\u8fdb\u5165closedCallBack");
        String actionId = event.getActionId();
        if ("close_menupage".equals(actionId)) {
            logger.info("\u5173\u95ed\u5dee\u65c5\u62a5\u9500\u5355\u8fdb\u5165closedCallBack\u4e2dif1");
            if (event.getReturnData() instanceof UserCurrentDeptInfo) {
                logger.info("\u5173\u95ed\u5dee\u65c5\u62a5\u9500\u5355\u8fdb\u5165closedCallBack\u4e2dif2");
                UserCurrentDeptInfo userInfo = (UserCurrentDeptInfo)event.getReturnData();
                String tripOpenType = TripReimOpenTypeUtils.getTripReimburseOpenType((Long)userInfo.getOldCompanyId(), (Long)userInfo.getCompanyId(), (Long)userInfo.getUserId());
                String formId = ErStdConfig.getExtTripReimFormId((String)TripReimburseOpenType.getTripReimburseOpenType((String)tripOpenType).getFormId());
                String appID = (String)this.getView().getFormShowParameter().getCustomParam("appid");
                List list = AppMetadataCache.getAppMenusInfoByAppId((String)appID);
                List checkedNodeIDs = list.stream().filter(v -> StringUtils.equals((CharSequence)formId, (CharSequence)v.getFormId()) && StringUtils.equals((CharSequence)"BillShowParameter", (CharSequence)v.getParamType())).collect(Collectors.toList());
                String checkedNodeID = "18X+PXETXUWI";
                if (!checkedNodeIDs.isEmpty()) {
                    checkedNodeID = ((AppMenuInfo)checkedNodeIDs.get(0)).getId();
                }
                AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)appID, (String)checkedNodeID);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("view", this.getView());
                map.put("formnumber", formId);
                map.put("parametertype", menu.getParamType());
                map.put("parameter", JSONArray.parseObject((String)menu.getParams()));
                map.put("menuname", menu.getName());
                map.put("openType", menu.getOpenType());
                map.put("permItem", menu.getPermission());
                HashMap customparameters = Maps.newHashMap();
                customparameters.put("userInfo", JSON.toJSONString((Object)userInfo));
                logger.info("TripAppHomeMainPagePlugin>>>\u4f20\u5165\u7684userinfo\u4e3a\uff1a" + JSON.toJSONString((Object)userInfo));
                map.put("customparameters", customparameters);
                OpenPageUtils.openApp((String)appID, (String)checkedNodeID, map, (IFormView)this.getView());
            }
        }
    }
}

