/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.TripUserGrantUtils;

public class TripBookChooseEdit
extends AbstractFormPlugin
implements ClickListener {
    private static Log logger = LogFactory.getLog(TripBookChooseEdit.class);
    private String[] tripControlIds = new String[]{"bee_domair", "bee_intair", "bee_hotel", "bee_train", "flex_beetrain", "corp_domair", "corp_intair", "corp_hotel", "corp_inthotel", "corp_car", "corp_train", "corp_home", "travelnoone_domair", "travelnoone_hotel", "travelnoone_train", "travelnoone_home", "dtg_home", "dtg_plane_in", "dtg_plane_out", "dtg_hotel_in", "dtg_hotel_out", "dtg_train", "dtg_car", "ali_home", "ali_plane", "ali_hotel", "ali_train", "ali_car", "qicheng_home", "qicheng_domair", "qicheng_intair", "qicheng_domhotel", "qicheng_train", "meiya_home", "meiya_plane", "meiya_hotel", "meiya_train", "meiya_list"};

    public void registerListener(EventObject e) {
        this.addClickListeners(this.tripControlIds);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        logger.info("Click key is: " + key);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long billId = (Long)parameter.getCustomParam("billId");
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("billId", billId);
        paraMap.put("key", key);
        if (Arrays.asList(this.tripControlIds).contains(key)) {
            this.getView().returnDataToParent(paraMap);
            this.getView().close();
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        boolean isCancel = TripCommonUtil.validateBizInfo((String)key, (IFormView)this.getView());
        evt.setCancel(isCancel);
        if (!isCancel) {
            String server = "";
            DynamicObjectCollection servers = null;
            boolean loginExternalPlat = false;
            if (key != null && key.startsWith("corp")) {
                servers = TripUserGrantUtils.getServers((String)Supplier.XIECHENG.name());
                server = Supplier.XIECHENG.name();
            } else if (key != null && key.contains("travelnoone")) {
                servers = TripUserGrantUtils.getServers((String)Supplier.CHAILVYIHAO.name());
                server = Supplier.CHAILVYIHAO.name();
            } else if (key != null && key.contains("didi")) {
                servers = TripUserGrantUtils.getServers((String)Supplier.DIDI.name());
                server = Supplier.DIDI.name();
                loginExternalPlat = true;
            } else if (key != null && key.contains("dtg")) {
                servers = TripUserGrantUtils.getServers((String)Supplier.TONGCHENG.name());
                server = Supplier.TONGCHENG.name();
            } else if (key != null && key.contains("ali")) {
                servers = TripUserGrantUtils.getServers((String)Supplier.ALI.name());
                server = Supplier.ALI.name();
            } else if (key != null && key.contains("qicheng_")) {
                servers = TripUserGrantUtils.getServers((String)Supplier.QICHENG.name());
                server = Supplier.QICHENG.name();
            } else if (key != null && key.contains("meiya_")) {
                servers = TripUserGrantUtils.getServers((String)Supplier.MEIYA.name());
                server = Supplier.MEIYA.name();
            }
            if (CollectionUtils.isNotEmpty((Collection)servers)) {
                boolean grant = TripUserGrantUtils.judgeIsOpenPage((DynamicObjectCollection)servers);
                if (grant) {
                    TripUserGrantUtils.openRemindPage((boolean)Boolean.FALSE, (IFormView)this.getView(), (boolean)Boolean.TRUE, (String)server, (IFormPlugin)this, (String)(loginExternalPlat ? "true" : "false"));
                }
                evt.setCancel(grant);
            }
        }
    }

    public void afterCreateNewData(EventObject arg0) {
        super.afterCreateNewData(arg0);
        TripCommonUtil.controlBusinessTrealPanleHiding((IFormView)this.getView());
    }
}

