/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.bean.CostDeptF7ChangePram;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.ExpenseItemServiceHelper;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ControlMethodEnum;
import kd.fi.er.common.SettlementTypeEnum;
import kd.fi.er.formplugin.budget.BudgetCommonUtil;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCompanyF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostDeptF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeExpenseItemF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.TripBeforeCostCenterF7SelectListener;
import kd.fi.er.formplugin.daily.web.workflow.ErMobWorkFlowOtherViewEditUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TripEntryEdit
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(TripEntryEdit.class);
    private static final String TRIP_ENTRY_ROW_INDEX = "tripEntryRowIndex";
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        MulBasedataEdit travelersF7 = (MulBasedataEdit)this.getControl("travelers");
        this.getF7FilterInfo((BasedataEdit)travelersF7);
        BasedataEdit travelerF7 = (BasedataEdit)this.getControl("traveler");
        this.getF7FilterInfo(travelerF7);
        if (this.getView().getParentView() != null && this.getView().getParentView().getModel() != null) {
            IDataModel model = this.getModel();
            IDataModel parentModel = this.getView().getParentView().getModel();
            String number = parentModel.getDataEntityType().getName();
            if (ErEntityTypeUtils.isTripReqBill((String)number) && ((Boolean)model.getValue("isloan")).booleanValue()) {
                number = "er_loanbill";
            }
            BasedataEdit tripExpenseItemF7 = (BasedataEdit)this.getControl("tripexpenseitem");
            tripExpenseItemF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeExpenseItemF7SelectListener(this.getView(), number, "entrycostdept"));
            this.costDeptF7Filter();
            this.costCompanyF7Filter();
            this.costCenterF7Filter();
        }
    }

    private void costCenterF7Filter() {
        TripBeforeCostCenterF7SelectListener beforeCostCenterF7SelectListener = new TripBeforeCostCenterF7SelectListener(this.getView());
        BasedataEdit entryCostCenterF7 = (BasedataEdit)this.getControl("std_entrycostcenter");
        if (entryCostCenterF7 != null) {
            entryCostCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
    }

    protected void costDeptF7Filter() {
        BasedataEdit entrycostDeptF7 = (BasedataEdit)this.getControl("entrycostdept");
        if (entrycostDeptF7 != null) {
            BeforeCostDeptF7SelectListener beforeCostDeptF7SelectListener = new BeforeCostDeptF7SelectListener(this.getView());
            entrycostDeptF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostDeptF7SelectListener);
        }
    }

    protected void costCompanyF7Filter() {
        BasedataEdit costCompanyF7 = (BasedataEdit)this.getControl("entrycostcompany");
        Object costDept = this.getModel().getValue("entrycostdept");
        Object company = this.getModel().getValue("company");
        if (costCompanyF7 != null && costDept != null) {
            BeforeCostCompanyF7SelectListener beforeCostCompanyF7SelectListener = new BeforeCostCompanyF7SelectListener(ErCommonUtils.getPk((Object)costDept), ErCommonUtils.getPk((Object)company));
            costCompanyF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCompanyF7SelectListener);
        }
    }

    public void getF7FilterInfo(BasedataEdit travelerF7) {
        travelerF7.addBeforeF7SelectListener(listener -> {
            IDataModel parentModel;
            DynamicObject org;
            ListShowParameter list = (ListShowParameter)listener.getFormShowParameter();
            IFormView parentView = this.getView().getParentView();
            if (parentView != null && (org = (DynamicObject)(parentModel = parentView.getModel()).getValue("company")) != null) {
                boolean travelersrelationtripreq = SystemParamterUtil.getBoolParamResult((Long)ErCommonUtils.getPk((Object)org), (String)"travelersrelationtripreq");
                if (travelersrelationtripreq) {
                    HashSet<Long> longSet = new HashSet<Long>();
                    if (parentModel.getProperty("writeoffapply") != null && !parentModel.getEntryEntity("writeoffapply").isEmpty()) {
                        DynamicObjectCollection writeoffapply = parentModel.getEntryEntity("writeoffapply");
                        for (Object item : writeoffapply) {
                            DynamicObjectCollection applytravelers = item.getDynamicObjectCollection("applytravelers");
                            if (applytravelers == null) continue;
                            for (DynamicObject apply : applytravelers) {
                                longSet.add(ErCommonUtils.getPk((Object)apply.getDynamicObject("fbasedataid")));
                            }
                        }
                    }
                    if (parentModel.getProperty("clearloanentry") != null && !parentModel.getEntryEntity("clearloanentry").isEmpty()) {
                        DynamicObject[] reqBills;
                        DynamicObjectCollection clearloanentry = parentModel.getEntryEntity("clearloanentry");
                        HashSet<Long> applyIdSet = new HashSet<Long>();
                        for (DynamicObject item : clearloanentry) {
                            if (!"er_tripreqbill".equals(item.getString("srcbilltype"))) continue;
                            applyIdSet.add(item.getLong("loanbillid"));
                        }
                        for (DynamicObject reqBill : reqBills = BusinessDataServiceHelper.load((String)"er_tripreqbill", (String)"tripentry.travelers", (QFilter[])new QFilter[]{new QFilter("id", "in", applyIdSet)})) {
                            DynamicObjectCollection tripentry = reqBill.getDynamicObjectCollection("tripentry");
                            if (null == tripentry) continue;
                            for (DynamicObject entry : tripentry) {
                                DynamicObjectCollection travelers = entry.getDynamicObjectCollection("travelers");
                                if (null == travelers) continue;
                                for (DynamicObject traveler : travelers) {
                                    longSet.add(ErCommonUtils.getPk((Object)traveler.getDynamicObject("fbasedataid")));
                                }
                            }
                        }
                    }
                    longSet.remove(null);
                    if (!longSet.isEmpty()) {
                        list.getListFilterParameter().setFilter(new QFilter("id", "in", longSet));
                    }
                }
                int multravelersrange = SystemParamterUtil.getMulTravelersRange((long)ErCommonUtils.getPk((Object)org));
                switch (multravelersrange) {
                    default: {
                        DynamicObject dept = (DynamicObject)parentModel.getValue("org");
                        list.getListFilterParameter().setFilter(QFilter.of((String)"entryentity.dpt.masterid=?", (Object[])new Object[]{dept.get("masterid")}).and(new QFilter("enable", "=", (Object)Boolean.TRUE)));
                        break;
                    }
                    case 1: {
                        DynamicObject company = org;
                        List allOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, Collections.singletonList(ErCommonUtils.getPk((Object)company)), (boolean)true);
                        list.getListFilterParameter().setFilter(new QFilter("entryentity.dpt.masterid", "in", (Object)allOrgList).and(new QFilter("enable", "=", (Object)Boolean.TRUE)));
                        break;
                    }
                    case 2: {
                        list.getListFilterParameter().setFilter(new QFilter("enable", "=", (Object)Boolean.TRUE));
                    }
                }
                if (multravelersrange == 0 || multravelersrange == 1) {
                    Long id = ErCommonUtils.getPk((Object)parentModel.getValue("org"));
                    if (multravelersrange == 1) {
                        id = ErCommonUtils.getPk((Object)org);
                    }
                    listener.getFormShowParameter().setCustomParam("initRootOrgId", (Object)id);
                    listener.getFormShowParameter().setCustomParam("initOrgId", (Object)id);
                }
                list.setCustomParam("isIncludeAllSub", (Object)true);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        int tripEntryRowIndex;
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        IDataModel parentModel = parentView.getModel();
        IDataModel model = this.getModel();
        model.setValue("formid", parentModel.getValue("formid"));
        model.setValue("iscurrency", parentModel.getValue("iscurrency"));
        model.setValue("currency", (Object)ErCommonUtils.getPk((Object)parentModel.getValue("currency")));
        model.setValue("isloan", parentModel.getValue("isloan"));
        model.setValue("company", parentModel.getValue("company"));
        model.setValue("org", parentModel.getValue("org"));
        model.setValue("bizdate", parentModel.getValue("bizdate"));
        model.setValue("costorgusemode", parentModel.getValue("costorgusemode"));
        model.setValue("tripentrystatus", (Object)"A");
        DynamicObject applierOb = (DynamicObject)parentModel.getValue("applier");
        String formId = (String)model.getValue("formid");
        if (applierOb != null && (ErEntityTypeUtils.isTripReqBill((String)parentView.getEntityId()) || ErEntityTypeUtils.isTripReimburseBill((String)parentView.getEntityId()))) {
            MulBasedataEdit travelersF7 = (MulBasedataEdit)this.getControl("travelers");
            travelersF7.setMustInput(true);
        }
        this.setRowIndexPageCache();
        DynamicObject company = (DynamicObject)model.getValue("company");
        String costMode = ErCommonUtils.getCostOrgUseMode((Long)(company == null ? Long.valueOf(0L) : (Long)company.getPkValue()));
        if (!"0".equals(costMode)) {
            BasedataEdit entryCostCenter = (BasedataEdit)this.getControl("std_entrycostcenter");
            entryCostCenter.setMustInput(true);
        }
        if ((tripEntryRowIndex = Integer.parseInt(this.getPageCache().get(TRIP_ENTRY_ROW_INDEX))) != -1) {
            DynamicObject tripEntry = parentModel.getEntryRowEntity("tripentry", tripEntryRowIndex);
            DataEntityPropertyCollection tripEntryProps = tripEntry.getDataEntityType().getProperties();
            DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                String propertyName = property.getName();
                if (tripEntryProps.get((Object)propertyName) == null) continue;
                model.setValue(propertyName, ErCommonUtils.getObjectValue((Object)tripEntry.get(propertyName)));
            }
            if (ErEntityTypeUtils.isTripReimburseBill((String)formId) && tripEntry.get("tripentryarea") != null) {
                model.setValue("triparea", (Object)ErCommonUtils.getPk((Object)tripEntry.get("tripentryarea")));
            }
        } else {
            model.setValue("entrycostdept", (Object)ErCommonUtils.getPk((Object)parentModel.getValue("costdept")));
            String centerKey = "std_entrycostcenter";
            if (!"0".equals(costMode)) {
                ErCostCenterUtil.initEntryCostCenter((IDataModel)this.getModel(), (String)"tripentry", (int)model.getEntryCurrentRowIndex("std_entrycostcenter"), (int)-1);
                DynamicObject costCenter = (DynamicObject)parentModel.getValue("std_costcenter");
                if (model.getProperty(centerKey) == null) {
                    centerKey = "entrycostcenter";
                }
                if (costCenter != null) {
                    model.setValue(centerKey, (Object)costCenter);
                }
            }
            model.setValue("entrycostcompany", (Object)ErCommonUtils.getPk((Object)parentModel.getValue("costcompany")));
            if (!"0".equals(costMode)) {
                if (model.getProperty(centerKey) == null) {
                    centerKey = "entrycostcenter";
                }
                if (ErCostCenterUtil.costCenterHasCostCompany((Object)model.getValue(centerKey), (Object)parentModel.getValue("costcompany"))) {
                    model.setValue(centerKey, null);
                }
            }
            model.setValue("tripcurrency", (Object)ErCommonUtils.getPk((Object)parentModel.getValue("currency")));
            DynamicObjectCollection parentTripEntry = parentModel.getEntryEntity("tripentry");
            if (parentTripEntry != null && parentTripEntry.size() > 0) {
                DynamicObject tripEntry = (DynamicObject)parentTripEntry.get(parentTripEntry.size() - 1);
                DynamicObject toPlace = tripEntry.getDynamicObject("to");
                model.setValue("from", (Object)ErCommonUtils.getPk((Object)toPlace));
                model.setValue("startdate", (Object)tripEntry.getDate("enddate"));
                model.setValue("triphappendate", (Object)tripEntry.getDate("enddate"));
            }
            model.setValue("tripexchangerate", (Object)BigDecimal.ONE);
        }
        DynamicObjectCollection travelers = (DynamicObjectCollection)model.getValue("travelers");
        if (travelers != null && applierOb != null && travelers.size() == 0) {
            Long pkid = (Long)applierOb.getPkValue();
            Long[] applierIds = new Long[]{pkid};
            model.setValue("travelers", (Object)applierIds);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object istravelers = formShowParameter.getCustomParam("istravelers");
        model.setValue("istravelers", istravelers);
        if (model.getValue("company") != null) {
            Object pkValue = ((DynamicObject)model.getValue("company")).getPkValue();
            boolean isControl = SystemParamterUtil.isEnableTripStandard((Long)Long.parseLong(pkValue.toString())) && SystemParamterUtil.getTripStandardControlLevel((long)Long.parseLong(pkValue.toString())) != ControlMethodEnum.NO_CONTROL;
            model.setValue("istripcontrol", (Object)isControl);
        }
        if (company != null) {
            int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
            model.setValue("expensesassumeshowtypes", (Object)String.valueOf(showType));
            if (showType == 2) {
                FieldEdit costDept = (FieldEdit)this.getControl("entrycostdept");
                costDept.setMustInput(true);
                FieldEdit costCompany = (FieldEdit)this.getControl("entrycostcompany");
                costCompany.setMustInput(true);
            }
        }
        this.showExchangeRate(false);
        Boolean isMonth = (Boolean)formShowParameter.getCustomParam("isMonth");
        if (isMonth != null) {
            model.setValue("ismonth", (Object)isMonth);
        }
        Object ismulwayto = formShowParameter.getCustomParam("ismulwayto");
        model.setValue("ismulwayto", ismulwayto);
        CommonServiceHelper.setMulWayToVisible((IDataModel)parentModel, (IFormView)this.getView());
        boolean iscurrencyshowintripentry = SystemParamterUtil.getIsCurrencyShowinTripentry((long)ErCommonUtils.getPk((Object)company));
        model.setValue("iscurrencyshowintripentry", (Object)iscurrencyshowintripentry);
        this.setBudgetInfoByDefaultValue();
    }

    private void setBudgetInfoByDefaultValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        Boolean isQueryBudget = (Boolean)formShowParameter.getCustomParam("isquerybudget");
        Object expenseItemObj = this.getModel().getValue("tripexpenseitem");
        if (expenseItemObj != null && status.equals((Object)OperationStatus.ADDNEW) && isQueryBudget.booleanValue()) {
            BudgetCommonUtil.buildBudgetAmountField(this.getView(), 0);
        }
    }

    public void afterBindData(EventObject e) {
        FormShowParameter formShowParameter;
        Map customParams;
        Boolean iscurrency;
        super.afterBindData(e);
        this.setControlVisible();
        IFormView parentView = this.getView().getParentView();
        Long companyId = 0L;
        if (parentView != null) {
            companyId = ErCommonUtils.getPk((Object)parentView.getModel().getValue("company"));
        }
        if (SystemParamterUtil.getTripexpenseitemMustInput((Long)companyId) || this.isShowExpenseItem().booleanValue()) {
            FieldEdit editor = (FieldEdit)this.getView().getControl("tripexpenseitem");
            editor.setMustInput(true);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tripexpenseitem"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tripexpenseitem"});
        }
        IDataModel model = this.getModel();
        String formId = (String)model.getValue("formid");
        Boolean istripcontrol = (Boolean)model.getValue("istripcontrol");
        if (ErEntityTypeUtils.isTripReimburseBill((String)formId) && istripcontrol.booleanValue()) {
            FieldEdit editor = (FieldEdit)this.getView().getControl("triparea");
            editor.setMustInput(true);
        }
        if (ErEntityTypeUtils.isTripReqBill((String)formId)) {
            String tripamountctrltype;
            Object type = model.getValue("triporiamouctrltype");
            String string = tripamountctrltype = type == null ? "" : type.toString();
            if ("1".equals(tripamountctrltype) || "3".equals(tripamountctrltype)) {
                FieldEdit editor = (FieldEdit)this.getView().getControl("triporiamount");
                editor.setMustInput(true);
            }
        }
        if ((iscurrency = (Boolean)model.getValue("iscurrency")).booleanValue()) {
            FieldEdit editor = (FieldEdit)this.getView().getControl("tripcurrency");
            editor.setMustInput(true);
            FieldEdit tripexchangerateEditor = (FieldEdit)this.getView().getControl("tripexchangerate");
            tripexchangerateEditor.setMustInput(true);
        }
        this.setRowIndexPageCache();
        int tripIndex = Integer.parseInt(this.getPageCache().get(TRIP_ENTRY_ROW_INDEX));
        if (tripIndex >= 0 && this.getView().getParentView() != null) {
            IDataModel pModel = this.getView().getParentView().getModel();
            DynamicObject trip = pModel.getEntryRowEntity("tripentry", tripIndex);
            if (ErEntityTypeUtils.isTripReimburseBill((String)formId) && trip != null && trip.getDynamicObjectCollection("entryentity").stream().anyMatch(v -> "2".equals(v.getString("settlementtype")))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"tripcurrency"});
            }
        }
        if (!(customParams = (formShowParameter = this.getView().getFormShowParameter()).getCustomParams()).containsKey(TRIP_ENTRY_ROW_INDEX)) {
            return;
        }
        int tripEntryRowIndex = (Integer)customParams.get(TRIP_ENTRY_ROW_INDEX);
        boolean isEnable = (Boolean)customParams.get("isEnable");
        Map allFields = this.getModel().getDataEntityType().getAllFields();
        if (tripEntryRowIndex != -1) {
            for (String key : allFields.keySet()) {
                this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{key});
            }
            this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"tirpdate"});
            this.getView().setVisible(Boolean.valueOf(isEnable), new String[]{BTN_OK, "btncancel"});
        }
        IFormView view = this.getView();
        if (parentView != null) {
            String entityId = parentView.getEntityId();
            Boolean isloan = (Boolean)parentView.getModel().getValue("isloan", tripEntryRowIndex);
            if ("er_tripreqbill_ssc".equals(entityId) && isloan.booleanValue()) {
                view.setEnable(Boolean.FALSE, new String[]{"from", "to", "mulwayto", "tirpdate", "vehicle", "vehicles", "entrycostcompany", "triporiamount", "entrycostdept", "std_project"});
            }
            if ("er_tripreqbill_ssc".equals(entityId) || !this.readOnly() && !this.multiVehicles()) {
                view.setVisible(Boolean.FALSE, new String[]{"vehicles"});
                view.setVisible(Boolean.TRUE, new String[]{"vehicle"});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"vehicles"});
                view.setVisible(Boolean.FALSE, new String[]{"vehicle"});
            }
            if (ErEntityTypeUtils.isTripReimburseBill((String)entityId) && tripEntryRowIndex != -1) {
                boolean enable = !((DynamicObject)parentView.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(tripEntryRowIndex)).getDynamicObjectCollection("entryentity").stream().anyMatch(v -> StringUtils.equals((String)ItemFrom.InvoiceCloud.getValue(), (String)v.getString("itemfrom")) && StringUtils.isNotBlank((String)v.getString("invoiceno_entry")));
                this.getView().setEnable(Boolean.valueOf(enable), new String[]{"tripcurrency"});
            }
        }
        ErMobWorkFlowOtherViewEditUtils.setWorkFlowEditView((IFormView)this.getView(), (Map)customParams, (IDataModel)model, (int)2);
        this.setTripDateControl();
    }

    protected boolean readOnly() {
        IFormView parentView = this.getView().getParentView();
        return parentView != null && !"A".equals(parentView.getModel().getValue("billstatus")) && !"D".equals(parentView.getModel().getValue("billstatus"));
    }

    protected boolean multiVehicles() {
        return !this.getVihicleFromStdConfig();
    }

    private boolean getVihicleFromStdConfig() {
        return StringUtils.equals((String)ErStdConfig.get((String)"notMultiVehicles"), (String)"true");
    }

    private void setRowIndexPageCache() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String tripRowIndex = "-1";
        if (customParams.get(TRIP_ENTRY_ROW_INDEX) != null) {
            tripRowIndex = customParams.get(TRIP_ENTRY_ROW_INDEX).toString();
        }
        this.getPageCache().put(TRIP_ENTRY_ROW_INDEX, tripRowIndex);
    }

    private void setControlVisible() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (null == this.getView().getParentView() || null == this.getView().getParentView().getModel() || null == this.getView().getParentView().getModel().getProperty("formid") || null == this.getView().getParentView().getModel().getValue("company")) {
            return;
        }
        Long companyId = null;
        DynamicObject company = (DynamicObject)this.getView().getParentView().getModel().getValue("company");
        if (company != null) {
            companyId = (Long)company.getPkValue();
        }
        if (companyId == null) {
            return;
        }
        String formId = (String)this.getView().getParentView().getModel().getValue("formid");
        if (customParams.get("isSsc") != null && "er_tripreqbill".equalsIgnoreCase(formId)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"triporiaccappamount"});
            this.setControlEnable(false);
        } else if (customParams.get("isSsc") != null && "er_tripreimbursebill".equalsIgnoreCase(formId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"triporiaccappamount"});
            this.setControlEnable(false);
        } else {
            boolean isEnable = (Boolean)customParams.get("isEnable");
            this.getView().setVisible(Boolean.valueOf(!isEnable), new String[]{"triporiaccappamount"});
            this.setControlEnable(true);
        }
        Boolean isQueryBudget = (Boolean)customParams.get("isquerybudget");
        String budgeMsgValue = (String)ErCommonUtils.getEMParameter((long)companyId, (String)"budgeMsgControl");
        BudgetCommonUtil.setIsQueryBudgetFlag(this.getPageCache(), isQueryBudget);
        if (isQueryBudget != null && isQueryBudget.booleanValue() || BudgetCommonUtil.getIsQueryEASBudgetFlag(this.getPageCache())) {
            BudgetCommonUtil.setBudgeInfoVisible(budgeMsgValue, this.getView());
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"budgetamount"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"budgetmsg"});
        }
    }

    private void setControlEnable(Boolean isSsc) {
        this.getView().setEnable(isSsc, new String[]{"from"});
        this.getView().setEnable(isSsc, new String[]{"to"});
        this.getView().setEnable(isSsc, new String[]{"tirpdate"});
        this.getView().setEnable(isSsc, new String[]{"vehicle"});
        this.getView().setEnable(isSsc, new String[]{"tripcurrency"});
        this.getView().setEnable(isSsc, new String[]{"tripexchangerate"});
        this.getView().setEnable(isSsc, new String[]{"triporiamount"});
    }

    private Boolean isShowExpenseItem() {
        IDataModel model = this.getModel();
        String formId = (String)model.getValue("formid");
        Boolean isLoan = (Boolean)model.getValue("isloan");
        Boolean istravelers = (Boolean)model.getValue("istravelers");
        if (ErEntityTypeUtils.isTripReqBill((String)formId) && isLoan != false || ErEntityTypeUtils.isTripReqBill((String)formId) && isLoan == false && istravelers != false || BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache()) || BudgetCommonUtil.getIsQueryEASBudgetFlag(this.getPageCache()) || BudgetCommonUtil.getIsTripReqShowExpenseitemFlag(this.getPageCache()) || ErEntityTypeUtils.isTripReimburseBill((String)formId)) {
            return true;
        }
        return false;
    }

    public void click(EventObject evt) {
        super.click(evt);
        IDataModel model = this.getModel();
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                String error;
                BigDecimal tripOriAmount;
                BigDecimal triporiaccappamount;
                IFormView parentView = this.getView().getParentView();
                IDataModel parentModel = parentView.getModel();
                String formId = (String)parentModel.getValue("formid");
                if (ErEntityTypeUtils.isTripReqBill((String)formId) && this.amountIsZero()) {
                    String tripamountctrltype;
                    boolean isloan = (Boolean)model.getValue("isloan");
                    Object type = model.getValue("triporiamouctrltype");
                    String string = tripamountctrltype = type == null ? "" : type.toString();
                    if (isloan && ("2".equals(tripamountctrltype) || "3".equals(tripamountctrltype))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u7a0b\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"TripEntryEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                if (ErEntityTypeUtils.isTripReqBill((String)formId) && (triporiaccappamount = (BigDecimal)model.getValue("triporiaccappamount")).compareTo(tripOriAmount = (BigDecimal)model.getValue("triporiamount")) > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u5b9a\u91d1\u989d\u4e0d\u5141\u8bb8\u8d85\u8fc7\u501f\u6b3e\u91d1\u989d\u3002", (String)"TripEntryEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                String billName = parentModel.getDataEntity().getDataEntityType().getName();
                boolean isTripReimburse = ErEntityTypeUtils.isTripReimburseBill((String)billName);
                boolean tripdatecontrol = SystemParamterUtil.isOpenTripDateControl((Long)ErCommonUtils.getPk((Object)parentModel.getValue("company")));
                if ((!((Boolean)parentModel.getValue("istravelers")).booleanValue() && !isTripReimburse || !((Boolean)parentModel.getValue("istravelers")).booleanValue() && isTripReimburse && tripdatecontrol) && StringUtils.isNotBlank((String)(error = this.validateTripDate(parentModel)))) {
                    this.getView().showErrorNotification(error);
                    return;
                }
                Object from = model.getValue("from");
                Object to = model.getValue("to");
                String cityMS = "";
                if (from.equals(to)) {
                    cityMS = ResManager.loadKDString((String)"\u51fa\u53d1\u5730\u4e0e\u76ee\u7684\u5730\u76f8\u540c\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"TripEntryEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
                }
                String currencyMs = "";
                int tripEntryRowIndex = Integer.parseInt(this.getPageCache().get(TRIP_ENTRY_ROW_INDEX));
                if (tripEntryRowIndex == 0 || parentModel.getEntryRowCount("tripentry") == 0) {
                    Object costCompany = model.getValue("entrycostcompany");
                    Object company = parentModel.getValue("company");
                    Long newCurrency = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)company, (Object)costCompany);
                    Long oldCurrency = ErCommonUtils.getPk((Object)parentModel.getValue("currency"));
                    if (newCurrency == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u672c\u4f4d\u5e01\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"TripEntryEdit_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (!newCurrency.equals(oldCurrency)) {
                        currencyMs = ResManager.loadKDString((String)"\u5207\u6362\u8d39\u7528\u627f\u62c5\u516c\u53f8\u5bfc\u81f4\u672c\u4f4d\u5e01\u53d8\u5316\uff0c\u5c06\u6e05\u7a7a\u586b\u5199\u5206\u5f55\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TripEntryEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]);
                    }
                }
                if (StringUtils.isNotBlank((String)cityMS) || StringUtils.isNotBlank((String)currencyMs)) {
                    String callBackId = "samecity";
                    if (StringUtils.isNotBlank((String)currencyMs)) {
                        callBackId = "changecurrency";
                    }
                    this.getView().showConfirm(cityMS + "\r\n" + currencyMs, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
                    return;
                }
                this.clickOk(model, parentView, parentModel, formId);
            }
        }
    }

    private boolean amountIsZero() {
        BigDecimal triporiamount = (BigDecimal)this.getModel().getValue("triporiamount");
        BigDecimal tripAmount = (BigDecimal)this.getModel().getValue("tripamount");
        return tripAmount.compareTo(BigDecimal.ZERO) <= 0 || triporiamount.compareTo(BigDecimal.ZERO) <= 0;
    }

    protected String validateTripDate(IDataModel parentModel) {
        DynamicObject nextTripEntry;
        DynamicObject lastTripEntry;
        DynamicObjectCollection parentTripEntry = parentModel.getEntryEntity("tripentry");
        int parentSize = parentTripEntry.size();
        TreeMap sortMap = new TreeMap();
        if (parentSize > 0) {
            parentTripEntry.forEach(entity -> {
                if (!sortMap.containsKey(entity.getInt("seq"))) {
                    sortMap.put(entity.getInt("seq") - 1, entity);
                }
            });
        }
        Date startDate = null;
        Date endDate = null;
        DynamicObject curTripEntry = this.getModel().getDataEntity();
        int index = Integer.parseInt(this.getPageCache().get(TRIP_ENTRY_ROW_INDEX));
        if (index == -1) {
            index = parentSize;
        }
        if ((lastTripEntry = (DynamicObject)sortMap.get(index - 1)) != null) {
            startDate = curTripEntry.getDate("startdate");
            endDate = lastTripEntry.getDate("enddate");
            if (startDate != null && endDate != null && startDate.before(endDate)) {
                return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u7a0b\u884c\u7a0b\u671f\u95f4\u4e0d\u80fd\u65e9\u4e8e\u7b2c%2$s\u7a0b\u884c\u7a0b\u671f\u95f4\u3002", (String)"TripEntryEdit_9", (String)"fi-er-formplugin", (Object[])new Object[0]), index + 1, index);
            }
        }
        if ((nextTripEntry = (DynamicObject)sortMap.get(index + 1)) != null) {
            endDate = curTripEntry.getDate("enddate");
            startDate = nextTripEntry.getDate("startdate");
            if (startDate != null && endDate != null && startDate.before(endDate)) {
                return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u7a0b\u884c\u7a0b\u671f\u95f4\u4e0d\u80fd\u665a\u4e8e\u7b2c%2$s\u7a0b\u884c\u7a0b\u671f\u95f4\u3002", (String)"TripEntryEdit_10", (String)"fi-er-formplugin", (Object[])new Object[0]), index + 1, index + 2);
            }
        }
        return null;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        String formId = (String)parentModel.getValue("formid");
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.clickOk(this.getModel(), parentView, parentModel, formId);
        }
    }

    protected void clickOk(IDataModel model, IFormView parentView, IDataModel parentModel, String formId) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_OK});
        DataEntityPropertyCollection tripEntryProps = parentModel.getDataEntity(true).getDynamicObjectCollection("tripentry").getDynamicObjectType().getProperties();
        int tripEntryRowIndex = Integer.parseInt(this.getPageCache().get(TRIP_ENTRY_ROW_INDEX));
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        HashMap<String, Object> returnParam = new HashMap<String, Object>();
        DynamicObjectCollection tripEntry = parentModel.getDataEntity().getDynamicObjectCollection("tripentry");
        Long oldCurrncy = ErCommonUtils.getPk((Object)parentModel.getValue("currency"));
        IDataEntityProperty tripamount = (IDataEntityProperty)properties.get((Object)"tripamount");
        IDataEntityProperty triporiamount = (IDataEntityProperty)properties.get((Object)"triporiamount");
        if (tripamount != null && triporiamount != null) {
            IDataEntityProperty first = (IDataEntityProperty)properties.get(0);
            IDataEntityProperty second = (IDataEntityProperty)properties.get(1);
            int tripamountIndex = properties.indexOf((Object)tripamount);
            int triporiamountIndex = properties.indexOf((Object)triporiamount);
            properties.set(0, (Object)tripamount);
            properties.set(1, (Object)triporiamount);
            properties.set(tripamountIndex, (Object)first);
            properties.set(triporiamountIndex, (Object)second);
        }
        if (tripEntryRowIndex == -1) {
            if (StringUtils.isNotEmpty((String)formId)) {
                int flag = ErCommonUtils.getExpenseAssumeShowTypes((long)ErCommonUtils.getPk((Object)parentModel.getValue("company")));
                if (flag != 1 && parentModel.getDataEntity(true).getDynamicObjectCollection("tripentry").isEmpty()) {
                    parentModel.beginInit();
                    parentModel.setValue("costdept", model.getValue("entrycostdept"));
                    parentModel.endInit();
                    parentModel.setValue("costcompany", model.getValue("entrycostcompany"));
                    this.getView().getParentView().updateView("costdept");
                    if (oldCurrncy.longValue() != ErCommonUtils.getPk((Object)parentModel.getValue("currency")).longValue()) {
                        parentView.updateView();
                        this.getView().sendFormAction(parentView);
                        this.getView().close();
                        return;
                    }
                    if (!((Boolean)parentModel.getValue("iscurrency")).booleanValue()) {
                        model.setValue("tripcurrency", parentModel.getValue("currency"));
                    }
                }
                int rowIndex = parentModel.createNewEntryRow("tripentry");
                parentModel.setEntryCurrentRowIndex("tripentry", rowIndex);
                for (IDataEntityProperty property : properties) {
                    String propertyName;
                    if (tripEntry.size() <= 0 || tripEntryProps.get((Object)(propertyName = property.getName())) == null) continue;
                    if ("vehicles".equalsIgnoreCase(propertyName) && ErEntityTypeUtils.isTripReimburseBill((String)formId)) {
                        String vehicles = (String)model.getValue(propertyName);
                        CoreBaseBillServiceHelper.mulTripVehicle((IDataModel)parentModel, (String)vehicles, (int)rowIndex);
                    }
                    if ("tripexchangerate".equals(propertyName) && properties.containsKey((Object)"tripcurrency")) {
                        parentModel.setValue("tripcurrency", ErCommonUtils.getObjectValue((Object)model.getValue("tripcurrency")), rowIndex);
                    }
                    parentModel.setValue(propertyName, ErCommonUtils.getObjectValue((Object)model.getValue(propertyName)), rowIndex);
                }
                if (tripEntry.size() > 0 && ErEntityTypeUtils.isTripReimburseBill((String)formId)) {
                    CoreBaseBillServiceHelper.addDefaultTripExpenseEntry((IDataModel)parentModel, (int)rowIndex);
                    this.setExpenseEntryValue(parentModel, model, rowIndex);
                }
                returnParam.put("currentTripEntryIndex", rowIndex);
            }
            returnParam.put("isUpdate", false);
        } else if (parentModel.getEntryEntity("tripentry").size() > 0) {
            if (tripEntryRowIndex == 0) {
                parentModel.beginInit();
                parentModel.setValue("costdept", model.getValue("entrycostdept"));
                parentModel.endInit();
                Object std_entrycostcenter = model.getValue("std_entrycostcenter");
                if (std_entrycostcenter != null) {
                    parentModel.setValue("std_costcenter", std_entrycostcenter);
                }
                parentModel.setValue("costcompany", model.getValue("entrycostcompany"));
                this.getView().getParentView().updateView("costdept");
                if (oldCurrncy.longValue() != ErCommonUtils.getPk((Object)parentModel.getValue("currency")).longValue()) {
                    parentView.updateView();
                    this.getView().sendFormAction(parentView);
                    this.getView().close();
                    return;
                }
            }
            for (IDataEntityProperty property : properties) {
                String propertyName = property.getName();
                if (parentModel.getEntryEntity("tripentry").size() <= 0 || tripEntryProps.get((Object)propertyName) == null) continue;
                if ("tripexchangerate".equals(propertyName) && properties.containsKey((Object)"tripcurrency")) {
                    parentModel.setValue("tripcurrency", ErCommonUtils.getObjectValue((Object)model.getValue("tripcurrency")), tripEntryRowIndex);
                }
                parentModel.setValue(propertyName, ErCommonUtils.getObjectValue((Object)model.getValue(propertyName)), tripEntryRowIndex);
            }
            if (ErEntityTypeUtils.isTripReimburseBill((String)formId) && parentModel.getEntryEntity("tripentry").size() > 0) {
                this.setExpenseEntryValue(parentModel, model, tripEntryRowIndex);
            }
            if (parentModel.getEntryEntity("tripentry").size() > 0) {
                int entrySize = parentModel.getEntryRowCount("entryentity");
                int tripDay = (Integer)parentModel.getValue("tripday", tripEntryRowIndex);
                for (int i = 0; i < entrySize; ++i) {
                    parentModel.setValue("daycount", (Object)tripDay, i, parentModel.getEntryCurrentRowIndex("tripentry"));
                }
                returnParam.put("isUpdate", true);
                returnParam.put("currentTripEntryIndex", parentModel.getEntryCurrentRowIndex("tripentry"));
            }
        }
        returnParam.put("isOK", true);
        returnParam.put("startDate", model.getValue("startDate"));
        returnParam.put("endDate", model.getValue("endDate"));
        this.getView().returnDataToParent(returnParam);
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }

    private void setExpenseEntryValue(IDataModel parentModel, IDataModel dataModel, int rowIndex) {
        DynamicObject tripEntry = parentModel.getEntryRowEntity("tripentry", rowIndex);
        int tripDay = tripEntry.getInt("tripday");
        DynamicObjectCollection tripTravlers = tripEntry.getDynamicObjectCollection("travelers");
        parentModel.setValue("tripentryarea", (Object)ErCommonUtils.getPk((Object)dataModel.getValue("triparea")), rowIndex);
        DynamicObjectCollection expenseEntry = tripEntry.getDynamicObjectCollection("entryentity");
        if (expenseEntry != null && !expenseEntry.isEmpty()) {
            for (int i = 0; i < expenseEntry.size(); ++i) {
                parentModel.setValue("triparea", (Object)ErCommonUtils.getPk((Object)dataModel.getValue("tripArea")), i, rowIndex);
                parentModel.setValue("daycount", (Object)tripDay, i, rowIndex);
                if (SettlementTypeEnum.MONTH_SETTLEMENT.getCode().equals(parentModel.getValue("settlementtype", i, rowIndex))) continue;
                parentModel.setValue("trip2travelers", (Object)tripTravlers, i, rowIndex);
                parentModel.setValue("trip2travelerscount", (Object)(tripTravlers == null ? 0 : tripTravlers.size()), i, rowIndex);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        switch (propName) {
            case "tripcurrency": {
                if (propValue == null) {
                    model.setValue("tripcurrency", (Object)ErCommonUtils.getPk((Object)valueSet[0].getOldValue()));
                }
                this.showExchangeRate(true);
                BigDecimal tripEntryAmount = (BigDecimal)this.getModel().getValue("triporiamount");
                this.getModel().setValue("triporiamount", (Object)BigDecimal.ZERO);
                this.getModel().setValue("triporiamount", (Object)tripEntryAmount);
                break;
            }
            case "triporiamount": {
                String quoteType = this.getModel().getProperty("tripquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)this.getModel().getValue("tripquotetype")), (Object)"0");
                BigDecimal tripOriAmount = (BigDecimal)propValue;
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)model.getValue("tripexchangerate")), (Object)BigDecimal.ONE);
                int currencyPrecision = AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency");
                BigDecimal tripAmount = AmountUtils.getCurrencyAmount((BigDecimal)tripOriAmount, (BigDecimal)exchangeRate, (int)currencyPrecision, (String)quoteType);
                model.setValue("tripamount", (Object)tripAmount);
                model.setValue("triporiaccappamount", (Object)tripOriAmount);
                model.setValue("tripaccappamount", (Object)tripAmount);
                break;
            }
            case "triporiaccappamount": {
                String quoteType = this.getModel().getProperty("tripquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)this.getModel().getValue("tripquotetype")), (Object)"0");
                BigDecimal triporiaccappamount = (BigDecimal)propValue;
                BigDecimal triporiamount = (BigDecimal)model.getValue("triporiamount");
                if (triporiaccappamount.compareTo(triporiamount) > 0) {
                    triporiaccappamount = triporiamount;
                    model.setValue("triporiaccappamount", (Object)triporiaccappamount);
                }
                int currencyPrecision = AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency");
                BigDecimal changeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)model.getValue("tripexchangerate")), (Object)BigDecimal.ONE);
                if (changeRate == null) {
                    changeRate = BigDecimal.ONE;
                }
                BigDecimal tripaccappamount = AmountUtils.getCurrencyAmount((BigDecimal)triporiaccappamount, (BigDecimal)changeRate, (int)currencyPrecision, (String)quoteType);
                model.setValue("tripaccappamount", (Object)tripaccappamount);
                break;
            }
            case "tripexchangerate": {
                String quoteType = this.getModel().getProperty("tripquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)this.getModel().getValue("tripquotetype")), (Object)"0");
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)propValue), (Object)BigDecimal.ONE);
                BigDecimal tripOriAmount = (BigDecimal)model.getValue("triporiamount");
                BigDecimal triporiaccappamount = (BigDecimal)model.getValue("triporiaccappamount");
                int currencyPrecision = AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency");
                BigDecimal tripAmount = AmountUtils.getCurrencyAmount((BigDecimal)tripOriAmount, (BigDecimal)exchangeRate, (int)currencyPrecision, (String)quoteType);
                BigDecimal tripaccappamount = AmountUtils.getCurrencyAmount((BigDecimal)triporiaccappamount, (BigDecimal)exchangeRate, (int)currencyPrecision, (String)quoteType);
                model.setValue("tripamount", (Object)tripAmount);
                model.setValue("tripaccappamount", (Object)tripaccappamount);
                break;
            }
            case "startdate": {
                Date startDate = (Date)propValue;
                Date endDate = (Date)model.getValue("enddate");
                Long tripDays = CommonServiceHelper.calcDays((Date)startDate, (Date)endDate);
                model.setValue("tripday", (Object)tripDays);
                if (startDate == null || model.getValue("triphappendate") != null) break;
                model.setValue("triphappendate", (Object)startDate);
                break;
            }
            case "enddate": {
                Date endDate = (Date)propValue;
                Date startDate = (Date)model.getValue("startdate");
                Long tripDays = CommonServiceHelper.calcDays((Date)startDate, (Date)endDate);
                model.setValue("tripday", (Object)tripDays);
                break;
            }
            case "to": {
                DynamicObject to = (DynamicObject)propValue;
                if (to == null) break;
                IDataModel parentModel = this.getView().getParentView().getModel();
                DynamicObject company = (DynamicObject)parentModel.getValue("company");
                Long toCityId = (Long)to.getPkValue();
                Long companyId = (Long)company.getPkValue();
                MainEntityType dataEntityType = model.getDataEntityType();
                String orgProp = ((BasedataProp)dataEntityType.getProperty("triparea")).getOrgProp();
                ErCommonUtils.getPk((Object)parentModel.getValue(orgProp));
                ErTripStdServiceImp stdService = new ErTripStdServiceImp();
                DynamicObject tripArea = stdService.getTripAreaByCityIdAndCompanyId(toCityId, ErCommonUtils.getPk((Object)parentModel.getValue(orgProp)));
                if (tripArea != null) {
                    model.setValue("triparea", tripArea.getPkValue());
                    break;
                }
                model.setValue("triparea", null);
                break;
            }
            case "entrycostdept": {
                String costDeptShowType;
                if (propValue == null) {
                    propValue = valueSet[0].getOldValue();
                    this.getModel().setValue("entrycostdept", (Object)ErCommonUtils.getPk((Object)propValue));
                }
                if (!StringUtils.equals((String)"3", (String)(costDeptShowType = CommonServiceHelper.getBillCostOrgShowType((IFormView)this.getView())))) {
                    this.costDeptChange((DynamicObject)propValue);
                }
                DynamicObject expenseItem = (DynamicObject)model.getValue("tripexpenseitem");
                log.info("\u5f53\u524d costDeptShowType" + costDeptShowType);
                log.info("\u5f53\u524d getPageCache" + BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache()));
                if (expenseItem != null && "2".equals(costDeptShowType) && BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache())) {
                    BudgetCommonUtil.buildBudgetAmountField(this.getView(), 0);
                }
                this.checkExpenseItem(propValue, model);
                break;
            }
            case "entrycostcompany": {
                if (propValue != null || valueSet[0].getOldValue() == null) break;
                this.getModel().setValue("entrycostcompany", valueSet[0].getOldValue());
                break;
            }
            case "tripexpenseitem": {
                if (!BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache()) || propValue == null) break;
                BudgetCommonUtil.buildBudgetAmountField(this.getView(), 0);
                break;
            }
            case "std_project": {
                if (!BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache())) break;
                BudgetCommonUtil.buildBudgetAmountField(this.getView(), 0);
                break;
            }
            case "vehicle": {
                if (!this.getVihicleFromStdConfig()) break;
                this.getModel().setValue("vehicles", propValue);
                break;
            }
            case "std_entrycostcenter": {
                if (propValue == null || propValue == "") break;
                ErCostCenterUtil.costCenterChangeForTripEdit((IFormView)this.getView(), (Object)propValue);
            }
        }
    }

    protected void checkExpenseItem(Object propValue, IDataModel model) {
        if (propValue != null) {
            Set exceptRelExpItems = ExpenseItemServiceHelper.getNotRelOrgExpItemIds((Long)((Long)((DynamicObject)propValue).getPkValue()));
            DynamicObject tripExpenseItem = (DynamicObject)this.getModel().getValue("tripexpenseitem");
            if (tripExpenseItem != null && exceptRelExpItems.contains(tripExpenseItem.getLong("id"))) {
                model.setValue("tripexpenseitem", null);
            }
        }
    }

    protected void costDeptChange(DynamicObject entryCostDept) {
        if (entryCostDept == null) {
            return;
        }
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        DynamicObject costCompany = (DynamicObject)this.getModel().getValue("entrycostcompany");
        CostDeptF7ChangePram costDeptF7ChangePram = new CostDeptF7ChangePram(Boolean.TRUE, (Object)entryCostDept, (Object)costCompany, (Object)company);
        Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((CostDeptF7ChangePram)costDeptF7ChangePram);
        this.getModel().setValue("entrycostcompany", (Object)costCompanyId);
    }

    private void showExchangeRate(boolean refreshExchangeRate) {
        IDataModel model = this.getModel();
        IDataModel parentModel = this.getView().getParentView().getModel();
        DynamicObject tripCurrency = (DynamicObject)model.getValue("tripcurrency");
        DynamicObject currency = (DynamicObject)parentModel.getValue("currency");
        boolean showExchangeRate = tripCurrency != null && currency != null && !tripCurrency.getPkValue().equals(currency.getPkValue());
        this.getView().setVisible(Boolean.valueOf(showExchangeRate), new String[]{"tripexchangerate", "tripamount"});
        String quoteType = "0";
        if (refreshExchangeRate) {
            BigDecimal exchangeRate = BigDecimal.ONE;
            if (tripCurrency != null && currency != null) {
                long sourceCurrencyId = tripCurrency.getLong("id");
                long targetCurrencyId = currency.getLong("id");
                long companyId = (Long)parentModel.getValue("company_Id");
                Map exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams((Object)companyId, (Object)parentModel.getValue("costcompany"), (Long)sourceCurrencyId, (Long)targetCurrencyId, (Object)model);
                quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateAndQuoteType.get("quoteType")), (Object)"0");
                exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateAndQuoteType.get("exchangeRate")), (Object)BigDecimal.ONE);
            }
            if (this.getModel().getProperty("tripquotetype") != null) {
                this.getModel().setValue("tripquotetype", (Object)quoteType);
            }
            this.getModel().setValue("tripexchangerate", (Object)exchangeRate);
        }
    }

    private void setTripDateControl() {
        IDataModel pModel = this.getView().getParentView().getModel();
        DateRangeEdit tripDate = (DateRangeEdit)this.getControl("tirpdate");
        String entryName = pModel.getDataEntityType().getName();
        LocalDate now = LocalDate.now();
        Long companyId = ErCommonUtils.getPk((Object)pModel.getValue("company"));
        if (ErEntityTypeUtils.isTripReqBill((String)entryName) && StringUtils.equals((String)"1", (String)ErCommonUtils.getTripDateSelectRange((Long)companyId))) {
            tripDate.setMinDate(ErCommonUtils.getDateFromLocalDate((LocalDate)now));
            return;
        }
        if (ErEntityTypeUtils.isTripReimburseBill((String)entryName) && StringUtils.equals((String)"0", (String)SystemParamterUtil.getTripReimDateSelectRange((Long)companyId))) {
            tripDate.setMaxDate(ErCommonUtils.getDateFromLocalDate((LocalDate)now));
        }
        if (pModel.getProperty("isopentripstd") == null) {
            return;
        }
        Object company = pModel.getValue("company");
        if (((Boolean)pModel.getValue("istravelers")).booleanValue() && !((Boolean)pModel.getValue("travelerssamestd")).booleanValue() || !SystemParamterUtil.isOpenTripDateControl((Long)ErCommonUtils.getPk((Object)company)) || !((Boolean)pModel.getValue("isopentripstd")).booleanValue() || pModel.getEntryRowCount("tripentry") == 0) {
            return;
        }
        int currentIndex = Integer.parseInt(this.getPageCache().get(TRIP_ENTRY_ROW_INDEX));
        currentIndex = currentIndex == -1 ? pModel.getEntryRowCount("tripentry") - 1 : currentIndex - 1;
        DynamicObjectCollection tripEntry = pModel.getDataEntity(true).getDynamicObjectCollection("tripentry");
        if (currentIndex < 0 || tripEntry.size() == 0) {
            return;
        }
        DynamicObject preRow = (DynamicObject)tripEntry.get(currentIndex);
        Date minDate = preRow.getDate("enddate");
        tripDate.setMinDate(minDate);
    }
}

