/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.servicehelper.TripReimburseServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AttachmentCountUtils;
import kd.fi.er.business.utils.CalculateTripSumUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.UnRepaymentAmountUtil;
import kd.fi.er.business.utils.model.ChangeField;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeExpenseItemF7SelectListener;
import kd.fi.er.formplugin.util.OffsetUtils;
import kd.fi.er.formplugin.web.ErTripReimAutoWriteDescription;
import kd.fi.er.formplugin.web.TripBaseBillEdit;
import kd.fi.er.model.FormModel;
import kd.sdk.fi.er.extpoint.dailyreimbursebill.ISuperClosedCallBack;
import org.apache.commons.lang.StringUtils;

public class TripReimburseBillEdit
extends TripBaseBillEdit
implements UploadListener {
    private static Log logger = LogFactory.getLog(TripReimburseBillEdit.class);
    public static final String ADD_EXPENSE = "addexpense";
    public static final String UPDATE_EXPENSE = "updateexpense";
    public static final String EXPENSE_ENTRY_FLEX = "expenseentryflex";
    public static final String TRIPITEM_TIPS_CARD = "tripitemtipscard";
    public static final String TRIPITEM_TIPS_LABEL = "trip_expense_tips";
    private boolean loanClearFlag = true;
    private static String[] afterApproveStatus = new String[]{ErBillStatusEnum.E.toString(), ErBillStatusEnum.F.toString(), ErBillStatusEnum.G.toString(), ErBillStatusEnum.H.toString(), ErBillStatusEnum.I.toString()};
    private static String[] orderType = new String[]{"er_planebill", "er_trainbill", "er_vehiclebill", "er_hotelbill"};
    private static final Map<String, String> tripReimTypeByFormId = new HashMap<String, String>(16);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADD_EXPENSE, UPDATE_EXPENSE, TRIPITEM_TIPS_CARD, TRIPITEM_TIPS_LABEL});
        BasedataEdit entrycurrencyF7 = (BasedataEdit)this.getControl("entrycurrency");
        if (entrycurrencyF7 != null) {
            entrycurrencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.setMultiSelect(Boolean.FALSE.booleanValue());
            });
        }
        BasedataEdit accountcurrencyF7 = (BasedataEdit)this.getControl("accountcurrency");
        accountcurrencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setMultiSelect(Boolean.FALSE.booleanValue());
        });
        BasedataEdit costDeptF7 = (BasedataEdit)this.getControl("costdept");
        costDeptF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setMultiSelect(Boolean.FALSE.booleanValue());
        });
        EntryGrid accountentry = (EntryGrid)this.getControl("accountentry");
        accountentry.addRowClickListener((RowClickEventListener)this);
        String number = this.getModel().getDataEntityType().getName();
        BasedataEdit entryexpenseitemF7 = (BasedataEdit)this.getControl("entrytravelexpenseitem");
        if (null != entryexpenseitemF7) {
            entryexpenseitemF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeExpenseItemF7SelectListener(this.getView(), number, "entrycostdept"));
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        switch (entryName) {
            case "entryentity": {
                int curTripIndex = model.getEntryCurrentRowIndex("tripentry");
                CoreBaseBillServiceHelper.refreshEntryRowSeq((IDataModel)this.getModel(), (boolean)false, (int)curTripIndex);
                break;
            }
            case "accountentry": {
                RowDataEntity[] rowDataEntities;
                String isgetaccountcurrency = "0";
                if (this.getModel().getValue("company") != null) {
                    isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
                }
                boolean iscurrency = (Boolean)model.getValue("iscurrency");
                if (!"1".equals(isgetaccountcurrency) || !iscurrency) break;
                for (RowDataEntity row : rowDataEntities = e.getRowDataEntities()) {
                    int rowIndex = row.getRowIndex();
                    DynamicObject accountcurrency = (DynamicObject)model.getValue("accountcurrency");
                    model.beginInit();
                    model.setValue("accountcurrency", null, rowIndex);
                    model.endInit();
                    model.setValue("accountcurrency", (Object)accountcurrency, rowIndex);
                }
                break;
            }
        }
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.initAccountEntryInfo();
        IDataModel model = this.getModel();
        String billStatus = (String)model.getValue("billstatus");
        if (!ErBillStatusEnum.A.toString().equalsIgnoreCase(billStatus) && !ErBillStatusEnum.D.toString().equalsIgnoreCase(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"cardentryfixrowap1"});
        }
        CommonServiceHelper.getDeductibleTaxShowType((IDataModel)model, (IFormView)this.getView());
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CommonServiceHelper.getDeductibleTaxShowType((IDataModel)this.getModel(), (IFormView)this.getView());
        IDataModel model = this.getModel();
        PublicBillUtil.showInvoiceEntry((IFormView)this.getView());
        Container advconap1 = (Container)this.getControl("advconap1");
        Boolean isloan = (Boolean)model.getValue("isloan");
        if (advconap1 != null && isloan.booleanValue()) {
            int entryRowCount = this.getModel().getEntryRowCount("clearloanentry");
            if (entryRowCount <= 0) {
                advconap1.setCollapse(true);
            } else {
                advconap1.setCollapse(false);
            }
        }
        IFormView view = this.getView();
        String billStatus = (String)model.getValue("billstatus");
        if (ErBillStatusEnum.A.toString().equals(billStatus) || ErBillStatusEnum.D.toString().equals(billStatus)) {
            DynamicObjectCollection tripEntrys = model.getEntryEntity("tripentry");
            boolean hideExpenseAdd = tripEntrys == null || tripEntrys.size() == 0;
            view.setVisible(Boolean.valueOf(!hideExpenseAdd), new String[]{EXPENSE_ENTRY_FLEX});
            view.setVisible(Boolean.valueOf(true), new String[]{"cardentryfixrowap3"});
            view.setVisible(Boolean.valueOf(true), new String[]{"cardentryfixrowap1"});
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"cardentryfixrowap1"});
        }
        DynamicObject company = (DynamicObject)model.getValue("company");
        int showType = 1;
        if (company != null) {
            showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
            boolean ischanged = model.getDataChanged();
            model.setValue("expensesassumeshowtypes", (Object)String.valueOf(showType));
            this.getView().updateView("expensesassumeshowtypes");
            String trippartneraccstdtype = (String)ErCommonUtils.getEMParameter((long)company.getLong("id"), (String)"trippartneraccstd");
            trippartneraccstdtype = StringUtils.isEmpty((String)trippartneraccstdtype) ? "max" : trippartneraccstdtype;
            model.setValue("trippartneraccstdtype", (Object)trippartneraccstdtype);
            model.setDataChanged(Boolean.FALSE.booleanValue());
        }
        if (ErBillStatusEnum.A.toString().equals(billStatus) || ErBillStatusEnum.D.toString().equals(billStatus)) {
            DynamicObject targetBill = model.getDataEntity();
            Long companyId = company == null ? Long.valueOf(0L) : (Long)company.getPkValue();
            boolean alterFlag = CoreBaseBillServiceHelper.isEnableAlterCostOrgInfoFromSrcBill((Long)companyId, (DynamicObject)targetBill);
            boolean ischanged = model.getDataChanged();
            model.setValue("enablealtercostbear", (Object)alterFlag);
            model.setDataChanged(Boolean.FALSE.booleanValue());
            if (showType == 1) {
                BasedataEdit costdept = (BasedataEdit)this.getControl("costdept");
                costdept.setMustInput(true);
                BasedataEdit costcompany = (BasedataEdit)this.getControl("costcompany");
                costcompany.setMustInput(true);
            }
        }
        int tripentryrows = this.getModel().getEntryRowCount("tripentry");
        EntryGrid tripentry = (EntryGrid)this.getControl("tripentry");
        if (tripentryrows > 0) {
            tripentry.selectRows(0);
        }
        this.initInvoiceExt();
        CoreBaseBillServiceHelper.setValueVhc((IDataModel)model);
        this.updateRelateCount();
        int currentTripIndex = this.getView().getModel().getEntryCurrentRowIndex("tripentry");
        CoreBaseBillServiceHelper.refreshEntryRowSeq((IDataModel)model, (boolean)true, (int)currentTripIndex);
        CoreBaseBillServiceHelper.refreshTrip2TravelersCount((IDataModel)model);
        TripReimburseServiceHelper.handleExpenseFieldDefaultValue((IDataModel)model);
        CalculateTripSumUtil.setTripSumLabel((IFormView)this.getView(), (int)currentTripIndex);
        PayeeServiceHelper.viewStorageLimits((IFormView)this.getView());
    }

    private void initInvoiceExt() {
        IDataModel model = this.getModel();
        model.beginInit();
        DynamicObjectCollection tripEntry = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
        for (int cardIndex = 0; cardIndex < tripEntry.size(); ++cardIndex) {
            DynamicObjectCollection entry = ((DynamicObject)tripEntry.get(cardIndex)).getDynamicObjectCollection("entryentity");
            for (int rowIndex = 0; rowIndex < entry.size(); ++rowIndex) {
                model.setValue("invoiceno_ext", this.getModel().getValue("invoiceno_entry", rowIndex, cardIndex), rowIndex, cardIndex);
            }
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    @Override
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName;
        super.afterDeleteRow(e);
        IDataModel model = this.getModel();
        switch (entryName = e.getEntryProp().getName()) {
            case "entryentity": {
                TripReimburseServiceHelper.updateTripEntryAmount((IDataModel)model);
                this.refreshAccCurrency(this.getModel(), this.getTripEntryCurrencyCount());
                this.loanClearFlag = false;
                int currentTripIndex = model.getEntryCurrentRowIndex("tripentry");
                CoreBaseBillServiceHelper.refreshEntryRowSeq((IDataModel)model, (boolean)false, (int)currentTripIndex);
                CalculateTripSumUtil.calculate((DynamicObject)this.getModel().getDataEntity(true), (IFormView)this.getView());
                CalculateTripSumUtil.setTripSumLabel((IFormView)this.getView(), (int)this.getView().getModel().getEntryCurrentRowIndex("tripentry"));
                break;
            }
            case "tripentry": {
                this.refreshTotalAmount("tripentry", "tripamount", "amount");
                this.refreshAccCurrency(this.getModel(), this.getTripEntryCurrencyCount());
                this.loanClearFlag = false;
                int tripEntrySize = model.getEntryRowCount("tripentry");
                if (tripEntrySize == 0) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{EXPENSE_ENTRY_FLEX});
                }
                DynamicObjectCollection tripEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
                BigDecimal tripAmounts = tripEntries.stream().map(entry -> entry.getBigDecimal("tripamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal tripAppAmounts = tripEntries.stream().map(entry -> entry.getBigDecimal("tripappamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                this.refreshTripAmountLabel(tripAmounts, tripAppAmounts);
                if (!tripEntries.isEmpty()) break;
                this.getView().setEnable(Boolean.TRUE, new String[]{"iscurrency"});
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        IDataModel model = this.getModel();
        String entryName = e.getEntryProp().getName();
        this.getView().getFormShowParameter().getFormId();
        int[] rowIndexs = e.getRowIndexs();
        switch (entryName) {
            case "tripentry": 
            case "entryentity": {
                Object company = model.getValue("company");
                boolean allowDelete = false;
                DynamicObjectCollection tripEntry = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
                List planeOrders = Collections.emptyList();
                if (!SystemParamterUtil.getIsShowInvoiceEntry((long)ErCommonUtils.getPk((Object)company))) break;
                if (StringUtils.equals((String)"tripentry", (String)entryName)) {
                    planeOrders = new ArrayList(rowIndexs.length);
                    for (int index : rowIndexs) {
                        DynamicObjectCollection entry = ((DynamicObject)tripEntry.get(index)).getDynamicObjectCollection("entryentity");
                        for (DynamicObject entryRow : entry) {
                            DynamicObject expenseItem = (DynamicObject)entryRow.get("expenseitem");
                            if (expenseItem == null || !StringUtils.equals((String)"2", (String)expenseItem.getString("attribute")) || !StringUtils.isNotBlank((String)entryRow.getString("ordernum"))) continue;
                            planeOrders.add(entryRow.getString("ordernum"));
                        }
                    }
                } else if (StringUtils.equals((String)"entryentity", (String)entryName)) {
                    ArrayList<DynamicObject> deleteEntry = new ArrayList<DynamicObject>(1);
                    planeOrders = new LinkedList();
                    int curentTripRowIndex = model.getEntryCurrentRowIndex("tripentry");
                    DynamicObjectCollection entry = ((DynamicObject)tripEntry.get(curentTripRowIndex)).getDynamicObjectCollection("entryentity");
                    for (int index : rowIndexs) {
                        DynamicObject entryRow = (DynamicObject)entry.get(index);
                        deleteEntry.add(entryRow);
                        DynamicObject expenseItem = (DynamicObject)entryRow.get("expenseitem");
                        if (expenseItem == null || !StringUtils.equals((String)"2", (String)expenseItem.getString("attribute")) || !StringUtils.isNotBlank((String)entryRow.getString("ordernum"))) continue;
                        planeOrders.add(entryRow.getString("ordernum"));
                    }
                    allowDelete = deleteEntry.stream().allMatch(m -> !"2".equalsIgnoreCase(m.getString("settlementtype")) || m.getBoolean("pulltravelorder"));
                }
                if (planeOrders.isEmpty()) break;
                DynamicObjectCollection delOrders = QueryServiceHelper.query((String)"er_planebill", (String)"ticketnum, ordertype", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", planeOrders)});
                Map<String, List<DynamicObject>> map = delOrders.stream().filter(m -> StringUtils.isNotBlank((String)m.getString("ordertype"))).collect(Collectors.groupingBy(m -> m.getString("ordertype")));
                DynamicObjectCollection invoiceEntry = model.getDataEntity(true).getDynamicObjectCollection("invoiceentry");
                HashSet<Integer> deleteInvoice = new HashSet<Integer>(12);
                for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
                    List tickets = entry.getValue().stream().map(n -> n.getString("ticketnum")).collect(Collectors.toList());
                    for (int i = 0; i < invoiceEntry.size(); ++i) {
                        DynamicObject invoice = (DynamicObject)invoiceEntry.get(i);
                        if (!entry.getKey().equals(invoice.getString("ordertype")) || !tickets.contains(invoice.getString("invoiceno"))) continue;
                        deleteInvoice.add(i);
                    }
                }
                if (deleteInvoice.size() > 0) {
                    this.getView().getPageCache().put("allowdeleteinvoice", allowDelete || Boolean.parseBoolean(this.getView().getPageCache().get("allowdeleteinvoice")) ? "true" : "false");
                    model.deleteEntryRows("invoiceentry", deleteInvoice.stream().mapToInt(m -> m).toArray());
                }
                this.getView().getPageCache().remove("allowdeleteinvoice");
                break;
            }
            case "writeoffapply": {
                this.getView().getPageCache().put("allowdeleteinvoice", "true");
                CommonServiceHelper.tripReimburseDelWriteOffApply((IDataModel)this.getModel(), (IFormView)this.getView(), (int[])rowIndexs);
            }
        }
    }

    @Override
    public void click(EventObject e) {
        super.click(e);
        String key = ((Control)e.getSource()).getKey();
        IDataModel model = this.getModel();
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        switch (key) {
            case "addexpense": {
                FormModel formModel = new FormModel("er_chooseexpenseitem", ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee", (String)"TripReimburseBillEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]), "1", true);
                formModel.setShowType(ShowType.Floating);
                formModel.setTargetKey(ADD_EXPENSE);
                HashMap<String, Object> customParam = new HashMap<String, Object>();
                customParam.put("formid", model.getValue("formid"));
                if (company == null) {
                    logger.info(">>>>>\u7533\u8bf7\u4eba\u516c\u53f8\u5f02\u5e38\u4e86\u54e6");
                } else {
                    customParam.put("companyid", company.getLong("id"));
                }
                formModel.setCustomParam(customParam);
                ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
                break;
            }
            case "updateexpense": {
                ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"er_tripexpenseitem", (boolean)false);
                ArrayList listQF = Lists.newArrayList();
                if (company == null) {
                    logger.info(">>>>>\u7533\u8bf7\u4eba\u516c\u53f8\u5f02\u5e38\u4e86\u54e6");
                } else {
                    QFilter bdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripexpenseitem", (Long)((Long)company.getPkValue()));
                    listQF.add(bdFilter);
                }
                listShowParameter.setListFilterParameter(new ListFilterParameter((List)listQF, (String)null));
                listShowParameter.setShowUsed(true);
                listShowParameter.setShowApproved(true);
                List buildDataPermissionFilter = FilterUtil.buildDataPermissionFilter((String)"er_tripexpenseitem", (boolean)listShowParameter.isShowUsed(), (boolean)listShowParameter.isShowApproved());
                listShowParameter.getListFilterParameter().getQFilters().addAll(buildDataPermissionFilter);
                listShowParameter.setHasRight(true);
                listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_tripexpenseitem"));
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
            case "tripitemtipscard": 
            case "trip_expense_tips": {
                Button updateExpense = (Button)this.getControl(UPDATE_EXPENSE);
                updateExpense.click();
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object oldPropValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        int parentIndex = valueSet[0].getParentRowIndex();
        if (null != this.pageCache && null != this.pageCache.get("flag")) {
            this.flag = Boolean.parseBoolean(this.pageCache.get("flag"));
        }
        IDataModel model = this.getModel();
        switch (propName) {
            case "applier": {
                if (this.getModel().getEntryRowCount("clearloanentry") <= 0) break;
                model.deleteEntryData("clearloanentry");
                AmountChangeUtil.refreshPayAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (String)((String)this.getModel().getValue("loanchecktype")));
                break;
            }
            case "iscurrency": {
                this.entryCurrencyChange((Boolean)propValue);
                break;
            }
            case "offset": {
                this.offsetChange(valueSet);
                OffsetUtils.setInvoiceOffset((boolean)((Boolean)propValue), (DynamicObject)this.getModel().getDataEntity(true), (int)rowIndex, (int)parentIndex, (IDataModel)this.getModel(), (IFormView)this.getView());
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentIndex, (ChangeField)ChangeField.All);
                break;
            }
            case "deductibletax": {
                BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("taxamount", rowIndex, parentIndex);
                if (!OffsetUtils.checkDeductibletax((BigDecimal)taxAmount, (BigDecimal)((BigDecimal)propValue))) {
                    this.getModel().setValue("deductibletax", oldPropValue, rowIndex, parentIndex);
                    return;
                }
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentIndex, (ChangeField)ChangeField.DEDUCTIBLE_TAX);
                break;
            }
            case "itemreasonfortransferout": {
                OffsetUtils.updateInvoiceOutReason((int)valueSet[0].getRowIndex(), (int)parentIndex, (String)((String)valueSet[0].getNewValue()), (IFormView)this.getView());
                break;
            }
            case "itemnodeductionreason": {
                OffsetUtils.updateInvoiceNoDeductionReason((int)valueSet[0].getRowIndex(), (int)parentIndex, (String)((String)valueSet[0].getNewValue()), (IFormView)this.getView());
                break;
            }
            case "iteminoutamount": {
                InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)this.getView(), (int)rowIndex, (int)parentIndex);
                break;
            }
            case "company": {
                DynamicObject company = (DynamicObject)model.getValue("company");
                Long companyId = ErCommonUtils.getPk((Object)company);
                if (company != null) {
                    int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)companyId);
                    model.setValue("expensesassumeshowtypes", (Object)String.valueOf(showType));
                    if (showType == 1) {
                        BasedataEdit costdept = (BasedataEdit)this.getControl("costdept");
                        costdept.setMustInput(true);
                        BasedataEdit costcompany = (BasedataEdit)this.getControl("costcompany");
                        costcompany.setMustInput(true);
                    }
                    this.delTripItemByCompanyChange(model, valueSet, company, parentIndex);
                }
                boolean iscurrencyshowintripentry = !DailyBillServiceHelper.isNewTripReim((IDataModel)this.getModel()) && companyId != null && SystemParamterUtil.getIsCurrencyShowinTripentry((long)companyId);
                model.setValue("iscurrencyshowintripentry", (Object)iscurrencyshowintripentry);
                model.deleteEntryData("clearloanentry");
                AmountChangeUtil.refreshPayAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (String)((String)this.getModel().getValue("loanchecktype")));
                break;
            }
            case "org": {
                Long companyId = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
                String range = SystemParamterUtil.getLoanDrawRange((Long)companyId);
                if (!StringUtils.equals((String)range, (String)"2") || this.getModel().getEntryRowCount("clearloanentry") <= 0) break;
                model.deleteEntryData("clearloanentry");
                AmountChangeUtil.refreshPayAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (String)((String)this.getModel().getValue("loanchecktype")));
                break;
            }
            case "vehicles": {
                CoreBaseBillServiceHelper.refreshVehicleRelateEntry((IDataModel)this.getModel(), (String)((String)propValue), (int)rowIndex);
                CoreBaseBillServiceHelper.setValueVhc((IDataModel)model);
                break;
            }
            case "tripexpenseitem": 
            case "headexpenseitem": {
                Object description = this.getModel().getValue("description");
                logger.info("come in there 1 , description : " + description);
                if (description != null && !((String)description).isEmpty()) break;
                logger.info("come in there one , description : " + description);
                ErTripReimAutoWriteDescription.setDiscription(this.getView());
                break;
            }
            case "curprice": {
                CalculateTripSumUtil.calculateAppnotaxamount((IFormView)this.getView(), (int)parentIndex);
                CalculateTripSumUtil.setLabelTripappnottaxamount((IFormView)this.getView(), (int)this.getView().getModel().getEntryCurrentRowIndex("tripentry"));
                break;
            }
            case "tripdeductibletax": {
                CalculateTripSumUtil.setLabelTripdeductibletax((IFormView)this.getView(), (int)this.getView().getModel().getEntryCurrentRowIndex("tripentry"));
                break;
            }
            case "entryappamount": {
                CalculateTripSumUtil.calculate((DynamicObject)this.getModel().getDataEntity(true), (IFormView)this.getView());
                CalculateTripSumUtil.setTripSumLabel((IFormView)this.getView(), (int)this.getView().getModel().getEntryCurrentRowIndex("tripentry"));
                break;
            }
            case "invoiceno_ext": {
                this.getModel().setValue("invoiceno_entry", valueSet[0].getNewValue(), rowIndex, parentIndex);
                break;
            }
            case "costcompany": {
                PublicBillUtil.showInvoiceEntry((IFormView)this.getView());
                break;
            }
            case "automapinvoice": {
                PublicBillUtil.showInvoiceEntry((IFormView)this.getView());
                InvoiceUtils.toggleAutoMapInvoice((IFormView)this.getView(), (boolean)((Boolean)propValue));
            }
        }
    }

    private void offsetChange(ChangeData[] valueSet) {
        int parentRowIndex = valueSet[0].getParentRowIndex();
        DynamicObject tripentry = this.getModel().getEntryRowEntity("tripentry", parentRowIndex);
        if (tripentry != null) {
            DynamicObjectCollection dynamicObjectCollection = tripentry.getDynamicObjectCollection("entryentity");
            int offsetCount = 0;
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                boolean offset = dynamicObject.getBoolean("offset");
                if (!offset) continue;
                ++offsetCount;
            }
            tripentry.set("offset_trip", (Object)true);
            if (offsetCount != 0 && offsetCount == dynamicObjectCollection.size()) {
                tripentry.set("offset_trip", (Object)true);
            } else {
                tripentry.set("offset_trip", (Object)false);
            }
        }
    }

    private void entryCurrencyChange(boolean propValue) {
        IDataModel model = this.getModel();
        int entryRows = model.getEntryRowCount("entryentity");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (!propValue && currency != null) {
            DynamicObjectCollection entryEntity = model.getEntryEntity("tripentry");
            for (int i = 0; i < entryEntity.size(); ++i) {
                model.setValue("tripcurrency", currency.getPkValue(), i);
                DynamicObjectCollection entry = ((DynamicObject)entryEntity.get(i)).getDynamicObjectCollection("entryentity");
                for (int j = 0; j < entry.size(); ++j) {
                    model.setValue("entrycurrency", currency.getPkValue(), j, i);
                }
            }
        }
        int rowIndex = model.getEntryCurrentRowIndex("accountentry");
        DynamicObject accountCurrency = (DynamicObject)model.getValue("accountcurrency", rowIndex);
        this.isLockAccexchangeByAccCurrency(rowIndex, accountCurrency);
        EntryGrid control = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = control.getSelectRows();
        this.getView().updateView("entryentity");
        if (selectRows.length > 0) {
            control.selectRows(selectRows, selectRows[0]);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String billStatus;
        String key;
        IDataModel model = this.getModel();
        super.entryRowClick(evt);
        EntryGrid source = evt.getSource() instanceof EntryGrid ? (EntryGrid)evt.getSource() : null;
        String string = key = source == null ? "" : source.getKey();
        if ("tripentry".equals(key)) {
            CalculateTripSumUtil.setTripSumLabel((IFormView)this.getView(), (int)this.getView().getModel().getEntryCurrentRowIndex("tripentry"));
        }
        if (this.isArrayContainsThisStr(billStatus = (String)model.getValue("billstatus"), afterApproveStatus)) {
            model.setDataChanged(false);
            return;
        }
        switch (key) {
            case "tripentry": {
                this.getView().updateView("entryentity");
                break;
            }
            case "accountentry": {
                String focusField;
                switch (focusField = source == null ? "" : source.getEntryState().getFocusField()) {
                    case "accountcurrency": 
                    case "accexchangerate": 
                    case "orireceiveamount": {
                        this.flag = true;
                        this.pageCache.put("flag", String.valueOf(this.flag));
                    }
                }
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        IDataModel model = this.getModel();
        Object returndate = e.getReturnData();
        if ("er_tripexpenseitem".equals(actionId) || "er_chooseexpenseitem".equals(actionId)) {
            int rowIndex = 0;
            Long tripexpenseId = 0L;
            if (returndate instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection selectedRowColl = (ListSelectedRowCollection)returndate;
                ListSelectedRow listSelectedRow = selectedRowColl.get(0);
                rowIndex = model.getEntryCurrentRowIndex("entryentity");
                tripexpenseId = (Long)listSelectedRow.getPrimaryKeyValue();
            } else if (returndate instanceof Map) {
                Map returnData = (Map)returndate;
                rowIndex = model.createNewEntryRow("entryentity");
                tripexpenseId = (Long)returnData.get("tripexpenseId");
            } else {
                return;
            }
            int tripEntryIndex = model.getEntryCurrentRowIndex("tripentry");
            model.setValue("expenseitem", (Object)tripexpenseId, rowIndex, tripEntryIndex);
            DynamicObject company = (DynamicObject)model.getValue("company");
            Long companyId = ErCommonUtils.getPk((Object)company);
            boolean isCurrencyShowinTripentry = SystemParamterUtil.getIsCurrencyShowinTripentry((long)companyId);
            if (isCurrencyShowinTripentry) {
                DynamicObject tripcurrency = (DynamicObject)model.getValue("tripcurrency", tripEntryIndex);
                this.changeEntryCurrencyBusiness(model, rowIndex, tripEntryIndex, tripcurrency);
                model.setValue("entrycurrency", tripcurrency.getPkValue(), rowIndex, tripEntryIndex);
            } else if ("er_chooseexpenseitem".equals(actionId)) {
                model.setValue("entrycurrency", (Object)ErCommonUtils.getPk((Object)model.getValue("currency")), rowIndex, tripEntryIndex);
            }
            model.beginInit();
            DynamicObject tripEntry = model.getEntryRowEntity("tripentry", tripEntryIndex);
            DynamicObject tripEntryCostcompany = tripEntry.getDynamicObject("entrycostcompany");
            DynamicObject tripEntryCostdept = tripEntry.getDynamicObject("entrycostdept");
            Date tripEntryHappendate = tripEntry.getDate("triphappendate");
            DynamicObject tripEntryExpenseitem = tripEntry.getDynamicObject("tripexpenseitem");
            DynamicObject tripFrom = tripEntry.getDynamicObject("from");
            DynamicObject tripTo = tripEntry.getDynamicObject("to");
            model.setValue("travelcostcompany", (Object)tripEntryCostcompany, rowIndex, tripEntryIndex);
            model.setValue("travelcostdept", (Object)tripEntryCostdept, rowIndex, tripEntryIndex);
            model.setValue("travelhappendate", (Object)tripEntryHappendate, rowIndex, tripEntryIndex);
            model.setValue("travelexpenseitem", (Object)tripEntryExpenseitem, rowIndex, tripEntryIndex);
            Long quotaDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)tripEntryExpenseitem, (DynamicObject)tripEntryCostdept, (IDataModel)model);
            model.setValue("travelquotactldept", (Object)quotaDeptId, rowIndex, tripEntryIndex);
            model.setValue("trip2from", (Object)tripFrom, rowIndex, tripEntryIndex);
            model.setValue("trip2to", (Object)tripTo, rowIndex, tripEntryIndex);
            model.endInit();
        } else if (this.getTripEntryEditForm().equals(actionId)) {
            PluginProxy pluginProxy = PluginProxy.create(null, ISuperClosedCallBack.class, (String)"FI_ER_SUPERCLOSEDCALLBACK", null);
            AtomicBoolean execute = new AtomicBoolean(true);
            pluginProxy.callReplace(p -> {
                execute.set(p.beforeClosedCallBack(TripReimburseBillEdit.class, this.getTripEntryEditForm(), Boolean.TRUE, new Object[]{this.getView(), returndate}));
                return null;
            });
            if (execute.get() && returndate != null) {
                this.tripentryEditCloseCallBack(e, model);
            }
            pluginProxy.callReplace(p -> {
                p.afterClosedCallBack(TripReimburseBillEdit.class, this.getTripEntryEditForm(), Boolean.TRUE, new Object[]{this.getView(), returndate});
                return null;
            });
        }
    }

    private void changeEntryCurrencyBusiness(IDataModel model, int rowIndex, int tripEntryIndex, DynamicObject tripcurrency) {
        DynamicObject currency;
        boolean isCurModelcurrency = (Boolean)model.getValue("iscurrency");
        if (isCurModelcurrency && (currency = (DynamicObject)model.getValue("currency")) != null && currency.getPkValue() != null && tripcurrency != null && tripcurrency.getPkValue() != null) {
            Object defaultEntryCurrencyPK;
            DynamicObject defaultEntryCurrency;
            Object currencyPK = currency.getPkValue();
            Object tripCurrencyPk = tripcurrency.getPkValue();
            if (!StringUtils.equals((String)currencyPK.toString(), (String)tripCurrencyPk.toString()) && (defaultEntryCurrency = (DynamicObject)model.getValue("entrycurrency", rowIndex, tripEntryIndex)) != null && StringUtils.equals((String)(defaultEntryCurrencyPK = defaultEntryCurrency.getPkValue()).toString(), (String)tripCurrencyPk.toString())) {
                model.beginInit();
                model.setValue("entrycurrency", currency.getPkValue(), rowIndex, tripEntryIndex);
                model.endInit();
            }
        }
    }

    protected void tripentryEditCloseCallBack(ClosedCallBackEvent e, IDataModel model) {
        int tripIndex;
        DynamicObject trip;
        int tripentryRowCount = model.getEntryRowCount("tripentry");
        if (tripentryRowCount > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{EXPENSE_ENTRY_FLEX});
            this.refreshAccCurrency(this.getModel(), this.getTripEntryCurrencyCount());
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{EXPENSE_ENTRY_FLEX});
        }
        int tripentryrows = this.getModel().getEntryRowCount("tripentry");
        EntryGrid tripentry = (EntryGrid)this.getControl("tripentry");
        Map returnParam = (Map)e.getReturnData();
        if (returnParam != null && tripentryrows > 0 && returnParam.get("isUpdate").equals(false)) {
            tripentry.selectRows(tripentryrows - 1);
        }
        if ((trip = model.getEntryRowEntity("tripentry", tripIndex = model.getEntryCurrentRowIndex("tripentry"))) != null) {
            DynamicObject tripCurrency = trip.getDynamicObject("tripcurrency");
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            boolean multiCurrency = tripCurrency != null && currency != null && !tripCurrency.getPkValue().equals(currency.getPkValue());
            DynamicObject tripEntryCostcompany = trip.getDynamicObject("entrycostcompany");
            DynamicObject tripEntryCostdept = trip.getDynamicObject("entrycostdept");
            Date tripEntryHappendate = trip.getDate("triphappendate");
            DynamicObject tripEntryExpenseitem = trip.getDynamicObject("tripexpenseitem");
            DynamicObject tripFrom = trip.getDynamicObject("from");
            DynamicObject tripTo = trip.getDynamicObject("to");
            Long quotaCtrlDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)tripEntryExpenseitem, (DynamicObject)tripEntryCostdept, (IDataModel)model);
            trip.getDynamicObjectCollection("entryentity").forEach(v -> {
                v.set("isMulticurrency", (Object)multiCurrency);
                v.set("travelcostcompany", (Object)tripEntryCostcompany);
                v.set("travelcostdept", (Object)tripEntryCostdept);
                v.set("travelhappendate", (Object)tripEntryHappendate);
                v.set("travelexpenseitem", (Object)tripEntryExpenseitem);
                v.set("travelquotactldept_id", (Object)quotaCtrlDeptId);
                v.set("trip2from", (Object)tripFrom);
                v.set("trip2to", (Object)tripTo);
            });
        }
    }

    @Deprecated
    public void callBack2SetExpenseItem(IDataModel model, Integer rowIndex, Long tripexpenseId) {
    }

    @Deprecated
    public void setStandardDays(IDataModel model, Map<String, Object> returnParam) {
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String objectId;
        switch (objectId = eventArgs.getObjectId()) {
            case "save": 
            case "draft": {
                IDataModel model;
                if (eventArgs.getOperationResult().isSuccess() && (model = this.getModel()).getEntryRowCount("tripentry") > 0) {
                    EntryGrid tripentry = (EntryGrid)this.getView().getControl("tripentry");
                    tripentry.selectRows(0);
                }
                this.updateRelateCount();
                break;
            }
            case "unsubmit": {
                boolean dataChange = this.getModel().getDataChanged();
                CoreBaseBillServiceHelper.setValueVhc((IDataModel)this.getModel());
                this.getModel().setDataChanged(dataChange);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{ADD_EXPENSE});
                this.getView().setVisible(Boolean.TRUE, new String[]{"cardentryfixrowap1", "cardentryflexpanelap3"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"cardentryfixrowap3"});
                break;
            }
            case "submit": {
                if (this.getModel().getEntryRowCount("tripentry") > 0) {
                    EntryGrid tripEntry = (EntryGrid)this.getView().getControl("tripentry");
                    tripEntry.selectRows(0);
                }
                this.updateRelateCount();
                CalculateTripSumUtil.setTripSumLabel((IFormView)this.getView(), (int)this.getView().getModel().getEntryCurrentRowIndex("tripentry"));
            }
        }
    }

    private void initAccountEntryInfo() {
        DynamicObjectCollection accountEntrys = this.getModel().getEntryEntity("accountentry");
        for (int i = 0; i < accountEntrys.size(); ++i) {
            DynamicObject accountEntry = (DynamicObject)accountEntrys.get(i);
            if (accountEntry.get("paymode") != null) continue;
            DynamicObject paymode = PayeeServiceHelper.getDefaultPayMode();
            accountEntry.set("paymode", (Object)paymode);
        }
    }

    private boolean isArrayContainsThisStr(String targetStr, String[] strArray) {
        for (String str : strArray) {
            if (!targetStr.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equalsIgnoreCase((String)operateKey, (String)"submit")) {
            String entityId;
            boolean isReimber;
            DynamicObjectCollection tripentrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
            boolean isEmpty = tripentrys.stream().flatMap(tripentry -> tripentry.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList()).isEmpty();
            boolean isAllMonthly = tripentrys.stream().flatMap(tripentry -> tripentry.getDynamicObjectCollection("entryentity").stream()).allMatch(entry -> entry.getBigDecimal("entryamount").compareTo(BigDecimal.ZERO) > 0 && StringUtils.equals((String)"2", (String)entry.getString("settlementtype")));
            if (!isEmpty && isAllMonthly) {
                Object currnecy = this.getModel().getValue("currency");
                IntStream.range(0, this.getModel().getEntryRowCount("accountentry")).forEach(idx -> this.getModel().setValue("accountcurrency", currnecy, idx));
            }
            boolean bl = isReimber = ErEntityTypeUtils.isTripReimburseBill((String)(entityId = this.getView().getEntityId())) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isDailyReimburseBill((String)entityId);
            if (isReimber) {
                OffsetUtils.updateInvoiceOffsetBeforeOpe((IFormView)this.getView(), (IDataModel)this.getModel());
            }
        } else if (StringUtils.equals((String)operateKey, (String)"printpreview")) {
            OperateOption printOp = operate.getOption();
            printOp.setVariableValue("BOS_AUDIT_CUSTOMAUDITVALUE", "E,F,G,H,I");
        }
        AttachmentCountUtils.setAttachmentCount((FormOperate)operate, (IDataModel)this.getModel(), (IFormView)this.getView());
        UnRepaymentAmountUtil.setUnrepaymentAmountAndBillPayerAmount((IFormView)this.getView(), (FormOperate)operate);
    }

    private void updateRelateCount() {
        DynamicObjectCollection writeOffApplyEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("writeoffapply");
        LinkedList<String> billNumbers = new LinkedList<String>();
        for (DynamicObject row : writeOffApplyEntity) {
            billNumbers.add(row.getString("applybillno"));
        }
        CommonServiceHelper.updateRelateCount(billNumbers, (DynamicObjectCollection)writeOffApplyEntity);
        this.getView().updateView("writeoffapply");
    }

    private void delTripItemByCompanyChange(IDataModel model, ChangeData[] valueSet, DynamicObject company, int parentIndex) {
        if (company.getPkValue() != null && !Objects.equals(valueSet[0].getNewValue(), valueSet[0].getOldValue())) {
            QFilter qC = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter bdFilter = null;
            Object companyId = company.getPkValue();
            if (companyId instanceof Integer) {
                Integer compId = (Integer)companyId;
                bdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripexpenseitem", (Long)compId.longValue());
            } else if (companyId instanceof Long) {
                bdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripexpenseitem", (Long)((Long)companyId));
            }
            QFilter[] qFilters = new QFilter[]{qC, bdFilter};
            String selectExpensePros = "id,number,longnumber,expenseitemicon,isdefault,isvactax";
            Map tripExpenseitem = BusinessDataServiceHelper.loadFromCache((String)"er_tripexpenseitem", (String)selectExpensePros, (QFilter[])qFilters);
            Set tripExpenseitemEntries = tripExpenseitem.entrySet();
            int length = tripExpenseitemEntries.size();
            HashSet itemIdSet = Sets.newHashSetWithExpectedSize((int)length);
            for (Map.Entry tripExpenseitemEntrie : tripExpenseitemEntries) {
                DynamicObject tripExpenseitemObj = (DynamicObject)tripExpenseitemEntrie.getValue();
                itemIdSet.add((Long)tripExpenseitemObj.getPkValue());
            }
            int tripEntryIndex = model.getEntryCurrentRowIndex("tripentry");
            DynamicObject dataEntity = model.getDataEntity(true);
            int tripEntrySize = dataEntity.getDynamicObjectCollection("tripentry").size();
            boolean isEntryChange = false;
            if (tripEntrySize > 0) {
                for (int i = 0; i < tripEntrySize; ++i) {
                    DynamicObjectCollection reimburseDetails = ((DynamicObject)dataEntity.getDynamicObjectCollection("tripentry").get(i)).getDynamicObjectCollection("entryentity");
                    if (reimburseDetails.size() <= 0) continue;
                    ArrayList needRemoveRows = Lists.newArrayList();
                    DynamicObjectCollection needRemoveObs = new DynamicObjectCollection();
                    for (int j = 0; j < reimburseDetails.size(); ++j) {
                        Long tripItemId;
                        DynamicObject reimburseDetail = (DynamicObject)reimburseDetails.get(j);
                        DynamicObject tripItemDO = reimburseDetail.getDynamicObject("expenseitem");
                        if (tripItemDO == null || itemIdSet.contains(tripItemId = (Long)tripItemDO.getPkValue())) continue;
                        if (tripEntryIndex == i) {
                            needRemoveRows.add(j);
                            continue;
                        }
                        needRemoveObs.add((Object)reimburseDetail);
                    }
                    if (!needRemoveRows.isEmpty()) {
                        model.deleteEntryRows("entryentity", needRemoveRows.stream().mapToInt(Integer::intValue).toArray());
                        isEntryChange = true;
                    }
                    if (needRemoveObs.isEmpty()) continue;
                    reimburseDetails.removeAll((Collection)needRemoveObs);
                    isEntryChange = true;
                }
                if (isEntryChange) {
                    this.getView().updateView("tripentry");
                    CoreBaseBillServiceHelper.refreshEntryRowSeq((IDataModel)model, (boolean)true, (int)parentIndex);
                    TripReimburseServiceHelper.updateTripEntryAmount((IDataModel)model);
                    this.refreshTotalAmount("tripentry", "tripamount", "amount");
                    this.refreshTotalAmount("tripentry", "triporiamount", "encashamount");
                    this.refreshAccCurrency(this.getModel(), this.getTripEntryCurrencyCount());
                }
            }
        }
    }

    private Boolean validatWriteOffApply() {
        int reqbilltoreimbursecount = SystemParamterUtil.getloancheckparam((long)ErCommonUtils.getPk((Object)this.getModel().getValue("company")), (String)"reqbilltoreimbursecount");
        if (reqbilltoreimbursecount > 0) {
            return true;
        }
        DynamicObjectCollection writeOffApply = this.getModel().getDataEntity(true).getDynamicObjectCollection("writeoffapply");
        if (writeOffApply == null || writeOffApply.isEmpty()) {
            return true;
        }
        Set applyBillNo = writeOffApply.stream().map(v -> v.getString("applybillno")).collect(Collectors.toSet());
        if (applyBillNo.isEmpty()) {
            return true;
        }
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"er_tripreqbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "in", applyBillNo)});
        Set applyBillId = bills.stream().map(v -> (Long)v.get("id")).collect(Collectors.toSet());
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"er_tripreqbill", (Long[])((Long[])applyBillId.stream().toArray(Long[]::new)));
        if (targetBills != null && targetBills.containsKey("er_tripreimbursebill")) {
            HashSet targetBillId = (HashSet)targetBills.get("er_tripreimbursebill");
            Object id = this.getModel().getValue("id");
            if (id != null) {
                targetBillId.remove(ErCommonUtils.getPk((Object)id));
            }
            QFilter qFilter = new QFilter("id", "in", (Object)targetBillId);
            qFilter.and("billstatus", "!=", (Object)Character.valueOf('H'));
            DynamicObjectCollection targetBill = QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (targetBill.size() > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51b2\u7533\u8bf7\u5206\u5f55\u5173\u8054\u5355\u636e\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u6e05\u7406\u540e\u64cd\u4f5c\u3002", (String)"TripReimburseBillEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void preOpenForm(PreOpenFormEventArgs event) {
        FormShowParameter billShowParameter = event.getFormShowParameter();
        OperationStatus status = billShowParameter.getStatus();
        Boolean isCopy = (Boolean)billShowParameter.getCustomParam("iscopy");
        String serviceName = RequestContext.get().getAudit().getServiceName();
        if (billShowParameter.getCustomParam("showreport") != null) {
            return;
        }
        Object userInfoObj = billShowParameter.getCustomParam("userInfo");
        if (userInfoObj != null) {
            return;
        }
        if (!(status != OperationStatus.ADDNEW || isCopy != null && isCopy.booleanValue())) {
            String tripReimType = SystemParamterUtil.getTripReimburseTypeByCurrentUser();
            String formId = event.getFormShowParameter().getFormId();
            String expectedType = tripReimTypeByFormId.get(formId);
            if (serviceName.toLowerCase().lastIndexOf("unittest") != -1) {
                return;
            }
            if (expectedType != null && !org.apache.commons.lang3.StringUtils.equals((CharSequence)tripReimType, (CharSequence)expectedType)) {
                event.setCancel(true);
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)tripReimType, (CharSequence)"card")) {
                    event.setCancelMessage(ResManager.loadKDString((String)"\u60a8\u4e0d\u5728\u8868\u683c\u5f0f\u5dee\u65c5\u62a5\u9500\u5355\u4f7f\u7528\u8303\u56f4\uff0c\u8bf7\u9009\u62e9\u201c\u5dee\u65c5\u62a5\u9500\u201d\uff0c\u586b\u62a5\u5dee\u65c5\u8d39\u3002", (String)"TripReimburseBillEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                } else {
                    event.setCancelMessage(ResManager.loadKDString((String)"\u60a8\u4e0d\u5728\u5361\u7247\u5f0f\u5dee\u65c5\u62a5\u9500\u5355\u4f7f\u7528\u8303\u56f4\uff0c\u8bf7\u9009\u62e9\u201c\u5dee\u65c5\u62a5\u9500(\u8868)\u201d\uff0c\u586b\u62a5\u5dee\u65c5\u8d39\u3002", (String)"TripReimburseBillEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    static {
        tripReimTypeByFormId.put("er_tripreimbursebill", "card");
        tripReimTypeByFormId.put("er_tripreimbill_grid", "grid");
    }
}

