/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripBillTravelerUtils;
import kd.fi.er.common.constant.ErTripExpenseItemConstant;
import kd.fi.er.formplugin.web.AbstractTripReimburseBillEditNew;
import org.apache.commons.lang3.StringUtils;

public class TripReimburseBillEditNew
extends AbstractTripReimburseBillEditNew {
    private static Log logger = LogFactory.getLog(TripReimburseBillEditNew.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setTravelsF7Filter();
    }

    @Override
    protected String getBillTypeId() {
        Object billTypeId;
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (!StringUtils.equals((CharSequence)formShowParameter.getFormId(), (CharSequence)this.getView().getEntityId()) && (billTypeId = this.getBillTypeIdByLayOutForm(formShowParameter.getFormId())) != null) {
            return billTypeId.toString();
        }
        return null;
    }

    protected void setTravelsF7Filter() {
        MulBasedataEdit travelersF7 = (MulBasedataEdit)this.getControl("trip2travelers");
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        TripBillTravelerUtils.getF7FilterInfo((DynamicObject)company, (DynamicObject)org, (BasedataEdit)travelersF7);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showAirPortConstructionfee(0);
        this.setTripDateControl();
    }

    private void setTripDateControl() {
        Map companyMap;
        Long companyID = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
        if (companyID == null && (companyMap = CommonServiceHelper.getCompanyByUserId((Long)RequestContext.get().getCurrUserId())) != null) {
            companyID = (Long)companyMap.get("id");
        }
        if (companyID != null && StringUtils.equals((CharSequence)SystemParamterUtil.getTripReimDateSelectRange((Long)companyID), (CharSequence)"0")) {
            DateRangeEdit tripDate = (DateRangeEdit)this.getControl("trip2tripdate");
            LocalDate now = LocalDate.now();
            tripDate.setMaxDate(ErCommonUtils.getDateFromLocalDate((LocalDate)now));
        }
    }

    private Object getBillTypeIdByLayOutForm(String formId) {
        QFilter qFilter = new QFilter("number", "=", (Object)formId);
        List solutionPks = QueryServiceHelper.queryPrimaryKeys((String)"bos_formmeta", (QFilter[])new QFilter[]{qFilter}, (String)"id", (int)1);
        if (!solutionPks.isEmpty()) {
            qFilter = new QFilter("layoutsolution", "=", solutionPks.get(0));
            List pks = QueryServiceHelper.queryPrimaryKeys((String)"bos_billtype", (QFilter[])new QFilter[]{qFilter}, (String)"id", (int)1);
            if (!pks.isEmpty()) {
                return pks.get(0);
            }
        }
        return null;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        int parentIndex = e.getChangeSet()[0].getParentRowIndex();
        switch (propName) {
            case "trip2startdate": {
                Date startDate = (Date)newValue;
                Date endDate = (Date)this.getModel().getValue("trip2enddate", rowIndex, parentIndex);
                this.setTripDays(startDate, endDate, rowIndex);
                break;
            }
            case "trip2enddate": {
                Date endDate = (Date)newValue;
                Date startDate = (Date)this.getModel().getValue("trip2startdate", rowIndex, parentIndex);
                this.setTripDays(startDate, endDate, rowIndex);
                break;
            }
            case "trip2travelers": {
                IDataModel model = this.getModel();
                if (newValue == null || ((DynamicObjectCollection)newValue).isEmpty()) {
                    Object oldValue = e.getChangeSet()[0].getOldValue();
                    model.setValue("trip2travelers", oldValue, rowIndex, parentIndex);
                    return;
                }
                model.setValue("trip2travelerscount", (Object)((DynamicObjectCollection)newValue).size(), rowIndex, parentIndex);
                break;
            }
            case "expenseitem": {
                this.showAirPortConstructionfee(parentIndex);
                break;
            }
        }
    }

    protected void showAirPortConstructionfee(int tripEntryIndex) {
        this.getView().setVisible(Boolean.valueOf(this.existAirPlane(tripEntryIndex)), new String[]{"airportconstructionfee"});
    }

    protected boolean existAirPlane(int tripEntryIndex) {
        return this.existExpense(tripEntryIndex, ErTripExpenseItemConstant.Attribute.AirPlane.getValue());
    }

    private boolean existExpense(int tripEntryIndex, String ... attributes) {
        DynamicObject tripEntry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(tripEntryIndex);
        DynamicObjectCollection entryColl = tripEntry.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryColl) {
            if (!Arrays.asList(attributes).contains(entry.get("expenseitem.attribute"))) continue;
            return true;
        }
        return false;
    }

    protected void setTripDays(Date startDate, Date endDate, int rowIndex) {
        this.getModel().setValue("daycount", (Object)CommonServiceHelper.calcDays((Date)startDate, (Date)endDate), rowIndex, 0);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if ("entryentity".equals(e.getEntryProp().getName())) {
            this.showAirPortConstructionfee(0);
        }
    }
}

