/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.form.IFormController;
import kd.fi.er.business.messagepublish.ErMessagePublisher;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.AttachmentCountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.TripBillTravelerUtils;
import kd.fi.er.business.utils.TripReimburseTypeControlUtils;
import kd.fi.er.business.utils.UnRepaymentAmountUtil;
import kd.fi.er.formplugin.daily.web.util.TempEncashAmountUtils;
import kd.fi.er.formplugin.web.TripBaseBillEdit;
import kd.sdk.fi.er.extpoint.dailyreimbursebill.ISuperClosedCallBack;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TripReqBill
extends TripBaseBillEdit
implements UploadListener {
    private static final Log logger = LogFactory.getLog(TripReqBill.class);
    private static final String CONFIRM_AFTERTRIPCHANGE = "afterTripChangeConfirm";
    private static final String TRIPCHANGE_OP = "tripchange";
    private static final String DEL_TRIPENTRY_CHECK = "deltripentrycheck";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"deltripentry"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Boolean isLoan = this.isLoan();
        this.getModel().setValue("isloan", (Object)isLoan);
        if (isLoan.booleanValue()) {
            this.refreshRepaymentDate();
        }
        CommonServiceHelper.setIsMulTravelers((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    @Override
    protected boolean isNeedToSetFundingOrg() {
        Boolean loan = this.isLoan();
        logger.info("\u662f\u5426\u9700\u8981\u8bbe\u7f6e\u652f\u4ed8\u516c\u53f8" + loan);
        return loan;
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        this.refreshTripInfoLabels();
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company != null) {
            int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
            model.setValue("expensesassumeshowtypes", (Object)String.valueOf(showType));
            logger.info("\u51fa\u5dee\u501f\u6b3e\u5355-\u5171\u4eab\u5ba1\u6279>>>>\u8d39\u7528\u627f\u62c5\u5355\u5934\u663e\u793a" + showType);
            if (showType == 1) {
                BasedataEdit costdept = (BasedataEdit)this.getControl("costdept");
                costdept.setMustInput(true);
                BasedataEdit costcompany = (BasedataEdit)this.getControl("costcompany");
                costcompany.setMustInput(true);
            }
        }
        CoreBaseBillServiceHelper.setValueVhc((IDataModel)model);
        model.setDataChanged(false);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_sncyyzj": {
                ErMessagePublisher.publishMessageToMq((String)"fi", (String)"fi.er.ext.tripReqBill.delete", null);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        IDataModel model = this.getModel();
        switch (propName) {
            case "bizdate": {
                this.refreshRepaymentDate();
                break;
            }
            case "company": {
                DynamicObject company = (DynamicObject)model.getValue("company");
                if (company == null) break;
                int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
                model.setValue("expensesassumeshowtypes", (Object)String.valueOf(showType));
                if (showType == 1) {
                    BasedataEdit costdept = (BasedataEdit)this.getControl("costdept");
                    costdept.setMustInput(true);
                    BasedataEdit costcompany = (BasedataEdit)this.getControl("costcompany");
                    costcompany.setMustInput(true);
                }
                this.refreshRepaymentDate();
                break;
            }
            case "approveamount": {
                if (!this.isLoan().booleanValue() || model.getEntryRowCount("accountentry") != 1 || model.getValue("accountcurrency", 0) == null) break;
                BigDecimal receiveAmount = (BigDecimal)propValue;
                model.setValue("encashamount", (Object)receiveAmount);
                model.setValue("receiveamount", (Object)receiveAmount, 0);
                BigDecimal oriReceiveAmount = BigDecimal.ZERO;
                if (this.isSingleSectionCurrency(model)) {
                    oriReceiveAmount = this.refreshTotalAmount("tripentry", "triporiaccappamount", null);
                } else {
                    BigDecimal accexchangerate = (BigDecimal)model.getValue("accexchangerate", 0);
                    DynamicObject currency = (DynamicObject)model.getValue("accountcurrency", 0);
                    oriReceiveAmount = AmountUtils.getOriAmount((BigDecimal)receiveAmount, (BigDecimal)accexchangerate, (int)currency.getInt("amtprecision"), (String)((String)model.getValue("accquotetype", 0)));
                }
                model.beginInit();
                model.setValue("orireceiveamount", (Object)oriReceiveAmount, 0);
                model.endInit();
                model.setValue("oriaccnotpayamount", (Object)oriReceiveAmount, 0);
                model.setValue("accnotpayamount", (Object)receiveAmount, 0);
                this.getView().updateView("orireceiveamount", 0);
                break;
            }
            case "accountcurrency": {
                this.accountCurrencyChange(rowIndex, (DynamicObject)propValue);
                this.isLockAccexchangeByAccCurrency(rowIndex, (DynamicObject)propValue);
                break;
            }
            case "iscurrency": {
                Boolean isCurrency = (Boolean)propValue;
                if (!isCurrency.booleanValue()) {
                    DynamicObject currency = (DynamicObject)model.getValue("currency");
                    DynamicObjectCollection tripEntry = model.getEntryEntity("tripentry");
                    BigDecimal totalAmount = new BigDecimal(0);
                    for (int i = 0; i < tripEntry.size(); ++i) {
                        model.setValue("tripcurrency", (Object)ErCommonUtils.getPk((Object)currency), i);
                        BigDecimal tripOriamount = (BigDecimal)model.getValue("triporiamount", i);
                        Map<String, Object> exchangeMap = this.refreshExchangeRate("tripexchangerate", currency);
                        BigDecimal tripExchangerate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
                        String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
                        if (model.getProperty("tripquotetype") != null) {
                            model.setValue("tripquotetype", (Object)quoteType, i);
                        }
                        model.setValue("tripexchangerate", (Object)tripExchangerate, i);
                        int currencyPrecision = AmountUtils.getCurrencyPrecision((Object)ErCommonUtils.getPk((Object)currency));
                        BigDecimal tripAmount = AmountUtils.getCurrencyAmount((BigDecimal)tripOriamount, (BigDecimal)tripExchangerate, (int)currencyPrecision, (String)quoteType);
                        model.setValue("tripamount", (Object)tripAmount, i);
                        model.setValue("triporiaccappamount", (Object)tripOriamount, i);
                        model.setValue("tripaccappamount", (Object)tripAmount, i);
                        totalAmount = totalAmount.add(tripAmount);
                    }
                    DynamicObjectCollection accEntry = model.getEntryEntity("accountentry");
                    for (int i = 0; i < accEntry.size(); ++i) {
                        model.setValue("accountcurrency", (Object)ErCommonUtils.getPk((Object)currency), i);
                    }
                    if (accEntry.size() == 1) {
                        model.setValue("orireceiveamount", (Object)totalAmount, 0);
                        this.refreshEncashamountlabel(totalAmount);
                    }
                    this.refreshTripInfo();
                    break;
                }
                rowIndex = model.getEntryCurrentRowIndex("accountentry");
                DynamicObject accountCurrency = (DynamicObject)model.getValue("accountcurrency", rowIndex);
                this.isLockAccexchangeByAccCurrency(rowIndex, accountCurrency);
                break;
            }
            case "accexchangerate": {
                Boolean isCurrensyOpen = (Boolean)this.getModel().getValue("iscurrency");
                Boolean isLoan = (Boolean)this.getModel().getValue("isloan");
                int rowCount = this.getModel().getEntryRowCount("accountentry");
                if (isLoan.booleanValue() && rowCount == 1 && isCurrensyOpen.booleanValue()) {
                    BigDecimal exchangeRate;
                    BigDecimal encashAMount = (BigDecimal)this.getModel().getValue("encashamount");
                    DynamicObject accCurrency = (DynamicObject)this.getModel().getValue("accountcurrency", rowIndex);
                    int amtprecision = 8;
                    if (accCurrency != null) {
                        amtprecision = accCurrency.getInt("amtprecision");
                    }
                    if ((exchangeRate = (BigDecimal)propValue).compareTo(BigDecimal.ZERO) == 0) {
                        exchangeRate = BigDecimal.ONE;
                    }
                    BigDecimal amount = encashAMount.divide(exchangeRate, amtprecision, 4);
                    this.getModel().setValue("orireceiveamount", (Object)amount, rowIndex);
                    this.getModel().setValue("receiveamount", (Object)encashAMount, rowIndex);
                    this.getModel().setValue("oriaccnotpayamount", (Object)amount, rowIndex);
                } else {
                    this.refreshReceiveAmount(rowIndex, model);
                }
                AmountChangeUtil.accExchangeRateChange((Object)propValue, (int)rowIndex, (IDataModel)model, (IFormView)this.getView());
                break;
            }
            case "orireceiveamount": {
                this.refreshReceiveAmount(rowIndex, model);
                AmountChangeUtil.orireceiveamountChange((Object)propValue, (int)rowIndex, (IDataModel)model);
                break;
            }
            case "triporiaccappamount": {
                model.beginInit();
                model.setValue("oriaccbalanceamount", propValue, rowIndex);
                model.endInit();
                break;
            }
            case "tripaccappamount": {
                model.beginInit();
                model.setValue("accbalanceamount", propValue, rowIndex);
                model.endInit();
                break;
            }
            case "currency": {
                this.refreshTripInfo();
                break;
            }
            case "vehicles": {
                CoreBaseBillServiceHelper.setValueVhc((IDataModel)model);
            }
        }
    }

    private void refreshRepaymentDate() {
        this.getModel().setValue("repaymentdate", (Object)CoreBaseBillServiceHelper.computeRepaymentDate((IDataModel)this.getModel()));
    }

    private void refreshReceiveAmount(int rowIndex, IDataModel model) {
        BigDecimal orireceiveamount = (BigDecimal)model.getValue("orireceiveamount", rowIndex);
        BigDecimal changeRate = (BigDecimal)model.getValue("accexchangerate", rowIndex);
        if (changeRate == null) {
            changeRate = BigDecimal.ONE;
        }
        String accQuoteType = model.getProperty("accquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("accquotetype", rowIndex)), (Object)"0");
        BigDecimal receiveamount = AmountUtils.getCurrencyAmount((BigDecimal)orireceiveamount, (BigDecimal)changeRate, (int)AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency"), (String)accQuoteType);
        model.setValue("receiveamount", (Object)receiveamount, rowIndex);
        model.setValue("oriaccnotpayamount", model.getValue("orireceiveamount", rowIndex), rowIndex);
        model.setValue("accnotpayamount", model.getValue("receiveamount", rowIndex), rowIndex);
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryprop = e.getEntryProp();
        if (entryprop.getName().equals("accountentry")) {
            for (RowDataEntity rowDataEntity : e.getRowDataEntities()) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.getModel().setValue("entryrepaydate", this.getModel().getValue("repaymentdate"), rowIndex);
            }
        }
    }

    @Override
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        this.refreshTripInfo();
        if (Arrays.asList("tripentry", "accountentry").contains(entryName)) {
            this.refshAccCurrency(this.getModel());
        }
        if ("accountentry".equals(entryName)) {
            AmountChangeUtil.handleDiiff((IDataModel)this.getModel(), (String)"accountentry", (String)"receiveamount", (String)"orireceiveamount", (String)"accexchangerate", (String)"currency");
        }
    }

    @Override
    protected boolean initAccount() {
        if (!this.isLoan().booleanValue()) {
            return false;
        }
        return super.initAccount();
    }

    @Override
    protected int initAccountEntryDefaultData(IDataModel model) {
        int rowIndex = super.initAccountEntryDefaultData(model);
        model.setValue("entryrepaydate", model.getValue("repaymentdate"), rowIndex);
        return rowIndex;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        IDataModel model = this.getView().getModel();
        if (this.getTripEntryEditForm().equals(actionId)) {
            PluginProxy pluginProxy = PluginProxy.create(null, ISuperClosedCallBack.class, (String)"FI_ER_SUPERCLOSEDCALLBACK", null);
            AtomicBoolean execute = new AtomicBoolean(true);
            pluginProxy.callReplace(p -> {
                execute.set(p.beforeClosedCallBack(TripReqBill.class, this.getTripEntryEditForm(), Boolean.TRUE, new Object[]{this.getView(), event.getReturnData()}));
                return null;
            });
            if (execute.get()) {
                int currentTripEntryIndex;
                Map map;
                if (event.getReturnData() != null) {
                    this.refreshTripInfo();
                    TempEncashAmountUtils.triploan_refshAccCurrency((IDataModel)model, (IFormView)this.getView());
                }
                if (event.getReturnData() instanceof Map && !((Boolean)(map = (Map)event.getReturnData()).get("isUpdate")).booleanValue() && (currentTripEntryIndex = ((Integer)map.get("currentTripEntryIndex")).intValue()) < this.getModel().getEntryRowCount("tripentry")) {
                    this.getModel().setValue("entrycreatetime", (Object)new Date(), currentTripEntryIndex);
                }
            }
            pluginProxy.callReplace(p -> {
                p.afterClosedCallBack(TripReqBill.class, this.getTripEntryEditForm(), Boolean.TRUE, new Object[]{this.getView(), event.getReturnData()});
                return null;
            });
        }
    }

    protected void refshAccCurrency(IDataModel model) {
        TempEncashAmountUtils.triploan_refshAccCurrency((IDataModel)model, (IFormView)this.getView());
    }

    private void refreshTripInfo() {
        TempEncashAmountUtils.triploan_refreshTripInfo((IDataModel)this.getModel(), (IFormView)this.getView());
        this.refreshTripInfoLabels();
    }

    private void refreshTripInfoLabels() {
        IDataModel model = this.getModel();
        BigDecimal appAmount = (BigDecimal)model.getValue("approveamount");
        this.refreshTripAmountLabel(appAmount);
        this.refreshPlanDays(model);
        if (this.isLoan().booleanValue()) {
            BigDecimal encashAmount = (BigDecimal)model.getValue("encashamount");
            this.refreshEncashamountlabel(encashAmount);
        }
    }

    private void refreshPlanDays(IDataModel model) {
        DynamicObjectCollection tripEntrys = model.getEntryEntity("tripentry");
        List startdateList = tripEntrys.stream().map(tripEntry -> tripEntry.getDate("startdate")).collect(Collectors.toList());
        List enddateList = tripEntrys.stream().map(tripEntry -> tripEntry.getDate("enddate")).collect(Collectors.toList());
        logger.info("startdateList:" + startdateList + "--enddateList:" + enddateList);
        if (startdateList.contains(null) || enddateList.contains(null)) {
            return;
        }
        int planDays = TripBillTravelerUtils.getPlayDays(startdateList, enddateList, (DynamicObjectCollection)tripEntrys);
        model.setValue("plandays", (Object)Integer.toString(planDays));
        Label planDaysLabel = (Label)this.getControl("labelplandays");
        planDaysLabel.setText(String.valueOf(planDays));
    }

    public Boolean isLoan() {
        return TempEncashAmountUtils.isLoan((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    private void accountCurrencyChange(int rowIndex, DynamicObject accountCurrency) {
        Map<String, Object> exchangerateMap = this.refreshExchangeRate("accexchangerate", accountCurrency);
        BigDecimal accexchangerate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangerateMap.get("exchangeRate")), (Object)BigDecimal.ONE);
        String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangerateMap.get("quoteType")), (Object)"0");
        if (accexchangerate == null) {
            logger.info(String.format("\u5e01\u79cdid:%s \u672a\u8bbe\u7f6e\u6c47\u7387", accountCurrency.getPkValue()));
            accexchangerate = BigDecimal.ONE;
        }
        if (this.getModel().getProperty("accquotetype") != null) {
            this.getModel().setValue("accquotetype", (Object)quoteType, rowIndex);
        }
        this.getModel().setValue("accexchangerate", (Object)accexchangerate, rowIndex);
    }

    protected boolean isSingleSectionCurrency(IDataModel model) {
        return TempEncashAmountUtils.isSingleSectionCurrency((IDataModel)model);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Push) {
            Push push = (Push)source;
            if (StringUtils.equals((CharSequence)push.getOperateKey(), (CharSequence)"pushreimburse")) {
                Long billId = (Long)this.getModel().getDataEntity().getPkValue();
                String formId = TripReimburseTypeControlUtils.getTripReqBillReimType(Collections.singletonList(billId), (boolean)false);
                push.getOption().setVariableValue("botp_push_target_bill_formid", formId);
                TripReimburseTypeControlUtils.setTripReqBillReimType(Collections.singletonList(billId));
            }
        } else if (((FormOperate)source).getOperateKey().equals(TRIPCHANGE_OP)) {
            RefObject afterConfirm = new RefObject();
            if (!((FormOperate)source).getOption().tryGetVariableValue(CONFIRM_AFTERTRIPCHANGE, afterConfirm)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(TRIPCHANGE_OP, (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u884c\u7a0b\u53d8\u66f4\u540e\uff0c\u6570\u636e\u65e0\u6cd5\u6062\u590d\u5230\u539f\u884c\u7a0b\u3002\u662f\u5426\u786e\u8ba4\u53d8\u66f4\uff1f", (String)"TripReqBill_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
            }
        }
        FormOperate operate = (FormOperate)args.getSource();
        AttachmentCountUtils.setAttachmentCount((FormOperate)operate, (IDataModel)this.getModel(), (IFormView)this.getView());
        UnRepaymentAmountUtil.setUnrepaymentAmountAndBillPayerAmount((IFormView)this.getView(), (FormOperate)operate);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        BillView formView = (BillView)messageBoxClosedEvent.getSource();
        if (StringUtils.equals((CharSequence)TRIPCHANGE_OP, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(CONFIRM_AFTERTRIPCHANGE, "true");
            this.getView().invokeOperation(TRIPCHANGE_OP, operateOption);
            IFormController srv = (IFormController)this.getView().getService(IFormController.class);
            srv.loadData();
        }
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setMax();
    }

    private void setMax() {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripchangehistoryentry");
        Optional<DynamicObject> optional = collection.stream().max(Comparator.comparing(v -> (Date)v.get("changetime")));
        if (optional.isPresent()) {
            this.getModel().setValue("maxchangedate", (Object)optional.get().getDate("changetime"));
        } else {
            this.getModel().setValue("maxchangedate", (Object)new Date());
        }
    }

    @Override
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        model.deleteEntryData("tripchangehistoryentry");
        model.setValue("ischange", (Object)Boolean.FALSE);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        if (evt.getSource() instanceof Image && "deltripentry".equals(((Image)evt.getSource()).getKey())) {
            this.getView().getPageCache().put(DEL_TRIPENTRY_CHECK, "true");
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        if (Boolean.parseBoolean(this.getView().getPageCache().get(DEL_TRIPENTRY_CHECK)) && "tripentry".equals(name)) {
            this.getView().getPageCache().remove(DEL_TRIPENTRY_CHECK);
            if (e.getRowIndexs().length > 0 && !collection.isEmpty()) {
                Long id = (Long)this.getModel().getDataEntity(true).getPkValue();
                for (int i = 0; i < e.getRowIndexs().length; ++i) {
                    int index = e.getRowIndexs()[i];
                    Long entryid = (Long)((DynamicObject)collection.get(index)).getPkValue();
                    if (!TripCommonUtil.checkTripExistOrder((Long)id, (Long)entryid)) continue;
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u7a0b\u5b58\u5728\u5173\u8054\u7684\u5546\u65c5\u8ba2\u5355\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"TripReqBill_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    break;
                }
            }
        }
    }
}

