/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripstandard;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.tripstd.context.StdPreCalContext;
import kd.fi.er.business.tripstd.model.TripStandardDetail;
import kd.fi.er.business.tripstd.service.IErTripStdService;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceProxy;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.SettlementTypeEnum;
import kd.fi.er.formplugin.web.tripstandard.AbstractTripStdCtrlPlugin;
import kd.fi.er.formplugin.web.tripstandard.util.TripStandardUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTripStdCtrlForCardStylePlugin
extends AbstractTripStdCtrlPlugin {
    private static Log logger = LogFactory.getLog(AbstractTripStdCtrlForCardStylePlugin.class);
    private static final String stdCtrlUpgradeDate = "stdCtrlUpgradeDate1_0";
    private Boolean isOldBillOfStdCtrl_result = null;

    @Override
    public void afterBindData(EventObject e) {
        this.afterSrcConvert();
        super.afterBindData(e);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entityName = e.getEntryProp().getName();
        if ("entryentity".equals(entityName)) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity row : rowDataEntities = e.getRowDataEntities()) {
                int tripEntryIndex = row.getParentRowIndex();
                DynamicObject tripEntry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(tripEntryIndex);
                int detailIndex = row.getRowIndex();
                DynamicObjectCollection travlers = tripEntry.getDynamicObjectCollection("travelers");
                this.getModel().setValue("trip2travelers", (Object)travlers, detailIndex, tripEntryIndex);
                this.getModel().setValue("trip2travelerscount", (Object)(travlers == null ? 0 : travlers.size()), detailIndex, tripEntryIndex);
                this.getModel().setValue("triparea", (Object)tripEntry.getDynamicObject("tripentryarea"), detailIndex, tripEntryIndex);
                this.getModel().setValue("daycount", (Object)tripEntry.getInt("tripday"), detailIndex, tripEntryIndex);
                this.getModel().setValue("trip2startdate", tripEntry.get("startdate"), detailIndex, tripEntryIndex);
                this.getModel().setValue("trip2enddate", tripEntry.get("enddate"), detailIndex, tripEntryIndex);
            }
        }
    }

    private void afterSrcConvert() {
        IDataModel model = this.getModel();
        if (model.getDataEntity().getDataEntityState().isPushChanged()) {
            DynamicObjectCollection tripEntryCollction = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
            for (int i = 0; i < tripEntryCollction.size(); ++i) {
                DynamicObject tripEntry = (DynamicObject)tripEntryCollction.get(i);
                DynamicObjectCollection travelers = tripEntry.getDynamicObjectCollection("travelers");
                DynamicObject tripEntryArea = tripEntry.getDynamicObject("tripentryarea");
                if (tripEntryArea == null) {
                    String orgType = ErCommonUtils.getTripAreaOrgType();
                    DynamicObject org = (DynamicObject)model.getValue(orgType);
                    IErTripStdService stdService = new ErTripStdServiceProxy((IErTripStdService)new ErTripStdServiceImp(), this.getModel().getDataEntity()).getInstance();
                    tripEntryArea = stdService.getTripAreaByCityIdAndCompanyId(ErCommonUtils.getPk((Object)tripEntry.getDynamicObject("to")), ErCommonUtils.getPk((Object)org));
                    model.setValue("tripentryarea", (Object)tripEntryArea, i);
                }
                DynamicObjectCollection detailColl = ((DynamicObject)tripEntryCollction.get(i)).getDynamicObjectCollection("entryentity");
                for (int j = 0; j < detailColl.size(); ++j) {
                    DynamicObject detailEntry = (DynamicObject)detailColl.get(j);
                    if (detailEntry.getDynamicObjectCollection("trip2travelers").isEmpty()) {
                        model.setValue("trip2travelers", (Object)travelers, j, i);
                    }
                    if (detailEntry.getDynamicObject("triparea") == null) {
                        model.setValue("triparea", (Object)ErCommonUtils.getPk((Object)tripEntryArea), j, i);
                    }
                    if (!StringUtils.isEmpty((CharSequence)detailEntry.getString("isover"))) continue;
                    model.setValue("triparea", (Object)"0", j, i);
                }
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        int parentRowIndex = e.getChangeSet()[0].getParentRowIndex();
        switch (propName) {
            case "company": {
                this.refreshAllTripEntryTripArea();
                break;
            }
            case "to": {
                DynamicObjectCollection tripEntryCollction = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
                DynamicObject oldTripArea = ((DynamicObject)tripEntryCollction.get(rowIndex)).getDynamicObject("tripentryarea");
                Object oldPkValue = oldTripArea == null ? null : oldTripArea.getPkValue();
                this.setTripEntryTripArea(rowIndex, newValue, this.getCompanyId(), oldPkValue);
                break;
            }
            case "tripentryarea": {
                this.updateDetailPropertyOfTripEntry("triparea", newValue, rowIndex);
                break;
            }
            case "travelers": {
                this.updateDetailPropertyOfTripEntry("trip2travelers", newValue, rowIndex);
                break;
            }
            case "tripday": {
                this.updateDetailPropertyOfTripEntry("daycount", newValue, rowIndex);
                break;
            }
            case "startdate": {
                this.updateDetailPropertyOfTripEntry("trip2startdate", newValue, rowIndex);
                break;
            }
            case "enddate": {
                this.updateDetailPropertyOfTripEntry("trip2enddate", newValue, rowIndex);
                break;
            }
            case "expenseitem": {
                this.repairIFSumGroupStdIsNotOver(true, (DynamicObject)oldValue, parentRowIndex, rowIndex);
                break;
            }
            case "entrycurrency": {
                this.repairIFSumGroupStdIsNotOver(false, (DynamicObject)oldValue, parentRowIndex, rowIndex);
            }
        }
    }

    @Override
    protected boolean isOnlySetTripStdShowInfoOfEntry(int parentEntryIndex, int curEntryIndex) {
        if (this.isOldBillOfStdCtrl()) {
            return false;
        }
        return super.isOnlySetTripStdShowInfoOfEntry(parentEntryIndex, curEntryIndex);
    }

    private boolean isOldBillOfStdCtrl() {
        Date createDate;
        String value;
        if (this.isOldBillOfStdCtrl_result != null) {
            return this.isOldBillOfStdCtrl_result;
        }
        Long upgradeDate = (Long)ErCommonUtils.getKeyValueFromAppCache((String)stdCtrlUpgradeDate, Long.class);
        if (upgradeDate == null && (value = ErStdConfig.get((String)stdCtrlUpgradeDate)) != null) {
            upgradeDate = Long.valueOf(value);
            ErCommonUtils.putKeyValueToAppCache((String)stdCtrlUpgradeDate, (Object)upgradeDate);
        }
        Long createTime = (createDate = this.getModel().getDataEntity().getDate("createtime")) == null ? Long.valueOf(System.currentTimeMillis()) : Long.valueOf(createDate.getTime());
        if (upgradeDate != null && upgradeDate.compareTo(createTime) > 0) {
            this.isOldBillOfStdCtrl_result = Boolean.TRUE;
        }
        this.isOldBillOfStdCtrl_result = Boolean.FALSE;
        return this.isOldBillOfStdCtrl_result;
    }

    @Override
    protected Set<Long> getTravelersOfEntry(DynamicObject entry, int parentEntryIndex, int curEntryIndex) {
        if (entry.getDynamicObjectCollection("trip2travelers").size() > 0) {
            return super.getTravelersOfEntry(entry, parentEntryIndex, curEntryIndex);
        }
        DynamicObject tripEntry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(parentEntryIndex);
        DynamicObjectCollection tripEntryTravers = tripEntry.getDynamicObjectCollection("travelers");
        if (tripEntryTravers.size() > 0 && this.isOldBillOfStdCtrl()) {
            this.getModel().setValue("trip2travelers", (Object)tripEntryTravers, curEntryIndex, parentEntryIndex);
        }
        return tripEntry.getDynamicObjectCollection("travelers").stream().filter(traveler -> traveler.get("fbasedataid") != null).map(traveler -> traveler.getLong("fbasedataid_id")).collect(Collectors.toSet());
    }

    @Override
    protected DynamicObject getTripAreaOfEntry(DynamicObject entry, int parentEntryIndex, int curEntryIndex) {
        DynamicObject tripArea = super.getTripAreaOfEntry(entry, parentEntryIndex, curEntryIndex);
        if (tripArea == null && (tripArea = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(parentEntryIndex)).getDynamicObject("tripentryarea")) != null && this.isOldBillOfStdCtrl()) {
            this.getModel().setValue("triparea", (Object)tripArea, curEntryIndex, parentEntryIndex);
        }
        return tripArea;
    }

    private void refreshAllTripEntryTripArea() {
        Long companyId = this.getCompanyId();
        if (companyId.compareTo(0L) == 0) {
            return;
        }
        DynamicObjectCollection tripEntryCollction = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        logger.info("cacheTripArea");
        this.cacheTripArea(tripEntryCollction);
        logger.info("loopTripEntry size=" + tripEntryCollction.size());
        for (int tripEntryIndex = 0; tripEntryIndex < tripEntryCollction.size(); ++tripEntryIndex) {
            DynamicObject tripEntry = (DynamicObject)tripEntryCollction.get(tripEntryIndex);
            DynamicObject oldTripArea = tripEntry.getDynamicObject("tripentryarea");
            Object oldPkValue = oldTripArea == null ? null : oldTripArea.getPkValue();
            this.setTripEntryTripArea(tripEntryIndex, tripEntry.get("to"), companyId, oldPkValue);
        }
        logger.info("loopTripEntry finish");
    }

    private void cacheTripArea(DynamicObjectCollection tripEntryCollction) {
        String orgType = ErCommonUtils.getTripAreaOrgType();
        Long orgId = ErCommonUtils.getPk((Object)((DynamicObject)this.getModel().getValue(orgType)));
        Set toCityIds = tripEntryCollction.stream().map(v -> v.getDynamicObject("to").getPkValue()).collect(Collectors.toSet());
        QFilter filter = new QFilter("entryentity.city.id", "in", toCityIds);
        filter.and(new QFilter("enable", "=", (Object)true));
        QFilter baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_triparea", (Long)orgId);
        if (null != baseFilter) {
            filter.and(baseFilter);
        }
        HashMap<String, DynamicObject> cityTripAreaMap = new HashMap<String, DynamicObject>();
        Map tripAreas = BusinessDataServiceHelper.loadFromCache((String)"er_triparea", (String)"id,entryentity.city", (QFilter[])new QFilter[]{filter});
        for (DynamicObject tripArea : tripAreas.values()) {
            DynamicObjectCollection tripAreaEntries = tripArea.getDynamicObjectCollection("entryentity");
            for (DynamicObject tripAreaEntry : tripAreaEntries) {
                Object cityId = tripAreaEntry.get("city");
                String key = String.format("%s,%s", ErCommonUtils.getPk((Object)cityId), orgId);
                if (cityTripAreaMap.containsKey(key)) continue;
                cityTripAreaMap.put(key, tripArea);
            }
        }
        ActionLocalCache.get().put("kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp.CITY_TRIP_AREA", cityTripAreaMap);
    }

    private void setTripEntryTripArea(int rowIndex, Object to, Long orgId, Object oldValuePk) {
        if (to == null) {
            this.getModel().setValue("tripentryarea", null, rowIndex);
            return;
        }
        Long toCityId = (Long)((DynamicObject)to).getPkValue();
        String orgType = ErCommonUtils.getTripAreaOrgType();
        DynamicObject org = (DynamicObject)this.getModel().getValue(orgType);
        IErTripStdService stdService = new ErTripStdServiceProxy((IErTripStdService)new ErTripStdServiceImp(), this.getModel().getDataEntity()).getInstance();
        DynamicObject tripArea = stdService.getTripAreaByCityIdAndCompanyId(toCityId, ErCommonUtils.getPk((Object)org));
        if (tripArea != null) {
            if (oldValuePk == null || oldValuePk != null && !tripArea.getPkValue().equals(oldValuePk)) {
                this.getModel().setValue("tripentryarea", tripArea.getPkValue(), rowIndex);
            }
        } else {
            this.getModel().setValue("tripentryarea", null, rowIndex);
        }
    }

    private void updateDetailPropertyOfTripEntry(String propName, Object newValue, int tripEntryIndex) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection tripColl = dataEntity.getDynamicObjectCollection("tripentry");
        if (tripColl.size() > tripEntryIndex && dataEntity.getString("billkind").equals("0")) {
            DynamicObjectCollection detailColl = ((DynamicObject)tripColl.get(tripEntryIndex)).getDynamicObjectCollection("entryentity");
            IDataModel model = this.getModel();
            for (int detailIndex = 0; detailIndex < detailColl.size(); ++detailIndex) {
                if (Arrays.asList("trip2travelers", "trip2startdate", "trip2enddate", "trip2travelerscount").contains(propName) && SettlementTypeEnum.MONTH_SETTLEMENT.getCode().equals(((DynamicObject)detailColl.get(detailIndex)).get("settlementtype"))) continue;
                model.setValue(propName, newValue, detailIndex, tripEntryIndex);
            }
        }
    }

    @Override
    protected boolean checkAccdAllowanceEntryStdIsOver(DynamicObject entry, int parentEntryIndex, int curEntryIndex, StdPreCalContext stdPreCalContext) {
        DynamicObjectCollection tripEntryColl;
        logger.info(">>>>>>>checkAccdAllowanceEntryStdIsOver>>>>>>sart>>>>");
        boolean curEntryIsOver = false;
        boolean tripStdNeedOnlySumCheck = SystemParamterUtil.getTripStdNeedOnlySumCheck((long)this.getCompanyId());
        logger.debug("tripStdNeedOnlySumCheck:" + tripStdNeedOnlySumCheck);
        if (!tripStdNeedOnlySumCheck) {
            curEntryIsOver = super.checkAccdAllowanceEntryStdIsOver(entry, parentEntryIndex, curEntryIndex, stdPreCalContext);
        }
        boolean stdSumIsOver = curEntryIsOver;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String billKind = dataEntity.getString("billkind");
        boolean sumcheck = SystemParamterUtil.getTripStdNeedSumCheck((long)this.getCompanyId());
        logger.debug("sumcheck:" + sumcheck);
        if ("0".equals(billKind) && sumcheck && !entry.getBoolean("useroutstdctrl") && entry.getDynamicObject("entrycurrency") != null && (tripEntryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry")).size() > parentEntryIndex) {
            DynamicObjectCollection detailColl = ((DynamicObject)tripEntryColl.get(parentEntryIndex)).getDynamicObjectCollection("entryentity");
            stdSumIsOver = this.checkSumGroupStdIsOver(entry, detailColl, parentEntryIndex, curEntryIndex, stdPreCalContext, "expenseitem", "entrycurrency");
            String isOver = stdSumIsOver ? "1" : "0";
            for (int i = 0; i < detailColl.size(); ++i) {
                DynamicObject detailEntry = (DynamicObject)detailColl.get(i);
                if (!entry.get("expenseitem").equals(detailEntry.get("expenseitem")) || !entry.get("entrycurrency").equals(detailEntry.get("entrycurrency"))) continue;
                if (stdSumIsOver && i != curEntryIndex) {
                    this.getModel().setValue("tripstdsumupover", (Object)stdSumIsOver, i, parentEntryIndex);
                    this.getModel().setValue("isover", (Object)isOver, i, parentEntryIndex);
                    continue;
                }
                if (stdSumIsOver || i == curEntryIndex || !"1".equals(detailEntry.getString("isover"))) continue;
                if (!tripStdNeedOnlySumCheck) {
                    boolean result = super.checkAccdAllowanceEntryStdIsOver(detailEntry, parentEntryIndex, i, stdPreCalContext);
                    if (result) continue;
                    this.getModel().setValue("isover", (Object)"0", i, parentEntryIndex);
                    continue;
                }
                this.getModel().setValue("isover", (Object)"0", i, parentEntryIndex);
            }
        }
        return tripStdNeedOnlySumCheck ? stdSumIsOver : curEntryIsOver || stdSumIsOver;
    }

    private boolean checkSumGroupStdIsOver(DynamicObject entryObject, DynamicObjectCollection entryColl, int cardIndex, int rowIndex, StdPreCalContext stdPreCalContext, String ... groupPrppertyName) {
        boolean isOver = false;
        if (entryObject == null || entryColl == null || entryColl.isEmpty() || ArrayUtils.isEmpty((Object[])groupPrppertyName) || !this.isHaveProperty(entryObject, groupPrppertyName)) {
            return isOver;
        }
        Map<String, List<DynamicObject>> sumGroupEntry = entryColl.stream().filter(entry -> this.isHaveProperty((DynamicObject)entry, groupPrppertyName)).collect(Collectors.groupingBy(entry -> AbstractTripStdCtrlForCardStylePlugin.fetchGroupKey(entry, groupPrppertyName)));
        List entryOfGroup = sumGroupEntry.getOrDefault(AbstractTripStdCtrlForCardStylePlugin.fetchGroupKey(entryObject, groupPrppertyName), new ArrayList());
        BigDecimal sumStdAmount = BigDecimal.ZERO;
        BigDecimal sumReimAmount = BigDecimal.ZERO;
        DynamicObject tripExp = entryObject.getDynamicObject("expenseitem");
        if (tripExp != null) {
            BigDecimal daycount = BigDecimal.valueOf(entryObject.getInt("daycount"));
            String attributeType = tripExp.getString("attribute");
            if (StringUtils.equals((CharSequence)EXPENSE_ITEM_SUBSIDY, (CharSequence)attributeType)) {
                daycount = daycount.add(this.getTripDelayDay(cardIndex, rowIndex, this.getCompanyId()));
            }
            BigDecimal highSeasonDays = this.getTripHighDays(entryObject);
            if (!entryOfGroup.isEmpty()) {
                String mulTraStdCtrType;
                DynamicObjectCollection travelers = ((DynamicObject)entryObject.getParent()).getDynamicObjectCollection("travelers");
                List<Long> userIds = travelers.stream().filter(traveler -> traveler.get("fbasedataid") != null).map(traveler -> traveler.getLong("fbasedataid_id")).collect(Collectors.toList());
                TripStandardDetail tripStdDetail = this.getSumGroupStd(userIds, entryObject, mulTraStdCtrType = SystemParamterUtil.getMultiTravelerStdControlType((long)this.getCompanyId()), stdPreCalContext);
                if (tripStdDetail != null) {
                    BigDecimal tripSTDAmount = tripStdDetail == null ? BigDecimal.ZERO : tripStdDetail.getStandardamount();
                    BigDecimal highSeasonTripSTDAmount = tripStdDetail == null ? BigDecimal.ZERO : tripStdDetail.getHighSeasonStandardamount();
                    String attribute = entryObject.getDynamicObject("expenseitem").getString("attribute");
                    if ("5".equals(attribute) && "max".equals(mulTraStdCtrType)) {
                        StringBuilder expenseItemAccommodationBuilder = new StringBuilder();
                        expenseItemAccommodationBuilder.append("tripSTDAmount before multiply:").append(tripSTDAmount).append(";").append("userIds.size():").append(userIds == null ? null : Integer.valueOf(userIds.size())).append(";").append("highSeasonTripSTDAmount before multiply:").append(highSeasonTripSTDAmount).append(";").append("userIds.size():").append(userIds == null ? null : Integer.valueOf(userIds.size())).append(";");
                        tripSTDAmount = tripSTDAmount.multiply(BigDecimal.valueOf(userIds.size()));
                        highSeasonTripSTDAmount = highSeasonTripSTDAmount.multiply(BigDecimal.valueOf(userIds.size()));
                        expenseItemAccommodationBuilder.append("tripSTDAmount after multiply :").append(tripSTDAmount).append(";");
                        expenseItemAccommodationBuilder.append("highSeasonTripSTDAmount  after multiply :").append(highSeasonTripSTDAmount).append(";");
                        logger.debug(expenseItemAccommodationBuilder.toString());
                    }
                    StringBuilder sumStdAmountBuilderProcess = new StringBuilder();
                    sumStdAmountBuilderProcess.append("sumStdAmount:").append(sumStdAmount).append(";");
                    sumStdAmountBuilderProcess.append("tripSTDAmount:").append(tripSTDAmount).append(";");
                    sumStdAmountBuilderProcess.append("daycount:").append(daycount).append(";");
                    sumStdAmountBuilderProcess.append("highSeasonDays:").append(highSeasonDays).append(";");
                    sumStdAmountBuilderProcess.append("highSeasonTripSTDAmount:").append(highSeasonTripSTDAmount).append(";");
                    logger.debug(sumStdAmountBuilderProcess.toString());
                    sumStdAmount = sumStdAmount.add(tripSTDAmount.multiply(daycount.subtract(highSeasonDays))).add(highSeasonTripSTDAmount.multiply(highSeasonDays));
                    logger.debug("sumStdAmount after calculate:" + sumStdAmount);
                }
                StringBuilder oriEntryAmountBuilder = new StringBuilder();
                for (DynamicObject entry2 : entryOfGroup) {
                    sumReimAmount = sumReimAmount.add(entry2.getBigDecimal("orientryamount"));
                    oriEntryAmountBuilder.append("orientryamount:").append(entry2.getBigDecimal("orientryamount")).append(";").append("sumReimAmount:").append(sumReimAmount).append(";");
                }
                logger.debug(oriEntryAmountBuilder.toString());
            }
            StringBuilder builder = new StringBuilder();
            builder.append("sumReimAmount:").append(sumReimAmount).append(";").append("sumStdAmount:").append(sumStdAmount).append(";");
            logger.debug(builder.toString());
            if (sumReimAmount.compareTo(sumStdAmount) > 0) {
                isOver = true;
            }
        }
        return isOver;
    }

    @Override
    protected AbstractTripStdCtrlPlugin.CheckEntryStdResult afterCheckEntryStdIsOver(boolean entryIsOver, int tripEntryIndex, int detailIndex) {
        AbstractTripStdCtrlPlugin.CheckEntryStdResult result = super.afterCheckEntryStdIsOver(entryIsOver, tripEntryIndex, detailIndex);
        boolean isOver = result.isOver();
        if (isOver) {
            this.getModel().setValue("isoverstd", (Object)isOver, tripEntryIndex);
        } else {
            DynamicObject tripEntry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(tripEntryIndex);
            DynamicObjectCollection detailColl = tripEntry.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < detailColl.size(); ++i) {
                DynamicObject detailEntry = (DynamicObject)detailColl.get(i);
                if (!"1".equals(detailEntry.getString("isover"))) continue;
                isOver = true;
                break;
            }
            if (isOver ^ tripEntry.getBoolean("isoverstd")) {
                this.getModel().setValue("isoverstd", (Object)isOver, tripEntryIndex);
            }
        }
        return result;
    }

    private static String fetchGroupKey(DynamicObject entryObject, String ... groupPrppertyName) {
        StringBuilder sb = new StringBuilder();
        if (groupPrppertyName != null && groupPrppertyName.length > 0) {
            for (int i = 0; i < groupPrppertyName.length; ++i) {
                Object property = entryObject.get(groupPrppertyName[i]);
                if (property instanceof DynamicObject) {
                    sb.append(((DynamicObject)property).getPkValue());
                    continue;
                }
                if (property == null) continue;
                sb.append(property);
            }
        }
        return sb.toString();
    }

    private boolean isHaveProperty(DynamicObject entryObject, String ... groupPrppertyName) {
        if (ArrayUtils.isEmpty((Object[])groupPrppertyName)) {
            return false;
        }
        boolean isHave = true;
        DataEntityPropertyCollection propertyCollection = entryObject.getDataEntityType().getProperties();
        for (int i = 0; i < groupPrppertyName.length; ++i) {
            isHave = isHave && propertyCollection.containsKey((Object)groupPrppertyName[i]);
        }
        return isHave;
    }

    protected BigDecimal getTripHighDays(DynamicObject entry) {
        if (!this.isOpenHighSeasonStd()) {
            return BigDecimal.ZERO;
        }
        return entry.getBigDecimal("originhighseasondays");
    }

    protected boolean repairIFSumGroupStdIsNotOver(boolean isExpenseItem, DynamicObject expenseItemOrentryCurrency, int parentEntryIndex, int curEntryIndex) {
        boolean sumcheck = SystemParamterUtil.getTripStdNeedSumCheck((long)this.getCompanyId());
        boolean result = false;
        Long expense = null;
        Long entryCurrency = null;
        DynamicObject expenseItem = null;
        if (isExpenseItem) {
            expense = ErCommonUtils.getPk((Object)expenseItemOrentryCurrency);
            expenseItem = expenseItemOrentryCurrency;
            entryCurrency = ErCommonUtils.getPk((Object)this.getModel().getValue("entrycurrency", curEntryIndex, parentEntryIndex));
        } else {
            entryCurrency = ErCommonUtils.getPk((Object)expenseItemOrentryCurrency);
            expenseItem = (DynamicObject)this.getModel().getValue("expenseitem", curEntryIndex, parentEntryIndex);
            expense = ErCommonUtils.getPk((Object)expenseItem);
        }
        if (expense == null || entryCurrency == null || !Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(expenseItem.getString("attribute"))) {
            return result;
        }
        DynamicObjectCollection tripEntryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        if (sumcheck && tripEntryColl.size() > parentEntryIndex) {
            DynamicObjectCollection detailColl = ((DynamicObject)tripEntryColl.get(parentEntryIndex)).getDynamicObjectCollection("entryentity");
            String[] keys = new String[]{"expenseitem", "entrycurrency"};
            Map<String, List<DynamicObject>> sumGroupEntry = detailColl.stream().filter(entry -> this.isHaveProperty((DynamicObject)entry, keys)).collect(Collectors.groupingBy(entry -> AbstractTripStdCtrlForCardStylePlugin.fetchGroupKey(entry, keys)));
            StringBuilder sb = new StringBuilder();
            sb.append(expense).append(entryCurrency);
            List entryOfGroup = sumGroupEntry.getOrDefault(sb.toString(), new ArrayList());
            if (entryOfGroup.size() > 0) {
                boolean isOver = this.checkSumGroupStdIsOver((DynamicObject)entryOfGroup.get(0), detailColl, parentEntryIndex, curEntryIndex, null, keys);
                if (isOver) {
                    return result;
                }
                for (int i = 0; i < detailColl.size(); ++i) {
                    boolean check;
                    DynamicObject entry2 = (DynamicObject)detailColl.get(i);
                    if (!"1".equals(entry2.getString("isover")) || !expenseItem.equals(entry2.getDynamicObject("expenseitem")) || !entryCurrency.equals(ErCommonUtils.getPk((Object)entry2.getDynamicObject("entrycurrency"))) || (check = super.checkAccdAllowanceEntryStdIsOver(entry2, parentEntryIndex, i, null))) continue;
                    this.getModel().setValue("isover", (Object)"0", i, parentEntryIndex);
                    result = true;
                }
            }
        }
        return result;
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String name = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"entryentity")) {
            ActionLocalCache.get().put("isDeleteEntryEntity", (Object)true);
        }
    }

    @Override
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entityName = e.getEntryProp().getName();
        if ("entryentity".equals(entityName)) {
            ActionLocalCache.get().put("isDeleteEntryEntity", (Object)true);
            this.updateAllStd(false, true);
            this.setTripOver();
            this.getView().updateView("entryentity");
        }
    }

    private TripStandardDetail getSumGroupStd(List<Long> userIds, DynamicObject entryObject, String mulTraStdCtrType, StdPreCalContext stdPreCalContext) {
        StringBuilder userIdsBuilder = new StringBuilder();
        userIdsBuilder.append("userIds == null : ").append(userIds == null).append(";").append("userIds.size() : ").append(userIds.size()).append(";");
        logger.debug(userIdsBuilder.toString());
        if (userIds == null || userIds.size() == 0) {
            return null;
        }
        DynamicObject entryCurrency = entryObject.getDynamicObject("entrycurrency");
        DynamicObject tripArea = entryObject.getDynamicObject("triparea");
        DynamicObject expenseItem = entryObject.getDynamicObject("expenseitem");
        if (tripArea == null || (Long)tripArea.getPkValue() == 0L) {
            tripArea = ((DynamicObject)entryObject.getParent()).getDynamicObject("tripentryarea");
        }
        if (TripStandardUtils.threadLocal.get() == null) {
            if (entryObject.getParent() != null && entryObject.getParent() instanceof DynamicObject && ((DynamicObject)entryObject.getParent()).getParent() instanceof DynamicObject && ((DynamicObject)((DynamicObject)entryObject.getParent()).getParent()).containsProperty("billno")) {
                TripStandardUtils.threadLocal.set("AbstractTripStdCtrlForCardStylePlugin-----" + ((DynamicObject)((DynamicObject)entryObject.getParent()).getParent()).get("billno"));
            } else {
                TripStandardUtils.threadLocal.set("AbstractTripStdCtrlForCardStylePlugin-----");
            }
        }
        TripStandardDetail tripStdDetail = null;
        if (entryCurrency != null && tripArea != null) {
            List tripStdDetailList;
            String parame = (String)TripStandardUtils.threadLocal.get();
            AbstractTripStdCtrlForCardStylePlugin formPluginDe = this;
            if (parame != null && parame.contains("AbstractTripStdCtrlPlugin-submit")) {
                formPluginDe = null;
            }
            tripStdDetail = (tripStdDetailList = TripStandardUtils.getAccmodationStdFromPageCache(userIds, (AbstractFormPlugin)formPluginDe, (String)mulTraStdCtrType, (Object)entryCurrency.getPkValue(), (Object)tripArea.getPkValue(), (DynamicObject)expenseItem, this.getExtMap(entryObject, -1, -1), (StdPreCalContext)stdPreCalContext)) == null || tripStdDetailList.isEmpty() ? null : (TripStandardDetail)tripStdDetailList.get(0);
        }
        this.printStdDetail(tripStdDetail);
        return tripStdDetail;
    }

    protected void printStdDetail(TripStandardDetail tripStdDetail) {
        if (tripStdDetail == null) {
            logger.debug("tripStdDetail:" + tripStdDetail);
        } else {
            StringBuilder stdDetailBuilder = new StringBuilder("tripStdDetail ^^^^^ ");
            stdDetailBuilder.append("tripStdDetail.getCurrency():").append(tripStdDetail.getCurrency()).append(";").append("tripStdDetail.getTripstandardtype():").append(tripStdDetail.getTripstandardtype()).append(";").append("tripStdDetail.getTripArea():").append(tripStdDetail.getTripArea()).append(";").append("tripStdDetail.getUserOutStdCtrl():").append(tripStdDetail.getUserOutStdCtrl()).append(";").append("tripStdDetail.getStandardamount():").append(tripStdDetail.getStandardamount()).append(";").append("tripStdDetail.getHighSeasonStandardamount():").append(tripStdDetail.getHighSeasonStandardamount()).append(";").append("tripStdDetail.getStdAndHighSeasonDetailDes():").append(tripStdDetail.getStdAndHighSeasonDetailDes()).append(";").append("tripStdDetail.getStdDetailDes():").append(tripStdDetail.getStdDetailDes()).append(";");
            logger.debug(stdDetailBuilder.toString());
        }
    }

    protected void setTripOver() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)dataEntity.get("tripentry");
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObjectCollection entrys = ((DynamicObject)dynamicObjectCollection.get(i)).getDynamicObjectCollection("entryentity");
            if (entrys != null && entrys.stream().anyMatch(m -> m.getBoolean("isover"))) {
                this.getModel().setValue("isoverstd", (Object)true, i);
                continue;
            }
            this.getModel().setValue("isoverstd", (Object)false, i);
        }
    }
}

