/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripstandard;

import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.common.type.StandardTypeEnum;
import kd.fi.er.common.type.TripStandardBillType;

public class TripStandardListPlugin
extends AbstractListPlugin {
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        HyperLinkClickEvent event = args.getHyperLinkClickEvent();
        String fieldName = event.getFieldName();
        if ("includeperson".equals(fieldName)) {
            IListView listView = (IListView)this.getView();
            Object stdId = listView.getFocusRowPkId();
            if (stdId == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"TripStandardListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject rowData = ErDaoFactory.getInstance((String)listView.getBillFormId()).queryOne(stdId);
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("er_include_employee");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            String includeperson = rowData.getString("includeperson");
            Object pkValue = rowData.get("id");
            if (ResManager.loadKDString((String)"\u672a\u6dfb\u52a0", (String)"TripStandardListPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]).equalsIgnoreCase(includeperson)) {
                showParameter.setStatus(OperationStatus.ADDNEW);
            } else {
                showParameter.setStatus(OperationStatus.EDIT);
                IErDao dao = ErDaoFactory.getInstance((String)"er_include_employee");
                DynamicObject[] includeEmployee = dao.query(new QFilter("tripstandard", "=", pkValue));
                if (includeEmployee != null && includeEmployee.length > 0) {
                    showParameter.setPkId(includeEmployee[0].getPkValue());
                }
            }
            showParameter.setCustomParam("tripstandard", pkValue);
            showParameter.setCustomParam("sourcebilltype", (Object)rowData.getDataEntityType().getName());
            showParameter.setCustomParam("billtype", (Object)this.getBillType(rowData));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_include_employee"));
            this.getView().showForm((FormShowParameter)showParameter);
            args.setCancel(true);
        }
    }

    private int getBillType(DynamicObject rowData) {
        int billType = 0;
        if (rowData.getDataEntityType().getName().equalsIgnoreCase("er_tripstandard_vehicle")) {
            if (StandardTypeEnum.AIR.getDesc().equals(rowData.getString("standardtype"))) {
                billType = TripStandardBillType.AIR.getValue();
            } else if (StandardTypeEnum.TRAIN.getDesc().equals(rowData.getString("standardtype"))) {
                billType = TripStandardBillType.TRAIN.getValue();
            }
        } else if (rowData.getDataEntityType().getName().equalsIgnoreCase("er_tripstand_accmodation")) {
            billType = TripStandardBillType.ACCOMODATION.getValue();
        }
        return billType;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "er_tripstand_add_choice": {
                if (e.getReturnData() == null) break;
                Map returnData = (Map)e.getReturnData();
                StandardTypeEnum standardType = (StandardTypeEnum)returnData.get("standardtype");
                this.getPageCache().put("standardtype", standardType.getName());
                this.getView().invokeOperation("new");
                this.getPageCache().remove("standardtype");
                break;
            }
            case "er_include_employee": {
                this.getView().invokeOperation("refresh");
            }
        }
    }
}

