/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripstandard;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.formop.CopyEntryRow;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.web.tripstandard.AbstractTripStdCtrlForGridStylePlugin;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TripStdCtrlForGridStylePcPlugin
extends AbstractTripStdCtrlForGridStylePlugin {
    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "highseason": {
                this.getView().setVisible(Boolean.valueOf(this.existHighSeason()), new String[]{"highseasondaycount", "highseasontripstdshow"});
                break;
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(this.existHighSeason()), new String[]{"highseasondaycount", "highseasontripstdshow"});
    }

    @Override
    protected void setTripStdShowInfo(DynamicObject entry, String attribute, int parentEntryIndex, int curEntryIndex) {
        super.setTripStdShowInfo(entry, attribute, parentEntryIndex, curEntryIndex);
        BigDecimal caldaycount = entry.getBigDecimal("caldaycount");
        BigDecimal highseasondaycount = entry.getBigDecimal("highseasondaycount");
        if (this.getModel().getDataEntity().getBoolean("tripstandcon") && this.getModel().getDataEntity().getBoolean("isopentripstd") && Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute) && entry.getBoolean("highseason") && caldaycount != null && highseasondaycount != null && highseasondaycount.compareTo(caldaycount) >= 0) {
            this.getModel().setValue("tripstdshow", (Object)"", curEntryIndex, parentEntryIndex);
        }
        if (this.getModel().getDataEntity().getBoolean("tripstandcon") && this.getModel().getDataEntity().getBoolean("isopentripstd") && Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute) && !entry.getBoolean("highseason")) {
            this.getModel().setValue("highseasontripstdshow", (Object)"", curEntryIndex, parentEntryIndex);
        }
    }

    private boolean existHighSeason() {
        DynamicObjectCollection tripEntryCollction = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        if (tripEntryCollction.size() <= 0) {
            return false;
        }
        DynamicObjectCollection detailEntryCollction = ((DynamicObject)tripEntryCollction.get(0)).getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : detailEntryCollction) {
            if (!dynamicObject.getBoolean("highseason")) continue;
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        Object op = eventArgs.getSource();
        if (op instanceof CopyEntryRow && StringUtils.equals((CharSequence)((CopyEntryRow)op).getOperateKey(), (CharSequence)"copyentryentityrow")) {
            int entryCount = Integer.parseInt(this.getPageCache().get("entryentitycount"));
            this.getPageCache().remove("iscopyrow");
            Long company = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
            Long costCompany = ErCommonUtils.getPk((Object)this.getModel().getValue("costcompany"));
            DynamicObjectCollection entry = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
            Boolean paramOffset = SystemParamterUtil.manuallyaddexpenseoffset((Long)company);
            String approveTaxFormulaType = ErStdConfig.getApproveTaxFormulaType();
            boolean deductibleOfTaxPayer = InvoiceOffsetUtils.deductibleOfTaxPayer((IDataModel)this.getModel());
            IntStream.range(entryCount, entry.size()).forEach(idx -> {
                Date begin = (Date)this.getModel().getValue("trip2startdate", idx, 0);
                Date end = (Date)this.getModel().getValue("trip2enddate", idx, 0);
                DynamicObject currency = (DynamicObject)this.getModel().getValue("entrycurrency", idx, 0);
                BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", idx, 0);
                taxRate = taxRate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
                int precision = currency == null ? 10 : currency.getInt("amtprecision");
                DynamicObject item = ((DynamicObject)entry.get(idx)).getDynamicObject("expenseitem");
                if (item != null) {
                    if (begin != null && end != null && StringUtils.equalsAny((CharSequence)item.getString("attribute"), (CharSequence[])new CharSequence[]{"1", "5"})) {
                        BigDecimal calDay = new BigDecimal(CommonServiceHelper.calcDays((Date)begin, (Date)end));
                        BigDecimal tripDelayDay = this.getTripDelayDay(0, idx, company);
                        this.getModel().setValue("caldaycount", (Object)calDay.add(tripDelayDay), idx, 0);
                        this.calcuHighSeasonDay(idx, 0, true, tripDelayDay);
                    }
                    boolean offset = paramOffset != false && item.getBoolean("isoffset") && deductibleOfTaxPayer;
                    this.getModel().setValue("offset", (Object)offset, idx, 0);
                    BigDecimal expenseAmountOri = (BigDecimal)this.getModel().getValue("orientryamount", idx, 0);
                    BigDecimal airportConstructionAmount = (BigDecimal)this.getModel().getValue("airportconstructionfee", idx, 0);
                    airportConstructionAmount = (BigDecimal)ObjectUtils.defaultIfNull((Object)airportConstructionAmount, (Object)BigDecimal.ZERO);
                    BigDecimal taxAmount = expenseAmountOri.subtract(airportConstructionAmount).multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), precision, RoundingMode.HALF_EVEN);
                    this.getModel().setValue("taxamount", (Object)BigDecimal.ZERO, idx, 0);
                    this.getModel().setValue("notaxamount", (Object)BigDecimal.ZERO, idx, 0);
                    this.getModel().setValue("approvetax", (Object)BigDecimal.ZERO, idx, 0);
                    this.getModel().setValue("deductibletax", (Object)BigDecimal.ZERO, idx, 0);
                    this.getModel().setValue("price", (Object)BigDecimal.ZERO, idx, 0);
                    BigDecimal noTaxAmount = expenseAmountOri.subtract(taxAmount);
                    this.getModel().setValue("taxamount", (Object)taxAmount, idx, 0);
                    this.getModel().setValue("notaxamount", (Object)noTaxAmount, idx, 0);
                    this.getModel().setValue("approvetax", (Object)taxAmount, idx, 0);
                    this.getModel().setValue("deductibletax", (Object)(offset ? taxAmount : BigDecimal.ZERO), idx, 0);
                    InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)this.getView(), (int)idx, (int)0);
                    BigDecimal price = StringUtils.equals((CharSequence)approveTaxFormulaType, (CharSequence)"1") ? expenseAmountOri.subtract((BigDecimal)this.getModel().getValue("deductibletax", idx, 0)) : noTaxAmount;
                    this.getModel().setValue("price", (Object)price, idx, 0);
                    this.entryPropertyUpdateStd((DynamicObject)entry.get(idx), 0, idx, true, null);
                }
            });
            this.getPageCache().remove("entryentitycount");
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object op = args.getSource();
        if (op instanceof CopyEntryRow && StringUtils.equals((CharSequence)((CopyEntryRow)op).getOperateKey(), (CharSequence)"copyentryentityrow")) {
            DynamicObjectCollection entry = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
            this.getPageCache().put("entryentitycount", String.valueOf(entry.size()));
            this.getPageCache().put("iscopyrow", "true");
        }
    }
}

