/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.common.model.invoice;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.er.common.model.invoice.InvoiceOCRVO;

public class Invoice {
    private String billid;
    private String serialNo;
    private InvoiceOCRVO invoiceVO;
    private Map<String, String> invoiceMap;
    private Map<String, String> invoiceItemMap;

    public Invoice(DynamicObject bill) {
        this.billid = bill.getString("billid");
        this.initMap(bill.getDynamicObjectCollection("entrykeyvalue"), bill.getDynamicObjectCollection("entryentity"));
    }

    private void initMap(DynamicObjectCollection invoiceColl, DynamicObjectCollection invoiceItemColl) {
        this.invoiceMap = new HashMap<String, String>(invoiceColl.size());
        for (DynamicObject invoice : invoiceColl) {
            this.invoiceMap.put(invoice.getString("invoicekey"), invoice.getString("invoicevalue"));
        }
        String invoiceJson = JSON.toJSONString(this.invoiceMap);
        this.invoiceVO = (InvoiceOCRVO)JSON.parseObject((String)invoiceJson, InvoiceOCRVO.class);
        if (invoiceItemColl.size() > 0) {
            this.invoiceItemMap = new HashMap<String, String>(invoiceItemColl.size());
            for (DynamicObject invoice : invoiceItemColl) {
                String key = invoice.getString("invoiceentrykey");
                String value = this.invoiceItemMap.get(key);
                String entryValue = invoice.getString("invoiceentryvalue");
                if (entryValue != null) {
                    if (entryValue.indexOf("%") != -1) {
                        entryValue = entryValue.replace("%", "");
                    }
                    if (entryValue.equals("0")) {
                        entryValue = "";
                    }
                }
                value = StringUtils.isBlank((CharSequence)value) ? entryValue : value + "," + entryValue;
                this.invoiceItemMap.put(key, value);
            }
        }
        this.serialNo = this.invoiceMap.get("serialNo");
    }

    public String getBillid() {
        return this.billid;
    }

    public void setBillid(String billid) {
        this.billid = billid;
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public Map<String, String> getInvoiceMap() {
        return this.invoiceMap;
    }

    public void setInvoiceMap(Map<String, String> invoiceMap) {
        this.invoiceMap = invoiceMap;
    }

    public Map<String, String> getInvoiceItemMap() {
        return this.invoiceItemMap;
    }

    public void setInvoiceItemMap(Map<String, String> invoiceItemMap) {
        this.invoiceItemMap = invoiceItemMap;
    }

    public InvoiceOCRVO getInvoiceVO() {
        return this.invoiceVO;
    }

    public void setInvoiceVO(InvoiceOCRVO invoiceVO) {
        this.invoiceVO = invoiceVO;
    }
}

