/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.common.model.invoice.bo;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RelationBO {
    private Long itemId;
    private String number;
    private Map<String, Object> factorMap = new HashMap<String, Object>();
    private List<InvoiceOtherMapFactor> invoiceOtherMapFactorList = new ArrayList<InvoiceOtherMapFactor>();
    private long createOrgId;
    private Date modifyTime;
    private String relbilltype;
    private String autoMapFormula;
    private int rightCount;
    private Map<String, InvoiceTextFactorMappingReslut> otherFactorMapResult = new HashMap<String, InvoiceTextFactorMappingReslut>();
    private Map<String, Boolean> factorMapResult = new HashMap<String, Boolean>();
    private List<String> priorityList;

    public RelationBO(Long itemId, List<String> priorityList) {
        this.init();
        this.itemId = itemId;
        this.priorityList = priorityList;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public Object getFactorInfo(String key) {
        return this.factorMap.get(key);
    }

    public void putFactorInfo(String key, Object value) {
        this.factorMap.put(key, value);
    }

    public int getAccordWith() {
        return this.rightCount;
    }

    public Map<String, InvoiceTextFactorMappingReslut> getOtherFactorMapResult() {
        return this.otherFactorMapResult;
    }

    public void setOtherFactorMapResult(Map<String, InvoiceTextFactorMappingReslut> otherFactorMapResult) {
        this.otherFactorMapResult = otherFactorMapResult;
    }

    public Map<String, Boolean> getFactorMapResult() {
        return this.factorMapResult;
    }

    public void setFactorMapResult(Map<String, Boolean> factorMapResult) {
        this.factorMapResult = factorMapResult;
    }

    public Map<String, Object> getFactorMap() {
        return this.factorMap;
    }

    public void setFactorMap(Map<String, Object> factorMap) {
        this.factorMap = factorMap;
    }

    public int getRightCount() {
        return this.rightCount;
    }

    public void setRightCount(int rightCount) {
        this.rightCount = rightCount;
    }

    public void setAutoMapFormula(String autoMapFormula) {
        this.autoMapFormula = autoMapFormula;
    }

    public String getAutoMapFormula() {
        return this.autoMapFormula;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setMapResult(boolean result, String key) {
        if (result) {
            ++this.rightCount;
            this.factorMapResult.put(key, true);
        } else if ("2".equalsIgnoreCase(this.getAutoMapFormula())) {
            this.rightCount = -1;
        }
    }

    public void setMapResult(boolean result, String factorKey, String mapType) {
        Boolean typeResult;
        InvoiceTextFactorMappingReslut mapResult = this.otherFactorMapResult.get(factorKey);
        if (mapResult == null) {
            mapResult = new InvoiceTextFactorMappingReslut();
            this.otherFactorMapResult.put(factorKey, mapResult);
        }
        if ((typeResult = mapResult.getMapResult().get(mapType)) == null) {
            mapResult.getMapResult().put(mapType, result);
        } else if (result) {
            mapResult.getMapResult().put(mapType, true);
        }
        if (result) {
            ++this.rightCount;
        }
    }

    public int compareTo(RelationBO other) {
        if (other == null) {
            return 1;
        }
        if ("2".equalsIgnoreCase(this.getAutoMapFormula())) {
            if (this.getAccordWith() == other.getAccordWith()) {
                return 0;
            }
            if (this.getAccordWith() > other.getAccordWith()) {
                return 1;
            }
            return -1;
        }
        for (String key : this.priorityList) {
            int compareResult;
            Boolean otherResult;
            Boolean thisResult;
            InvoiceTextFactorMappingReslut thisFactor = this.otherFactorMapResult.get(key);
            InvoiceTextFactorMappingReslut otherFactor = other.getOtherFactorMapResult().get(key);
            if (thisFactor != null || otherFactor != null) {
                thisResult = thisFactor == null ? Boolean.valueOf(false) : thisFactor.getMapResult().get("0");
                compareResult = this.compare(thisResult, otherResult = otherFactor == null ? Boolean.valueOf(false) : otherFactor.getMapResult().get("0"));
                if (compareResult == -2) {
                    thisResult = thisFactor == null ? Boolean.valueOf(false) : thisFactor.getMapResult().get("1");
                    otherResult = otherFactor == null ? Boolean.valueOf(false) : otherFactor.getMapResult().get("1");
                    compareResult = this.compare(thisResult, otherResult);
                }
                if (compareResult == -2) continue;
                return compareResult;
            }
            thisResult = this.factorMapResult.get(key);
            compareResult = this.compare(thisResult, otherResult = other.getFactorMapResult().get(key));
            if (compareResult == -2) continue;
            return compareResult;
        }
        return -2;
    }

    private int compare(Boolean thisResult, Boolean otherResult) {
        if (thisResult == null) {
            thisResult = Boolean.FALSE;
        }
        if (otherResult == null) {
            otherResult = Boolean.FALSE;
        }
        if (thisResult.booleanValue() && otherResult.booleanValue()) {
            return 0;
        }
        if (!thisResult.booleanValue() && !otherResult.booleanValue()) {
            return -2;
        }
        if (thisResult.booleanValue()) {
            return 1;
        }
        if (otherResult.booleanValue()) {
            return -1;
        }
        return -2;
    }

    public boolean realMapResult() {
        int result = this.factorMap.size() + this.invoiceOtherMapFactorList.size();
        return result == this.rightCount;
    }

    public final void init() {
        this.rightCount = 0;
        this.factorMapResult = new HashMap<String, Boolean>();
        this.otherFactorMapResult = new HashMap<String, InvoiceTextFactorMappingReslut>();
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public long getCreateOrgId() {
        return this.createOrgId;
    }

    public void setCreateOrgId(long createOrgId) {
        this.createOrgId = createOrgId;
    }

    public String getRelbilltype() {
        return this.relbilltype;
    }

    public void setRelbilltype(String relbilltype) {
        this.relbilltype = relbilltype;
    }

    public List<InvoiceOtherMapFactor> getInvoiceOtherMapFactorList() {
        return this.invoiceOtherMapFactorList;
    }

    public void setInvoiceOtherMapFactorList(List<InvoiceOtherMapFactor> invoiceOtherMapFactorList) {
        this.invoiceOtherMapFactorList = invoiceOtherMapFactorList;
    }

    public List<String> getPriorityList() {
        return this.priorityList;
    }

    public void setPriorityList(List<String> priorityList) {
        this.priorityList = priorityList;
    }

    public String toString() {
        return "RelationBO{itemId=" + this.itemId + ", rightCount=" + this.rightCount + ", otherFactorMapResult=" + this.otherFactorMapResult + ", factorMapResult=" + this.factorMapResult + ", priorityList=" + this.priorityList + '}';
    }

    private static class InvoiceTextFactorMappingReslut {
        private Map<String, Boolean> mapResult = new HashMap<String, Boolean>();

        private InvoiceTextFactorMappingReslut() {
        }

        public Map<String, Boolean> getMapResult() {
            return this.mapResult;
        }
    }

    public static class InvoiceOtherMapFactor {
        private String mappingType;
        private String invoiceFactor;
        private Set<String> mapFactor = new HashSet<String>();

        public String getMappingType() {
            return this.mappingType;
        }

        public void setMappingType(String mappingType) {
            this.mappingType = mappingType;
        }

        public String getInvoiceFactor() {
            return this.invoiceFactor;
        }

        public void setInvoiceFactor(String invoiceFactor) {
            this.invoiceFactor = invoiceFactor;
        }

        public Set<String> getMapFactor() {
            return this.mapFactor;
        }

        public void setMapFactor(Set<String> mapFactor) {
            this.mapFactor = mapFactor;
        }

        public String toString() {
            return "InvoiceOtherMapFactor{mappingType='" + this.mappingType + '\'' + ", invoiceFactor='" + this.invoiceFactor + '\'' + ", mapFactor=" + this.mapFactor + '}';
        }
    }
}

