/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.common.utils;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.common.model.invoice.OperationConfigBo;
import kd.fi.er.common.model.invoice.QuickConfigBo;

public class InvoiceCloudUtil {
    public static QuickConfigBo buildQuickConfigBo(DynamicObject quickConfig) {
        QuickConfigBo config = new QuickConfigBo();
        DynamicObject group = quickConfig.getDynamicObject("group");
        DynamicObject bizItem = quickConfig.getDynamicObject("bizitem");
        QFilter qFilter = new QFilter("billgroup", "=", group.getPkValue());
        qFilter.and("bizitem", "=", bizItem.getPkValue());
        qFilter.and("isdefault", "=", (Object)true);
        DynamicObjectCollection pgInfoCollection = QueryServiceHelper.query((String)"er_invoicepginfo", (String)"id,number,bizitem,billgroup,isdefault,clienttype,pluginpath", (QFilter[])new QFilter[]{qFilter});
        config.setId((Long)quickConfig.getPkValue());
        config.setName(quickConfig.getLocaleString("formtitle").getLocaleValue());
        config.setNumber(quickConfig.getString("number"));
        config.setSrcFormId(group.getString("number"));
        config.setCreateOrgId((Long)quickConfig.getDynamicObject("createorg").getPkValue());
        config.setReimburseType(quickConfig.getString("reimbursetype"));
        config.setMenuImg(quickConfig.getString("picturefield"));
        config.setGroup((Long)group.getPkValue());
        config.setBizItem((Long)bizItem.getPkValue());
        if (!pgInfoCollection.isEmpty()) {
            DynamicObject invoicePlugin = (DynamicObject)pgInfoCollection.get(0);
            config.getOperation().setId((Long)invoicePlugin.getPkValue());
            config.getOperation().setNumber(invoicePlugin.getString("number"));
            config.getOperation().setBillGroup((Long)invoicePlugin.getDynamicObject("billgroup").getPkValue());
            config.getOperation().setBizItem((Long)invoicePlugin.getDynamicObject("bizitem").getPkValue());
            config.getOperation().setDefault(invoicePlugin.getBoolean("isdefault"));
            config.getOperation().setClientType(invoicePlugin.getString("clienttype"));
            config.getOperation().setPluginPath(invoicePlugin.getString("pluginpath"));
        }
        return config;
    }

    public static OperationConfigBo buildOperationConfigBo(DynamicObject quickConfig) {
        OperationConfigBo op = new OperationConfigBo();
        op.setId((Long)quickConfig.getPkValue());
        op.setNumber(quickConfig.getString("number"));
        op.setName(quickConfig.getString("name"));
        op.setBillType(quickConfig.getString("billtype"));
        op.setClientType(quickConfig.getString("clienttype"));
        op.setClickSign(quickConfig.getString("clicksign"));
        op.setPluginPath(quickConfig.getString("pluginpath"));
        return op;
    }

    public static OperationConfigBo getInvoicePlugin(String billEntityId, boolean isPc, String clickSign) {
        QFilter filter = new QFilter("billtype", "=", (Object)billEntityId);
        filter.and("clienttype", "=", (Object)(isPc ? "1" : "0"));
        filter.and("clicksign", "=", (Object)clickSign);
        filter.and("enable", "=", (Object)"1");
        DynamicObject pluginDyObject = BusinessDataServiceHelper.loadSingle((String)"er_invoicepginfo", (QFilter[])new QFilter[]{filter});
        if (pluginDyObject == null) {
            return null;
        }
        OperationConfigBo operationConfigBo = InvoiceCloudUtil.buildOperationConfigBo(pluginDyObject);
        return operationConfigBo;
    }
}

