/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.common.utils;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;

public class KsqlHelper {
    public static void exportSQLByEntity(String entityName, List<String> idornumbers, IFormView view) {
        DynamicObjectCollection dynamicObjects;
        ArrayList<Object> ids;
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)entityName).getProperties();
        if (properties.get((Object)"id") instanceof LongProp) {
            ids = new ArrayList<Object>(idornumbers.size());
            for (String idornumber : idornumbers) {
                ids.add(Long.parseLong(idornumber));
            }
            dynamicObjects = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter("id", "in", ids).toArray());
        } else {
            dynamicObjects = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter("id", "in", idornumbers).toArray());
        }
        if (dynamicObjects == null && EntityMetadataCache.getDataEntityType((String)entityName).getProperties().containsKey((Object)"number")) {
            dynamicObjects = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter("number", "in", idornumbers).toArray());
        }
        if (dynamicObjects == null) {
            return;
        }
        ids = new ArrayList(dynamicObjects.size());
        for (Object dynamicObject : dynamicObjects) {
            ids.add(dynamicObject.getString("id"));
        }
        try {
            ArrayList<String> urls = new ArrayList<String>(ids.size());
            for (String string : ids) {
                List<String> sqls = KsqlHelper.genSQLScript(entityName, string);
                String fileName = string + ".sql";
                String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, sqls.get(0).getBytes(StandardCharsets.UTF_8), 300);
                urls.add(url);
                if (sqls.size() <= 1) continue;
                fileName = string + ".xml";
                String url2 = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, sqls.get(1).getBytes(StandardCharsets.UTF_8), 300);
                urls.add(url2);
            }
            String zipName = entityName + ".zip";
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().compress(zipName, urls.toArray(new String[0]), 300);
            view.openUrl(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<String> genSQLScript(String entityName, String id) {
        ArrayList<String> s = new ArrayList<String>(2);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        Map allEntities = dataEntityType.getAllEntities();
        Set entrySet = allEntities.entrySet();
        LinkedList<String> tableNameList = new LinkedList<String>();
        for (Map.Entry mapEntry : entrySet) {
            EntityType entityType = (EntityType)mapEntry.getValue();
            if (entityType instanceof LinkEntryType) continue;
            String tableName = entityType.getAlias().toUpperCase(Locale.ROOT);
            tableNameList.add(tableName);
            boolean hasMultiLang = entityType.getProperties().stream().anyMatch(v -> v instanceof MuliLangTextProp);
            if (!hasMultiLang) continue;
            tableName = tableName + "_L";
            tableNameList.add(tableName);
        }
        String dbRouteKey = dataEntityType.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        String strWhere = "fid in (" + id + ")";
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        StringBuilder finalSql = new StringBuilder();
        StringBuilder finalXml = new StringBuilder();
        for (String tableName : tableNameList) {
            Object xmlGened;
            if (null == tableName || tableName.isEmpty()) continue;
            Map map = builder.genInsertSQLScript(dbRoute, tableName, KsqlHelper.getTableFields(dbRoute, tableName), strWhere, "", "");
            Object sqlGened = map.get("sql");
            if (sqlGened != null && !sqlGened.toString().trim().isEmpty()) {
                finalSql.append(sqlGened);
            }
            if ((xmlGened = map.get("xml")) == null || xmlGened.toString().trim().isEmpty()) continue;
            finalXml.append(xmlGened);
        }
        s.add(finalSql.toString());
        s.add(finalXml.toString());
        return s;
    }

    public static String getTableFields(DBRoute dbRoute, Object tableName) {
        String sql = String.format("/*dialect*/select * from %s where 1=2", tableName.toString());
        DataSet ds = DB.queryDataSet((String)"getTableFields", (DBRoute)dbRoute, (String)sql);
        String selectfield = Stream.of(ds.getRowMeta().getFields()).map(Field::getName).collect(Collectors.joining(","));
        return selectfield;
    }

    public static void exportSchedulKsql(List<String> idornumbers, IFormView view) {
        DynamicObjectCollection schedules = QueryServiceHelper.query((String)"sch_schedule", (String)"id,job,number", (QFilter[])new QFilter("number", "in", idornumbers).toArray());
        if (schedules == null) {
            schedules = QueryServiceHelper.query((String)"sch_schedule", (String)"id,job,number", (QFilter[])new QFilter("id", "in", idornumbers).toArray());
        }
        if (schedules == null) {
            return;
        }
        ArrayList<String> urls = new ArrayList<String>(5);
        for (DynamicObject schedule : schedules) {
            String scheduleid = schedule.getString("id");
            String number = schedule.getString("number");
            String jobId = schedule.getString("job");
            StringBuilder builder = new StringBuilder();
            builder.append(KsqlHelper.genSQLScript("T_SCH_SCHEDULE", scheduleid));
            builder.append(KsqlHelper.genSQLScript("T_SCH_SCHEDULE_N", scheduleid));
            builder.append(KsqlHelper.genSQLScript("T_SCH_JOB", jobId));
            DynamicObject job = QueryServiceHelper.queryOne((String)"sch_job", (String)"id,number,taskclassname", (QFilter[])new QFilter("id", "=", (Object)jobId).toArray());
            String taskId = job.getString("taskclassname");
            builder.append(KsqlHelper.genSQLScript("T_SCH_TASKDEFINE", taskId));
            builder.append(KsqlHelper.genSQLScript("T_SCH_TASKDEFENTRY", taskId));
            String fileName = number + ".sql";
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, builder.toString().getBytes(StandardCharsets.UTF_8), 300);
            urls.add(url);
        }
        try {
            String zipName = "T_SCH_SCHEDULE.zip";
            String zipUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().compress(zipName, urls.toArray(new String[0]), 300);
            view.openUrl(zipUrl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

