/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.model;

import java.io.Serializable;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.base.MobileBaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.report.ReportShowParameter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;

@KSObject
public class FormModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String formId;
    private String formName;
    private String formType;
    private Boolean callBack;
    private Map<String, Object> customParam;
    private ShowType showType;
    private String templateId;
    private Boolean lookup;
    private FormShowParameter formShowParameter;
    private String targetKey;
    private ListFilterParameter listFilterParameter;
    private Boolean closeCurrentPage;
    private int width = Integer.MIN_VALUE;
    private int height = Integer.MIN_VALUE;
    private boolean showTitle = true;

    public FormModel(String formId) {
        this.formId = formId;
        this.callBack = false;
        this.formType = "14";
    }

    public FormModel(String formId, String formName, String formType) {
        this(formId, formName, formType, false);
    }

    public FormModel(String formId, String formName, String formType, boolean callBack) {
        this(formId, formName, formType, callBack, null);
    }

    public FormModel(String formId, String formName, String formType, boolean callBack, Map<String, Object> customParam) {
        this.formId = formId;
        this.formName = formName;
        this.formType = formType;
        this.callBack = callBack;
        this.customParam = customParam;
    }

    @KSMethod
    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getFormType() {
        return this.formType;
    }

    public void setFormType(String formType) {
        this.formType = formType;
    }

    @KSMethod
    public Boolean getCallBack() {
        if (this.callBack == null) {
            return Boolean.FALSE;
        }
        return this.callBack;
    }

    public void setCallBack(Boolean callBack) {
        this.callBack = callBack;
    }

    public Map<String, Object> getCustomParam() {
        return this.customParam;
    }

    public void setCustomParam(Map<String, Object> customParam) {
        this.customParam = customParam;
    }

    public ShowType getShowType() {
        if (this.showType == null) {
            switch (this.formType) {
                case "7": 
                case "2": 
                case "1": 
                case "0": 
                case "3": 
                case "9": {
                    this.showType = ShowType.MainNewTabPage;
                    break;
                }
                case "14": 
                case "15": {
                    this.showType = ShowType.Modal;
                    break;
                }
                case "8": 
                case "10": 
                case "6": 
                case "4": 
                case "5": {
                    this.showType = ShowType.Floating;
                    break;
                }
                case "11": 
                case "12": {
                    this.showType = ShowType.NewWindow;
                    break;
                }
            }
        }
        return this.showType;
    }

    public void setShowType(ShowType showType) {
        this.showType = showType;
    }

    public String getTemplateId() {
        if (this.templateId == null) {
            switch (this.formType) {
                case "0": {
                    this.templateId = "bos_list";
                    break;
                }
                case "9": {
                    this.templateId = "bos_treelist";
                    break;
                }
                case "10": {
                    this.templateId = "er_basetemplate";
                    break;
                }
                case "4": 
                case "12": {
                    this.templateId = "er_billtemplate";
                    break;
                }
            }
        }
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public Boolean getLookup() {
        if (this.lookup == null) {
            return Boolean.FALSE;
        }
        return this.lookup;
    }

    public void setLookup(Boolean lookup) {
        this.lookup = lookup;
    }

    @KSMethod
    public FormShowParameter getFormShowParameter() {
        switch (this.formType) {
            case "0": 
            case "9": {
                this.formShowParameter = new ListShowParameter();
                break;
            }
            case "1": 
            case "14": {
                this.formShowParameter = new FormShowParameter();
                break;
            }
            case "2": {
                this.formShowParameter = new BillShowParameter();
                break;
            }
            case "3": {
                this.formShowParameter = new ReportShowParameter();
                break;
            }
            case "7": {
                this.formShowParameter = new BaseShowParameter();
                break;
            }
            case "5": 
            case "11": {
                this.formShowParameter = new MobileFormShowParameter();
                break;
            }
            case "6": {
                this.formShowParameter = new MobileBillShowParameter();
                break;
            }
            case "4": 
            case "10": 
            case "12": {
                this.formShowParameter = new MobileListShowParameter();
                break;
            }
            case "8": {
                this.formShowParameter = new MobileBaseShowParameter();
                break;
            }
            case "13": 
            case "15": {
                this.formShowParameter = new MobileFormShowParameter();
                break;
            }
        }
        if (this.formShowParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.formShowParameter;
            listShowParameter.setBillFormId(this.getFormId());
            listShowParameter.setFormId(this.getTemplateId());
            listShowParameter.setLookUp(this.getLookup().booleanValue());
            listShowParameter.setListFilterParameter(this.getListFilterParameter());
        } else {
            this.formShowParameter.setFormId(this.getFormId());
        }
        this.formShowParameter.getOpenStyle().setShowType(this.getShowType());
        this.formShowParameter.getOpenStyle().setTargetKey(this.getTargetKey());
        this.formShowParameter.setCaption(this.getFormName());
        if (this.getCustomParam() != null) {
            this.formShowParameter.getCustomParams().putAll(this.getCustomParam());
        }
        this.formShowParameter.getOpenStyle().setShowType(this.getShowType());
        if (this.width > Integer.MIN_VALUE && this.height > Integer.MIN_VALUE) {
            StyleCss inlineStyleCss = new StyleCss();
            inlineStyleCss.setWidth(String.valueOf(this.width));
            inlineStyleCss.setHeight(String.valueOf(this.height));
            this.formShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        }
        this.formShowParameter.setShowTitle(this.showTitle);
        return this.formShowParameter;
    }

    public String getTargetKey() {
        if (this.targetKey == null) {
            switch (this.formType) {
                case "7": 
                case "2": 
                case "1": 
                case "0": 
                case "3": 
                case "9": {
                    this.targetKey = "_submaintab_";
                    break;
                }
            }
        }
        return this.targetKey;
    }

    public void setTargetKey(String targetKey) {
        this.targetKey = targetKey;
    }

    public ListFilterParameter getListFilterParameter() {
        return this.listFilterParameter;
    }

    public void setListFilterParameter(ListFilterParameter listFilterParameter) {
        this.listFilterParameter = listFilterParameter;
    }

    public Boolean getCloseCurrentPage() {
        if (this.closeCurrentPage == null) {
            return Boolean.FALSE;
        }
        return this.closeCurrentPage;
    }

    public void setCloseCurrentPage(Boolean closeCurrentPage) {
        this.closeCurrentPage = closeCurrentPage;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }
}

