/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report;

import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.fi.er.business.servicehelper.CheckingBillServiceHelper;
import org.apache.commons.lang.StringUtils;

public class CheckingPayRpt
extends AbstractReportFormPlugin {
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList billList = (ReportList)this.getControl("reportlistap");
        final IPageCache pageCache = this.getPageCache();
        billList.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent e) {
                int currentRow = e.getRow();
                pageCache.put("rowIndex", String.valueOf(currentRow));
            }

            public void cellDoubleClick(CellClickEvent e) {
            }
        });
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("vieworderbtn".equalsIgnoreCase(key)) {
            this.showOrderBill();
        } else if ("paybtn".equalsIgnoreCase(key)) {
            this.createPaymentBill();
        }
    }

    private void createPaymentBill() {
    }

    private void showOrderBill() {
        IPageCache pageCache = this.getPageCache();
        IReportView view = this.getView();
        ReportList billList = (ReportList)this.getControl("reportlistap");
        if (!StringUtils.isNotBlank((String)pageCache.get("rowIndex"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CheckingPayRpt_0", (String)"fi-er-report", (Object[])new Object[0]));
            return;
        }
        int rowIndex = Integer.parseInt(pageCache.get("rowIndex"));
        DynamicObject currentRowData = billList.getReportModel().getRowData(rowIndex);
        String period = currentRowData.getString("periodcol");
        String[] periodArr = period.split("\\.");
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, Integer.parseInt(periodArr[0]));
        calendar.set(2, Integer.parseInt(periodArr[1]) - 1);
        Date periodDate = calendar.getTime();
        CheckingBillServiceHelper.CheckDateRange orderDateRange = CheckingBillServiceHelper.getCheckDateRange((Date)periodDate);
        Date startDate = orderDateRange.getStartDate();
        Date endDate = orderDateRange.getEndDate();
        Long companyId = (Long)currentRowData.getDynamicObject("companycol").getPkValue();
        String operationType = currentRowData.getString("operationtypecol");
        String orderFormId = currentRowData.getString("orderformid");
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId(orderFormId);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        String filterStr = "company=? and operationtype=? and happenddate>=? and happenddate<=? and producttype!=2";
        QFilter orderListFilter = QFilter.of((String)filterStr, (Object[])new Object[]{companyId, operationType, startDate, endDate});
        listFilterParameter.setFilter(orderListFilter);
        listShowParameter.setListFilterParameter(listFilterParameter);
        view.showForm((FormShowParameter)listShowParameter);
    }
}

