/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.invoice.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.servicehelper.ErPermissionServiceHelper;
import kd.fi.er.report.invoice.service.util.InvoiceRptSQL;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractInvoiceInfoDataSet {
    public static final String algoKey = "kd.fi.er.report.invoice.service.dataset";
    public static final int maxInParamsLimit = 500000;
    private static Log logger = LogFactory.getLog(AbstractInvoiceInfoDataSet.class);
    private String billType;
    private Map<String, Set<Long>> permOrgMap = null;

    @Deprecated
    protected AbstractInvoiceInfoDataSet(String billType) {
        this.billType = billType;
    }

    protected AbstractInvoiceInfoDataSet(String billType, Map<String, Set<Long>> permOrgMap) {
        this.billType = billType;
        this.permOrgMap = permOrgMap;
    }

    public DataSet getDataSet(FilterInfo filterInfo, List<Long> batchFilter) {
        logger.info("\u62a5\u8868\u67e5\u8be2 getDataSet \u6267\u884c " + this.getBillType() + " \u5f00\u59cb");
        List<QFilter> historyInvoiceInfoFilter = this.getHistoryInfoFilter(filterInfo, this.getBillType());
        if (!CollectionUtils.isEmpty(batchFilter)) {
            historyInvoiceInfoFilter.add(new QFilter("id", "in", batchFilter));
        }
        DataSet historyInvoiceInfoSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"er_invoiceinforptbill", (String)this.getHistoryInvoiceSelectFieldsSQL(), (QFilter[])historyInvoiceInfoFilter.toArray(new QFilter[0]), null);
        String billSelectSQL = this.getHistoryBillSelectFieldsSQL().replace("billtype", String.format("'%s' as billtype", this.billType));
        Object[] historyBills = this.mapValCollects2List(historyInvoiceInfoSet, "excelbillno");
        QFilter billNoFilter = new QFilter("billno", "in", (Object)historyBills);
        List<QFilter> historyBillInfoFilters = this.getHistoryBillInfoFilter(filterInfo);
        AbstractInvoiceInfoDataSet.addList(historyBillInfoFilters, billNoFilter);
        DataSet historyBillDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)this.billType, (String)billSelectSQL, (QFilter[])historyBillInfoFilters.toArray(new QFilter[0]), null);
        DataSet historyDataSet = historyInvoiceInfoSet.join(historyBillDataSet, JoinType.INNER).on("excelbillno", "billno").select(InvoiceRptSQL.joinSelectFieldsHistory).finish();
        DataSet mainDataSet = this.getMainDataSet(filterInfo, historyBills, batchFilter);
        DataSet result = historyDataSet.union(mainDataSet);
        DataSet dapDataSet = this.getDapDataSet(filterInfo, result);
        List<String> fields = Stream.of(result.getRowMeta().getFields()).map(Field::getName).collect(Collectors.toList());
        JoinType dapJoinType = JoinType.LEFT;
        if (!this.getDapFilter(filterInfo).isEmpty() && !AbstractInvoiceInfoDataSet.orLogic(filterInfo)) {
            dapJoinType = JoinType.RIGHT;
        }
        DataSet finish = result.join(dapDataSet, dapJoinType).on("id", "sourcebillid").select(fields.toArray(new String[0]), new String[]{"voucherdate", "voucherdatenew", "vouchercode", "vouchertype", "vouchercreator", "voucherid", "voucherinfo"}).finish();
        QFilter invoiceItemQF = AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoicefrom", "invoicefrom");
        if (invoiceItemQF != null) {
            finish = finish.filter(invoiceItemQF.toString());
        }
        if (this.existExt()) {
            DataSet ret1 = finish.filter("vouchercode is not null");
            DataSet ret2 = finish.filter("vouchercode is null");
            DataSet dapDataSetByBill = this.getDapDataSetByBillInfo(filterInfo, ret2);
            return ret1.union(ret2.join(dapDataSetByBill, JoinType.LEFT).on("id", "fid").select(fields.toArray(new String[0]), new String[]{"voucherdate", "voucherdatenew", "vouchercode", "vouchertype", "vouchercreator", "voucherid", "voucherinfo"}).finish());
        }
        logger.info("\u62a5\u8868\u67e5\u8be2 getDataSet \u6267\u884c " + this.getBillType() + " \u7ed3\u675f");
        return finish;
    }

    private boolean existExt() {
        return MetadataServiceHelper.getDataEntityType((String)this.billType).getProperty("vouchercode") != null;
    }

    private DataSet getDapDataSetByBillInfo(FilterInfo filterInfo, DataSet resultDataSet) {
        DataSet filterDs = resultDataSet.copy();
        Object[] ids = this.mapValCollects2List(filterDs, "id");
        DataSet billInfoDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)this.billType, (String)"id as fid,to_char(voucherdate,'yyyy-MM-dd') as voucherdate , voucherdate as voucherdatenew,vouchercode, 0 as voucherid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)}, null);
        return billInfoDs;
    }

    private DataSet getDapDataSet(FilterInfo filterInfo, DataSet resultDataSet) {
        Object[] ids = this.mapValCollects2List(resultDataSet, "id");
        List<QFilter> dapFilter = this.getDapFilter(filterInfo);
        int batchSize = 500000;
        int batchCount = (ids.length + batchSize - 1) / batchSize;
        DataSet dataSet = null;
        if (ids.length == 0) {
            DataSet relationDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", (Object)ids)}, null);
            Object[] voucherIds = this.mapValCollects2List(relationDs, "voucherid");
            dapFilter.add(new QFilter("id", "in", (Object)voucherIds));
            DataSet voucherDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"gl_voucher", (String)"billno, to_char(bookeddate,'yyyy-MM-dd') as voucherdate, bookeddate as voucherdatenew, id,vouchertype.id,vouchertype.name,creator.id,creator.name", (QFilter[])dapFilter.toArray(new QFilter[0]), null);
            JoinDataSet result = relationDs.join(voucherDs).on("voucherid", "id").select(new String[]{"sourcebillid", "voucherid", "billno as vouchercode", "vouchertype.id as vouchertype", "creator.id as vouchercreator", "voucherdate", "voucherdatenew", "vouchertype.name + '-'+ billno +'-' +creator.name as voucherinfo"});
            return result.finish();
        }
        for (int i = 0; i < batchCount; ++i) {
            int start = i * batchSize;
            int end = Math.min(start + batchSize, ids.length);
            Object[] batchIds = Arrays.copyOfRange(ids, start, end);
            DataSet relationDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", (Object)batchIds)}, null);
            Object[] voucherIds = this.mapValCollects2List(relationDs, "voucherid");
            if (voucherIds.length == 0) {
                dapFilter.add(new QFilter("id", "in", (Object)voucherIds));
                DataSet voucherDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"gl_voucher", (String)"billno, to_char(bookeddate,'yyyy-MM-dd') as voucherdate, bookeddate as voucherdatenew, id,vouchertype.id,vouchertype.name,creator.id,creator.name", (QFilter[])dapFilter.toArray(new QFilter[0]), null);
                JoinDataSet result = relationDs.join(voucherDs).on("voucherid", "id").select(new String[]{"sourcebillid", "voucherid", "billno as vouchercode", "vouchertype.id as vouchertype", "creator.id as vouchercreator", "voucherdate", "voucherdatenew", "vouchertype.name + '-'+ billno +'-' +creator.name as voucherinfo"});
                dataSet = dataSet == null ? result.finish() : dataSet.union(result.finish());
                dapFilter.remove(dapFilter.size() - 1);
            }
            int batchCount1 = (voucherIds.length + batchSize - 1) / batchSize;
            for (int j = 0; j < batchCount1; ++j) {
                int start1 = j * batchSize;
                int end1 = Math.min(start1 + batchSize, voucherIds.length);
                Object[] batchIds1 = Arrays.copyOfRange(voucherIds, start1, end1);
                dapFilter.add(new QFilter("id", "in", (Object)batchIds1));
                DataSet voucherDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"gl_voucher", (String)"billno, to_char(bookeddate,'yyyy-MM-dd') as voucherdate, bookeddate as voucherdatenew,id,vouchertype.id,vouchertype.name,creator.id,creator.name", (QFilter[])dapFilter.toArray(new QFilter[0]), null);
                JoinDataSet result = relationDs.join(voucherDs).on("voucherid", "id").select(new String[]{"sourcebillid", "voucherid", "billno as vouchercode", "vouchertype.id as vouchertype", "creator.id as vouchercreator", "voucherdate", "voucherdatenew", "vouchertype.name + '-'+ billno +'-' +creator.name as voucherinfo"});
                dataSet = dataSet == null ? result.finish() : dataSet.union(result.finish());
                dapFilter.remove(dapFilter.size() - 1);
            }
        }
        return dataSet;
    }

    private List<QFilter> getDapFilter(FilterInfo filterInfo) {
        ArrayList list = Lists.newArrayList();
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customvouchercode", "billno"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customvoucherdate", "bookeddate"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customvouchertype.id", "vouchertype.id"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customvouchercreator.id", "creator.id"));
        return list;
    }

    protected List<QFilter> getHistoryBillInfoFilter(FilterInfo filterInfo) {
        ArrayList list = Lists.newArrayList();
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customorg.id", "org.id"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customorg.name", "org.name"));
        this.addBillCommonFilter(filterInfo, list);
        return list;
    }

    protected void addBillCommonFilter(FilterInfo filterInfo, List<QFilter> list) {
        AbstractInvoiceInfoDataSet.addList(list, this.getMainOrgFilter(filterInfo, "customcostcompany.id", "costcompany.id"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customcompany.id", "company.id"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custombillno", "billno"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custombizdate", "bizdate"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customauditdate", "auditdate"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customapplier.id", "applier.id"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custombillstatus", "billstatus"));
    }

    protected QFilter getMainOrgFilter(FilterInfo filterInfo, String propName, String filterPropName) {
        QFilter costcompanyFilter = AbstractInvoiceInfoDataSet.getQFilter(filterInfo, propName, filterPropName);
        if (costcompanyFilter != null) {
            return costcompanyFilter;
        }
        if (this.permOrgMap == null) {
            logger.info("\u53ef\u4ee5\u67e5\u770b\u6240\u6709\u7ec4\u7ec7\u6570\u636e \u6240\u4ee5permOrgMap \u4e3anull\uff0c \u6240\u4ee5filter\u6761\u4ef6\u8bbe\u7f6e\u4e3a 1=1 ");
            return QFilter.of((String)"1=1", (Object[])new Object[0]);
        }
        FilterItemInfo filterItem = filterInfo.getFilterItem("appId");
        String appId = (String)StringUtils.defaultIfBlank((CharSequence)((String)filterItem.getValue()), (CharSequence)"em");
        return new QFilter(filterPropName, "in", this.permOrgMap.getOrDefault(appId, Collections.EMPTY_SET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Long> getOrgListWithQueryPerm(String appId) {
        Map<String, Set<Long>> map = this.permOrgMap;
        synchronized (map) {
            Set<Long> permOrgs = this.permOrgMap.get(appId);
            if (permOrgs == null) {
                permOrgs = new HashSet<Long>();
                this.permOrgMap.put(appId, permOrgs);
                permOrgs.addAll(ErPermissionServiceHelper.getOrgListWithQueryPerm((String)appId, (String)"er_invoiceinfo_query"));
            }
            return permOrgs;
        }
    }

    protected List<QFilter> getHistoryInfoFilter(FilterInfo filterInfo, String billType) {
        ArrayList list = Lists.newArrayList();
        AbstractInvoiceInfoDataSet.addList(list, new QFilter("billtype", "=", (Object)billType));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoicetype", "invoicetype"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoicedate", "invoicedate"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoicecode", "invoicecode"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoiceno", "invoiceno"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customtotalamount", "totalamount"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customtaxrate_invoice", "taxrate_invoice"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customtaxamount_invoice", "taxamount_invoice"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customcount", "count"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customgoodsname", "goodsname"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custompassengername", "passengername"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custombuyerorgname", "buyerorgname"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custommakeoutcompname", "makeoutcompname"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customoffset_invoice", "offset_invoice"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customoffsetamount", "offsetamount"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoicefromcity", "invoicefromcity"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoicetocity", "invoicetocity"));
        if (AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customie_validatest", "invoiceentry.ie_validatest") != null || AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custompaycompany.id", "paycompany.id") != null || AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customcostdept.id", "costdept.id") != null || AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customvalidatemessage", "invoicevalidatemessage") != null || AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoiceischange", "invoiceischange") != null || AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customsequencenum", "invoicesequencenum") != null || AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customsequencenuminfo", "invoicesequencenuminfo") != null || AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominoutamount", "inoutamount") != null || AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customdescription", "description") != null || AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customhead_paydate", "head_paydate") != null || AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customseatgrade", "seatgrade") != null || AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custombuyertaxno", "buyertaxno") != null || AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customsalertaxno_h", "salertaxno_h") != null || AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customremark_invoice", "remark_invoice") != null || AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customreasonfortransferou", "reasonfortransferout") != null) {
            AbstractInvoiceInfoDataSet.addList(list, QFilter.of((String)"1!=1", (Object[])new Object[0]));
        }
        return list;
    }

    protected static void addList(List<QFilter> list, QFilter qFilter) {
        if (qFilter != null) {
            list.add(qFilter);
        }
    }

    protected DataSet getMainDataSet(FilterInfo filterInfo, Object[] historyBills, List<Long> batchFilter) {
        List<QFilter> commonFilters = this.getMainDataSetFilter(filterInfo, historyBills);
        if (!CollectionUtils.isEmpty(batchFilter)) {
            commonFilters.add(new QFilter("invoiceentry.id", "in", batchFilter));
        }
        String mainSelectFieldSQL = this.getMainSelectFieldsSQL().replace("billtype", String.format("'%s' as billtype", this.billType));
        DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)this.billType, (String)mainSelectFieldSQL, (QFilter[])commonFilters.toArray(new QFilter[0]), null).select(InvoiceRptSQL.joinSelectFields);
        return mainDataSet;
    }

    protected List<QFilter> getInvoiceItemsFilter(FilterInfo filterInfo, DataSet mainDataSet) {
        ArrayList list = Lists.newArrayList();
        list.add(new QFilter("id", "in", (Object)this.mapValCollects2List(mainDataSet, "id")));
        list.add(new QFilter("invoiceitementry.invoiceheadentryid", "in", (Object)this.mapValCollects2List(mainDataSet, "invoiceentry.id")));
        if (filterInfo.getFilterItems("customgoodsname") != null) {
            AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customgoodsname", "invoiceitementry.goodsname"));
        }
        return list;
    }

    protected List<QFilter> getMainDataSetFilter(FilterInfo filterInfo, Object[] historyBills) {
        ArrayList list = Lists.newArrayList();
        AbstractInvoiceInfoDataSet.addList(list, QFilter.isNotNull((String)"invoiceentry.invoicecode"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoicedate", "invoiceentry.invoiceDate"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoicetype", "invoiceentry.invoicetype"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoicecode", "invoiceentry.invoicecode"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoiceno", "invoiceentry.invoiceno"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customtotalamount", "invoiceentry.totalamount"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customtaxrate_invoice", "invoiceentry.taxrate_invoice"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customtaxamount_invoice", "invoiceentry.taxamount_invoice"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customcount", "invoiceentry.count"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custompassengername", "invoiceentry.passengername"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custombuyerorgname", "invoiceentry.buyerorgname"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custommakeoutcompname", "invoiceentry.makeoutcompname"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customoffset_invoice", "invoiceentry.offset_invoice"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customie_validatest", "invoiceentry.ie_validatest"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customvalidatemessage", "invoiceentry.validatemessage"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoiceischange", "invoiceentry.invoiceischange"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customsequencenum", "invoiceentry.sequencenum"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customsequencenuminfo", "invoiceentry.sequencenuminfo"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customorg.id", "org.id"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custombuyertaxno", "invoiceentry.buyertaxno"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customsalertaxno_h", "invoiceentry.salertaxno_h"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customremark_invoice", "invoiceentry.remark_invoice"));
        AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customreasonfortransferou", "invoiceentry.reasonfortransferout"));
        if ("er_dailyreimbursebill".equals(this.billType) || "er_tripreimbursebill".equals(this.billType) || "er_publicreimbursebill".equals(this.billType)) {
            AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customdescription", "description"));
            AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custompaycompany.id", "paycompany.id"));
            AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customcostdept.id", "costdept.id"));
            AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominoutamount", "invoiceentry.inoutamount"));
            AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customhead_paydate", "head_paydate"));
            AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customseatgrade", "invoiceentry.seatgrade"));
            AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoicefromcity", "invoiceentry.istartcity"));
            AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoicetocity", "invoiceentry.idestcity"));
        } else if ("er_checkingpaybill".equals(this.billType)) {
            AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "customdescription", "applyexplain"));
            AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoicefromcity", "invoiceentry.invoicefromcity"));
            AbstractInvoiceInfoDataSet.addList(list, AbstractInvoiceInfoDataSet.getQFilter(filterInfo, "custominvoicetocity", "invoiceentry.invoicetocity"));
        }
        AbstractInvoiceInfoDataSet.addList(list, new QFilter("billno", "not in", (Object)historyBills));
        this.addBillCommonFilter(filterInfo, list);
        return list;
    }

    protected static QFilter getQFilter(FilterInfo filterInfo, String propName, String filterPropName) {
        QFilter ret = AbstractInvoiceInfoDataSet.constructFilter(filterInfo, propName, filterPropName);
        if (propName.endsWith(".id") && ret == null) {
            propName = propName.replace(".id", ".name");
            filterPropName = filterPropName.replace(".id", ".name");
            ret = AbstractInvoiceInfoDataSet.constructFilter(filterInfo, propName, filterPropName);
        }
        return ret;
    }

    private static QFilter constructFilter(FilterInfo filterInfo, String propName, String filterPropName) {
        QFilter ret = null;
        boolean or = AbstractInvoiceInfoDataSet.orLogic(filterInfo);
        List filterItemInfos = filterInfo.getFilterItems(propName);
        if (filterItemInfos != null && filterItemInfos.size() > 0) {
            for (FilterItemInfo filterItemInfo : filterItemInfos) {
                QFilter qFilter = new QFilter(filterPropName, filterItemInfo.getCompareType(), filterItemInfo.getValue());
                if (or) {
                    ret = ret == null ? qFilter : ret.or(qFilter);
                    continue;
                }
                ret = ret == null ? qFilter : ret.and(qFilter);
            }
        }
        return ret;
    }

    protected static boolean orLogic(FilterInfo filterInfo) {
        return filterInfo.toString().indexOf("is null") != -1;
    }

    public String getBillType() {
        return this.billType;
    }

    protected Object[] mapValCollects2List(DataSet dataSet, String key) {
        ArrayList list = Lists.newArrayList();
        for (Row row : dataSet.copy()) {
            list.add(row.get(key));
        }
        return list.toArray();
    }

    protected String getHistoryInvoiceSelectFieldsSQL() {
        return InvoiceRptSQL.historyInvoiceSelectFieldsSQL;
    }

    protected String getHistoryBillSelectFieldsSQL() {
        return InvoiceRptSQL.historyBillSelectFieldsSQL;
    }

    protected String getMainSelectFieldsSQL() {
        return InvoiceRptSQL.mainSelectFieldsSQL;
    }
}

