/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.invoice.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.context.RequestContext;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.er.business.servicehelper.invoice.InvoiceType;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.report.invoice.service.AbstractInvoiceInfoDataSet;
import kd.fi.er.report.invoice.service.util.InvoiceRptSQL;
import org.apache.commons.lang3.StringUtils;

public class InvoiceOrderBillInfoImpl
extends AbstractInvoiceInfoDataSet {
    private static Log logger = LogFactory.getLog(InvoiceOrderBillInfoImpl.class);

    @Deprecated
    public InvoiceOrderBillInfoImpl(String billType) {
        super(billType);
    }

    protected InvoiceOrderBillInfoImpl(String billType, Map<String, Set<Long>> permOrgMap) {
        super(billType, permOrgMap);
    }

    @Override
    public DataSet getDataSet(FilterInfo filterInfo, List<Long> batchFilter) {
        List<QFilter> historyInvoiceInfoFilter = this.getHistoryInfoFilter(filterInfo, this.getBillType());
        ORM orm = ORM.create();
        if (!CollectionUtils.isEmpty(batchFilter)) {
            historyInvoiceInfoFilter.add(new QFilter("id", "in", batchFilter));
        }
        DataSet historyInvoiceInfoSet = orm.queryDataSet("kd.fi.er.report.invoice.service.dataset", "er_invoiceinforptbill", InvoiceRptSQL.historyInvoiceSelectFieldsSQL, historyInvoiceInfoFilter.toArray(new QFilter[0]));
        Object[] historyBills = this.mapValCollects2List(historyInvoiceInfoSet, "excelbillno");
        QFilter billNoFilter = new QFilter("billno", "in", (Object)historyBills);
        List<QFilter> historyBillInfoFilters = this.getHistoryBillInfoFilter(filterInfo);
        InvoiceOrderBillInfoImpl.addList(historyBillInfoFilters, billNoFilter);
        DataSet historyBillDataSet = orm.queryDataSet("kd.fi.er.report.invoice.service.dataset", this.getBillType(), InvoiceRptSQL.historyInvoiceOrderSelectFieldsSQL, historyBillInfoFilters.toArray(new QFilter[0]));
        DataSet historyDataSet = historyInvoiceInfoSet.join(historyBillDataSet, JoinType.INNER).on("excelbillno", "billno").select(InvoiceRptSQL.joinSelectFields2).finish();
        DataSet mainDataSet = this.getMainDataSet(filterInfo, historyBills, batchFilter);
        DataSet result = historyDataSet.union(mainDataSet);
        int isusedmonthlyinvoiceentryValue = SystemParamterUtil.getloancheckparam((long)RequestContext.get().getOrgId(), (String)"isusedmonthlyinvoiceentry");
        if (isusedmonthlyinvoiceentryValue == 0) {
            DataSet itineraryDataSet = this.getItineraryDataSet(filterInfo, historyBills);
            result = result.union(itineraryDataSet);
        }
        result = this.whereresult(filterInfo, result);
        QFilter invoiceItemQF = InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "custominvoicefrom", "invoicefrom");
        if (invoiceItemQF != null) {
            return result.filter(invoiceItemQF.toString());
        }
        return result;
    }

    private DataSet whereresult(FilterInfo filterInfo, DataSet result) {
        if (filterInfo.getFilterItem("customvoucherdate") != null || filterInfo.getFilterItem("customapplier.id") != null || filterInfo.getFilterItem("customapplier.name") != null || filterInfo.getFilterItem("customcompany.id") != null || filterInfo.getFilterItem("customcompany.name") != null || filterInfo.getFilterItem("custommakeoutcompname") != null || filterInfo.getFilterItem("custombuyerorgname") != null || filterInfo.getFilterItem("customtaxrate_invoice") != null || filterInfo.getFilterItem("customtaxamount_invoice") != null || filterInfo.getFilterItem("customoffset_invoice") != null && "1".equals(filterInfo.getFilterItem("customoffset_invoice").getValue()) || filterInfo.getFilterItem("customie_validatest") != null || filterInfo.getFilterItem("customdescription") != null || filterInfo.getFilterItem("customcostdept.id") != null || filterInfo.getFilterItem("customcostdept.name") != null || filterInfo.getFilterItem("custompaycompany.id") != null || filterInfo.getFilterItem("custompaycompany.name") != null || filterInfo.getFilterItem("customvalidatemessage") != null || filterInfo.getFilterItem("custominvoiceischange") != null || filterInfo.getFilterItem("customsequencenum") != null || filterInfo.getFilterItem("customsequencenuminfo") != null || filterInfo.getFilterItem("custominoutamount") != null || filterInfo.getFilterItem("customvouchertype.id") != null || filterInfo.getFilterItem("customvouchertype.name") != null || filterInfo.getFilterItem("customvouchercreator.id") != null || filterInfo.getFilterItem("customvouchercreator.name") != null || filterInfo.getFilterItem("customhead_paydate") != null || filterInfo.getFilterItem("customseatgrade") != null || filterInfo.getFilterItem("custominvoicefromcity") != null || filterInfo.getFilterItem("custominvoicetocity") != null || filterInfo.getFilterItem("custombuyertaxno") != null || filterInfo.getFilterItem("customsalertaxno_h") != null || filterInfo.getFilterItem("customremark_invoice") != null || filterInfo.getFilterItem("customreasonfortransferou") != null) {
            result = result.where("1 != 1");
            return result;
        }
        result = this.whereString(filterInfo, result, "customgoodsname", "goodsname");
        result = this.whereString(filterInfo, result, "custompassengername", "passengername");
        result = this.whereString(filterInfo, result, "customvouchercode", "vouchercode");
        return result;
    }

    private DataSet whereString(FilterInfo filterInfo, DataSet result, String propName, String filterPropName) {
        List filterItems = filterInfo.getFilterItems(propName);
        if (filterItems != null && filterItems.size() > 0) {
            StringBuffer sBuffer = new StringBuffer();
            String logicStr = " and ";
            boolean or = InvoiceOrderBillInfoImpl.orLogic(filterInfo);
            if (or) {
                logicStr = " or ";
            }
            for (FilterItemInfo filterItem : filterItems) {
                if (!"is null".equals(filterItem.getCompareType()) && !"is not null".equals(filterItem.getCompareType()) || filterItem.getValue() != null && StringUtils.isNotEmpty((CharSequence)filterItem.getValue().toString())) {
                    this.append(sBuffer, logicStr, String.format("%s %s '%s'", filterPropName, filterItem.getCompareType(), filterItem.getValue().toString()));
                    continue;
                }
                this.append(sBuffer, logicStr, String.format("%s %s ", filterPropName, filterItem.getCompareType()));
            }
            result = result.where(sBuffer.toString());
        }
        return result;
    }

    private void append(StringBuffer sBuffer, String logicStr, String filterStr) {
        if (sBuffer.length() > 0) {
            sBuffer.append(logicStr).append(filterStr);
        } else {
            sBuffer.append(filterStr);
        }
    }

    private List<Long> getOrgList(FilterInfo filterInfo, String filterPropName) {
        FilterItemInfo orgItemInfo = filterInfo.getFilterItem(filterPropName);
        ArrayList<Long> permOrgsList = new ArrayList();
        if (orgItemInfo != null) {
            if (orgItemInfo != null && "=".equals(orgItemInfo.getCompareType())) {
                Long orgId = (Long)orgItemInfo.getValue();
                permOrgsList.add(orgId);
            } else {
                List orgIds = (List)orgItemInfo.getValue();
                for (Long orgId : orgIds) {
                    permOrgsList.add(orgId);
                }
            }
        } else {
            permOrgsList = ReimburseControlUtils.getCompanysWithQueryPerm((String)"em", (String)"er_invoiceinfo_query");
        }
        return permOrgsList;
    }

    private DataSet getItineraryDataSet(FilterInfo filterInfo, Object[] historyBills) {
        QFilter[] commonFilters = this.getItineraryDataSetFilter(filterInfo, historyBills).toArray(new QFilter[0]);
        QFilter[] planeCheckingDataSetFilter = this.getPlaneCheckingDataSetFilter(filterInfo).toArray(new QFilter[0]);
        ORM orm = ORM.create();
        DataSet invoiceOrderbillDataSet = orm.queryDataSet("kd.fi.er.report.invoice.service.dataset", "er_invoiceorderbill", InvoiceRptSQL.invoiceInfoFieldsSQL, commonFilters);
        DataSet invoiceSettleRelDataSet = orm.queryDataSet("kd.fi.er.report.invoice.service.dataset", "er_invoicesettle_rel", "invoicebillno as billno,settleid", new QFilter[0]);
        DataSet invoiceInfoDataSet = invoiceOrderbillDataSet.join(invoiceSettleRelDataSet).on("billno", "billno").select(InvoiceRptSQL.invoiceInfoJoinFields).finish();
        DataSet planeCheckingBillDataSet = orm.queryDataSet("kd.fi.er.report.invoice.service.dataset", "er_planecheckingbill", InvoiceRptSQL.planeCheckingInfoFieldsSQL, planeCheckingDataSetFilter);
        DataSet itineraryDataSet = planeCheckingBillDataSet.join(invoiceInfoDataSet).on("id", "id").select(InvoiceRptSQL.planeCheckingBillSelectFields).finish();
        return itineraryDataSet;
    }

    private List<QFilter> getItineraryDataSetFilter(FilterInfo filterInfo, Object[] historyBills) {
        ArrayList list = Lists.newArrayList();
        InvoiceOrderBillInfoImpl.addList(list, new QFilter("invoicetype", "in", (Object)new String[]{"3"}));
        InvoiceOrderBillInfoImpl.addList(list, new QFilter("billno", "not in", (Object)historyBills));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "custominvoicedate", "invoicedate"));
        InvoiceOrderBillInfoImpl.addList(list, this.getInvoiceTypeQFilter(filterInfo, "custominvoicetype"));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "custominvoicecode", "invoicecode"));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "customtotalamount", "settleamountwithtax"));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "customcount", "1"));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "customoffsetamount", "invoicetax"));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "custombillstatus", "billstatus"));
        InvoiceOrderBillInfoImpl.addList(list, this.getMainOrgFilter(filterInfo, "customcostcompany.id", "expcommitcomnum.id"));
        InvoiceOrderBillInfoImpl.addList(list, this.getMainOrgFilter(filterInfo, "customorg.id", "org.id"));
        this.addBillCommonFilter(filterInfo, list);
        return list;
    }

    private List<QFilter> getPlaneCheckingDataSetFilter(FilterInfo filterInfo) {
        ArrayList list = Lists.newArrayList();
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "custominvoiceno", "ticketnum"));
        return list;
    }

    @Override
    protected DataSet getMainDataSet(FilterInfo filterInfo, Object[] historyBills, List<Long> batchFilter) {
        List<QFilter> commonFilters = this.getMainDataSetFilter(filterInfo, historyBills);
        if (!CollectionUtils.isEmpty(batchFilter)) {
            commonFilters.add(new QFilter("id", "in", batchFilter));
        }
        ORM orm = ORM.create();
        DataSet mainDataSet = orm.queryDataSet("kd.fi.er.report.invoice.service.dataset", this.getBillType(), InvoiceRptSQL.mainSelectInvoiceFieldsSQL, commonFilters.toArray(new QFilter[0])).select(InvoiceRptSQL.joinSelectFields2);
        Field[] rowFields = mainDataSet.getRowMeta().getFields();
        return mainDataSet;
    }

    @Override
    protected List<QFilter> getMainDataSetFilter(FilterInfo filterInfo, Object[] historyBills) {
        ArrayList list = Lists.newArrayList();
        InvoiceOrderBillInfoImpl.addList(list, new QFilter("invoicetype", "not in", (Object)new String[]{"3"}));
        InvoiceOrderBillInfoImpl.addList(list, new QFilter("billno", "not in", (Object)historyBills));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "custominvoicedate", "invoicedate"));
        InvoiceOrderBillInfoImpl.addList(list, this.getInvoiceTypeQFilter(filterInfo, "custominvoicetype"));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "custominvoicecode", "invoicecode"));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "custominvoiceno", "invoicenum"));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "customtotalamount", "settleamountwithtax"));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "customcount", "1"));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "customoffsetamount", "invoicetax"));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "customorg.id", "org.id"));
        if (filterInfo.getFilterItem("custombillstatus") != null && "E".equals(filterInfo.getFilterItem("custombillstatus").getValue())) {
            filterInfo.getFilterItem("custombillstatus").setValue((Object)"C");
        } else if (filterInfo.getFilterItem("custombillstatus") != null && "C".equals(filterInfo.getFilterItem("custombillstatus").getValue())) {
            filterInfo.getFilterItem("custombillstatus").setValue((Object)"Omicron");
        }
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "custombillstatus", "billstatus"));
        InvoiceOrderBillInfoImpl.addList(list, this.getMainOrgFilter(filterInfo, "customcostcompany.id", "expcommitcomnum.id"));
        this.addBillCommonFilter(filterInfo, list);
        return list;
    }

    private QFilter getInvoiceTypeQFilter(FilterInfo filterInfo, String propName) {
        QFilter ret = null;
        List filterItemInfos = filterInfo.getFilterItems("custominvoicetype");
        if (filterItemInfos != null && filterItemInfos.size() > 0) {
            for (FilterItemInfo filterItemInfo : filterItemInfos) {
                String orderBillInvoicetype = this.getInvoiceTypeMapping(String.valueOf(filterItemInfo.getValue()));
                QFilter qFilter = new QFilter("invoicetype", filterItemInfo.getCompareType(), (Object)orderBillInvoicetype);
                ret = ret == null ? qFilter : ret.and(qFilter);
            }
        }
        return ret;
    }

    private String getInvoiceTypeMapping(String reportInvoicetype) {
        String orderBillInvoicetype = null;
        switch (reportInvoicetype) {
            case "1": {
                orderBillInvoicetype = InvoiceType.type3.getValue();
                break;
            }
            case "3": {
                orderBillInvoicetype = InvoiceType.type1.getValue();
                break;
            }
            case "4": {
                orderBillInvoicetype = InvoiceType.type2.getValue();
                break;
            }
            case "10": {
                orderBillInvoicetype = InvoiceType.type4.getValue();
                break;
            }
        }
        return orderBillInvoicetype;
    }

    @Override
    protected void addBillCommonFilter(FilterInfo filterInfo, List<QFilter> list) {
        InvoiceOrderBillInfoImpl.addList(list, this.getMainOrgFilter(filterInfo, "customcostcompany.id", "expcommitcomnum.id"));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "custombillno", "billno"));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "custombizdate", "invoicedate"));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "customauditdate", "auditdate"));
        InvoiceOrderBillInfoImpl.addList(list, InvoiceOrderBillInfoImpl.getQFilter(filterInfo, "custombillstatus", "billstatus"));
    }
}

