/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.plugin;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.Year;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.CustomOrgFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.license.LicenseUtils;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.util.AmountQueryAndReimburseUtils;
import kd.fi.er.report.amount.service.AbstractAmountQueryService;

public class AmountQueryReportPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(AmountQueryReportPlugin.class);
    protected static final List<String> BILL_STATUS_WITH_REIMBURSE = Arrays.asList("B", "C", "E", "F", "G", "I");
    private static String[] nums = new String[]{"00", "000001", "00-001", "0000100", "0000111111111", "00-002", "0001", "00010004", "000119292", "000212", "000927", "0011", "00111", "00113132", "001234", "00157", "00183315", "0025", "00252", "0046", "008", "00lj", "01", "01001.0023", "01011", "01012", "01021.0", "01022", "01S001", "02121", "023685", "03001", "040", "045", "0509", "051", "052", "0603", "060301", "08412", "10000001", "100025", "110", "122201", "1223", "123123123", "1234567890", "20210608001", "20210715", "20220201", "20230218", "20230403", "20232656", "2345", "66", "666660", "666888", "81701", "8742", "8744", "ABCABC01", "ABCD0000", "acct", "aefunittest", "ASWQ", "BCM2022", "bigdata1", "bjfgs000", "BU-00007", "BU-0401500", "CKQ1", "coco", "CS01", "CS0623", "cstest001", "cws", "dept_sheeg_lc", "dfxz", "DG-01", "dkwbudgetorg", "dkwFreezeTest00", "Fa-0001", "Fa-0002", "Fa-0003", "Fa-0004", "Fa-0005", "Fa-0006", "Fa-0007", "Fa-0008", "Fa-3001", "FA4001", "fi-gl-5001", "fi-mb-org05", "fi-mb-org06", "fi-mb-org07", "fi-ssc-org01", "fqcs", "gqjysjt", "HD2023.001", "hll-001"};

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        String appId = formShowParameter.getAppId();
        if (StringUtils.equalsIgnoreCase((CharSequence)"dhc", (CharSequence)appId) && "er_employee_amount_query".equals(formShowParameter.getFormId())) {
            LicenseUtils.checkLicenseByAppIds((PreOpenFormEventArgs)e, (String[])new String[]{"EXP", "TRA", "CEXP"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"toolbarap", "refresh"});
        this.addItemClickListeners(new String[]{"toolbarap", "refresh"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    private void cloneData() {
    }

    private void cloneDataForFI() {
    }

    private DynamicObject[] getBaseDataCols(String entity, int top, Set<Long> ids) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter nameNotNullFilter = new QFilter("name", "is not null", null);
        QFilter fids = new QFilter("id", "!=", (Object)-1L);
        if (ids != null && !ids.isEmpty()) {
            fids = new QFilter("id", "in", ids);
        }
        DynamicObject[] cols = BusinessDataServiceHelper.load((String)entity, (String)"id,number,name", (QFilter[])new QFilter[]{enableFilter, statusFilter, nameNotNullFilter, fids}, null, (int)top);
        return cols;
    }

    private Set<Long> buildTestOrgs() {
        List<String> numsIn = Arrays.asList(nums);
        QFilter numsInFilter = new QFilter("number", "in", numsIn);
        HashSet<Long> orgids = new HashSet<Long>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"query dataids", (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{numsInFilter}, null);){
            for (Row row : ds) {
                orgids.add(row.getLong("id"));
            }
        }
        return orgids;
    }

    public void click(EventObject evt) {
        super.click(evt);
        System.out.println("test click btn");
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.setPageRows(40);
        List commonFilterColumns = contInitEvent.getCommonFilterColumns();
        commonFilterColumns.forEach(v -> {
            if (StringUtils.equals((CharSequence)v.getFieldName(), (CharSequence)"dateyear_filter")) {
                CommonFilterColumn c = (CommonFilterColumn)v;
                ArrayList comboItems = Lists.newArrayListWithExpectedSize((int)4);
                for (int i = 0; i <= 2; ++i) {
                    ComboItem comboItem = new ComboItem();
                    LocaleString caption = null;
                    String value = null;
                    if (i == 0) {
                        caption = new LocaleString(ResManager.loadKDString((String)"\u4eca\u5e74(\u4e0a\u6708)", (String)"AmountQueryReportPlugin_0", (String)"fi-er-report", (Object[])new Object[0]));
                        value = Year.now().getValue() + "_LM";
                    }
                    if (i == 1) {
                        caption = new LocaleString(ResManager.loadKDString((String)"\u4eca\u5e74(\u672c\u6708)", (String)"AmountQueryReportPlugin_1", (String)"fi-er-report", (Object[])new Object[0]));
                        value = Year.now().getValue() + "_TM";
                    }
                    if (i == 2) {
                        caption = new LocaleString(ResManager.loadKDString((String)"\u53bb\u5e74", (String)"AmountQueryReportPlugin_3", (String)"fi-er-report", (Object[])new Object[0]));
                        value = Year.now().minusYears(1L).getValue() + "";
                    }
                    comboItem.setCaption(caption);
                    comboItem.setValue(value);
                    comboItem.setId(i + "");
                    comboItems.add(comboItem);
                }
                c.setComboItems((List)comboItems);
                v.setDefaultValue(Year.now().getValue() + "_LM");
                c.setMulti(false);
            } else if (StringUtils.equals((CharSequence)v.getFieldName(), (CharSequence)"company_filter") && this.getPageCache().get("loadflag") == null) {
                long orgId;
                String appNum = StringUtils.isBlank((CharSequence)this.getView().getFormShowParameter().getAppId()) ? "em" : this.getView().getFormShowParameter().getAppId();
                List orgIds = ReimburseControlUtils.getCompanysWithQueryPerm((String)appNum, (String)"er_finance_amount_query");
                if (orgIds.contains(orgId = RequestContext.get().getOrgId())) {
                    ((CustomOrgFilterColumn)v).setDefaultValues(new Object[]{orgId + ""});
                } else {
                    List comboItems = ((CustomOrgFilterColumn)v).getComboItems();
                    if (comboItems.size() > 0) {
                        v.setDefaultValue(((ComboItem)comboItems.get(0)).getValue());
                    }
                }
                this.getPageCache().put("loadflag", "loadflag");
            }
        });
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName;
        int rowIndex = event.getRowIndex();
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        switch (fieldName = event.getFieldName()) {
            case "yeartotalamount": {
                this.showReimburseAmountPage(rowData);
                break;
            }
            case "thisyearusedamount": {
                Optional<QFilter> billKindFilterOptional = reportModel.getReportQueryParam().getFilter().getQFilters().stream().filter(q -> "billkind_filter".equals(q.getProperty())).findAny();
                this.showReimburseAmountUseDetail(rowData, billKindFilterOptional);
                break;
            }
            case "thistermbalanceamount": {
                this.showDailyReimburseBillPage(rowData);
                break;
            }
        }
    }

    protected void showDailyReimburseBillPage(DynamicObject rowData) {
        DynamicObject expenseItem = rowData.getDynamicObject("expenseitem");
        BigDecimal balanceamount = rowData.getBigDecimal("thistermbalanceamount");
        DynamicObject companyDO = rowData.getDynamicObject("company");
        DynamicObject employeeDO = rowData.getDynamicObject("employee");
        DynamicObject currencyDO = rowData.getDynamicObject("currency");
        AmountQueryAndReimburseUtils.CreateDailyReimburseByEmployeeReimParam param = new AmountQueryAndReimburseUtils.CreateDailyReimburseByEmployeeReimParam();
        param.setFormPlugin((AbstractFormPlugin)this);
        param.setBalanceAmount(balanceamount);
        param.setCompanyId(companyDO.getPkValue());
        param.setCurrencyId(currencyDO.getPkValue());
        param.setExpenseItemId(expenseItem.getPkValue());
        param.setHappendDate(AmountQueryAndReimburseUtils.getHappendDateInReimCtlReport((ReportQueryParam)this.getQueryParam()));
        param.setUserId(employeeDO.getPkValue());
        AmountQueryAndReimburseUtils.createDailyReimburseByEmployeeReim((AmountQueryAndReimburseUtils.CreateDailyReimburseByEmployeeReimParam)param);
    }

    private void showReimburseAmountUseDetail(DynamicObject rowData, Optional<QFilter> billKindFilterOptional) {
        IReportView view = this.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u4e2a\u4eba\u989d\u5ea6", (String)"AmountQueryReportPlugin_2", (String)"fi-er-report", (Object[])new Object[0]));
        showParameter.setFormId("er_reimctl_usedetail");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setHasRight(true);
        QuotaAmountBO reimAmountBO = new QuotaAmountBO();
        reimAmountBO.setCompanyId(ErCommonUtils.getPk((Object)rowData.getDynamicObject("company")));
        reimAmountBO.setUserOrDeptId(ErCommonUtils.getPk((Object)rowData.getDynamicObject("employee")));
        String personCtrlCurrency = SystemParamterUtil.getPersonCtlCurrency((Long)ErCommonUtils.getPk((Object)rowData.getDynamicObject("company")));
        QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)personCtrlCurrency, (Long)ErCommonUtils.getPk((Object)rowData.getDynamicObject("currency")), (Long)ErCommonUtils.getPk((Object)rowData.getDynamicObject("currency")));
        QuotaCtrlUtil.genQuotaExpItem((QuotaAmountBO)reimAmountBO, (Long)ErCommonUtils.getPk((Object)rowData.getDynamicObject("expenseitem")));
        String empCltBillStr = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)rowData.getDynamicObject("company")), (String)"empquotaapplicablebill");
        List<String> empCltList = Arrays.asList(empCltBillStr.split(","));
        reimAmountBO.setEmpCtlBill(empCltList);
        reimAmountBO.setHappenYear(Integer.valueOf(rowData.getString("year")));
        showParameter.setCustomParam("reimAmountQueryBean", (Object)reimAmountBO);
        showParameter.setCustomParam("isDeptAmount", (Object)false);
        view.showForm(showParameter);
    }

    private void showReimburseAmountPage(DynamicObject rowData) {
        Object pkValue = rowData.get("id");
        IReportView view = this.getView();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setPkId(pkValue);
        parameter.setCaption(ResManager.loadKDString((String)"\u4e2a\u4eba\u989d\u5ea6", (String)"AmountQueryReportPlugin_2", (String)"fi-er-report", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("er_reimburseamount");
        parameter.setStatus(OperationStatus.VIEW);
        view.showForm((FormShowParameter)parameter);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        AbstractAmountQueryService service = AbstractAmountQueryService.getImplService(this.getView().getEntityId());
        long l = System.currentTimeMillis();
        service.processRowDatasForPersonal(rowData, queryParam);
        log.info(rowData.size() + "\u6761\u6570\u636e\u5904\u7406\u82b1\u8d39\u65f6\u95f4---------------------------" + (System.currentTimeMillis() - l) + "\u6beb\u5999");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"company_filter.id")) {
            String appNum = StringUtils.isBlank((CharSequence)this.getView().getFormShowParameter().getAppId()) ? "em" : this.getView().getFormShowParameter().getAppId();
            List orgIds = ReimburseControlUtils.getCompanysWithQueryPerm((String)appNum, (String)"er_finance_amount_query");
            if (orgIds == null || orgIds.isEmpty()) {
                log.info("\u5f53\u524d\u7528\u6237\u672a\u67e5\u8be2\u5230\u6709\u6743\u9650\u7684\u7ec4\u7ec7");
                return;
            }
            args.getQfilters().add(new QFilter("id", "in", (Object)orgIds));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        queryParam.getFilter().addFilterItem("appId", (Object)this.getView().getFormShowParameter().getAppId(), "=");
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("tra".equals(appId) || "cexp".equals(appId)) {
            for (AbstractReportColumn column : event.getColumns()) {
                if (!"thistermbalanceamount".equals(((ReportColumn)column).getFieldKey())) continue;
                ((ReportColumn)column).setHyperlink(false);
            }
        }
    }
}

