/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.plugin;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.license.LicenseUtils;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.formplugin.daily.web.util.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class EmployeeLoanRepayReportPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final Set<String> EQUAL_QUERY_ELE = Collections.unmodifiableSet(Stream.of("pcurrency", "paramstatus").collect(Collectors.toSet()));

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        String appId = formShowParameter.getAppId();
        if (StringUtils.equalsIgnoreCase((CharSequence)"dhc", (CharSequence)appId) && "er_employee_loan_repay".equals(formShowParameter.getFormId())) {
            LicenseUtils.checkLicenseByAppIds((PreOpenFormEventArgs)e, (String[])new String[]{"EXP", "TRA", "CEXP"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"configurereport"});
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName;
        int rowIndex = event.getRowIndex();
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        String billId = rowData.getString("id");
        String billNo = rowData.getString("billno");
        String formId = rowData.getString("reportformid");
        String billtype = rowData.getString("billtype");
        switch (fieldName = event.getFieldName()) {
            case "billno": {
                if (null == billNo) break;
                if ("1".equals(billtype)) {
                    formId = "er_tripreqbill";
                } else if ("2".equals(billtype)) {
                    formId = "er_dailyloanbill";
                } else if ("3".equals(billtype)) {
                    formId = "er_planebill";
                } else if ("4".equals(billtype)) {
                    formId = "er_hotelbill";
                } else if ("5".equals(billtype)) {
                    formId = "er_vehiclebill";
                }
                if (null != billId) {
                    this.openLinkedForm(billId, formId);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u64cd\u4f5c\u3002", (String)"EmployeeLoanRepayReportPlugin_0", (String)"fi-er-report", (Object[])new Object[0]));
                break;
            }
            case "clearamountori": 
            case "clearamountacc": 
            case "repayamountori": 
            case "repayamountacc": {
                if ("".equals(billId)) {
                    return;
                }
                IFormView view = reportList.getView();
                DynamicObject ds = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(billId), (String)formId);
                if (ds == null) {
                    return;
                }
                ArrayList downNodes = new ArrayList(BFTrackerServiceHelper.loadBillLinkDownNodes((String)formId, (Long[])new Long[]{Long.valueOf(billId)}, (boolean)true).values());
                if (downNodes.size() == 0) {
                    this.showNotFoundData(null, view);
                    return;
                }
                downNodes.forEach(e -> e.getTNodes().entrySet().removeIf(entry -> !this.bizDownNodeCondi(fieldName, EntityMetadataCache.loadTableDefine((Long)((BFRowId)entry.getKey()).getMainTableId()).getEntityKey())));
                if (downNodes.stream().anyMatch(e -> e.getTNodes().size() == 0) && this.showNotFoundData(null, view)) {
                    return;
                }
                String jsonNodes = SerializationUtils.serializeToBase64(downNodes);
                String type = "lookdown";
                BotpDrawServiceUtil.showRelateBills((String)formId, (String)billNo, (String)jsonNodes, (String)type, (IFormView)view);
            }
        }
    }

    protected boolean bizDownNodeCondi(String field, String entityId) {
        switch (field) {
            case "clearamountori": 
            case "clearamountacc": {
                return ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isDailyLoanBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isTripReimburseBill((String)entityId);
            }
            case "repayamountori": 
            case "repayamountacc": {
                return ErEntityTypeUtils.isRepaymentBill((String)entityId);
            }
        }
        return false;
    }

    protected boolean showNotFoundData(List list, IFormView view) {
        if (list == null || list.size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u6570\u636e\u3002", (String)"ErLoanBillDsList_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        DynamicObject rowData = packageDataEvent.getRowData();
        BigDecimal norepayamountori = rowData.getBigDecimal("norepayamountori");
        Integer daysBetween = null;
        if (norepayamountori.compareTo(BigDecimal.ZERO) > 0) {
            Date head_paydate = rowData.getDate("head_paydate");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String headOPaydateStr = null;
            headOPaydateStr = head_paydate == null ? simpleDateFormat.format(new Date()) : simpleDateFormat.format(head_paydate);
            daysBetween = Math.abs((int)DateUtils.daysBetween((Calendar)DateUtils.str2Date((String)headOPaydateStr)));
        } else {
            daysBetween = 0;
        }
        rowData.set("loandays", (Object)daysBetween);
        packageDataEvent.setRowData(rowData);
    }

    private void openLinkedForm(Object pkValue, String formId) {
        IReportView view = this.getView();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(pkValue);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setHasRight(true);
        parameter.setAppId(this.getView().getFormShowParameter().getAppId());
        parameter.setFormId(formId);
        if ("er_tripreqbill".equals(formId)) {
            parameter.setCaption(ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355(\u501f)", (String)"EmployeeLoanRepayReportPlugin_1", (String)"fi-er-report", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        List commonFilterColumns = contInitEvent.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            String fieldName = commonFilterColumn.getFieldName();
            if ("currencytype".equalsIgnoreCase(fieldName)) {
                Map billMap = CoreBaseBillServiceHelper.createNewData((Long)RequestContext.get().getCurrUserId());
                long currencytype = billMap.get("currency") == null ? 1L : (Long)billMap.get("currency");
                commonFilterColumn.setDefaultValue(Long.valueOf(currencytype).toString());
                queryParam.getFilter().getFilterItems().add(new FilterItemInfo("currencytype", (Object)currencytype, "="));
                continue;
            }
            if (!"parambilltype".equalsIgnoreCase(fieldName) || !CollectionUtils.isEmpty((Collection)commonFilterColumn.getDefaultValues())) continue;
            commonFilterColumn.setDefaultValues(Arrays.asList("1", "2"));
            queryParam.getFilter().getFilterItems().add(new FilterItemInfo("parambilltype", (Object)commonFilterColumn.getDefaultValues(), "in"));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Function<FilterItemInfo, String> getPropNameFun = item -> item.getPropName().split("\\.")[0];
        String errMsg = filterInfo.getFilterItems().stream().filter(item -> EQUAL_QUERY_ELE.contains(getPropNameFun.apply((FilterItemInfo)item)) && !StringUtils.equals((CharSequence)"=", (CharSequence)item.getCompareType())).map(item -> ((SchemeFilterColumn)this.getView().getControl((String)getPropNameFun.apply((FilterItemInfo)item))).getCaption().getLocaleValue()).distinct().collect(Collectors.joining(","));
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            errMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u5f55\u5165\uff0c%1$s\u67e5\u8be2\u63a7\u4ef6\u4ec5\u652f\u6301\"\u7b49\u4e8e\"\u6761\u4ef6\u67e5\u8be2\u3002", (String)"ExpenseDetailReportPlugin_9", (String)"fi-er-report", (Object[])new Object[0]), errMsg);
            throw new KDBizException(errMsg);
        }
        long applier = queryParam.getFilter().getLong("applier");
        if (applier != 0L) {
            this.getView().getPageCache().put("applier", Long.toString(applier));
        } else {
            String applierID = this.getView().getPageCache().get("applier");
            if (applierID != null) {
                applier = Long.parseLong(applierID);
            }
        }
        if (applier != 0L) {
            queryParam.getFilter().addFilterItem("applier", (Object)applier, "=");
        }
        queryParam.getFilter().addFilterItem("appId", (Object)this.getView().getFormShowParameter().getAppId(), "=");
    }
}

