/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.plugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CustomOrgFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.MetaDataInvoiceTypeEntryEnum;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceStatusEnum;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeComboBoxUtil;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.VoucherUtil;
import kd.fi.er.common.ShowPageUtils;
import org.apache.commons.lang3.StringUtils;

public class ErInvoiceInfoReportPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(ErInvoiceInfoReportPlugin.class);
    private Map<String, ComboItem> loadInvoiceTypesComboItemsMap = InvoiceTypeComboBoxUtil.loadInvoiceTypesComboItemsMap();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("importexcel".equals(evt.getItemKey())) {
            MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
            String operateStr = metadataService.loadEntityOperationMeta("er_invoiceinforptbill", "importdata");
            Map op = null;
            if (!StringUtils.isEmpty((CharSequence)operateStr)) {
                op = (Map)SerializationUtils.fromJsonString((String)operateStr, Map.class);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bos_importstart");
                showParameter.setCustomParams((Map)op.get("parameter"));
                showParameter.setCustomParam("BillFormId", (Object)"er_invoiceinforptbill");
                showParameter.setCustomParam("OperateKey", (Object)"refresh");
                showParameter.setCustomParam("ServiceAppId", (Object)this.getView().getFormShowParameter().getServiceAppId());
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importexcel"));
                this.getView().showForm(showParameter);
            }
        } else if ("view".equals(evt.getItemKey())) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("formId", "er_invoiceinforptbill");
            paramMap.put("showType", ShowType.MainNewTabPage);
            paramMap.put("needCallBack", Boolean.TRUE);
            ShowPageUtils.showWebList(paramMap, (AbstractFormPlugin)this);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        Map cusMap = this.getView().getFormShowParameter().getCustomParams();
        Boolean isItinerar = (Boolean)cusMap.get("isItinerar");
        FilterInfo filter = queryParam.getFilter();
        if (isItinerar != null && isItinerar.booleanValue()) {
            filter.addFilterItem("custominvoiceno", cusMap.get("itinerarynumSet"), "in");
            Long expcommitcomnumId = Long.valueOf(String.valueOf(cusMap.get("expcommitcomnumId")));
            int isusedmonthlyinvoiceentryValue = SystemParamterUtil.getloancheckparam((long)expcommitcomnumId, (String)"isusedmonthlyinvoiceentry");
            if (isusedmonthlyinvoiceentryValue == 0) {
                filter.addFilterItem("custombillno", cusMap.get("billno"), "in");
            }
        }
        queryParam.getFilter().addFilterItem("appId", (Object)this.getView().getFormShowParameter().getAppId(), "=");
    }

    public void packageData(PackageDataEvent e) {
        String str;
        ComboItem comboItem;
        Object source = e.getSource();
        MetaDataInvoiceTypeEntryEnum metaData = MetaDataInvoiceTypeEntryEnum.INVOICEINFO_QUERY_COLUMN;
        if (source instanceof ComboReportColumn && metaData.getFieldName().equals(((ComboReportColumn)source).getFieldKey()) && (comboItem = this.loadInvoiceTypesComboItemsMap.get(str = String.valueOf(e.getFormatValue()))) != null) {
            e.setFormatValue((Object)comboItem.getCaption().getLocaleValue());
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        reportList.selectRows(-1);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        switch (event.getFieldName()) {
            case "billno": {
                DynamicObject bill;
                String billNo = rowData.getString("billno");
                String billtype = rowData.getString("billtype");
                DynamicObject company = (DynamicObject)rowData.get("company");
                QFilter qFilter = new QFilter("billno", "=", (Object)billNo);
                if (company != null) {
                    qFilter.and(new QFilter("company", "=", company.getPkValue()));
                }
                if ((bill = QueryServiceHelper.queryOne((String)billtype, (String)"id", (QFilter[])new QFilter[]{qFilter})) == null) break;
                this.openLinkedForm(bill.get("id"), billtype);
                break;
            }
            case "vouchercode": {
                String voucherId = rowData.getString("voucherid");
                BigDecimal compare = BigDecimal.ZERO;
                try {
                    compare = new BigDecimal(voucherId);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (voucherId != null && compare.compareTo(BigDecimal.ZERO) != 0) {
                    this.openLinkedVoucher(rowData);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"EAS\u4e2d\u7684\u51ed\u8bc1\u6682\u4e0d\u652f\u6301\u67e5\u770b\u3002", (String)"ErInvoiceInfoReportPlugin_0", (String)"fi-er-report", (Object[])new Object[0]));
                break;
            }
            case "invoiceno": {
                List invoiceentryList;
                String billtype = rowData.getString("billtype");
                String billNo = rowData.getString("billno");
                if ("er_invoiceorderbill".equalsIgnoreCase(billtype)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u975e\u53d1\u7968\u4e91\u5bfc\u5165\uff0c\u65e0\u6cd5\u67e5\u770b\u53d1\u7968\u4fe1\u606f\u3002", (String)"ErInvoiceInfoReportPlugin_6", (String)"fi-er-report", (Object[])new Object[0]));
                    return;
                }
                String invoiceno = rowData.getString("invoiceno");
                DynamicObjectCollection bills = QueryServiceHelper.query((String)billtype, (String)"id,billno,invoiceentry.invoicefrom,invoiceentry.invoiceno", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
                if (bills != null && (invoiceentryList = bills.stream().filter(invoiceentry -> invoiceno.equals(invoiceentry.getString("invoiceentry.invoiceno")) && !InvoiceFrom.InvoiceCloud.getValue().equals(invoiceentry.getString("invoiceentry.invoicefrom"))).collect(Collectors.toList())) != null && invoiceentryList.size() > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u975e\u53d1\u7968\u4e91\u5bfc\u5165\uff0c\u65e0\u6cd5\u67e5\u770b\u53d1\u7968\u4fe1\u606f\u3002", (String)"ErInvoiceInfoReportPlugin_6", (String)"fi-er-report", (Object[])new Object[0]));
                    return;
                }
                DynamicObject costcompany = rowData.getDynamicObject("costcompany");
                if (costcompany == null) break;
                InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)((Long)costcompany.getPkValue()));
                if (config == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ec4\u7ec7\u7684\u53d1\u7968\u4e91\u914d\u7f6e", (String)"ErInvoiceInfoReportPlugin_7", (String)"fi-er-report", (Object[])new Object[0]));
                    return;
                }
                List<String> serialNoList = this.getSerialNos(rowData);
                HashSet serialNos = Sets.newHashSet(serialNoList);
                HashMap param = Maps.newHashMapWithExpectedSize((int)1);
                param.put("optMode", "0");
                Long id = 0L;
                if (rowData.getDynamicObjectType().getProperties().containsKey((Object)"id")) {
                    id = rowData.getLong("id");
                }
                log.info("\u67e5\u770b\u53d1\u7968\u5355\u636e\u7c7b\u578b\uff1a {}, id : {}", (Object)rowData.getString("billtype"), (Object)id);
                param.put("billId", rowData.getString("billtype") + "_" + id);
                InvoiceService.getInstanceService().showInvoiceListInPC((AbstractFormPlugin)this, this.getModel(), (Collection)serialNos, config, (Map)param);
                break;
            }
        }
    }

    private void openLinkedVoucher(DynamicObject rowData) {
        String billno = rowData.getString("billno");
        String billtype = rowData.getString("billtype");
        DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((String)billtype, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        VoucherUtil.findVoucher(Collections.singleton(ErCommonUtils.getPk((Object)bill)), (String)billtype, (IFormView)this.getView());
    }

    private List<String> getSerialNos(DynamicObject rowData) {
        DynamicObjectCollection bills;
        ArrayList serialNos = Lists.newArrayList();
        String invoiceno = rowData.getString("invoiceno");
        String invoicecode = rowData.getString("invoicecode");
        String billNo = rowData.getString("billno");
        String billtype = rowData.getString("billtype");
        if (StringUtils.isNotBlank((CharSequence)invoiceno) && StringUtils.isNotBlank((CharSequence)invoicecode) && (bills = QueryServiceHelper.query((String)billtype, (String)"invoiceentry.invoiceno,invoiceentry.invoicecode,invoiceentry.serialno", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)})).size() > 0) {
            for (int i = 0; i < bills.size(); ++i) {
                if (!invoiceno.equals(((DynamicObject)bills.get(i)).get("invoiceentry.invoiceno")) || !invoicecode.equals(((DynamicObject)bills.get(i)).get("invoiceentry.invoicecode"))) continue;
                serialNos.add(((DynamicObject)bills.get(i)).getString("invoiceentry.serialno"));
            }
        }
        return serialNos;
    }

    private void openLinkedForm(Object pkValue, String formId) {
        ShowPageUtils.openLinkedForm((Object)pkValue, (String)formId, (IFormView)this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().invokeOperation("refresh");
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        List commonFilterColumns = contInitEvent.getCommonFilterColumns();
        Map cusMap = this.getView().getFormShowParameter().getCustomParams();
        Boolean isItinerar = (Boolean)cusMap.get("isItinerar");
        if (isItinerar == null || !isItinerar.booleanValue()) {
            for (FilterColumn commonFilterColumn : commonFilterColumns) {
                String fieldName = commonFilterColumn.getFieldName();
                if ("custombillstatus".equalsIgnoreCase(fieldName)) {
                    commonFilterColumn.setDefaultValues(new Object[]{"E", "F", "G", "I"});
                }
                if (!"customcostcompany".equals(fieldName) || this.getPageCache().get("loadflag") != null) continue;
                this.getPageCache().put("loadflag", "loadflag");
                List comboItems = ((CustomOrgFilterColumn)commonFilterColumn).getComboItems();
                if (comboItems.size() <= 0) continue;
                long orgId = RequestContext.get().getOrgId();
                List values = comboItems.stream().map(ComboItem::getValue).collect(Collectors.toList());
                if (orgId != 0L && values.contains(String.valueOf(orgId))) {
                    commonFilterColumn.setDefaultValue(String.valueOf(orgId));
                    continue;
                }
                commonFilterColumn.setDefaultValue(((ComboItem)comboItems.get(0)).getValue());
            }
        } else if (isItinerar.booleanValue()) {
            for (FilterColumn commonFilterColumn : commonFilterColumns) {
                String fieldName = commonFilterColumn.getFieldName();
                if ("customcostcompany".equalsIgnoreCase(fieldName)) {
                    commonFilterColumn.setDefaultValue(null);
                }
                if ("custominvoicedate".equalsIgnoreCase(fieldName)) {
                    commonFilterColumn.setDefaultValue(null);
                }
                if ("customauditdate".equalsIgnoreCase(fieldName)) {
                    commonFilterColumn.setDefaultValue(null);
                }
                if (!"custominvoicetype".equalsIgnoreCase(fieldName)) continue;
                commonFilterColumn.setDefaultValue(null);
            }
        }
        InvoiceTypeComboBoxUtil.constructListFilterInvoiceTypeComboBox((IDataModel)this.getModel(), (IFormView)this.getView(), (List)contInitEvent.getCommonFilterColumns());
        InvoiceTypeComboBoxUtil.constructListFilterInvoiceTypeComboBox((IDataModel)this.getModel(), (IFormView)this.getView(), (List)contInitEvent.getSchemeFilterColumns());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("releaseinvoice".equals(operateKey) && !KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud()) {
            ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
            int[] selectedRows = reportList.getEntryState().getSelectedRows();
            if (selectedRows.length > 0) {
                HashSet<String> errorinfos = new HashSet<String>();
                for (int index : selectedRows) {
                    String status = "A,D,H";
                    DynamicObject rowData = reportList.getReportModel().getRowData(index);
                    String billstatus = rowData.getString("billstatus");
                    if (status.indexOf(billstatus) == -1) {
                        errorinfos.add(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5e94\u4e3a\u6682\u5b58\u3001\u5ba1\u6838\u4e0d\u901a\u8fc7\u3001\u5e9f\u5f03\uff0c\u65b9\u53ef\u89e3\u9664\u53d1\u7968\u7ed1\u5b9a\u3002", (String)"ErInvoiceInfoReportPlugin_1", (String)"fi-er-report", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject costcompany = rowData.getDynamicObject("costcompany");
                    if (costcompany == null) continue;
                    List<String> serialNos = this.getSerialNos(rowData);
                    String serialNo = StringUtils.join(serialNos, (String)",");
                    String billno = rowData.getString("billno");
                    InvoiceStatusEnum invoiceStatus = InvoiceStatusEnum.unused;
                    InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)costcompany));
                    if (config == null) {
                        errorinfos.add(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u672a\u542f\u7528\u53d1\u7968\u4e91\u3002", (String)"ErInvoiceInfoReportPlugin_8", (String)"fi-er-report", (Object[])new Object[0]));
                        continue;
                    }
                    try {
                        APIHelper.updateInvoiceStatus((InvoiceCloudCfgBO)config, (InvoiceStatusEnum)invoiceStatus, (String)billno, (String)serialNo, (String)billno);
                    }
                    catch (Exception e) {
                        log.info("APIHelper.updateInvoiceStatus \u89e3\u9664\u7ed1\u5b9a\u5931\u8d25" + e.getMessage());
                        errorinfos.add(e.getMessage());
                    }
                }
                if (errorinfos.size() == 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89e3\u9664\u7ed1\u5b9a\u6210\u529f", (String)"ErInvoiceInfoReportPlugin_2", (String)"fi-er-report", (Object[])new Object[0]));
                } else if (errorinfos.size() == selectedRows.length) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u89e3\u9664\u7ed1\u5b9a\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (String)"ErInvoiceInfoReportPlugin_3", (String)"fi-er-report", (Object[])new Object[0]), StringUtils.join(errorinfos, (String)System.lineSeparator()), MessageTypes.Default);
                } else {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u89e3\u9664\u7ed1\u5b9a\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (String)"ErInvoiceInfoReportPlugin_4", (String)"fi-er-report", (Object[])new Object[0]), StringUtils.join(errorinfos, (String)System.lineSeparator()), MessageTypes.Default);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ErInvoiceInfoReportPlugin_5", (String)"fi-er-report", (Object[])new Object[0]));
            }
        }
    }
}

