/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.query;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportBatchQueryInfo;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.report.invoice.service.InvoiceDataSetFactory;
import org.apache.commons.lang3.StringUtils;

public class ErInvoiceInfoReportQuery
extends AbstractReportListDataPlugin {
    private static Log logger = LogFactory.getLog(ErInvoiceInfoReportQuery.class);
    protected static List<String> billTypeList = Lists.newArrayList();
    private Map<String, Set<Long>> permOrgMap = new HashMap<String, Set<Long>>();
    private boolean hasAllOrgPerm = false;

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        DataSet dataSet = null;
        FilterInfo filterInfo = queryParam.getFilter();
        List<String> selectBillTypes = this.getSelBillType(filterInfo.getFilterItem("custombilltype"));
        Iterator<String> iterator = selectBillTypes.iterator();
        this.queryOrgPerm(filterInfo);
        long start = System.currentTimeMillis();
        if (!ErStdConfig.getBoolean((String)"invoicequery.report.smallAmountOfData")) {
            ReportBatchQueryInfo byBatchInfo = (ReportBatchQueryInfo)queryParam.byBatchInfo();
            List currentBatchRows = byBatchInfo.getCurrentBatchRows();
            ArrayList<Long> batchId = new ArrayList<Long>(currentBatchRows.size());
            for (Row currentBatchRow : currentBatchRows) {
                Long id = currentBatchRow.getLong(0);
                batchId.add(id);
            }
            while (iterator.hasNext()) {
                String billtype = iterator.next();
                DataSet tuple = this.getDataSet(billtype, filterInfo, batchId);
                dataSet = this.unionDataSet(dataSet, tuple);
            }
            if (dataSet != null) {
                boolean totalLastBatch;
                DataSet union = dataSet.orderBy(new String[]{"invoiceDate desc", "invociceentryid desc"});
                boolean bl = totalLastBatch = byBatchInfo.getBatchCount() - 1 == byBatchInfo.getCurrentBatchIndex();
                if (totalLastBatch) {
                    DataSet sumSet = this.getSumType(dataSet);
                    union = union.union(sumSet);
                }
                logger.info(String.format("ErInvoiceInfoReportQuery.query orderBy end: %s", System.currentTimeMillis() - start));
                return union;
            }
            return null;
        }
        ArrayList futureLst = Lists.newArrayListWithExpectedSize((int)8);
        String filterInfoStr = SerializationUtils.serializeToBase64((Object)filterInfo);
        RequestContext requestContext = RequestContext.get();
        this.queryOrgPerm(filterInfo);
        while (iterator.hasNext()) {
            String billtype = iterator.next();
            BillTypeTask task = new BillTypeTask(billtype, filterInfoStr, false, null);
            futureLst.add(ThreadService.submit((Callable)task, (TaskType)TaskType.ER_REPORT_QUERY, (RequestContext)requestContext));
        }
        for (Future future : futureLst) {
            Tuple tuple = (Tuple)future.get();
            Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
            DataSetBuilder dataSetBuilder = algo.createDataSetBuilder((RowMeta)tuple.item1);
            for (Object[] row : (List)tuple.item2) {
                dataSetBuilder.append(row);
            }
            DataSet ds = dataSetBuilder.build();
            dataSet = this.unionDataSet(dataSet, ds);
        }
        logger.info("ErInvoiceInfoReportQuery \u4e3b\u7ebf\u7a0b for(Future) \u7ed3\u675f");
        if (dataSet != null) {
            DataSet sumSet = this.getSumType(dataSet);
            DataSet union = dataSet.orderBy(new String[]{"invoiceDate desc"}).union(sumSet);
            logger.info("ErInvoiceInfoReportQuery \u4e3b\u7ebf\u7a0b orderBy \u7ed3\u675f");
            return union;
        }
        return null;
    }

    public DataSet queryBatchBy(ReportQueryParam queryParam) {
        if (!ErStdConfig.getBoolean((String)"invoicequery.report.smallAmountOfData")) {
            long start = System.currentTimeMillis();
            DataSet dataSet = null;
            FilterInfo filterInfo = queryParam.getFilter();
            List<String> selectBillTypes = this.getSelBillType(filterInfo.getFilterItem("custombilltype"));
            Iterator<String> iterator = selectBillTypes.iterator();
            this.queryOrgPerm(filterInfo);
            ArrayList futureLst = Lists.newArrayListWithExpectedSize((int)8);
            String filterInfoStr = SerializationUtils.serializeToBase64((Object)filterInfo);
            RequestContext requestContext = RequestContext.get();
            while (iterator.hasNext()) {
                String billtype = iterator.next();
                BillTypeTask task = new BillTypeTask(billtype, filterInfoStr, true, null);
                futureLst.add(ThreadService.submit((Callable)task, (TaskType)TaskType.ER_REPORT_QUERY, (RequestContext)requestContext));
            }
            try {
                for (Future future : futureLst) {
                    Tuple tuple = (Tuple)future.get();
                    Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
                    DataSetBuilder dataSetBuilder = algo.createDataSetBuilder((RowMeta)tuple.item1);
                    for (Object[] row : (List)tuple.item2) {
                        dataSetBuilder.append(row);
                    }
                    DataSet ds = dataSetBuilder.build();
                    dataSet = this.unionDataSet(dataSet, ds);
                }
            }
            catch (Exception e) {
                logger.error("ErInvoiceInfoReportQuery.queryBatchBy ", (Throwable)e);
            }
            logger.info("ErInvoiceInfoReportQuery for(Future) end");
            if (dataSet != null) {
                DataSet dataSetResult = dataSet.orderBy(new String[]{"invoiceDate desc", "invociceentryid desc"});
                IReportBatchQueryInfo byBatchInfo = queryParam.byBatchInfo();
                byBatchInfo.setCountPerBatch(5000);
                byBatchInfo.setMaxRowCountCached(100000);
                logger.info(String.format("ErInvoiceInfoReportQuery.queryBatchBy get queryBtachBy end cost %s ms", System.currentTimeMillis() - start));
                return dataSetResult.select("invociceentryid");
            }
            return null;
        }
        ((ReportBatchQueryInfo)queryParam.byBatchInfo()).setLargeData(false);
        return super.queryBatchBy(queryParam);
    }

    private void queryOrgPerm(FilterInfo filterInfo) {
        FilterItemInfo appFilter = filterInfo.getFilterItem("appId");
        String appId = (String)appFilter.getValue();
        appId = StringUtils.isBlank((CharSequence)appId) ? "em" : appId;
        HasPermOrgResult permResult = PermissionServiceHelper.getAllPermOrgs((Long)CommonServiceHelper.getCurrentUserID(), (String)appId, (String)"er_invoiceinfo_query", (String)"47150e89000000ac");
        if (permResult.hasAllOrgPerm()) {
            this.hasAllOrgPerm = true;
        }
        this.permOrgMap.put(appId, new HashSet(permResult.getHasPermOrgs()));
    }

    private DataSet getSumType(DataSet dataSet) {
        DataSet totakDataSet = dataSet.copy();
        totakDataSet = totakDataSet.groupBy(null).sum("totalamount").sum("taxamount_invoice").sum("count").sum("offsetamount").min("currency").finish();
        Field[] groupFields = totakDataSet.getRowMeta().getFields();
        HashSet groupFieldsSet = new HashSet();
        Stream.of(groupFields).forEach(record -> groupFieldsSet.add(record.getAlias().toUpperCase()));
        Field[] reportAllFields = dataSet.getRowMeta().getFields();
        ArrayList groupSelectFields = Lists.newArrayListWithExpectedSize((int)32);
        for (Field field : reportAllFields) {
            String fieldName;
            String emptyField = fieldName = field.getAlias().toUpperCase();
            if (!groupFieldsSet.contains(fieldName) && !"currency".equals(fieldName)) {
                emptyField = "null as " + fieldName;
                if ("invoicetype".equalsIgnoreCase(fieldName)) {
                    emptyField = "'999' as " + fieldName;
                }
                if ("summarytype".equalsIgnoreCase(fieldName)) {
                    emptyField = String.format("cast(1 as integer) as %s", fieldName);
                }
            }
            groupSelectFields.add(emptyField);
        }
        totakDataSet = totakDataSet.select(groupSelectFields.toArray(new String[groupSelectFields.size()]));
        return totakDataSet;
    }

    private DataSet unionDataSet(DataSet dataSet, DataSet unionDataSet) {
        if (dataSet == null) {
            return unionDataSet;
        }
        return dataSet.union(unionDataSet);
    }

    protected DataSet getDataSet(String billType, FilterInfo filterInfo, List<Long> batchFilter) {
        return InvoiceDataSetFactory.getInstance(billType, this.hasAllOrgPerm ? null : this.permOrgMap).getDataSet(filterInfo, batchFilter);
    }

    private List<String> getSelBillType(FilterItemInfo filterItem) {
        if (filterItem != null) {
            if ("<>".equals(filterItem.getCompareType())) {
                ArrayList<String> res = new ArrayList<String>(billTypeList);
                res.remove(filterItem.getValue());
                return res;
            }
            if (filterItem.getValue() instanceof String) {
                ArrayList retList = Lists.newArrayList();
                retList.add((String)filterItem.getValue());
                return retList;
            }
            return (List)filterItem.getValue();
        }
        return billTypeList;
    }

    static {
        billTypeList.add("er_dailyreimbursebill");
        billTypeList.add("er_tripreimbursebill");
        billTypeList.add("er_invoiceorderbill");
        billTypeList.add("er_publicreimbursebill");
        billTypeList.add("er_checkingpaybill");
    }

    private class BillTypeTask
    implements Callable<Tuple<RowMeta, List<Object[]>>> {
        private String billtype;
        private String filterInfoStr;
        private List<Long> batchFilter;
        private boolean isGetQueryBatchBy;

        public BillTypeTask(String billtype, String filterInfoStr, boolean isGetQueryBatchBy, List<Long> batchFilter) {
            this.billtype = billtype;
            this.filterInfoStr = filterInfoStr;
            this.batchFilter = batchFilter;
            this.isGetQueryBatchBy = isGetQueryBatchBy;
        }

        @Override
        public Tuple<RowMeta, List<Object[]>> call() {
            FilterInfo filterInfo = (FilterInfo)SerializationUtils.deSerializeFromBase64((String)this.filterInfoStr);
            DataSet dataSet = ErInvoiceInfoReportQuery.this.getDataSet(this.billtype, filterInfo, this.batchFilter);
            if (this.isGetQueryBatchBy) {
                dataSet = dataSet.select("invoiceDate,invociceentryid");
            }
            RowMeta rowMeta = dataSet.getRowMeta();
            String[] fieldNames = rowMeta.getFieldNames();
            ArrayList<Object[]> rowLst = new ArrayList<Object[]>();
            for (Row row : dataSet) {
                Object[] arr = new Object[fieldNames.length];
                int i = 0;
                for (String fieldName : fieldNames) {
                    arr[i] = row.get(fieldName);
                    ++i;
                }
                rowLst.add(arr);
            }
            dataSet.close();
            return new Tuple((Object)rowMeta, rowLst);
        }
    }
}

