/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.query;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;

public class ErOrderBalanceReport
extends AbstractReportListDataPlugin {
    private static final String RELATE_ENTITY_ALL_ORDER = "er_allorderbill";
    private static final String RELATE_ENTITY_INVOICE_ORDER = "er_invoiceorderbill";
    private static final String RELATE_ENTITY_CHECKINGPAYBILL = "er_checkingpaybill";
    private static final String SUMMARY_TYPE = "summarytype";
    private static final String SUMMARY_ROW_INDEX = "server";
    private static final String ORDER_FIELD_INDEX = "index";
    private static final String ALL_ORDER_SELECT_FIELD = new StringBuffer().append("id").append(",").append("server").append(",").append("expcommitcomnum").append(",").append("operationtype").append(",").append("ordernum").append(",").append("happenddate").append(",").append("checkingpayid").append(",").append("totalamount").append(",").append("invoiceid").append(",").append("company").toString();
    private static final String INVOICE_ORDER_SELECT_FIELD = new StringBuffer().append("id").append(",").append("case when vatcominvoicenum=null or vatcominvoicenum=' ' then null else vatcominvoicenum end vatcominvoicenum").append(",").append("case when vatcominvoicecode=null or vatcominvoicecode=' ' then null else vatcominvoicecode end vatcominvoicecode").append(",").append("case when vatdednvoicenum=null or vatdednvoicenum=' ' then null else vatdednvoicenum end vatdednvoicenum").append(",").append("case when vatdednvoicecode=null or vatdednvoicecode=' ' then null else vatdednvoicecode end vatdednvoicecode").append(",").append("invoicedate").toString();
    private static final String SELECT_FIELD = "id,server,expcommitcomnum bear_cost_company,company companycol,operationtype server_type,ordernum order_number,happenddate order_date,totalamount order_amount,totalamount payable_amount,case when paybillnum = ' ' OR paybillnum = null THEN 0 ELSE totalamount END paid_amount,case when vatcominvoicenum = null AND vatdednvoicenum  = null THEN 0 ELSE totalamount END invoice_amount,case when vatcominvoicenum = null AND vatdednvoicenum = null THEN totalamount ELSE 0 END unbilled_amount,case when vatcominvoicecode != null then vatcominvoicecode WHEN vatdednvoicecode != null THEN vatdednvoicecode else NULL end invoice_code,case when vatcominvoicenum != null then vatcominvoicenum WHEN vatdednvoicenum != null THEN vatdednvoicenum else null end invoice_number,case when vatcominvoicenum != null OR vatdednvoicenum != null THEN invoicedate ELSE NULL END invoice_date,0 as summarytype, server as index,paybillnum";
    private static final String[] RIGHT_SELECT_FIELD = new String[]{"vatcominvoicenum", "vatcominvoicecode", "vatdednvoicenum", "vatdednvoicecode", "invoicedate"};
    private static final String[] LEFT_SELECT_FIELD = ALL_ORDER_SELECT_FIELD.split(",");
    private static final String[] MAIN_SELECT_FIELD = new String[]{"id", "server", "expcommitcomnum", "operationtype", "ordernum", "happenddate", "checkingpayid", "totalamount", "invoiceid", "paybillnum", "company"};

    private void buildQFilter(ReportQueryParam queryParam, List<QFilter> invoiceFilterList, List<QFilter> orderBillFilterList, List<QFilter> resultFilterList) {
        FilterInfo commonFilterInfo = queryParam.getFilter();
        commonFilterInfo.getFilterItems().forEach(filterItem -> {
            String propName = filterItem.getPropName();
            Object value = filterItem.getValue();
            String compareType = filterItem.getCompareType();
            if ("happenddate".equals(propName) || "company.id".equals(propName) || "company.name".equals(propName) || "operationtype".equals(propName) || "ordernum".equals(propName) || "expcommitcomnum.name".equals(propName)) {
                orderBillFilterList.add(new QFilter(propName, compareType, value));
            } else if ("filter_server".equals(propName)) {
                orderBillFilterList.add(new QFilter(SUMMARY_ROW_INDEX, compareType, value));
            } else if ("filter_order_amount".equals(propName)) {
                orderBillFilterList.add(new QFilter("totalamount", compareType, value));
            } else if ("filter_payable_amount".equals(propName)) {
                orderBillFilterList.add(new QFilter("totalamount", compareType, value));
            } else if ("filter_paid_amount".equals(propName)) {
                orderBillFilterList.add(new QFilter("payamount", compareType, value));
            } else if (("filter_paybillnum".equals(propName) || "filter_invoice_amount".equals(propName) || "filter_unbilled_amount".equals(propName) || "filter_invoice_code".equals(propName) || "filter_invoice_number".equals(propName) || "filter_invoice_date".equals(propName)) && !"is null".equals(compareType)) {
                resultFilterList.add(new QFilter(propName.substring(7, propName.length()), compareType, value));
            }
        });
    }

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        ArrayList<QFilter> invoiceFilterList = new ArrayList<QFilter>();
        ArrayList<QFilter> orderBillFilterList = new ArrayList<QFilter>();
        ArrayList<QFilter> checkingPayFilterList = new ArrayList<QFilter>();
        ArrayList<QFilter> resultFilterList = new ArrayList<QFilter>();
        this.buildQFilter(queryParam, invoiceFilterList, orderBillFilterList, resultFilterList);
        DataSet result = this.buildDetailRowData(invoiceFilterList, orderBillFilterList, checkingPayFilterList, resultFilterList);
        DataSet totalRowDataSet = this.buildTotalRowData(result);
        result = result.union(totalRowDataSet);
        return result.orderBy(new String[]{ORDER_FIELD_INDEX, SUMMARY_TYPE});
    }

    private DataSet buildTotalRowData(DataSet result) {
        DataSet totalRowDataSet = result.copy();
        totalRowDataSet = totalRowDataSet.groupBy(new String[]{SUMMARY_ROW_INDEX, ORDER_FIELD_INDEX}).sum("order_amount").sum("payable_amount").sum("paid_amount").sum("invoice_amount").sum("unbilled_amount").finish();
        Field[] totalFields = totalRowDataSet.getRowMeta().getFields();
        HashSet totalExistFields = new HashSet();
        Stream.of(totalFields).forEach(v -> totalExistFields.add(v.getAlias().toUpperCase()));
        Field[] allFields = result.getRowMeta().getFields();
        ArrayList groupSelectFields = Lists.newArrayListWithExpectedSize((int)32);
        for (Field field : allFields) {
            String fieldName;
            String temp = fieldName = field.getAlias().toUpperCase();
            if (!totalExistFields.contains(fieldName)) {
                temp = "null as " + fieldName;
                if (SUMMARY_TYPE.equalsIgnoreCase(fieldName)) {
                    temp = "1 as " + fieldName;
                }
            }
            if (SUMMARY_ROW_INDEX.equalsIgnoreCase(fieldName)) {
                temp = String.format("'%s' as %s", ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ErOrderBalanceReport_0", (String)"fi-er-report", (Object[])new Object[0]), fieldName);
            }
            groupSelectFields.add(temp);
        }
        totalRowDataSet = totalRowDataSet.select(groupSelectFields.toArray(new String[groupSelectFields.size()]));
        return totalRowDataSet;
    }

    private DataSet buildDetailRowData(List<QFilter> invoiceFilterList, List<QFilter> orderBillFilterList, List<QFilter> checkingPayFilterList, List<QFilter> resultFilterList) {
        orderBillFilterList.add(new QFilter("producttype", "!=", (Object)"2"));
        IErDao allOrderDao = ErDaoFactory.getInstance((String)RELATE_ENTITY_ALL_ORDER);
        DataSet allOrderDataSet = allOrderDao.queryDataSet(((Object)((Object)this)).getClass().getName(), ALL_ORDER_SELECT_FIELD, orderBillFilterList.toArray(new QFilter[orderBillFilterList.size()]));
        if (orderBillFilterList.size() > 0) {
            DataSet allOrderTemp = allOrderDataSet.copy();
            HashSet invoiceIds = new HashSet();
            HashSet checkingPaybillIds = new HashSet();
            allOrderTemp.iterator().forEachRemaining(v -> {
                invoiceIds.add(Long.valueOf(v.getString("invoiceid")));
                checkingPaybillIds.add(v.getLong("checkingpayid"));
            });
            invoiceFilterList.add(new QFilter("id", "in", invoiceIds));
            checkingPayFilterList.add(new QFilter("id", "in", checkingPaybillIds));
            allOrderTemp.close();
        }
        IErDao invoiceOrderDao = ErDaoFactory.getInstance((String)RELATE_ENTITY_INVOICE_ORDER);
        DataSet invoiceOrderDataSet = invoiceOrderDao.queryDataSet(((Object)((Object)this)).getClass().getName(), INVOICE_ORDER_SELECT_FIELD, invoiceFilterList.toArray(new QFilter[invoiceFilterList.size()]));
        StringBuilder resultFilter = new StringBuilder();
        resultFilterList.forEach(v -> {
            resultFilter.append(" and ");
            resultFilter.append(v);
        });
        IErDao checkingPayDao = ErDaoFactory.getInstance((String)RELATE_ENTITY_CHECKINGPAYBILL);
        DataSet checkingPayDataSet = checkingPayDao.queryDataSet(((Object)((Object)this)).getClass().getName(), "id,paybillnum", checkingPayFilterList.toArray(new QFilter[checkingPayFilterList.size()]));
        allOrderDataSet = allOrderDataSet.join(checkingPayDataSet, JoinType.LEFT).on("checkingpayid", "id").select(LEFT_SELECT_FIELD, new String[]{"paybillnum"}).finish();
        DataSet result = allOrderDataSet.join(invoiceOrderDataSet, JoinType.LEFT).on("invoiceid", "id").select(MAIN_SELECT_FIELD, RIGHT_SELECT_FIELD).finish();
        result = resultFilterList.size() > 0 ? result.select(SELECT_FIELD.split(",")).filter(resultFilter.toString().replaceFirst(" and ", "")) : result.select(SELECT_FIELD.split(","));
        return result;
    }
}

