/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.query;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.servicehelper.ErPermissionServiceHelper;
import kd.fi.er.report.DetailReportQueryUtil;
import kd.fi.er.report.treerpt.RowWrap;
import kd.fi.er.report.treerpt.RowWrapGroup;
import kd.fi.er.report.treerpt.TreeQueryParam;
import org.apache.commons.lang3.StringUtils;

public class ExpenseDetailReportQuery
extends AbstractReportListDataPlugin {
    private static Log logger = LogFactory.getLog(ExpenseDetailReportQuery.class);
    private static String ER_EXPENSE_DETAILDATA = "er_expense_detaildata";

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        TreeQueryParam treeQueryParam = new TreeQueryParam(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        DataSet dataSet = this.getDataSet(this.getTargetEntity(), treeQueryParam, filterInfo);
        FilterItemInfo filterItemInfo = filterInfo.getFilterItem("pstatisticaldimension");
        String[] groups = new String[]{};
        if (filterItemInfo != null) {
            if (filterItemInfo.getValue() instanceof String) {
                groups = new String[]{filterItemInfo.getValue().toString()};
            } else if (filterItemInfo.getValue() instanceof List) {
                groups = ((List)filterItemInfo.getValue()).toArray(new String[0]);
            }
            List<String> in = Arrays.asList("IN", "=");
            if (!in.contains(filterItemInfo.getCompareType())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7edf\u8ba1\u7ef4\u5ea6\u4ec5\u652f\u6301\u201c\u7b49\u4e8e\u201d\u3001\u201c\u5728...\u4e2d\u201d\u7b49\u6761\u4ef6\u67e5\u8be2\u3002", (String)"ExpenseDetailReportPlugin_10", (String)"fi-er-report", (Object[])new Object[0]));
            }
        }
        if (groups == null || groups.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7edf\u8ba1\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExpenseDetailReportPlugin_0", (String)"fi-er-report", (Object[])new Object[0]));
        }
        ArrayList<String> statisticaldimension = new ArrayList<String>(Arrays.asList(groups));
        String pstatisticalperiod = "";
        if (filterInfo.getFilterItem("pstatisticalperiod").getValue() instanceof String) {
            pstatisticalperiod = (String)filterInfo.getFilterItem("pstatisticalperiod").getValue();
            if ("1".equals(pstatisticalperiod)) {
                pstatisticalperiod = "year";
            } else if ("2".equals(pstatisticalperiod)) {
                pstatisticalperiod = "quarter";
            } else if ("3".equals(pstatisticalperiod)) {
                pstatisticalperiod = "yearmonth";
            }
            statisticaldimension.add(pstatisticalperiod);
        }
        RefObject refObject = new RefObject(new ArrayList(10));
        DataSet data = this.sumByGroup(dataSet, statisticaldimension, (RefObject<List<String>>)refObject, pstatisticalperiod);
        if (treeQueryParam.isLevelShow().booleanValue()) {
            DataSet buildtreeData = this.buildtreeData(data, treeQueryParam);
            return buildtreeData;
        }
        return data.addFields(new String[]{"'0'", String.format("concat(%1s)", StringUtils.join((Object[])statisticaldimension.toArray(), (String)",")), "false"}, new String[]{"pid", "rowid", "isgroupnode"});
    }

    private DataSet buildtreeData(DataSet rawData, TreeQueryParam treeQueryParam) {
        rawData = this.appendOrgInfo(rawData, treeQueryParam);
        RowMeta rowMeta = rawData.getRowMeta();
        int rawFieldCount = rowMeta.getFieldCount();
        Field[] newFields = new Field[rawFieldCount + 5];
        for (int i = 0; i < rawFieldCount; ++i) {
            newFields[i] = rowMeta.getField(i);
        }
        newFields[rawFieldCount] = new Field("orgname", (DataType)DataType.StringType);
        newFields[rawFieldCount + 1] = new Field("forgname", (DataType)DataType.StringType);
        newFields[rawFieldCount + 2] = new Field("rowid", (DataType)DataType.StringType);
        newFields[rawFieldCount + 3] = new Field("pid", (DataType)DataType.StringType);
        newFields[rawFieldCount + 4] = new Field("isgroupnode", (DataType)DataType.BooleanType);
        RowMeta newMeta = new RowMeta(newFields);
        RowWrapGroup rowWrapGroup = new RowWrapGroup();
        Iterator iterator = rawData.iterator();
        int seq = 1;
        while (iterator.hasNext()) {
            Object[] newRow = new Object[newFields.length];
            Row rawRow = (Row)iterator.next();
            for (int i = 0; i < rawFieldCount; ++i) {
                newRow[i] = rawRow.get(i);
            }
            newRow[rawFieldCount + 2] = String.valueOf(seq);
            Long costcompany = rawRow.getLong("costcompany");
            String costCompanyNumber = rawRow.getString("number");
            if (costCompanyNumber != null) {
                rowWrapGroup.addRowWrap(new RowWrap(newRow, newMeta, rawRow.getBoolean("isleaf"), String.valueOf(seq), costcompany, rawRow.getLong("porgid"), rawRow.getString("longnumber"), rawRow.getString("pnumber"), costCompanyNumber));
            }
            ++seq;
        }
        List<RowWrap> list = rowWrapGroup.get();
        list = list.stream().distinct().collect(Collectors.toList());
        DataSetBuilder treeDataSetBuilder = Algo.create((String)"fi.tree.expensedetail").createDataSetBuilder(newMeta);
        list.stream().forEach(v -> treeDataSetBuilder.append(v.getRowData()));
        return treeDataSetBuilder.build();
    }

    private DataSet appendOrgInfo(DataSet oriDataSet, TreeQueryParam treeQueryParam) {
        String selectFields = "org orgid,parent porgid,parent.number pnumber,isleaf,longnumber,org.number number";
        Object value = treeQueryParam.getQueryParam().getFilter().getValue("orgview.id");
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"TreeReportHelper.appendOrgInfo", (String)"bos_org_structure", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("view.treetype", "=", (Object)"10"), new QFilter("view", "=", value == null ? Long.valueOf(10L) : value)}, (String)"level asc");){
            DataSet dataSet = oriDataSet = oriDataSet.join(orgDataSet, JoinType.LEFT).on("costcompany", "orgid").select(ExpenseDetailReportQuery.getDataSetCols(oriDataSet, new ArrayList<String>(0)).toArray(new String[0]), new String[]{"porgid", "isleaf", "longnumber", "number", "pnumber"}).finish();
            return dataSet;
        }
    }

    public static List<String> getDataSetCols(DataSet ds, List<String> filterFields) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            if (filterFields.contains(field.getName())) continue;
            list.add(field.getName());
        }
        return list;
    }

    private DataSet sumByGroup(DataSet dataSet, List<String> list, RefObject<List<String>> refObject, String statisticalperiod) {
        DataSet totakDataSet = dataSet;
        ArrayList<String> groupBysAndSort = new ArrayList<String>(1);
        for (String s : list) {
            if (Arrays.asList("year", "quarter", "yearmonth").contains(s) || !Arrays.asList("expenseitem", "company", "org").contains(s)) continue;
            groupBysAndSort.add(s + "number");
        }
        list.addAll(groupBysAndSort);
        list.add("currency");
        GroupbyDataSet groupbyDataSet = totakDataSet.groupBy(list.toArray(new String[0])).sum("inorder").sum("finished").sum("inorder_notax").sum("finished_notax").sum("currapprove").sum("currtaxamt").sum("currapprovenotax").sum("entryamount");
        totakDataSet = groupbyDataSet.finish();
        HashSet groupFieldsSet = new HashSet();
        Stream.of(totakDataSet.getRowMeta().getFields()).forEach(record -> groupFieldsSet.add(record.getAlias().toUpperCase()));
        Field[] reportAllFields = dataSet.getRowMeta().getFields();
        ArrayList groupSelectFields = Lists.newArrayListWithExpectedSize((int)32);
        for (Field field : reportAllFields) {
            String fieldName;
            String emptyField = fieldName = field.getAlias().toUpperCase();
            if (!groupFieldsSet.contains(fieldName)) {
                emptyField = "null as " + fieldName;
            }
            if (statisticalperiod.equalsIgnoreCase(fieldName)) {
                groupSelectFields.add(fieldName + " as  statisticalperiod");
            }
            groupSelectFields.add(emptyField);
        }
        if (StringUtils.isEmpty((CharSequence)statisticalperiod)) {
            groupSelectFields.add("'' as  statisticalperiod");
        }
        ((List)refObject.getValue()).addAll(groupSelectFields);
        ArrayList<String> sortBy = new ArrayList<String>(2);
        sortBy.add("statisticalperiod desc");
        groupBysAndSort.stream().forEach(e -> sortBy.add(e + " desc"));
        sortBy.sort(new SortByFieldComparator());
        totakDataSet = totakDataSet.select(groupSelectFields.toArray(new String[groupSelectFields.size()])).orderBy(sortBy.toArray(new String[0]));
        return totakDataSet;
    }

    private DataSet getDataSet(String billType, TreeQueryParam treeQueryParam, FilterInfo filterInfo) {
        List<QFilter> qFilters = DetailReportQueryUtil.getQfilter(treeQueryParam.getQueryParam().getFilter());
        this.orgProcess(qFilters, treeQueryParam, filterInfo);
        qFilters.add(DetailReportQueryUtil.getInOrderStatus().or(DetailReportQueryUtil.getFinishedStatus()));
        return ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName() + "." + billType, billType, this.getSql(), qFilters.toArray(new QFilter[0]));
    }

    private void orgProcess(List<QFilter> qFilters, TreeQueryParam treeQueryParam, FilterInfo filterInfo) {
        Iterator<QFilter> iterator = qFilters.iterator();
        QFilter permQf = null;
        String permissionField = MetadataServiceHelper.getDataEntityType((String)"er_expense_detail_query").getPermissionControlType().getDataDimensionField();
        while (iterator.hasNext()) {
            QFilter filter = iterator.next();
            String property = filter.getProperty();
            if (!StringUtils.equalsAny((CharSequence)property, (CharSequence[])new CharSequence[]{"company.id", "costdept.id", "costcompany.id"}) || !StringUtils.equals((CharSequence)permissionField, (CharSequence)property.split("\\.")[0]) || !StringUtils.equalsAny((CharSequence)filter.getCP(), (CharSequence[])new CharSequence[]{"=", "in"})) continue;
            permQf = filter;
            iterator.remove();
        }
        FilterItemInfo item = filterInfo.getFilterItem("appId");
        String appId = "em";
        if (item != null) {
            appId = (String)StringUtils.defaultIfEmpty((CharSequence)((String)item.getValue()), (CharSequence)appId);
        }
        Set orgIDs = ErPermissionServiceHelper.getOrgListWithPerm((String)appId, (String)"er_expense_detail_query", (String)"47150e89000000ac").stream().collect(Collectors.toSet());
        if (permQf != null) {
            List<Long> value = permQf.getValue();
            if (value instanceof Long) {
                value = Collections.singletonList((Long)((Object)value));
            }
            orgIDs.retainAll((List)value);
        }
        if (permissionField != null) {
            qFilters.add(new QFilter(permissionField + ".id", "in", orgIDs));
        }
    }

    protected String getTargetEntity() {
        return ER_EXPENSE_DETAILDATA;
    }

    protected String getFinishedStatus() {
        return " (billstatus in ('G', 'I') and encashamount > 0 ) or (billstatus in ('E', 'I') and encashamount = 0 )";
    }

    protected String getInOrderStatus() {
        return " (billstatus in ('B', 'C', 'E', 'F') and encashamount > 0 ) or (billstatus in ('B', 'C') and encashamount = 0 )";
    }

    protected String getSql() {
        String sql = "company, org,  applier,bizdate, billstatus, currency, costcompany,costdept, applier.number as appliernumber, org.number as orgnumber, company.number as companynumber,costcompany.number as costcompanynumber, costdept.number as costdeptnumber, travelitem.number as travelitemnumber, expenseitem.number as expenseitemnumber, stdproject.number as stdprojectnumber,travelitem, expenseitem, stdproject, year, quarter, yearmonth, ( case when " + this.getInOrderStatus() + "  then entryappamount  else 0 end ) as inorder, ( case when " + this.getFinishedStatus() + " then entryappamount  else 0 end ) as finished, ( case when " + this.getInOrderStatus() + "  then curprice  else 0 end ) as inorder_notax, ( case when " + this.getFinishedStatus() + " then curprice  else 0 end ) as finished_notax , entryappamount as currapprove , deductibletax as currtaxamt ,curprice as currapprovenotax,entryamount";
        return sql;
    }

    private static class SortByFieldComparator
    implements Comparator {
        private static Map<String, Integer> sortByFields = new HashMap<String, Integer>(8);

        private SortByFieldComparator() {
            sortByFields.put("statisticalperiod desc", 1);
            sortByFields.put("expenseitemnumber desc", 4);
            sortByFields.put("companynumber desc", 2);
            sortByFields.put("orgnumber desc", 3);
        }

        public int compare(Object o1, Object o2) {
            return sortByFields.get(o1) - sortByFields.get(o2);
        }
    }
}

